<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Debug_add_note extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('leads_model');
    }

    public function test($lead_id = 108)
    {
        if (!is_staff_member()) {
            echo "Access denied - not logged in as staff";
            return;
        }

        echo "<h2>Debug Add Note for Lead $lead_id</h2>";

        // Test if lead exists and user has access
        if (!$this->leads_model->staff_can_access_lead($lead_id)) {
            echo "<p style='color: red;'>✗ Cannot access lead $lead_id</p>";
            return;
        } else {
            echo "<p style='color: green;'>✓ Can access lead $lead_id</p>";
        }

        // Simulate form data
        $test_data = [
            'description' => 'Test note with follow-up date',
            'next_followup_date' => '2025-08-10 15:00:00',
            'date_contacted' => date('Y-m-d H:i:s')
        ];

        echo "<h3>Test Data:</h3>";
        echo "<pre>" . print_r($test_data, true) . "</pre>";

        // Test database insert
        try {
            $insert_data = [
                'description' => nl2br($test_data['description']),
                'leadid' => $lead_id,
                'addedfrom' => get_staff_user_id(),
                'dateadded' => date('Y-m-d H:i:s'),
                'next_followup_date' => $test_data['next_followup_date'],
                'date_contacted' => $test_data['date_contacted']
            ];

            echo "<h3>Insert Data:</h3>";
            echo "<pre>" . print_r($insert_data, true) . "</pre>";

            $this->db->insert(db_prefix() . 'lead_notes', $insert_data);
            $note_id = $this->db->insert_id();

            if ($note_id) {
                echo "<p style='color: green;'>✓ Successfully inserted note with ID: $note_id</p>";
            } else {
                echo "<p style='color: red;'>✗ Failed to insert note</p>";
                echo "<p>Database error: " . $this->db->error()['message'] . "</p>";
            }

        } catch (Exception $e) {
            echo "<p style='color: red;'>✗ Exception: " . $e->getMessage() . "</p>";
        }

        // Test query to retrieve the note
        $this->db->select('id, description, next_followup_date, leadid, dateadded');
        $this->db->where('leadid', $lead_id);
        $this->db->order_by('dateadded', 'DESC');
        $this->db->limit(3);
        $notes = $this->db->get(db_prefix() . 'lead_notes')->result();

        echo "<h3>Recent Notes for Lead $lead_id:</h3>";
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Description</th><th>Follow-up Date</th><th>Date Added</th></tr>";
        foreach ($notes as $note) {
            echo "<tr>";
            echo "<td>" . $note->id . "</td>";
            echo "<td>" . htmlspecialchars(strip_tags($note->description)) . "</td>";
            echo "<td>" . ($note->next_followup_date ?: 'None') . "</td>";
            echo "<td>" . $note->dateadded . "</td>";
            echo "</tr>";
        }
        echo "</table>";

        echo "<p><a href='" . admin_url('leads/lead/' . $lead_id) . "'>← Back to Lead</a></p>";
    }
}
?>
