<?php foreach($notes as $note) { 
    // ENHANCED TEMPLATE MARKER - v5.0 - <?php echo date('Y-m-d H:i:s'); ?>
    echo '<script>
        console.log("🚨 ENHANCED TEMPLATE LOADING - v5.0 - ' . date('Y-m-d H:i:s') . '");
        console.log("Notes count: " . count($notes) . '");
        alert("ENHANCED TEMPLATE IS WORKING v5.0 - ' . date('Y-m-d H:i:s') . '");
    </script>';
    echo '<div style="position: fixed; top: 0; left: 0; width: 100%; height: 100px; background: red; color: white; z-index: 9999; text-align: center; padding: 20px; font-size: 24px; font-weight: bold;">
        🚨 ENHANCED TEMPLATE v5.0 IS ACTIVE 🚨<br>
        <small>Current time: ' . date('Y-m-d H:i:s') . '</small>
    </div>';
    // Detect communication type from note content
    $note_text = strtolower($note['description']);
    $communication_type = 'general';
    $icon = 'fa-sticky-note';
    $color_class = 'note-general';
    
    if (strpos($note_text, 'whatsapp') !== false || strpos($note_text, 'whats app') !== false) {
        $communication_type = 'whatsapp';
        $icon = 'fa-whatsapp';
        $color_class = 'note-whatsapp';
    } elseif (strpos($note_text, 'call') !== false || strpos($note_text, 'phone') !== false || strpos($note_text, 'rang') !== false) {
        $communication_type = 'call';
        $icon = 'fa-phone';
        $color_class = 'note-call';
    } elseif (strpos($note_text, 'message') !== false || strpos($note_text, 'sms') !== false || strpos($note_text, 'text') !== false) {
        $communication_type = 'message';
        $icon = 'fa-comment';
        $color_class = 'note-message';
    } elseif (strpos($note_text, 'email') !== false || strpos($note_text, 'mail') !== false) {
        $communication_type = 'email';
        $icon = 'fa-envelope';
        $color_class = 'note-email';
    } elseif (strpos($note_text, 'meeting') !== false || strpos($note_text, 'visit') !== false) {
        $communication_type = 'meeting';
        $icon = 'fa-users';
        $color_class = 'note-meeting';
    }
?>
<div class="lead-note <?php echo $color_class; ?>" data-note-id="<?php echo $note['id']; ?>" data-communication-type="<?php echo $communication_type; ?>" style="border: 5px solid red !important; background: yellow !important;">
    <!-- ENHANCED TEMPLATE ACTIVE - v3.0 - TEST MARKER -->
    <div style="background: red; color: white; padding: 10px; font-weight: bold; text-align: center; margin-bottom: 10px;">
        🚨 ENHANCED TEMPLATE IS WORKING - v3.0 🚨
    </div>
    <div class="note-header">
        <div class="note-icon">
            <i class="fa <?php echo $icon; ?>"></i>
        </div>
        <div class="note-meta">
            <div class="note-author">
                <?php echo staff_profile_image($note['addedfrom'], ['staff-profile-image-xs', 'pull-left', 'mright5']); ?>
                <strong><?php echo get_staff_full_name($note['addedfrom']); ?></strong>
            </div>
            <div class="note-timestamp">
                <small class="text-muted">
                    <i class="fa fa-clock-o mright5"></i><?php echo _dt($note['dateadded']); ?>
                </small>
            </div>
        </div>
        <?php if(has_permission('leads','','delete') || $note['addedfrom'] == get_staff_user_id()) { ?>
        <div class="note-actions">
            <a href="#" class="text-danger note-delete" onclick="delete_lead_note(this, <?php echo $note['id']; ?>, <?php echo isset($lead) ? $lead->id : (isset($_GET['id']) ? $_GET['id'] : 'null'); ?>); return false;" title="Delete Note">
                <i class="fa fa-times"></i>
            </a>
        </div>
        <?php } ?>
    </div>
    <div class="note-content">
        <?php echo process_text_content_for_display($note['description']); ?>
    </div>
    <div class="note-footer">
        <span class="communication-badge badge-<?php echo $communication_type; ?>">
            <i class="fa <?php echo $icon; ?> mright5"></i><?php echo ucfirst($communication_type); ?>
        </span>
    </div>
</div>
<?php } ?>
