<?php

defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = [
    'id',
    'lead_name',
    'confidence_score',
    'purchase_likelihood',
    'analysis_type',
    'created_at',
    'created_by_name',
];

$sIndexColumn = 'id';
$sTable = db_prefix() . 'leads_ai_reports';
$joins = [
    'LEFT JOIN ' . db_prefix() . 'leads l ON l.id = ' . db_prefix() . 'leads_ai_reports.lead_id',
    'LEFT JOIN ' . db_prefix() . 'staff s ON s.staffid = ' . db_prefix() . 'leads_ai_reports.created_by',
];

$where = [];

// If not admin, only show reports for accessible leads
if (!is_admin()) {
    $staff_id = get_staff_user_id();
    $where[] = 'AND (l.assigned = ' . $staff_id . ' OR ' . db_prefix() . 'leads_ai_reports.created_by = ' . $staff_id . ')';
}

$additionalSelect = [
    db_prefix() . 'leads_ai_reports.id',
    db_prefix() . 'leads_ai_reports.lead_id',
    db_prefix() . 'leads_ai_reports.confidence_score',
    db_prefix() . 'leads_ai_reports.purchase_likelihood',
    db_prefix() . 'leads_ai_reports.analysis_type',
    db_prefix() . 'leads_ai_reports.created_at',
    db_prefix() . 'leads_ai_reports.created_by',
    'l.name as lead_name',
    'l.company as lead_company',
    'l.email as lead_email',
    'CONCAT(s.firstname, " ", s.lastname) as created_by_name',
];

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $joins, $where, $additionalSelect);

$output = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];
    
    // Process each column
    for ($i = 0; $i < count($aColumns); $i++) {
        $_data = $aRow[$aColumns[$i]];
        
        if ($aColumns[$i] == 'id') {
            // Report ID with link
            $_data = '<a href="' . admin_url('ai_reports/view/' . $aRow['id']) . '">#' . $aRow['id'] . '</a>';
        } elseif ($aColumns[$i] == 'lead_name') {
            // Lead info
            $_data = '<a href="' . admin_url('leads/index/' . $aRow['lead_id']) . '">' . e($_data) . '</a>';
            if (!empty($aRow['lead_company'])) {
                $_data .= '<br><small class="text-muted">' . e($aRow['lead_company']) . '</small>';
            }
        } elseif ($aColumns[$i] == 'confidence_score') {
            // Confidence score with progress bar
            $score = $_data ?: 0;
            $score_class = $score >= 80 ? 'success' : ($score >= 60 ? 'warning' : 'danger');
            $_data = '<div class="progress" style="margin-bottom: 0;">
                        <div class="progress-bar progress-bar-' . $score_class . '" style="width: ' . $score . '%">' . $score . '%</div>
                      </div>';
        } elseif ($aColumns[$i] == 'purchase_likelihood') {
            // Verdict with badge
            $verdict = $_data ?: 'Unknown';
            $badge_class = '';
            switch (strtolower($verdict)) {
                case 'hot':
                case 'high':
                    $badge_class = 'success';
                    break;
                case 'warm':
                case 'medium':
                    $badge_class = 'warning';
                    break;
                case 'cold':
                case 'low':
                    $badge_class = 'danger';
                    break;
                default:
                    $badge_class = 'default';
                    break;
            }
            $_data = '<span class="label label-' . $badge_class . '">' . e($verdict) . '</span>';
        } elseif ($aColumns[$i] == 'analysis_type') {
            // Analysis type
            $_data = e(ucfirst(str_replace('_', ' ', $_data)));
        } elseif ($aColumns[$i] == 'created_at') {
            // Created date
            $_data = e(_dt($_data));
        } elseif ($aColumns[$i] == 'created_by_name') {
            // Created by
            $_data = e($_data ?: 'Unknown');
        }
        
        $row[] = $_data;
    }
    
    // Add actions column
    $actions = '<div class="btn-group">';
    $actions .= '<a href="' . admin_url('ai_reports/view/' . $aRow['id']) . '" class="btn btn-default btn-xs" title="View"><i class="fa fa-eye"></i></a>';
    if (is_admin()) {
        $actions .= '<a href="' . admin_url('ai_reports/delete/' . $aRow['id']) . '" class="btn btn-danger btn-xs" onclick="return confirm(\'Are you sure?\')" title="Delete"><i class="fa fa-trash"></i></a>';
    }
    $actions .= '</div>';
    $row[] = $actions;
    
    $row['DT_RowClass'] = 'has-row-options';
    
    $output['aaData'][] = $row;
}
