<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h4 class="no-margin">
                                    <i class="fa fa-brain text-primary"></i> 
                                    <?php echo $title; ?>
                                </h4>
                                <p class="text-muted">Detailed AI Analysis Report</p>
                            </div>
                            <div class="col-md-4 text-right">
                                <a href="<?php echo admin_url('leads/ai_reports_dashboard'); ?>" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> Back to Reports
                                </a>
                                <a href="<?php echo admin_url('leads/index/' . $lead->id); ?>" class="btn btn-primary">
                                    <i class="fa fa-user"></i> View Lead
                                </a>
                            </div>
                        </div>
                        <hr class="hr-panel-heading">
                        
                        <!-- Report Header -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Lead Information</h4>
                                    </div>
                                    <div class="panel-body">
                                        <table class="table table-bordered">
                                            <tr>
                                                <th width="30%">Name:</th>
                                                <td><?php echo $lead->name; ?></td>
                                            </tr>
                                            <tr>
                                                <th>Email:</th>
                                                <td><?php echo $lead->email; ?></td>
                                            </tr>
                                            <tr>
                                                <th>Company:</th>
                                                <td><?php echo $lead->company; ?></td>
                                            </tr>
                                            <tr>
                                                <th>Phone:</th>
                                                <td><?php echo $lead->phonenumber; ?></td>
                                            </tr>
                                            <tr>
                                                <th>Source:</th>
                                                <td><?php echo $lead->source_name ?? 'Unknown'; ?></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="panel panel-primary">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Analysis Summary</h4>
                                    </div>
                                    <div class="panel-body">
                                        <table class="table table-bordered">
                                            <tr>
                                                <th width="30%">Confidence Score:</th>
                                                <td>
                                                    <div class="progress" style="margin-bottom: 5px;">
                                                        <div class="progress-bar progress-bar-<?php 
                                                            echo $report->score >= 80 ? 'success' : 
                                                                ($report->score >= 60 ? 'warning' : 'danger'); 
                                                        ?>" 
                                                             style="width: <?php echo $report->score; ?>%">
                                                            <?php echo $report->score; ?>%
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Verdict:</th>
                                                <td>
                                                    <span class="label label-<?php 
                                                        echo strtolower($report->verdict) == 'hot' ? 'danger' : 
                                                            (strtolower($report->verdict) == 'warm' ? 'warning' : 
                                                            (strtolower($report->verdict) == 'qualified' ? 'success' : 'default')); 
                                                    ?> label-lg">
                                                        <?php echo $report->verdict; ?>
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Confidence Level:</th>
                                                <td><?php echo $report->confidence_level ?? 'Medium'; ?></td>
                                            </tr>
                                            <tr>
                                                <th>Analysis Date:</th>
                                                <td><?php echo _dt($report->created_at); ?></td>
                                            </tr>
                                            <tr>
                                                <th>Analyst:</th>
                                                <td>
                                                    <?php echo ($report->analyst_firstname ?? '') . ' ' . ($report->analyst_lastname ?? ''); ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Files Analyzed:</th>
                                                <td>
                                                    <span class="badge"><?php echo $report->files_analyzed_count ?? 0; ?></span>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Detailed Analysis Sections -->
                        <div class="row">
                            <div class="col-md-12">
                                
                                <!-- Key Insights -->
                                <div class="panel panel-success">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-lightbulb-o"></i> Detailed Key Insights
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <div class="well">
                                            <?php echo nl2br(htmlspecialchars($report->detailed_insights ?? $report->rationale ?? 'No insights available')); ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Recommendations -->
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-tasks"></i> Detailed Recommendations
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <div class="well">
                                            <?php echo nl2br(htmlspecialchars($report->detailed_recommendations ?? $report->recommendations ?? 'No recommendations available')); ?>
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                        
                        <!-- Advanced Analysis Sections -->
                        <div class="row">
                            
                            <!-- Communication Analysis -->
                            <?php if (!empty($report->communication_analysis)): ?>
                            <div class="col-md-6">
                                <div class="panel panel-primary">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-comments"></i> Communication Analysis
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php echo nl2br(htmlspecialchars($report->communication_analysis)); ?>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <!-- Timeline Analysis -->
                            <?php if (!empty($report->timeline_analysis)): ?>
                            <div class="col-md-6">
                                <div class="panel panel-warning">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-clock-o"></i> Timeline Analysis
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php echo nl2br(htmlspecialchars($report->timeline_analysis)); ?>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                        </div>
                        
                        <div class="row">
                            
                            <!-- Financial Assessment -->
                            <?php if (!empty($report->financial_assessment)): ?>
                            <div class="col-md-6">
                                <div class="panel panel-success">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-dollar"></i> Financial Assessment
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php echo nl2br(htmlspecialchars($report->financial_assessment)); ?>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <!-- Competitive Landscape -->
                            <?php if (!empty($report->competitive_landscape)): ?>
                            <div class="col-md-6">
                                <div class="panel panel-danger">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-line-chart"></i> Competitive Landscape
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php echo nl2br(htmlspecialchars($report->competitive_landscape)); ?>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                        </div>
                        
                        <!-- Relationship Status -->
                        <?php if (!empty($report->relationship_status)): ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-handshake-o"></i> Relationship Status
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php echo nl2br(htmlspecialchars($report->relationship_status)); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Signals and Risk Factors -->
                        <div class="row">
                            
                            <!-- Positive Signals -->
                            <div class="col-md-6">
                                <div class="panel panel-success">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-thumbs-up"></i> Positive Signals
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php 
                                        $positive_signals = json_decode($report->positive_signals ?? '[]', true);
                                        if (!empty($positive_signals) && is_array($positive_signals)):
                                        ?>
                                            <ul class="list-unstyled">
                                                <?php foreach ($positive_signals as $signal): ?>
                                                    <li><i class="fa fa-check text-success"></i> <?php echo htmlspecialchars($signal); ?></li>
                                                <?php endforeach; ?>
                                            </ul>
                                        <?php else: ?>
                                            <p class="text-muted">No specific positive signals identified.</p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Risk Factors -->
                            <div class="col-md-6">
                                <div class="panel panel-danger">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-exclamation-triangle"></i> Risk Factors
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php 
                                        $risk_factors = json_decode($report->risk_factors ?? '[]', true);
                                        if (!empty($risk_factors) && is_array($risk_factors)):
                                        ?>
                                            <ul class="list-unstyled">
                                                <?php foreach ($risk_factors as $risk): ?>
                                                    <li><i class="fa fa-warning text-danger"></i> <?php echo htmlspecialchars($risk); ?></li>
                                                <?php endforeach; ?>
                                            </ul>
                                        <?php else: ?>
                                            <p class="text-muted">No specific risk factors identified.</p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                        
                        <!-- Technical Details -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-cogs"></i> Technical Details
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <strong>Analysis Type:</strong><br>
                                                <span class="text-muted"><?php echo $report->analysis_type ?? 'Unknown'; ?></span>
                                            </div>
                                            <div class="col-md-3">
                                                <strong>Analysis Version:</strong><br>
                                                <span class="text-muted"><?php echo $report->analysis_version ?? 'v1.0'; ?></span>
                                            </div>
                                            <div class="col-md-3">
                                                <strong>Processing Time:</strong><br>
                                                <span class="text-muted"><?php echo $report->processing_time ?? 0; ?>s</span>
                                            </div>
                                            <div class="col-md-3">
                                                <strong>Last Updated:</strong><br>
                                                <span class="text-muted">
                                                    <?php echo $report->updated_at ? _dt($report->updated_at) : 'Never'; ?>
                                                </span>
                                            </div>
                                        </div>
                                        
                                        <?php if (!empty($report->raw_ai_response)): ?>
                                        <hr>
                                        <button type="button" class="btn btn-sm btn-default" data-toggle="collapse" data-target="#rawResponse">
                                            <i class="fa fa-code"></i> Show Raw AI Response (Debug)
                                        </button>
                                        <div id="rawResponse" class="collapse mtop15">
                                            <pre style="max-height: 300px; overflow-y: auto; background: #f5f5f5; padding: 10px; border-radius: 4px;"><?php echo htmlspecialchars($report->raw_ai_response); ?></pre>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php init_tail(); ?>
