<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<style>
    .additional-phone-numbers {
        margin-top: 4px;
        padding-left: 8px;
        border-left: 2px solid #e3f2fd;
        background: #f8fbff;
        border-radius: 0 4px 4px 0;
        padding: 4px 8px;
    }
    .additional-phone {
        margin: 2px 0;
        font-size: 0.9em;
        color: #2563eb;
        font-weight: 500;
    }
    .additional-phone:before {
        content: "📞 ";
        margin-right: 2px;
    }
    .additional-phone a {
        color: #2563eb;
        text-decoration: none;
        transition: color 0.2s ease;
    }
    .additional-phone a:hover {
        color: #1d4ed8;
        text-decoration: underline;
    }
    
    /* Address field styling */
    .address-value {
        max-height: 40px;
        overflow-y: auto;
    }
    
    /* Compact styling for tags */
    .info-value .label {
        font-size: 9px !important;
        padding: 2px 6px !important;
        margin: 1px !important;
    }
    
    /* Modern Lead Information Styling - Ultra Compact */
    .lead-info-container {
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        border-radius: 12px;
        padding: 15px;
        margin: 10px 0;
        box-shadow: 0 4px 12px rgba(0,0,0,0.06);
        border: 1px solid #e2e8f0;
    }
    
    .lead-section {
        background: white;
        border-radius: 8px;
        padding: 12px;
        margin-bottom: 12px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.04);
        border: 1px solid #f1f5f9;
        transition: all 0.2s ease;
        position: relative;
    }
    
    .lead-section::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 2px;
        background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
    }
    
    .lead-section:hover {
        box-shadow: 0 4px 12px rgba(0,0,0,0.08);
    }
    
    .section-header {
        display: flex;
        align-items: center;
        gap: 8px;
        margin-bottom: 10px;
        padding-bottom: 6px;
        border-bottom: 1px solid #f1f5f9;
    }
    
    .section-icon {
        width: 24px;
        height: 24px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 6px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 12px;
        font-weight: 600;
    }
    
    .section-title {
        font-size: 14px;
        font-weight: 700;
        color: #1e293b;
        margin: 0;
        letter-spacing: -0.025em;
    }
    
    .lead-info-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
        gap: 6px;
        margin-bottom: 0;
    }
    
    .info-item {
        background: #f8fafc;
        border-radius: 6px;
        padding: 8px;
        border: 1px solid #e2e8f0;
        transition: all 0.2s ease;
    }
    
    .info-item.full-width {
        grid-column: 1 / -1;
    }
    
    .info-item:hover {
        background: #f1f5f9;
        border-color: #cbd5e1;
    }
    
    .info-label {
        font-size: 9px;
        font-weight: 600;
        color: #64748b;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        margin-bottom: 3px;
        display: flex;
        align-items: center;
        gap: 4px;
    }
    
    .info-value {
        font-size: 12px;
        font-weight: 600;
        color: #1e293b;
        line-height: 1.2;
        word-break: break-word;
    }
    
    .info-value a {
        color: #2563eb;
        text-decoration: none;
        transition: color 0.2s ease;
    }
    
    .info-value a:hover {
        color: #1d4ed8;
        text-decoration: underline;
    }
    
    .info-value.empty {
        color: #94a3b8;
        font-style: italic;
        font-weight: 400;
        font-size: 11px;
    }
    
    .status-badge {
        display: inline-flex;
        align-items: center;
        gap: 4px;
        padding: 3px 8px;
        border-radius: 12px;
        font-size: 10px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.3px;
    }
    
    .description-content {
        background: #f8fafc;
        border-radius: 6px;
        padding: 10px;
        border: 1px solid #e2e8f0;
        font-size: 12px;
        line-height: 1.4;
        color: #475569;
        max-height: 80px;
        overflow-y: auto;
    }
    
    .activity-container {
        background: #f8fafc;
        border-radius: 6px;
        padding: 10px;
        border: 1px solid #e2e8f0;
        min-height: 60px;
        max-height: 100px;
        overflow-y: auto;
    }
    
    /* Icon Styles */
    .info-icon {
        font-size: 10px;
        color: #667eea;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
        .lead-info-container {
            padding: 10px;
            margin: 5px 0;
        }
        
        .lead-section {
            padding: 8px;
            margin-bottom: 8px;
        }
        
        .lead-info-grid {
            grid-template-columns: 1fr;
            gap: 6px;
        }
        
        .section-header {
            gap: 6px;
            margin-bottom: 8px;
        }
        
        .section-icon {
            width: 20px;
            height: 20px;
            font-size: 10px;
        }
        
        .section-title {
            font-size: 12px;
        }
        
        .info-item {
            padding: 6px;
        }
        
        .description-content,
        .activity-container {
            padding: 8px;
            max-height: 60px;
        }
    }
</style>
<!-- Include the duplicate phone number warning CSS -->
<link rel="stylesheet" href="<?= base_url('assets/css/phone_duplicate.css') . '?v=' . time(); ?>">
<div class="lead-wrapper<?= $openEdit == true ? ' open-edit' : ''; ?>"
    <?= isset($lead) && ($lead->junk == 1 || $lead->lost == 1) ? 'lead-is-just-or-lost' : ''; ?>>

    <?php if (isset($lead)) { ?>
    <div class="tw-flex tw-items-center tw-justify-end tw-space-x-1.5">
        <?php
        $client = false;
        $convert_to_client_tooltip_email_exists = '';
        if (total_rows(db_prefix() . 'contacts', ['email' => $lead->email]) > 0 && total_rows(db_prefix() . 'clients', ['leadid' => $lead->id]) == 0) {
            $convert_to_client_tooltip_email_exists = _l('lead_email_already_exists');
            $text = _l('lead_convert_to_client');
        } elseif (total_rows(db_prefix() . 'clients', ['leadid' => $lead->id])) {
            $client = true;
        } else {
            $text = _l('lead_convert_to_client');
        }
        ?>

        <?php if ($lead_locked == false) { ?>
        <div class="lead-edit<?= isset($lead) ? ' hide' : ''; ?>">
            <button type="button" class="btn btn-primary lead-top-btn lead-save-btn"
                onclick="document.getElementById('lead-form-submit').click();">
                <?= _l('submit'); ?>
            </button>
        </div>
        <?php } ?>
        
        <?php if ($client && (staff_can('view', 'customers') || is_customer_admin(get_client_id_by_lead_id($lead->id)))) { ?>
        <a data-toggle="tooltip" class="btn btn-primary lead-top-btn lead-view" data-placement="top"
            title="<?= _l('lead_converted_edit_client_profile'); ?>"
            href="<?= admin_url('clients/client/' . get_client_id_by_lead_id($lead->id)); ?>">
            <i class="fa-regular fa-user"></i>
        </a>
        <?php } ?>
        <?php if (total_rows(db_prefix() . 'clients', ['leadid' => $lead->id]) == 0) { ?>
        <a href="#" data-toggle="tooltip"
            data-title="<?= e($convert_to_client_tooltip_email_exists); ?>"
            class="btn btn-primary lead-convert-to-customer lead-top-btn lead-view"
            onclick="convert_lead_to_customer(<?= e($lead->id); ?>); return false;">
            <i class="fa-regular fa-user"></i>
            <?= e($text); ?>
        </a>
        <?php } ?>

        <div
            class="<?= $lead_locked == true ? ' hide' : ''; ?>">
            <a href="#" lead-edit data-toggle="tooltip"
                data-title="<?= _l('edit'); ?>"
                class="btn btn-default lead-top-btn !tw-px-3">

                <i class="fa-regular fa-pen-to-square"></i>
            </a>
        </div>

        <div class="btn-group" id="lead-more-btn">
            <a href="#" class="btn btn-default dropdown-toggle lead-top-btn" data-toggle="dropdown" aria-haspopup="true"
                aria-expanded="false">
                <?= _l('more'); ?>
                <span class="caret"></span>
            </a>
            <ul class="dropdown-menu dropdown-menu-right" id="lead-more-dropdown">
                <?php if ($lead->junk == 0) {
                    if ($lead->lost == 0 && (total_rows(db_prefix() . 'clients', ['leadid' => $lead->id]) == 0)) { ?>
                <li>
                    <a href="#"
                        onclick="lead_mark_as_lost(<?= e($lead->id); ?>); return false;">
                        <i class="fa fa-mars"></i>
                        <?= _l('lead_mark_as_lost'); ?>
                    </a>
                </li>
                <?php } elseif ($lead->lost == 1) { ?>
                <li>
                    <a href="#"
                        onclick="lead_unmark_as_lost(<?= e($lead->id); ?>); return false;">
                        <i class="fa fa-smile-o"></i>
                        <?= _l('lead_unmark_as_lost'); ?>
                    </a>
                </li>
                <?php } ?>
                <?php } ?>
                <!-- mark as junk -->
                <?php if ($lead->lost == 0) {
                    if ($lead->junk == 0 && (total_rows(db_prefix() . 'clients', ['leadid' => $lead->id]) == 0)) { ?>
                <li>
                    <a href="#"
                        onclick="lead_mark_as_junk(<?= e($lead->id); ?>); return false;">
                        <i class="fa fa fa-times"></i>
                        <?= _l('lead_mark_as_junk'); ?>
                    </a>
                </li>
                <?php } elseif ($lead->junk == 1) { ?>
                <li>
                    <a href="#"
                        onclick="lead_unmark_as_junk(<?= e($lead->id); ?>); return false;">
                        <i class="fa fa-smile-o"></i>
                        <?= _l('lead_unmark_as_junk'); ?>
                    </a>
                </li>
                <?php } ?>
                <?php } ?>
                <?php if ((staff_can('delete', 'leads') && $lead_locked == false) || is_admin()) { ?>
                <li>
                    <a href="<?= admin_url('leads/delete/' . $lead->id); ?>"
                        class="text-danger delete-text _delete" data-toggle="tooltip" title="">
                        <i class="fa-regular fa-trash-can"></i>
                        <?= _l('lead_edit_delete_tooltip'); ?>
                    </a>
                </li>
                <?php } ?>
            </ul>
        </div>
    </div>
    <?php } ?>

    <div class="clearfix no-margin"></div>

    <?php if (isset($lead)) { ?>
    <div class="row mbot15" style="margin-top:12px;">
        <hr class="no-margin" />
    </div>

    <div class="alert alert-warning hide mtop20" role="alert" id="lead_proposal_warning">
        <?= _l('proposal_warning_email_change', [_l('lead_lowercase'), _l('lead_lowercase'), _l('lead_lowercase')]); ?>
        <hr />
        <a href="#"
            onclick="update_all_proposal_emails_linked_to_lead(<?= e($lead->id); ?>); return false;"
            class="alert-link">
            <?= _l('update_proposal_email_yes'); ?>
        </a>
        <br />
        <a href="#"
            onclick="init_lead_modal_data(<?= e($lead->id); ?>); return false;"
            class="alert-link">
            <?= _l('update_proposal_email_no'); ?>
        </a>
    </div>
    <?php } ?>
    
    <?= form_open((isset($lead) ? admin_url('leads/lead/' . $lead->id) : admin_url('leads/lead')), ['id' => 'lead_form']); ?>
    <div class="row">
        <!-- SINGLE PAGE LEAD INFORMATION -->
        <div class="col-md-12">
            <div class="lead-info-container">
                <div class="lead-view<?= !isset($lead) ? ' hide' : ''; ?>" id="leadViewWrapper">
                    
                    <!-- BASIC INFORMATION SECTION -->
                    <div class="lead-section">
                        <div class="section-header">
                            <div class="section-icon">
                                <i class="fa-solid fa-user"></i>
                            </div>
                            <h3 class="section-title"><?= _l('lead_info'); ?></h3>
                        </div>
                        
                        <div class="lead-info-grid">
                            <!-- Name & Title -->
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-id-badge info-icon"></i>
                                    <?= _l('Title'); ?>
                                </div>
                                <div class="info-value <?= !isset($lead) || $lead->salutation == '' ? 'empty' : '' ?>">
                                    <?= isset($lead) && $lead->salutation != '' ? e(ucfirst($lead->salutation)) : 'Not specified' ?>
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-signature info-icon"></i>
                                    <?= _l('lead_add_edit_name'); ?>
                                </div>
                                <div class="info-value lead-name <?= !isset($lead) || $lead->name == '' ? 'empty' : '' ?>">
                                    <?= isset($lead) && $lead->name != '' ? e($lead->name) : 'Not specified' ?>
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-briefcase info-icon"></i>
                                    <?= _l('lead_title'); ?>
                                </div>
                                <div class="info-value <?= !isset($lead) || $lead->title == '' ? 'empty' : '' ?>">
                                    <?= isset($lead) && $lead->title != '' ? e($lead->title) : 'Not specified' ?>
                                </div>
                            </div>
                            
                            <!-- Contact Information -->
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-envelope info-icon"></i>
                                    <?= _l('lead_add_edit_email'); ?>
                                </div>
                                <div class="info-value <?= !isset($lead) || $lead->email == '' ? 'empty' : '' ?>">
                                    <?= isset($lead) && $lead->email != '' ? '<a href="mailto:' . e($lead->email) . '" class="contact-link">' . e($lead->email) . '</a>' : 'Not specified' ?>
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-globe info-icon"></i>
                                    <?= _l('lead_website'); ?>
                                </div>
                                <div class="info-value <?= !isset($lead) || $lead->website == '' ? 'empty' : '' ?>">
                                    <?= isset($lead) && $lead->website != '' ? '<a href="' . e(maybe_add_http($lead->website)) . '" target="_blank" class="contact-link">' . e($lead->website) . '</a>' : 'Not specified' ?>
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-phone info-icon"></i>
                                    <?= _l('lead_add_edit_phonenumber'); ?>
                                </div>
                                <div class="info-value <?= !isset($lead) || $lead->phonenumber == '' ? 'empty' : '' ?>">
                                    <?= isset($lead) && $lead->phonenumber != '' ? '<a href="tel:' . e($lead->phonenumber) . '" class="contact-link">' . e($lead->phonenumber) . '</a>' : 'Not specified' ?>
                                    <?php 
                                    // Display additional phone numbers
                                    if(isset($lead) && !empty($lead->phone_numbers)) {
                                        $phone_numbers = json_decode($lead->phone_numbers, true);
                                        if(is_array($phone_numbers) && count($phone_numbers) > 0) {
                                            echo '<div class="additional-phone-numbers mtop5">';
                                            foreach($phone_numbers as $phone) {
                                                if(!empty($phone)) {
                                                    echo '<div class="additional-phone"><a href="tel:' . e($phone) . '" class="contact-link">' . e($phone) . '</a></div>';
                                                }
                                            }
                                            echo '</div>';
                                        }
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- BUSINESS INFORMATION SECTION -->
                    <div class="lead-section">
                        <div class="section-header">
                            <div class="section-icon">
                                <i class="fa-solid fa-building"></i>
                            </div>
                            <h3 class="section-title">Business Information</h3>
                        </div>
                        
                        <div class="lead-info-grid">
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-dollar-sign info-icon"></i>
                                    <?= _l('Client Budget'); ?>
                                </div>
                                <div class="info-value <?= !isset($lead) || $lead->lead_value == 0 ? 'empty' : '' ?>">
                                    <?= isset($lead) && $lead->lead_value != 0 ? e(app_format_money($lead->lead_value, $base_currency->id)) : 'Not specified' ?>
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-home info-icon"></i>
                                    <?= _l('Apartment type'); ?>
                                </div>
                                <div class="info-value">
                                    <?php
                                    if (isset($lead) && $lead->item_id) {
                                        $CI = &get_instance(); 
                                        $CI->db->select('description');
                                        $CI->db->where('id', $lead->item_id);
                                        $item = $CI->db->get(db_prefix() . 'items')->row();
                                        echo $item ? e($item->description) : 'Not specified';
                                    } else {
                                        echo 'Not specified';
                                    }
                                    ?>
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-building info-icon"></i>
                                    <?= _l('lead_company'); ?>
                                </div>
                                <div class="info-value <?= !isset($lead) || $lead->company == '' ? 'empty' : '' ?>">
                                    <?= isset($lead) && $lead->company != '' ? e($lead->company) : 'Not specified' ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- LOCATION SECTION -->
                    <div class="lead-section">
                        <div class="section-header">
                            <div class="section-icon">
                                <i class="fa-solid fa-map-marker-alt"></i>
                            </div>
                            <h3 class="section-title">Location Information</h3>
                        </div>
                        
                        <div class="lead-info-grid">
                            <div class="info-item full-width">
                                <div class="info-label">
                                    <i class="fa-solid fa-map info-icon"></i>
                                    <?= _l('lead_address'); ?>
                                </div>
                                <div class="info-value address-value <?= !isset($lead) || $lead->address == '' ? 'empty' : '' ?>">
                                    <div class="lead-view">
                                        <?= isset($lead) && $lead->address != '' ? e(clear_textarea_breaks($lead->address)) : 'Not specified' ?>
                                    </div>
                                    <div class="lead-edit hide">
                                        <textarea class="form-control" name="address" rows="4"><?= isset($lead) ? $lead->address : ''; ?></textarea>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-location-dot info-icon"></i>
                                    <?= _l('Location'); ?>
                                </div>
                                <div class="info-value">
                                    <?php
                                    if (isset($lead)) {
                                        $city = !empty($lead->city) ? e($lead->city) : '';
                                        $state = !empty($lead->state) ? e($lead->state) : '';
                                        $countryObj = ($lead->country != 0) ? get_country($lead->country) : false;
                                        $country = ($countryObj && !empty($countryObj->short_name)) ? e($countryObj->short_name) : '';
                                        $locations = array_filter([$city, $state, $country]);
                                        echo count($locations) > 0 ? implode(', ', $locations) : 'Not specified';
                                    } else {
                                        echo 'Not specified';
                                    }
                                    ?>
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-mailbox info-icon"></i>
                                    <?= _l('lead_zip'); ?>
                                </div>
                                <div class="info-value <?= !isset($lead) || $lead->zip == '' ? 'empty' : '' ?>">
                                    <?= isset($lead) && $lead->zip != '' ? e($lead->zip) : 'Not specified' ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- LEAD STATUS & DETAILS SECTION -->
                    <div class="lead-section">
                        <div class="section-header">
                            <div class="section-icon">
                                <i class="fa-solid fa-info-circle"></i>
                            </div>
                            <h3 class="section-title"><?= _l('lead_general_info'); ?></h3>
                        </div>
                        
                        <div class="lead-info-grid">
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-flag info-icon"></i>
                                    <?= _l('lead_add_edit_status'); ?>
                                </div>
                                <div class="info-value">
                                    <?php if (isset($lead)) {
                                        echo $lead->status_name != '' ? ('<span class="lead-status-' . e($lead->status) . ' label' . (empty($lead->color) ? ' label-default' : '') . '" style="color:' . e(isset($lead->color) ? $lead->color : '#333') . ';border:1px solid ' . adjust_hex_brightness(isset($lead->color) ? $lead->color : '#333', 0.4) . ';background: ' . adjust_hex_brightness(isset($lead->color) ? $lead->color : '#333', 0.04) . ';">' . e($lead->status_name) . '</span>') : 'Not specified';
                                    } else {
                                        echo 'Not specified';
                                    } ?>
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-source info-icon"></i>
                                    <?= _l('lead_add_edit_source'); ?>
                                </div>
                                <div class="info-value <?= !isset($lead) || $lead->source_name == '' ? 'empty' : '' ?>">
                                    <?= isset($lead) && $lead->source_name != '' ? e($lead->source_name) : 'Not specified' ?>
                                </div>
                            </div>
                            
                            <?php if (!is_language_disabled()) { ?>
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-language info-icon"></i>
                                    <?= _l('localization_default_language'); ?>
                                </div>
                                <div class="info-value">
                                    <?= isset($lead) && $lead->default_language != '' ? e(ucfirst($lead->default_language)) : _l('system_default_string') ?>
                                </div>
                            </div>
                            <?php } ?>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-user-check info-icon"></i>
                                    <?= _l('lead_add_edit_assigned'); ?>
                                </div>
                                <div class="info-value <?= !isset($lead) || $lead->assigned == 0 ? 'empty' : '' ?>">
                                    <?= isset($lead) && $lead->assigned != 0 ? e(get_staff_full_name($lead->assigned)) : 'Not assigned' ?>
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-tags info-icon"></i>
                                    <?= _l('tags'); ?>
                                </div>
                                <div class="info-value">
                                    <?php if (isset($lead)) {
                                        $tags = get_tags_in($lead->id, 'lead');
                                        if (count($tags) > 0) {
                                            echo render_tags($tags);
                                        } else {
                                            echo 'No tags';
                                        }
                                    } ?>
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-calendar-plus info-icon"></i>
                                    <?= _l('leads_dt_datecreated'); ?>
                                </div>
                                <div class="info-value">
                                    <?= isset($lead) && $lead->dateadded != '' ? '<span class="text-has-action" data-toggle="tooltip" data-title="' . e(_dt($lead->dateadded)) . '">' . e(time_ago($lead->dateadded)) . '</span>' : 'Not specified' ?>
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-clock info-icon"></i>
                                    <?= _l('leads_dt_last_contact'); ?>
                                </div>
                                <div class="info-value">
                                    <?= isset($lead) && $lead->lastcontact != '' ? '<span class="text-has-action" data-toggle="tooltip" data-title="' . e(_dt($lead->lastcontact)) . '">' . e(time_ago($lead->lastcontact)) . '</span>' : 'No contact yet' ?>
                                </div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-eye info-icon"></i>
                                    <?= _l('lead_public'); ?>
                                </div>
                                <div class="info-value">
                                    <?php if (isset($lead)) {
                                        if ($lead->is_public == 1) {
                                            echo _l('lead_is_public_yes');
                                        } else {
                                            echo _l('lead_is_public_no');
                                        }
                                    } else {
                                        echo 'Not specified';
                                    } ?>
                                </div>
                            </div>
                            
                            <?php if (isset($lead) && $lead->from_form_id != 0) { ?>
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-form info-icon"></i>
                                    <?= _l('web_to_lead_form'); ?>
                                </div>
                                <div class="info-value">
                                    <?= e($lead->form_data->name); ?>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                    
                    <!-- CUSTOM FIELDS SECTION -->
                    <?php if (total_rows(db_prefix() . 'customfields', ['fieldto' => 'leads', 'active' => 1]) > 0 && isset($lead)) { ?>
                    <div class="lead-section">
                        <div class="section-header">
                            <div class="section-icon">
                                <i class="fa-solid fa-cogs"></i>
                            </div>
                            <h3 class="section-title"><?= _l('custom_fields'); ?></h3>
                        </div>
                        
                        <div class="lead-info-grid">
                            <?php foreach (get_custom_fields('leads') as $field) { ?>
                            <?php $value = get_custom_field_value($lead->id, $field['id'], 'leads'); ?>
                            <div class="info-item">
                                <div class="info-label">
                                    <i class="fa-solid fa-puzzle-piece info-icon"></i>
                                    <?= e($field['name']); ?>
                                </div>
                                <div class="info-value <?= $value == '' ? 'empty' : '' ?>">
                                    <?= $value != '' ? $value : 'Not specified' ?>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                    <?php } ?>
                    
                    <!-- DESCRIPTION SECTION -->
                    <div class="lead-section">
                        <div class="section-header">
                            <div class="section-icon">
                                <i class="fa-solid fa-file-text"></i>
                            </div>
                            <h3 class="section-title"><?= _l('lead_description'); ?></h3>
                        </div>
                        
                        <div class="description-content">
                            <?= process_text_content_for_display((isset($lead) && $lead->description != '' ? $lead->description : 'No description provided')); ?>
                        </div>
                    </div>
                    
                    <!-- ACTIVITY SECTION -->
                    <?php if (isset($lead)) { ?>
                    <div class="lead-section">
                        <div class="section-header">
                            <div class="section-icon">
                                <i class="fa-solid fa-activity"></i>
                            </div>
                            <h3 class="section-title"><?= _l('lead_latest_activity'); ?></h3>
                        </div>
                        
                        <div class="activity-container">
                            <div id="lead-latest-activity" class="pleft5"></div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        
        <div class="clearfix"></div>
        
        <!-- EDIT FORM (Initially Hidden) -->
        <div class="lead-edit<?= isset($lead) ? ' hide' : ''; ?>">
            <div class="col-md-4">
                <?php
        $selected = '';
if (isset($lead)) {
    $selected = $lead->status;
} elseif (isset($status_id)) {
    $selected = $status_id;
}
echo render_leads_status_select($statuses, $selected, 'lead_add_edit_status');
?>
            </div>
            <div class="col-md-4">
                <?= render_leads_source_select($sources, (isset($lead) ? $lead->source : get_option('leads_default_source')), 'lead_add_edit_source'); ?>
            </div>
            <div class="col-md-4">
                <?php
               $assigned_attrs = [];
$selected                      = (isset($lead) ? $lead->assigned : get_staff_user_id());
if (isset($lead)
   && $lead->assigned == get_staff_user_id()
   && $lead->addedfrom != get_staff_user_id()
   && ! is_admin($lead->assigned)
   && staff_cant('view', 'leads')
) {
    $assigned_attrs['disabled'] = true;
}
echo render_select('assigned', $members, ['staffid', ['firstname', 'lastname']], 'lead_add_edit_assigned', $selected, $assigned_attrs); ?>
            </div>
            <div class="clearfix"></div>
            <hr class="mtop5 mbot10" />
            <div class="col-md-12">
                <div class="form-group no-mbot" id="inputTagsWrapper">
                    <label for="tags" class="control-label"><i class="fa fa-tag" aria-hidden="true"></i>
                        <?= _l('tags'); ?></label>
                    <input type="text" class="tagsinput" id="tags" name="tags"
                        value="<?= isset($lead) ? prep_tags_input(get_tags_in($lead->id, 'lead')) : ''; ?>"
                        data-role="tagsinput">
                </div>
            </div>
            <div class="clearfix"></div>
            <hr class="no-mtop mbot15" />            <div class="col-md-6">
                <?php                // Salutation dropdown
                $salutation_options = array(
                    array('id' => 'Mr', 'name' => 'Mr.'),
                    array('id' => 'Mrs', 'name' => 'Mrs.'),
                    array('id' => 'Ms', 'name' => 'Ms.'),
                    array('id' => 'Dr', 'name' => 'Dr.'),
                    array('id' => 'Prof', 'name' => 'Prof.')
                );
                $selected = (isset($lead) ? $lead->salutation : '');
                echo render_select('salutation', $salutation_options, array('id', 'name'), 'Title', $selected);
                
                // Name field
                $value = (isset($lead) ? $lead->name : '');
                echo render_input('name', 'lead_add_edit_name', $value); ?>
                <?php $value = (isset($lead) ? $lead->title : ''); ?>
                <?= render_input('title', 'lead_title', $value); ?>
                <?php $value = (isset($lead) ? $lead->email : ''); ?>
                <?= render_input('email', 'lead_add_edit_email', $value); ?>
                <?php if ((isset($lead) && empty($lead->website)) || ! isset($lead)) {
                    $value = (isset($lead) ? $lead->website : '');
                    echo render_input('website', 'lead_website', $value);
                } else { ?>
                <div class="form-group">
                    <label
                        for="website"><?= _l('lead_website'); ?></label>
                    <div class="input-group">
                        <input type="text" name="website" id="website"
                            value="<?= e($lead->website); ?>"
                            class="form-control">
                        <div class="input-group-addon">
                            <span>
                                <a href="<?= e(maybe_add_http($lead->website)); ?>"
                                    target="_blank" tabindex="-1">
                                    <i class="fa fa-globe"></i>
                                </a>
                            </span>
                        </div>
                    </div>
                </div>
                <?php }
                $value = (isset($lead) ? $lead->phonenumber : ''); 
                $phone_numbers = isset($lead->phone_numbers) ? json_decode($lead->phone_numbers, true) : []; ?>
                <div class="form-group phone-numbers">
                    <label class="control-label"><?= _l('lead_add_edit_phonenumber'); ?></label>
                    <div class="phone-number-input">
                        <div class="input-group">
                            <input type="text" name="phonenumber" class="form-control" value="<?= $value; ?>" placeholder="Primary Phone Number" />
                        </div>
                    </div>
                    <div id="additional-phone-numbers">
                        <?php if(!empty($phone_numbers) && is_array($phone_numbers)): ?>
                            <?php foreach ($phone_numbers as $index => $phone): ?>
                                <div class="extra-phone-number mtop10">
                                    <div class="input-group">
                                        <input type="text" name="additional_phones[<?= $index; ?>]" class="form-control" value="<?= $phone; ?>" placeholder="Additional Phone Number" />
                                        <div class="input-group-btn">
                                            <button type="button" class="btn btn-danger remove-phone" onclick="removePhone(this)">
                                                <i class="fa fa-minus"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                    <button type="button" class="btn btn-info btn-xs mtop10" id="add-phone-number">
                        <i class="fa fa-plus"></i> <?php echo _l('Add another phone number'); ?>
                    </button>
                </div><div class="form-group">
                    <label
                        for="lead_value"><?= _l('Client Budget'); ?></label>
                    <div class="input-group" data-toggle="tooltip"
                        title="<?= _l('lead_value_tooltip'); ?>">
                        <input type="number" class="form-control" name="lead_value" value="<?php if (isset($lead)) {
                            echo $lead->lead_value;
                        }?>">
                        <div class="input-group-addon">
                            <?= e($base_currency->symbol); ?>
                        </div>
                    </div>
                    </label>
                </div>
                <?php $value = (isset($lead) ? $lead->company : ''); ?>
                <?= render_input('company', 'lead_company', $value); ?>
            </div>            <div class="col-md-6">                <?php
                // Get all available apartment types from items table
                $CI = &get_instance();
                $CI->db->select('id, description');
                $CI->db->where('group_id', 1); // Assuming group_id 1 is for apartments
                $items = $CI->db->get(db_prefix() . 'items')->result_array();
                $selected = (isset($lead) ? $lead->item_id : '');
                echo render_select('item_id', $items, ['id', 'description'], 'Apartment type', $selected, ['data-width' => '100%']); ?>
                <?php $value = (isset($lead) ? $lead->address : ''); ?>
                <?= render_textarea('address', 'lead_address', $value, ['rows' => 1, 'style' => 'height:36px;font-size:100%;']); ?>
                <?php $value = (isset($lead) ? $lead->city : ''); ?>
                <?= render_input('city', 'lead_city', $value); ?>
                <?php $value = (isset($lead) ? $lead->state : ''); ?>
                <?= render_input('state', 'lead_state', $value); ?>
                <?php
                           $countries = get_all_countries();
$customer_default_country             = get_option('customer_default_country');
$selected                             = (isset($lead) ? $lead->country : $customer_default_country);
echo render_select('country', $countries, ['country_id', ['short_name']], 'lead_country', $selected, ['data-none-selected-text' => _l('dropdown_non_selected_tex')]);
?>
                <?php $value = (isset($lead) ? $lead->zip : ''); ?>
                <?= render_input('zip', 'lead_zip', $value); ?>
                <?php if (! is_language_disabled()) { ?>
                <div class="form-group">
                    <label for="default_language"
                        class="control-label"><?= _l('localization_default_language'); ?></label>
                    <select name="default_language" data-live-search="true" id="default_language"
                        class="form-control selectpicker"
                        data-none-selected-text="<?= _l('dropdown_non_selected_tex'); ?>">
                        <option value="">
                            <?= _l('system_default_string'); ?>
                        </option>
                        <?php foreach ($this->app->get_available_languages() as $availableLanguage) {
                            $selected = '';
                            if (isset($lead)) {
                                if ($lead->default_language == $availableLanguage) {
                                    $selected = 'selected';
                                }
                            } ?>
                        <option value="<?= e($availableLanguage); ?>"
                            <?= e($selected); ?>>
                            <?= e(ucfirst($availableLanguage)); ?>
                        </option>
                        <?php
                        } ?>
                    </select>
                </div>
                <?php } ?>
            </div>
            <div class="col-md-12">
                <?php $value = (isset($lead) ? $lead->description : ''); ?>
                <?= render_textarea('description', 'lead_description', $value); ?>
                <div class="row">
                    <div class="col-md-12">
                        <?php if (! isset($lead)) { ?>
                        <div class="lead-select-date-contacted hide">
                            <?= render_datetime_input('custom_contact_date', 'lead_add_edit_datecontacted', '', ['data-date-end-date' => date('Y-m-d')]); ?>
                        </div>
                        <?php } else { ?>
                        <?= render_datetime_input('lastcontact', 'leads_dt_last_contact', _dt($lead->lastcontact), ['data-date-end-date' => date('Y-m-d')]); ?>
                        <?php } ?>
                        <div
                            class="checkbox-inline checkbox<?= isset($lead) ? ' hide' : ''; ?><?= isset($lead) && (is_lead_creator($lead->id) || staff_can('edit', 'leads')) ? ' lead-edit' : ''; ?>">
                            <input type="checkbox" name="is_public"
                                <?= isset($lead) && $lead->is_public ? 'checked' : ''; ?>
                            id="lead_public">
                            <label for="lead_public">
                                <?= _l('lead_public'); ?>
                            </label>
                        </div>
                        <?php if (! isset($lead)) { ?>
                        <div class="checkbox-inline checkbox checkbox-primary">
                            <input type="checkbox" name="contacted_today" id="contacted_today" checked>
                            <label for="contacted_today">
                                <?= _l('lead_add_edit_contacted_today'); ?>
                            </label>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="col-md-12 mtop15">
                <?php $rel_id = (isset($lead) ? $lead->id : false); ?>
                <?= render_custom_fields('leads', $rel_id); ?>
            </div>
            <div class="clearfix"></div>
        </div>
    </div>

    <?php if ($lead_locked == false) { ?>
    <div class="lead-edit<?= isset($lead) ? ' hide' : ''; ?>">
        <hr class="-tw-mx-5 tw-border-neutral-200" />
        <button type="submit" class="btn btn-primary pull-right lead-save-btn" id="lead-form-submit">
            <?= _l('submit'); ?>
        </button>
        <button type=" button" class="btn btn-default pull-right mright5" data-dismiss="modal">
            <?= _l('close'); ?>
        </button>
    </div>
    <?php } ?>
    <div class="clearfix"></div>
    <?= form_close(); ?>
</div>

<?php if (isset($lead) && $lead_locked == true) { ?>
<script>
    $(function() {
        // Set all fields to disabled if lead is locked
        $.each($('.lead-wrapper').find('input, select, textarea'), function() {
            $(this).attr('disabled', true);
            if ($(this).is('select')) {
                $(this).selectpicker('refresh');
            }
        });
    });
</script>
<?php } ?>

<script>
$(function() {
    // Add phone number field
    $('#add-phone-number').on('click', function() {
        var newInput = $('<div class="phone-number-input mtop10">' +
            '<div class="input-group">' +
            '<input type="text" name="phonenumber[]" class="form-control" placeholder="<?php echo _l("lead_add_edit_phonenumber"); ?>">' +
            '<div class="input-group-btn">' +
            '<button type="button" class="btn btn-danger remove-phone-number"><i class="fa fa-remove"></i></button>' +
            '</div>' +
            '</div>' +
            '</div>');
        $('#additional-phone-numbers').append(newInput);
    });

    // Remove phone number field
    $(document).on('click', '.remove-phone-number', function() {
        $(this).closest('.phone-number-input').remove();
    });
});
</script>
<!-- Load the leads.js script -->
<script src="<?= base_url('assets/js/leads.js') . '?v=' . time(); ?>"></script>