<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
    <link href="<?php echo base_url('assets/css/lead_notes_enhanced.css?v=' . time()); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo base_url('assets/css/lead_attachments.css?v=' . time()); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo base_url('assets/css/ai_lead_analysis.css?v=' . time()); ?>" rel="stylesheet" type="text/css" />
    <script src="<?php echo base_url('assets/js/lead_attachment_fix.js?v=' . time()); ?>"></script>
    <script src="<?php echo base_url('assets/js/ai_lead_analysis.js?v=' . time()); ?>"></script>
    
    <!-- CSRF Token for AJAX requests -->
    <script>
        window.csrfToken = '<?= $this->security->get_csrf_hash(); ?>';
        window.csrfName = '<?= $this->security->get_csrf_token_name(); ?>';
    </script>
    <?php
    // Add monitoring script if enabled in session
    if (isset($_SESSION['enable_description_monitor']) && $_SESSION['enable_description_monitor']) {
        echo '<script src="' . base_url('assets/js/description_monitor.js?v=' . time()) . '"></script>';
        echo '<!-- Description monitoring enabled -->';
        // Clear flag after one use
        unset($_SESSION['enable_description_monitor']);
    }
    ?>
    <div class="tw-flex tw-justify-between tw-items-center">
        <h4 class="modal-title tw-flex tw-items-center">
            <?php if (isset($lead)) { ?>
            <?php $name = ! empty($lead->name) ? $lead->name : (! empty($lead->company) ? $lead->company : _l('lead')); ?>
            #<?= $lead->id; ?> -
            <?= e($name); ?>
            <div class="tw-ml-3 -tw-mt-px">
                <?php if ($lead->lost == 1) { ?>
                <span
                    class="label label-danger"><?= _l('lead_lost'); ?></span>
                <?php } elseif ($lead->junk == 1) { ?>
                <span
                    class="label label-warning"><?= _l('lead_junk'); ?></span>
                <?php } elseif (total_rows(db_prefix() . 'clients', ['leadid' => $lead->id])) { ?>
                <span
                    class="label label-success"><?= _l('lead_is_client'); ?></span>
                <?php } ?>
            </div>
            <?php } else { ?>
            <?= _l('add_new', _l('lead_lowercase')); ?>
            <?php } ?>
        </h4>

        <?php if (isset($lead)) { ?>
        <a href="#"
            class="lead-print-btn tw-text-neutral-500 hover:tw-text-neutral-800 focus:tw-text-neutral-800 tw-mt-1 tw-space-x-1.5 tw-mx-4"
            onclick="print_lead_information(); return false;">
            <i class="fa-solid fa-print"></i>
            <span><?= _l('print'); ?></span>
        </a>
        <?php } ?>
    </div>

</div>
<div class="modal-body">
    <div class="row">
        <div class="col-md-12">
            <?php if (isset($lead)) {
                echo form_hidden('leadid', $lead->id);
            } ?>
            <div class="top-lead-menu">
                <?php if (isset($lead)) { ?>
                <div class="horizontal-scrollable-tabs tw-mb-10">
                    <div class="scroller arrow-left"><i class="fa fa-angle-left"></i></div>
                    <div class="scroller arrow-right"><i class="fa fa-angle-right"></i></div>
                    <div class="horizontal-tabs">
                        <ul class="nav nav-tabs nav-tabs-horizontal nav-tabs-segmented<?= ! isset($lead) ? ' lead-new' : ''?>"
                            role="tablist">
                            <li role="presentation" class="active">
                                <a href="#tab_lead_profile" aria-controls="tab_lead_profile" role="tab"
                                    data-toggle="tab">
                                    <i class="fa-regular fa-user menu-icon"></i>
                                    <?= _l('lead_profile'); ?>
                                </a>
                            </li>
                            <?php if (isset($lead)) { ?>
                            <li role="presentation">
                                <a href="#ai_analysis" aria-controls="ai_analysis" role="tab" data-toggle="tab">
                                    <i class="fa-solid fa-brain menu-icon"></i>
                                    AI Analysis
                                </a>
                            </li>
                            <?php if (count($mail_activity) > 0 || isset($show_email_activity) && $show_email_activity) { ?>
                            <li role="presentation">
                                <a href="#tab_email_activity" aria-controls="tab_email_activity" role="tab"
                                    data-toggle="tab">
                                    <i class="fa-regular fa-envelope menu-icon"></i>
                                    <?= hooks()->apply_filters('lead_email_activity_subject', _l('lead_email_activity')); ?>
                                </a>
                            </li>
                            <?php } ?>
                            <li role="presentation">
                                <a href="#tab_proposals_leads"
                                    onclick="initDataTable('.table-proposals-lead', admin_url + 'proposals/proposal_relations/' + <?= e($lead->id); ?> + '/lead','undefined', 'undefined','undefined',[6,'desc']);"
                                    aria-controls="tab_proposals_leads" role="tab" data-toggle="tab">
                                    <i class="fa-regular fa-file-lines menu-icon"></i>
                                    <?= _l('proposals');
                                if ($total_proposals > 0) {
                                    echo ' <span class="badge">' . $total_proposals . '</span>';
                                }
                                ?>
                                </a>
                            </li>
                            <li role="presentation">
                                <a href="#tab_tasks_leads"
                                    onclick="init_rel_tasks_table(<?= e($lead->id); ?>,'lead','.table-rel-tasks-leads');"
                                    aria-controls="tab_tasks_leads" role="tab" data-toggle="tab">
                                    <i class="fa-regular fa-circle-check menu-icon"></i>
                                    <?= _l('tasks');
                                if ($total_tasks > 0) {
                                    echo ' <span class="badge">' . $total_tasks . '</span>';
                                }
                                ?>
                                </a>
                            </li>
                            <li role="presentation">
                                <a href="#attachments" aria-controls="attachments" role="tab" data-toggle="tab">
                                    <i class="fa-solid fa-paperclip menu-icon"></i>
                                    <?= _l('lead_attachments');
                                if ($total_attachments > 0) {
                                    echo ' <span class="badge">' . $total_attachments . '</span>';
                                }
                                ?>
                                </a>
                            </li>
                            <li role="presentation">
                                <a href="#lead_reminders" 
                                    onclick="initDataTable('.table-reminders-leads', admin_url + 'misc/get_reminders/' + <?= e($lead->id); ?> + '/' + 'lead', undefined, undefined, undefined,[1,'asc']); return false;"
                                    aria-controls="lead_reminders" role="tab" data-toggle="tab">
                                    <i class="fa-regular fa-bell menu-icon"></i>
                                    <?= _l('reminders');
                                    // You could add a badge here if needed, similar to other tabs
                                    ?>
                                </a>
                            </li>
                            <li role="presentation">
                                <a href="#lead_notes" aria-controls="lead_notes" role="tab" data-toggle="tab">
                                    <i class="fa-regular fa-note-sticky menu-icon"></i>
                                    <?= _l('Followups');
                                    if ($total_notes > 0) {
                                        echo ' <span class="badge">' . $total_notes . '</span>';
                                    }
                                    ?>
                                </a>
                            </li>
                            <li role="presentation">
                                <a href="#lead_activity" aria-controls="lead_activity" role="tab" data-toggle="tab">
                                    <i class="fa-solid fa-grip-lines-vertical menu-icon"></i>
                                    <?= _l('lead_add_edit_activity'); ?>
                                </a>
                            </li>
                            <?php if (is_gdpr() && (get_option('gdpr_enable_lead_public_form') == '1' || get_option('gdpr_enable_consent_for_leads') == '1')) { ?>
                            <li role="presentation">
                                <a href="#gdpr" aria-controls="gdpr" role="tab" data-toggle="tab">
                                    <i class="fa-solid fa-gavel menu-icon"></i>
                                    <?= _l('gdpr_short'); ?>
                                </a>
                            </li>
                            <?php } ?>
                            <?php } ?>
                            <?php hooks()->do_action('after_lead_lead_tabs', $lead ?? null); ?>
                        </ul>
                    </div>
                </div>
                <?php } ?>
            </div>
            <!-- Tab panes -->
            <div class="tab-content">
                <!-- from leads modal -->
                <div role="tabpanel" class="tab-pane active" id="tab_lead_profile">
                    <?php $this->load->view('admin/leads/profile'); ?>
                </div>
                <?php if (isset($lead)) { ?>
                <div role="tabpanel" class="tab-pane" id="ai_analysis">
                    <div class="ai-analysis-container-modern">
                        <!-- Hero Section -->
                        <div class="ai-hero-section">
                            <div class="ai-hero-content">
                                <div class="ai-hero-icon">
                                    <i class="fa-solid fa-brain"></i>
                                </div>
                                <div class="ai-hero-text">
                                    <h3 class="ai-title">AI-Powered Lead Intelligence</h3>
                                    <p class="ai-subtitle">Unlock deep insights about your lead with advanced artificial intelligence analysis</p>
                                </div>
                            </div>
                            <div class="ai-hero-stats">
                                <div class="ai-stat-item">
                                    <span class="ai-stat-number" id="total-analyses">0</span>
                                    <span class="ai-stat-label">Total Analyses</span>
                                </div>
                                <div class="ai-stat-item">
                                    <span class="ai-stat-number" id="confidence-score">--</span>
                                    <span class="ai-stat-label">Avg. Score</span>
                                </div>
                            </div>
                        </div>

                        <!-- Quick Actions Dashboard -->
                        <div class="ai-dashboard-grid">
                            <div class="ai-card ai-card-primary">
                                <div class="ai-card-header">
                                    <i class="fa-solid fa-file-text"></i>
                                    <h4>Document Analysis</h4>
                                </div>
                                <div class="ai-card-body">
                                    <p>Extract insights from contracts, proposals, and documents</p>
                                    <button class="ai-quick-btn" data-analysis-type="document_analysis">
                                        <i class="fa-solid fa-upload"></i> Analyze Documents
                                    </button>
                                </div>
                            </div>

                            <div class="ai-card ai-card-success">
                                <div class="ai-card-header">
                                    <i class="fa-solid fa-target"></i>
                                    <h4>Lead Scoring</h4>
                                </div>
                                <div class="ai-card-body">
                                    <p>Get intelligent lead qualification and priority scoring</p>
                                    <button class="ai-quick-btn" data-analysis-type="lead_scoring">
                                        <i class="fa-solid fa-chart-line"></i> Score Lead
                                    </button>
                                </div>
                            </div>

                            <div class="ai-card ai-card-info">
                                <div class="ai-card-header">
                                    <i class="fa-solid fa-comments"></i>
                                    <h4>Conversation Analysis</h4>
                                </div>
                                <div class="ai-card-body">
                                    <p>Analyze communication patterns and sentiment</p>
                                    <button class="ai-quick-btn" data-analysis-type="conversation_analysis">
                                        <i class="fa-solid fa-microphone"></i> Analyze Talks
                                    </button>
                                </div>
                            </div>

                            <div class="ai-card ai-card-warning">
                                <div class="ai-card-header">
                                    <i class="fa-solid fa-building"></i>
                                    <h4>Company Research</h4>
                                </div>
                                <div class="ai-card-body">
                                    <p>Deep dive into company background and market position</p>
                                    <button class="ai-quick-btn" data-analysis-type="company_research">
                                        <i class="fa-solid fa-search"></i> Research Company
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Advanced Analysis Panel -->
                        <div class="ai-analysis-panel" id="ai-analysis-panel" style="display: none;">
                            <div class="ai-panel-header">
                                <h4 class="ai-panel-title">
                                    <i class="fa-solid fa-cog"></i>
                                    <span id="analysis-type-title">Advanced Analysis Configuration</span>
                                </h4>
                                <button class="ai-panel-close" id="close-analysis-panel">
                                    <i class="fa-solid fa-times"></i>
                                </button>
                            </div>

                            <div class="ai-panel-body">
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="ai-upload-zone">
                                            <div class="ai-form-group">
                                                <label class="ai-label">
                                                    <i class="fa-solid fa-list"></i> Analysis Type
                                                </label>
                                                <select id="ai_analysis_type" name="ai_analysis_type" class="ai-select">
                                                    <option value="document_analysis">📄 Document Analysis</option>
                                                    <option value="lead_scoring">🎯 Lead Scoring & Qualification</option>
                                                    <option value="conversation_analysis">💬 Conversation & Sentiment Analysis</option>
                                                    <option value="company_research">🏢 Company Research & Intelligence</option>
                                                    <option value="competitive_analysis">⚔️ Competitive Analysis</option>
                                                    <option value="opportunity_assessment">💎 Opportunity Assessment</option>
                                                    <option value="risk_evaluation">⚠️ Risk Evaluation</option>
                                                </select>
                                            </div>

                                            <div class="ai-form-group">
                                                <label class="ai-label">
                                                    <i class="fa-solid fa-brain"></i> Analysis Focus
                                                </label>
                                                <div class="ai-focus-options">
                                                    <label class="ai-checkbox-label">
                                                        <input type="checkbox" name="analysis_focus[]" value="financial_capacity" class="ai-checkbox">
                                                        <span class="ai-checkbox-text">Financial Capacity</span>
                                                    </label>
                                                    <label class="ai-checkbox-label">
                                                        <input type="checkbox" name="analysis_focus[]" value="decision_making" class="ai-checkbox">
                                                        <span class="ai-checkbox-text">Decision Making Process</span>
                                                    </label>
                                                    <label class="ai-checkbox-label">
                                                        <input type="checkbox" name="analysis_focus[]" value="pain_points" class="ai-checkbox">
                                                        <span class="ai-checkbox-text">Pain Points & Needs</span>
                                                    </label>
                                                    <label class="ai-checkbox-label">
                                                        <input type="checkbox" name="analysis_focus[]" value="timeline" class="ai-checkbox">
                                                        <span class="ai-checkbox-text">Purchase Timeline</span>
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="ai-form-group">
                                                <label class="ai-label">
                                                    <i class="fa-solid fa-comment-dots"></i> Additional Context
                                                </label>
                                                <textarea id="ai_analysis_notes" name="ai_analysis_notes" class="ai-textarea" rows="4" placeholder="Provide specific questions, concerns, or context that will help the AI provide more targeted insights..."></textarea>
                                            </div>

                                            <!-- Enhanced Dropzone -->
                                            <div class="ai-dropzone-container">
                                                <div class="ai-dropzone-header">
                                                    <i class="fa-solid fa-cloud-upload"></i>
                                                    <span>Upload Documents for Analysis</span>
                                                </div>
                                                <?= form_open('admin/leads/ai_upload_files', ['class' => 'ai-dropzone', 'id' => 'ai-analysis-dropzone']); ?>
                                                    <div class="ai-dropzone-content">
                                                        <i class="fa-solid fa-file-upload ai-upload-icon"></i>
                                                        <p class="ai-upload-text">Drag & drop files here or click to browse</p>
                                                        <p class="ai-upload-hint">Supports: PDF, DOC, TXT, Images (Max 10MB each)</p>
                                                    </div>
                                                <?= form_close(); ?>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="ai-insights-panel">
                                            <h5 class="ai-insights-title">
                                                <i class="fa-solid fa-lightbulb"></i> Smart Insights
                                            </h5>
                                            <div class="ai-insight-item">
                                                <div class="ai-insight-icon ai-insight-success">
                                                    <i class="fa-solid fa-check"></i>
                                                </div>
                                                <div class="ai-insight-text">
                                                    <strong>Quick Analysis</strong>
                                                    <p>Get instant insights from existing lead data</p>
                                                </div>
                                            </div>
                                            <div class="ai-insight-item">
                                                <div class="ai-insight-icon ai-insight-info">
                                                    <i class="fa-solid fa-robot"></i>
                                                </div>
                                                <div class="ai-insight-text">
                                                    <strong>AI Recommendations</strong>
                                                    <p>Receive actionable next steps and strategies</p>
                                                </div>
                                            </div>
                                            <div class="ai-insight-item">
                                                <div class="ai-insight-icon ai-insight-warning">
                                                    <i class="fa-solid fa-shield"></i>
                                                </div>
                                                <div class="ai-insight-text">
                                                    <strong>Risk Assessment</strong>
                                                    <p>Identify potential challenges and mitigation strategies</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="ai-panel-actions">
                                    <button type="button" id="start-ai-analysis" class="ai-btn ai-btn-primary">
                                        <i class="fa-solid fa-play"></i>
                                        <span>Start AI Analysis</span>
                                        <div class="ai-btn-loading" style="display: none;">
                                            <i class="fa-solid fa-spinner fa-spin"></i>
                                        </div>
                                    </button>
                                    <button type="button" id="clear-ai-uploads" class="ai-btn ai-btn-secondary">
                                        <i class="fa-solid fa-trash"></i>
                                        <span>Clear All</span>
                                    </button>
                                    <button type="button" id="save-analysis-template" class="ai-btn ai-btn-outline">
                                        <i class="fa-solid fa-save"></i>
                                        <span>Save as Template</span>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Results Section -->
                        <div id="ai-analysis-results" class="ai-results-section" style="display: none;">
                            <div class="ai-results-header">
                                <h4 class="ai-results-title">
                                    <i class="fa-solid fa-chart-bar"></i>
                                    Analysis Results
                                </h4>
                                <div class="ai-results-actions">
                                    <button class="ai-results-btn" id="export-results">
                                        <i class="fa-solid fa-download"></i> Export
                                    </button>
                                    <button class="ai-results-btn" id="share-results">
                                        <i class="fa-solid fa-share"></i> Share
                                    </button>
                                </div>
                            </div>
                            <div id="ai-results-content" class="ai-results-content">
                                <!-- Results will be populated here -->
                            </div>
                        </div>

                        <!-- Analysis History -->
                        <div class="ai-history-section">
                            <div class="ai-history-header">
                                <h4 class="ai-history-title">
                                    <i class="fa-solid fa-clock-rotate-left"></i>
                                    Analysis History
                                </h4>
                                <div class="ai-history-filters">
                                    <select class="ai-filter-select" id="history-filter">
                                        <option value="all">All Types</option>
                                        <option value="document_analysis">Document Analysis</option>
                                        <option value="lead_scoring">Lead Scoring</option>
                                        <option value="conversation_analysis">Conversation Analysis</option>
                                        <option value="company_research">Company Research</option>
                                    </select>
                                </div>
                            </div>
                            <div id="ai-history-content" class="ai-history-content">
                                <div class="ai-history-placeholder">
                                    <div class="ai-placeholder-icon">
                                        <i class="fa-solid fa-history"></i>
                                    </div>
                                    <h5>No Previous Analyses</h5>
                                    <p>Start your first AI analysis to see results here</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Custom Styles -->
                    <style>
                    .ai-analysis-container-modern {
                        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
                        background: linear-gradient(135deg, #f8f9ff 0%, #f1f3f8 100%);
                        border-radius: 12px;
                        padding: 0;
                        margin: -15px;
                    }

                    .ai-hero-section {
                        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                        color: white;
                        padding: 30px;
                        border-radius: 12px 12px 0 0;
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                    }

                    .ai-hero-content {
                        display: flex;
                        align-items: center;
                        gap: 20px;
                    }

                    .ai-hero-icon {
                        width: 60px;
                        height: 60px;
                        background: rgba(255,255,255,0.2);
                        border-radius: 50%;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        font-size: 24px;
                    }

                    .ai-title {
                        margin: 0;
                        font-size: 28px;
                        font-weight: 700;
                        letter-spacing: -0.5px;
                    }

                    .ai-subtitle {
                        margin: 5px 0 0 0;
                        opacity: 0.9;
                        font-size: 16px;
                    }

                    .ai-hero-stats {
                        display: flex;
                        gap: 30px;
                    }

                    .ai-stat-item {
                        text-align: center;
                    }

                    .ai-stat-number {
                        display: block;
                        font-size: 24px;
                        font-weight: 700;
                        line-height: 1;
                    }

                    .ai-stat-label {
                        font-size: 12px;
                        opacity: 0.8;
                        text-transform: uppercase;
                        letter-spacing: 0.5px;
                    }

                    .ai-dashboard-grid {
                        display: grid;
                        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
                        gap: 20px;
                        padding: 30px;
                    }

                    .ai-card {
                        background: white;
                        border-radius: 12px;
                        padding: 24px;
                        box-shadow: 0 4px 6px rgba(0,0,0,0.05);
                        border: 1px solid #e2e8f0;
                        transition: all 0.3s ease;
                        position: relative;
                        overflow: hidden;
                    }

                    .ai-card::before {
                        content: '';
                        position: absolute;
                        top: 0;
                        left: 0;
                        right: 0;
                        height: 4px;
                        background: linear-gradient(90deg, #667eea, #764ba2);
                    }

                    .ai-card:hover {
                        transform: translateY(-2px);
                        box-shadow: 0 8px 20px rgba(0,0,0,0.1);
                    }

                    .ai-card-header {
                        display: flex;
                        align-items: center;
                        gap: 12px;
                        margin-bottom: 16px;
                    }

                    .ai-card-header i {
                        font-size: 20px;
                        color: #667eea;
                    }

                    .ai-card-header h4 {
                        margin: 0;
                        font-size: 18px;
                        font-weight: 600;
                        color: #2d3748;
                    }

                    .ai-card-body p {
                        color: #64748b;
                        margin-bottom: 20px;
                        line-height: 1.5;
                    }

                    .ai-quick-btn {
                        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                        color: white;
                        border: none;
                        padding: 12px 20px;
                        border-radius: 8px;
                        font-weight: 600;
                        cursor: pointer;
                        transition: all 0.3s ease;
                        display: flex;
                        align-items: center;
                        gap: 8px;
                        width: 100%;
                        justify-content: center;
                    }

                    .ai-quick-btn:hover {
                        transform: translateY(-1px);
                        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
                        color: white;
                    }

                    .ai-analysis-panel {
                        background: white;
                        margin: 0 30px 30px 30px;
                        border-radius: 12px;
                        box-shadow: 0 8px 25px rgba(0,0,0,0.1);
                        border: 1px solid #e2e8f0;
                    }

                    .ai-panel-header {
                        padding: 20px 30px;
                        border-bottom: 1px solid #e2e8f0;
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                        background: #f8fafc;
                        border-radius: 12px 12px 0 0;
                    }

                    .ai-panel-title {
                        margin: 0;
                        font-size: 20px;
                        font-weight: 600;
                        color: #2d3748;
                        display: flex;
                        align-items: center;
                        gap: 10px;
                    }

                    .ai-panel-close {
                        background: none;
                        border: none;
                        font-size: 18px;
                        color: #64748b;
                        cursor: pointer;
                        padding: 8px;
                        border-radius: 6px;
                        transition: all 0.2s ease;
                    }

                    .ai-panel-close:hover {
                        background: #e2e8f0;
                        color: #2d3748;
                    }

                    .ai-panel-body {
                        padding: 30px;
                    }

                    .ai-form-group {
                        margin-bottom: 24px;
                    }

                    .ai-label {
                        display: flex;
                        align-items: center;
                        gap: 8px;
                        font-weight: 600;
                        color: #2d3748;
                        margin-bottom: 8px;
                        font-size: 14px;
                    }

                    .ai-select, .ai-textarea {
                        width: 100%;
                        padding: 12px 16px;
                        border: 2px solid #e2e8f0;
                        border-radius: 8px;
                        font-size: 14px;
                        transition: all 0.3s ease;
                        background: white;
                    }

                    .ai-select:focus, .ai-textarea:focus {
                        border-color: #667eea;
                        outline: none;
                        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
                    }

                    .ai-focus-options {
                        display: grid;
                        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
                        gap: 12px;
                        margin-top: 8px;
                    }

                    .ai-checkbox-label {
                        display: flex;
                        align-items: center;
                        gap: 8px;
                        cursor: pointer;
                        padding: 8px 12px;
                        border-radius: 6px;
                        transition: all 0.2s ease;
                    }

                    .ai-checkbox-label:hover {
                        background: #f1f5f9;
                    }

                    .ai-checkbox {
                        width: 16px;
                        height: 16px;
                        accent-color: #667eea;
                    }

                    .ai-dropzone-container {
                        margin-top: 20px;
                    }

                    .ai-dropzone-header {
                        display: flex;
                        align-items: center;
                        gap: 8px;
                        margin-bottom: 12px;
                        font-weight: 600;
                        color: #2d3748;
                    }

                    .ai-dropzone {
                        border: 2px dashed #cbd5e0;
                        border-radius: 12px;
                        background: #f8fafc;
                        transition: all 0.3s ease;
                        min-height: 120px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                    }

                    .ai-dropzone:hover {
                        border-color: #667eea;
                        background: #f1f5f9;
                    }

                    .ai-dropzone-content {
                        text-align: center;
                        padding: 30px;
                    }

                    .ai-upload-icon {
                        font-size: 32px;
                        color: #667eea;
                        margin-bottom: 12px;
                    }

                    .ai-upload-text {
                        font-size: 16px;
                        font-weight: 600;
                        color: #2d3748;
                        margin-bottom: 4px;
                    }

                    .ai-upload-hint {
                        font-size: 12px;
                        color: #64748b;
                        margin: 0;
                    }

                    .ai-insights-panel {
                        background: #f8fafc;
                        border-radius: 12px;
                        padding: 20px;
                        height: fit-content;
                    }

                    .ai-insights-title {
                        display: flex;
                        align-items: center;
                        gap: 8px;
                        margin-bottom: 20px;
                        color: #2d3748;
                        font-size: 16px;
                        font-weight: 600;
                    }

                    .ai-insight-item {
                        display: flex;
                        gap: 12px;
                        margin-bottom: 16px;
                        align-items: flex-start;
                    }

                    .ai-insight-icon {
                        width: 32px;
                        height: 32px;
                        border-radius: 50%;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        font-size: 14px;
                        color: white;
                        flex-shrink: 0;
                    }

                    .ai-insight-success { background: #10b981; }
                    .ai-insight-info { background: #3b82f6; }
                    .ai-insight-warning { background: #f59e0b; }

                    .ai-insight-text strong {
                        display: block;
                        color: #2d3748;
                        font-size: 14px;
                        margin-bottom: 2px;
                    }

                    .ai-insight-text p {
                        margin: 0;
                        font-size: 12px;
                        color: #64748b;
                        line-height: 1.4;
                    }

                    .ai-panel-actions {
                        margin-top: 30px;
                        padding-top: 20px;
                        border-top: 1px solid #e2e8f0;
                        display: flex;
                        gap: 12px;
                        flex-wrap: wrap;
                    }

                    .ai-btn {
                        padding: 12px 24px;
                        border-radius: 8px;
                        font-weight: 600;
                        font-size: 14px;
                        cursor: pointer;
                        transition: all 0.3s ease;
                        border: none;
                        display: flex;
                        align-items: center;
                        gap: 8px;
                        position: relative;
                        overflow: hidden;
                    }

                    .ai-btn-primary {
                        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                        color: white;
                    }

                    .ai-btn-primary:hover {
                        transform: translateY(-1px);
                        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
                    }

                    .ai-btn-secondary {
                        background: #f1f5f9;
                        color: #64748b;
                        border: 1px solid #e2e8f0;
                    }

                    .ai-btn-secondary:hover {
                        background: #e2e8f0;
                        color: #2d3748;
                    }

                    .ai-btn-outline {
                        background: transparent;
                        color: #667eea;
                        border: 2px solid #667eea;
                    }

                    .ai-btn-outline:hover {
                        background: #667eea;
                        color: white;
                    }

                    .ai-results-section {
                        margin: 0 30px 30px 30px;
                        background: white;
                        border-radius: 12px;
                        box-shadow: 0 4px 6px rgba(0,0,0,0.05);
                        border: 1px solid #e2e8f0;
                    }

                    .ai-results-header {
                        padding: 20px 30px;
                        border-bottom: 1px solid #e2e8f0;
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                        background: #f8fafc;
                        border-radius: 12px 12px 0 0;
                    }

                    .ai-results-title {
                        margin: 0;
                        font-size: 18px;
                        font-weight: 600;
                        color: #2d3748;
                        display: flex;
                        align-items: center;
                        gap: 10px;
                    }

                    .ai-results-actions {
                        display: flex;
                        gap: 8px;
                    }

                    .ai-results-btn {
                        padding: 8px 16px;
                        background: #f1f5f9;
                        border: 1px solid #e2e8f0;
                        border-radius: 6px;
                        color: #64748b;
                        font-size: 12px;
                        cursor: pointer;
                        transition: all 0.2s ease;
                    }

                    .ai-results-btn:hover {
                        background: #e2e8f0;
                        color: #2d3748;
                    }

                    .ai-results-content {
                        padding: 30px;
                    }

                    .ai-history-section {
                        margin: 0 30px 30px 30px;
                    }

                    .ai-history-header {
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                        margin-bottom: 20px;
                    }

                    .ai-history-title {
                        margin: 0;
                        font-size: 18px;
                        font-weight: 600;
                        color: #2d3748;
                        display: flex;
                        align-items: center;
                        gap: 10px;
                    }

                    .ai-filter-select {
                        padding: 8px 12px;
                        border: 1px solid #e2e8f0;
                        border-radius: 6px;
                        background: white;
                        font-size: 12px;
                    }

                    .ai-history-content {
                        background: white;
                        border-radius: 12px;
                        border: 1px solid #e2e8f0;
                        min-height: 200px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        width: 100%;
                        max-width: 100%;
                        box-sizing: border-box;
                        overflow: hidden;
                        padding: 15px;
                    }

                    .ai-history-placeholder {
                        text-align: center;
                        color: #64748b;
                    }

                    .ai-placeholder-icon {
                        font-size: 48px;
                        color: #cbd5e0;
                        margin-bottom: 16px;
                    }

                    .ai-history-placeholder h5 {
                        margin-bottom: 8px;
                        color: #2d3748;
                    }

                    .ai-history-placeholder p {
                        margin: 0;
                        font-size: 14px;
                    }

                    /* History items */
                    .ai-history-item {
                        display: flex;
                        align-items: center;
                        gap: 16px;
                        padding: 16px;
                        background: white;
                        border-radius: 8px;
                        border: 1px solid #e2e8f0;
                        margin-bottom: 12px;
                    }

                    .ai-history-icon {
                        width: 40px;
                        height: 40px;
                        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                        border-radius: 50%;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        color: white;
                        font-size: 16px;
                    }

                    .ai-history-details {
                        flex: 1;
                    }

                    .ai-history-details h6 {
                        margin: 0 0 4px 0;
                        font-size: 16px;
                        font-weight: 600;
                        color: #2d3748;
                    }

                    .ai-history-details p {
                        margin: 0 0 4px 0;
                        color: #64748b;
                        font-size: 14px;
                    }

                    .ai-history-actions {
                        display: flex;
                        gap: 8px;
                    }
                    
                    /* AI History Styles */
                    .ai-history-loading {
                        text-align: center;
                        padding: 40px 20px;
                        color: #6c757d;
                    }
                    
                    .ai-loading-spinner {
                        font-size: 2rem;
                        margin-bottom: 15px;
                        color: #007bff;
                    }
                    
                    .ai-history-list {
                        max-height: 500px;
                        overflow-y: auto;
                        margin-bottom: 20px;
                    }
                    
                    .ai-history-item {
                        background: #f8f9fa;
                        border: 1px solid #e9ecef;
                        border-radius: 8px;
                        padding: 15px;
                        margin-bottom: 15px;
                        transition: all 0.2s ease;
                    }
                    
                    .ai-history-item:hover {
                        box-shadow: 0 2px 8px rgba(0,123,255,0.15);
                        border-color: #007bff;
                    }
                    
                    .ai-history-item.latest {
                        background: linear-gradient(135deg, #e3f2fd 0%, #f8f9fa 100%);
                        border-color: #007bff;
                    }
                    
                    .ai-history-header {
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                        margin-bottom: 10px;
                    }
                    
                    .ai-history-meta {
                        display: flex;
                        align-items: center;
                        gap: 10px;
                    }
                    
                    .ai-analysis-type {
                        font-weight: 600;
                        color: #495057;
                        font-size: 0.9rem;
                    }
                    
                    .ai-confidence-badge {
                        padding: 2px 8px;
                        border-radius: 12px;
                        font-size: 0.75rem;
                        font-weight: 600;
                    }
                    
                    .badge-success {
                        background-color: #d4edda;
                        color: #155724;
                    }
                    
                    .badge-warning {
                        background-color: #fff3cd;
                        color: #856404;
                    }
                    
                    .badge-danger {
                        background-color: #f8d7da;
                        color: #721c24;
                    }
                    
                    .latest-badge {
                        background: linear-gradient(45deg, #007bff, #0056b3);
                        color: white;
                        padding: 2px 8px;
                        border-radius: 10px;
                        font-size: 0.7rem;
                        font-weight: 600;
                        text-transform: uppercase;
                    }
                    
                    .ai-history-date {
                        display: flex;
                        align-items: center;
                        gap: 5px;
                        color: #6c757d;
                        font-size: 0.8rem;
                    }
                    
                    .ai-history-summary {
                        color: #495057;
                        font-size: 0.9rem;
                        line-height: 1.4;
                        margin-bottom: 15px;
                        padding: 10px;
                        background: white;
                        border-radius: 6px;
                        border-left: 3px solid #007bff;
                    }
                    
                    .ai-history-actions {
                        display: flex;
                        gap: 8px;
                    }
                    
                    .ai-history-actions .btn {
                        font-size: 0.8rem;
                        padding: 4px 12px;
                    }
                    
                    .ai-history-footer {
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                        padding: 15px;
                        background: #e9ecef;
                        border-radius: 8px;
                        margin-top: 20px;
                    }
                    
                    .ai-history-stats {
                        color: #495057;
                        font-size: 0.9rem;
                    }
                    
                    .ai-history-actions-footer .btn {
                        font-size: 0.85rem;
                    }
                    
                    .ai-history-placeholder,
                    .ai-history-error {
                        text-align: center;
                        padding: 60px 20px;
                        color: #6c757d;
                    }
                    
                    .ai-placeholder-icon,
                    .ai-error-icon {
                        font-size: 3rem;
                        margin-bottom: 20px;
                        color: #dee2e6;
                    }
                    
                    .ai-error-icon {
                        color: #dc3545;
                    }
                    
                    .ai-history-placeholder h5,
                    .ai-history-error h5 {
                        margin-bottom: 10px;
                        color: #495057;
                    }
                    
                    .ai-history-placeholder p,
                    .ai-history-error p {
                        margin-bottom: 20px;
                        font-size: 0.9rem;
                    }
                    
                    /* Responsive adjustments for AI history */
                    @media (max-width: 768px) {
                        .ai-history-header {
                            flex-direction: column;
                            align-items: flex-start;
                            gap: 10px;
                        }
                        
                        .ai-history-meta {
                            flex-wrap: wrap;
                        }
                        
                        .ai-history-footer {
                            flex-direction: column;
                            gap: 15px;
                        }
                        
                        .ai-history-actions {
                            justify-content: center;
                        }
                    }
                    
                    /* Professional AI Report Cards */
                    .ai-history-list-professional {
                        display: flex;
                        flex-direction: column;
                        gap: 20px;
                        width: 100%;
                        max-width: 100%;
                        margin: 0;
                        padding: 0;
                    }
                    
                    .ai-report-card {
                        background: #ffffff;
                        border: 1px solid #e9ecef;
                        border-radius: 12px;
                        padding: 20px;
                        box-shadow: 0 2px 4px rgba(0,0,0,0.04);
                        transition: all 0.3s ease;
                        position: relative;
                        width: 100%;
                        max-width: 100%;
                        margin: 0;
                        box-sizing: border-box;
                        overflow: hidden;
                    }
                    
                    .ai-report-card:hover {
                        box-shadow: 0 4px 12px rgba(0,0,0,0.08);
                        border-color: #007bff;
                        transform: translateY(-1px);
                    }
                    
                    .ai-report-card.latest-report {
                        background: linear-gradient(135deg, #f8f9ff 0%, #ffffff 100%);
                        border-color: #007bff;
                        box-shadow: 0 4px 8px rgba(0,123,255,0.1);
                    }
                    
                    .ai-report-header {
                        display: flex;
                        justify-content: space-between;
                        align-items: flex-start;
                        margin-bottom: 16px;
                        padding-bottom: 12px;
                        border-bottom: 1px solid #f0f0f0;
                        width: 100%;
                        box-sizing: border-box;
                    }
                    
                    .ai-report-meta-left {
                        display: flex;
                        align-items: center;
                        gap: 12px;
                        flex-wrap: wrap;
                        flex: 1;
                        min-width: 0;
                    }
                    
                    .ai-report-type {
                        display: flex;
                        align-items: center;
                        gap: 8px;
                        font-weight: 600;
                        color: #343a40;
                        font-size: 1rem;
                        word-wrap: break-word;
                        overflow-wrap: break-word;
                    }
                    
                    .ai-report-type i {
                        color: #007bff;
                        font-size: 1.1rem;
                    }
                    
                    .latest-indicator {
                        background: linear-gradient(135deg, #007bff, #0056b3);
                        color: white;
                        padding: 4px 10px;
                        border-radius: 20px;
                        font-size: 0.75rem;
                        font-weight: 600;
                        text-transform: uppercase;
                        letter-spacing: 0.5px;
                        box-shadow: 0 2px 4px rgba(0,123,255,0.3);
                    }
                    
                    .ai-report-meta-right {
                        text-align: right;
                    }
                    
                    .ai-report-date {
                        display: flex;
                        align-items: center;
                        gap: 6px;
                        font-weight: 500;
                        color: #495057;
                        font-size: 0.9rem;
                    }
                    
                    .ai-report-time-ago {
                        font-size: 0.8rem;
                        margin-top: 2px;
                    }
                    
                    .ai-report-metrics {
                        display: grid;
                        grid-template-columns: 2fr 1fr;
                        gap: 20px;
                        margin-bottom: 16px;
                        padding: 12px 0;
                        width: 100%;
                        box-sizing: border-box;
                    }
                    
                    .ai-metric-item {
                        display: flex;
                        flex-direction: column;
                        gap: 6px;
                    }
                    
                    .ai-metric-label {
                        font-size: 0.85rem;
                        color: #6c757d;
                        font-weight: 500;
                        text-transform: uppercase;
                        letter-spacing: 0.5px;
                    }
                    
                    .progress-wrapper {
                        display: flex;
                        align-items: center;
                        gap: 10px;
                    }
                    
                    .progress {
                        flex: 1;
                        height: 8px;
                        background-color: #f8f9fa;
                        border-radius: 4px;
                        overflow: hidden;
                    }
                    
                    .progress-bar {
                        height: 100%;
                        transition: width 0.6s ease;
                        border-radius: 4px;
                    }
                    
                    .progress-bar-success { background-color: #28a745; }
                    .progress-bar-warning { background-color: #ffc107; }
                    .progress-bar-info { background-color: #17a2b8; }
                    .progress-bar-danger { background-color: #dc3545; }
                    
                    .progress-text {
                        font-weight: 600;
                        color: #495057;
                        font-size: 0.85rem;
                        min-width: 35px;
                    }
                    
                    .ai-report-summary {
                        margin-bottom: 16px;
                    }
                    
                    .ai-summary-content {
                        color: #495057;
                        line-height: 1.5;
                        font-size: 0.95rem;
                        padding: 12px;
                        background-color: #f8f9fa;
                        border-radius: 8px;
                        border-left: 3px solid #007bff;
                    }
                    
                    .ai-report-actions {
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                        padding-top: 12px;
                        border-top: 1px solid #f0f0f0;
                    }
                    
                    .ai-action-buttons {
                        display: flex;
                        gap: 8px;
                    }
                    
                    .ai-action-buttons .btn {
                        font-size: 0.85rem;
                        padding: 6px 12px;
                        border-radius: 6px;
                        font-weight: 500;
                        transition: all 0.2s ease;
                    }
                    
                    .ai-action-buttons .btn:hover {
                        transform: translateY(-1px);
                        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
                    }
                    
                    .ai-report-status {
                        display: flex;
                        align-items: center;
                    }
                    
                    .status-indicator {
                        display: flex;
                        align-items: center;
                        gap: 4px;
                        font-size: 0.8rem;
                        font-weight: 500;
                        text-transform: capitalize;
                    }
                    
                    .status-completed { color: #28a745; }
                    .status-pending { color: #ffc107; }
                    .status-failed { color: #dc3545; }
                    
                    .ai-history-summary {
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                        margin-top: 24px;
                        padding: 16px 20px;
                        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
                        border-radius: 10px;
                        border: 1px solid #dee2e6;
                    }
                    
                    .ai-summary-stats {
                        display: flex;
                        align-items: center;
                        gap: 20px;
                    }
                    
                    .stat-item {
                        text-align: center;
                    }
                    
                    .stat-number {
                        font-size: 1.5rem;
                        font-weight: 700;
                        color: #007bff;
                        line-height: 1;
                    }
                    
                    .stat-label {
                        font-size: 0.8rem;
                        color: #6c757d;
                        text-transform: uppercase;
                        letter-spacing: 0.5px;
                        margin-top: 2px;
                    }
                    
                    .stat-divider {
                        width: 1px;
                        height: 40px;
                        background-color: #dee2e6;
                    }
                    
                    .ai-summary-actions {
                        display: flex;
                        gap: 10px;
                    }
                    
                    .ai-summary-actions .btn {
                        font-size: 0.85rem;
                        padding: 8px 16px;
                        border-radius: 6px;
                        font-weight: 500;
                    }
                    
                    /* Responsive Design for Professional Cards */
                    @media (max-width: 768px) {
                        .ai-report-card {
                            padding: 15px;
                            margin: 0;
                        }
                        
                        .ai-report-metrics {
                            grid-template-columns: 1fr;
                            gap: 12px;
                        }
                        
                        .ai-report-header {
                            flex-direction: column;
                            align-items: flex-start;
                            gap: 10px;
                        }
                        
                        .ai-report-meta-left {
                            width: 100%;
                        }
                        
                        .ai-report-meta-right {
                            text-align: left;
                            width: 100%;
                        }
                        
                        .ai-action-buttons {
                            flex-wrap: wrap;
                            gap: 6px;
                        }
                        
                        .ai-action-buttons .btn {
                            font-size: 0.8rem;
                            padding: 5px 10px;
                        }
                        
                        .ai-history-summary {
                            flex-direction: column;
                            gap: 16px;
                            padding: 12px;
                        }
                        
                        .ai-summary-stats {
                            justify-content: center;
                        }
                        
                        .ai-history-list-professional {
                            gap: 15px;
                        }
                    }
                    
                    </style>
                </div>
                <?php if (count($mail_activity) > 0 || isset($show_email_activity) && $show_email_activity) { ?>
                <div role="tabpanel" class="tab-pane" id="tab_email_activity">
                    <?php hooks()->do_action('before_lead_email_activity', ['lead' => $lead, 'email_activity' => $mail_activity]); ?>
                    <?php foreach ($mail_activity as $_mail_activity) { ?>
                    <div class="lead-email-activity">
                        <div class="media-left">
                            <i class="fa-regular fa-envelope"></i>
                        </div>
                        <div class="media-body">
                            <h4 class="bold no-margin lead-mail-activity-subject">
                                <?= e($_mail_activity['subject']); ?>
                                <br />
                                <small
                                    class="text-muted display-block mtop5 font-medium-xs"><?= e(_dt($_mail_activity['dateadded'])); ?></small>
                            </h4>
                            <div class="lead-mail-activity-body">
                                <hr />
                                <?= process_text_content_for_display($_mail_activity['body']); ?>
                            </div>
                            <hr />
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <?php } ?>
                    <?php hooks()->do_action('after_lead_email_activity', ['lead_id' => $lead->id, 'emails' => $mail_activity]); ?>
                </div>
                <?php } ?>
                <?php if (is_gdpr() && (get_option('gdpr_enable_lead_public_form') == '1' || get_option('gdpr_enable_consent_for_leads') == '1' || (get_option('gdpr_data_portability_leads') == '1') && is_admin())) { ?>
                <div role="tabpanel" class="tab-pane" id="gdpr">
                    <?php if (get_option('gdpr_enable_lead_public_form') == '1') { ?>
                    <a href="<?= e($lead->public_url); ?>"
                        target="_blank" class="mtop5">
                        <?= _l('view_public_form'); ?>
                    </a>
                    <?php } ?>
                    <?php if (get_option('gdpr_data_portability_leads') == '1' && is_admin()) { ?>
                    <?php
                                if (get_option('gdpr_enable_lead_public_form') == '1') {
                                    echo ' | ';
                                }
                        ?>
                    <a
                        href="<?= admin_url('leads/export/' . $lead->id); ?>">
                        <?= _l('dt_button_export'); ?>
                    </a>
                    <?php } ?>
                    <?php if (get_option('gdpr_enable_lead_public_form') == '1' || (get_option('gdpr_data_portability_leads') == '1' && is_admin())) { ?>
                    <hr class="-tw-mx-3.5" />
                    <?php } ?>
                    <?php if (get_option('gdpr_enable_consent_for_leads') == '1') { ?>
                    <h4 class="no-mbot">
                        <?= _l('gdpr_consent'); ?>
                    </h4>
                    <?php $this->load->view('admin/gdpr/lead_consent'); ?>
                    <hr />
                    <?php } ?>
                </div>
                <?php } ?>
                <div role="tabpanel" class="tab-pane" id="lead_activity">
                    <div>
                        <div class="activity-feed">
                            <?php foreach ($activity_log as $log) { ?>
                            <div class="feed-item">
                                <div class="date">
                                    <span class="text-has-action" data-toggle="tooltip"
                                        data-title="<?= e(_dt($log['date'])); ?>">
                                        <?= e(time_ago($log['date'])); ?>
                                    </span>
                                </div>
                                <div class="text">
                                    <?php if ($log['staffid'] != 0) { ?>
                                    <a
                                        href="<?= admin_url('profile/' . $log['staffid']); ?>">
                                        <?= staff_profile_image($log['staffid'], ['staff-profile-xs-image pull-left mright5']);
                                        ?>
                                    </a>
                                    <?php
                                    }
                                $additional_data = '';
                                if (! empty($log['additional_data'])) {
                                    $additional_data = unserialize($log['additional_data']);
                                    echo ($log['staffid'] == 0) ? _l($log['description'], $additional_data) : e($log['full_name']) . ' - ' . _l($log['description'], $additional_data);
                                } else {
                                    echo e($log['full_name']) . ' - ';

                                    if ($log['custom_activity'] == 0) {
                                        echo e(_l($log['description']));
                                    } else {
                                        echo process_text_content_for_display(_l($log['description'], '', false));
                                    }
                                }
                                ?>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                        <div class="col-md-12">
                            <?= render_textarea('lead_activity_textarea', '', '', ['placeholder' => _l('enter_activity')], [], 'mtop15'); ?>
                            <div class="text-right">
                                <button id="lead_enter_activity"
                                    class="btn btn-primary"><?= _l('submit'); ?></button>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="tab_proposals_leads">
                    <?php if (staff_can('create', 'proposals')) { ?>
                    <a href="<?= admin_url('proposals/proposal?rel_type=lead&rel_id=' . $lead->id); ?>"
                        class="btn btn-primary mbot25"><?= _l('new_proposal'); ?></a>
                    <?php } ?>
                    <?php if (total_rows(db_prefix() . 'proposals', ['rel_type' => 'lead', 'rel_id' => $lead->id]) > 0 && (staff_can('create', 'proposals') || staff_can('edit', 'proposals'))) { ?>
                    <a href="#" class="btn btn-primary mbot25" data-toggle="modal"
                        data-target="#sync_data_proposal_data"><?= _l('sync_data'); ?></a>
                    <?php $this->load->view('admin/proposals/sync_data', ['related' => $lead, 'rel_id' => $lead->id, 'rel_type' => 'lead']); ?>
                    <?php } ?>
                    <?php
                        $table_data = [
                            _l('proposal') . ' #',
                            _l('proposal_subject'),
                            _l('proposal_total'),
                            _l('proposal_date'),
                            _l('proposal_open_till'),
                            _l('tags'),
                            _l('proposal_date_created'),
                            _l('proposal_status'),
                        ];
                    $custom_fields = get_custom_fields('proposal', ['show_on_table' => 1]);

                    foreach ($custom_fields as $field) {
                        array_push($table_data, [
                            'name'     => $field['name'],
                            'th_attrs' => ['data-type' => $field['type'], 'data-custom-field' => 1],
                        ]);
                    }
                    $table_data = hooks()->apply_filters('proposals_relation_table_columns', $table_data);
                    render_datatable($table_data, 'proposals-lead', [], [
                        'data-last-order-identifier' => 'proposals-relation',
                        'data-default-order'         => get_table_last_order('proposals-relation'),
                    ]);
                    ?>
                </div>
                <div role="tabpanel" class="tab-pane" id="tab_tasks_leads">
                    <?php init_relation_tasks_table(['data-new-rel-id' => $lead->id, 'data-new-rel-type' => 'lead'], 'tasksFilters'); ?>
                </div>
                <div role="tabpanel" class="tab-pane" id="lead_reminders">
                    <a href="#" data-toggle="modal" class="btn btn-primary"
                        data-target=".reminder-modal-lead-<?= e($lead->id); ?>"><i
                            class="fa-regular fa-bell"></i>
                        <?= _l('lead_set_reminder_title'); ?></a>
                    <hr />
                    <?php render_datatable([_l('reminder_description'), _l('reminder_date'), _l('reminder_staff'), _l('reminder_is_notified')], 'reminders-leads'); ?>
                </div>
                <div role="tabpanel" class="tab-pane" id="attachments">
                    <div class="form-group">
                        <label for="attachment_description"><?= _l('lead_attachment_description'); ?></label>
                        <textarea id="attachment_description" name="attachment_description" class="form-control" rows="3" placeholder="<?= _l('lead_attachment_description_placeholder'); ?>"></textarea>
                    </div>
                    <?= form_open('admin/leads/add_lead_attachment', ['class' => 'dropzone mtop15 mbot15', 'id' => 'lead-attachment-upload']); ?>
                    <?= form_close(); ?>
                    <?php if (get_option('dropbox_app_key') != '') { ?>
                    <hr />
                    <div class=" pull-left">
                        <?php if (count($lead->attachments) > 0) { ?>
                        <a href="<?= admin_url('leads/download_files/' . $lead->id); ?>"
                            class="bold">
                            <?= _l('download_all'); ?>
                            (.zip)
                        </a>
                        <?php } ?>
                    </div>
                    <div class="tw-flex tw-justify-end tw-items-center tw-space-x-2">
                        <button class="gpicker">
                            <i class="fa-brands fa-google" aria-hidden="true"></i>
                            <?= _l('choose_from_google_drive'); ?>
                        </button>
                        <div id="dropbox-chooser-lead"></div>
                    </div>
                    <div class=" clearfix"></div>
                    <?php } ?>
                    <?php if (count($lead->attachments) > 0) { ?>
                    <div class="mtop20" id="lead_attachments">
                        <?php $this->load->view('admin/leads/leads_attachments_template', ['attachments' => $lead->attachments]); ?>
                    </div>
                    <?php } ?>
                </div>
                <div role="tabpanel" class="tab-pane" id="lead_notes">
                    <?= form_open_multipart(admin_url('leads/add_note/' . $lead->id), ['id' => 'lead-modal-note-form']); ?>
                    <div class="form-group">
                        <label for="followup_type"><?= _l('followup_type'); ?></label>
                        <select id="followup_type" name="followup_type" class="form-control">
                            <?php foreach($followup_types as $type): ?>
                                <option value="<?= htmlspecialchars($type); ?>"><?= htmlspecialchars($type); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <textarea id="description" name="description" class="form-control" rows="4"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="file" class="control-label"><?php echo _l('lead_note_add_attachment'); ?></label>
                        <input type="file" id="file" name="file" class="form-control">
                    </div>
                    
                    <div class="lead-select-date-contacted hide">
                        <?= render_datetime_input('custom_contact_date', 'lead_add_edit_datecontacted', '', ['data-date-end-date' => date('Y-m-d')]); ?>
                    </div>
                    <div class="radio radio-primary">
                        <input type="radio" name="contacted_indicator" id="contacted_indicator_yes" value="yes">
                        <label for="contacted_indicator_yes"><?= _l('lead_add_edit_contacted_this_lead'); ?></label>
                    </div>
                    <div class="radio radio-primary">
                        <input type="radio" name="contacted_indicator" id="contacted_indicator_no" value="no" checked>
                        <label for="contacted_indicator_no"><?= _l('lead_not_contacted'); ?></label>
                    </div>
                    <button type="submit" class="btn btn-primary pull-right"><?= _l('Add followup'); ?></button>
                    <?= form_close(); ?>
                    
                    <div class="clearfix"></div>
                    <hr />
                    
                    <?php
                    $len = count($notes);
                    $i   = 0;
                    foreach ($notes as $note) { ?>
                    <?php
                        // Detect communication type from note content
                        $note_text = strtolower($note['description']);
                        $communication_type = 'general';
                        $icon = 'fa-regular fa-note-sticky';
                        $color_class = 'note-general';
                        
                        if (strpos($note_text, 'whatsapp') !== false || strpos($note_text, 'whats app') !== false) {
                            $communication_type = 'whatsapp';
                            $icon = 'fa-brands fa-whatsapp';
                            $color_class = 'note-whatsapp';
                        } elseif (strpos($note_text, 'call') !== false || strpos($note_text, 'phone') !== false || strpos($note_text, 'rang') !== false) {
                            $communication_type = 'call';
                            $icon = 'fa-solid fa-phone';
                            $color_class = 'note-call';
                        } elseif (strpos($note_text, 'message') !== false || strpos($note_text, 'sms') !== false || strpos($note_text, 'text') !== false) {
                            $communication_type = 'message';
                            $icon = 'fa-solid fa-comment';
                            $color_class = 'note-message';
                        } elseif (strpos($note_text, 'email') !== false || strpos($note_text, 'mail') !== false) {
                            $communication_type = 'email';
                            $icon = 'fa-regular fa-envelope';
                            $color_class = 'note-email';
                        } elseif (strpos($note_text, 'meeting') !== false || strpos($note_text, 'visit') !== false) {
                            $communication_type = 'meeting';
                            $icon = 'fa-solid fa-users';
                            $color_class = 'note-meeting';
                        }
                    ?>
                    <div class="media lead-note <?php echo $color_class; ?>">
                        <a href="<?= admin_url('profile/' . $note['addedfrom']); ?>" target="_blank">
                            <?= staff_profile_image($note['addedfrom'], ['staff-profile-image-small', 'pull-left mright10']); ?>
                        </a>
                        <!-- Add communication type icon -->
                        <span class="comm-icon" style="margin-right: 8px; font-size: 16px; color: <?php 
                            if ($color_class == 'note-whatsapp') echo '#25D366';
                            elseif ($color_class == 'note-call') echo '#007bff';
                            elseif ($color_class == 'note-message') echo '#6f42c1';
                            elseif ($color_class == 'note-email') echo '#fd7e14';
                            elseif ($color_class == 'note-meeting') echo '#20c997';
                            else echo '#6c757d';
                        ?>;">
                            <i class="<?php echo $icon; ?>"></i>
                        </span>
                        <div class="media-body">
                            <?php if ($note['addedfrom'] == get_staff_user_id() || is_admin()) { ?>
                            <a href="#" class="pull-right text-muted" onclick="delete_lead_note(this,<?= e($note['id']); ?>, <?= e($lead->id); ?>);return false;" style="margin-left: 8px; font-size: 16px;">
                                <i class="fa-regular fa-trash-can"></i>
                            </a>
                            <a href="#" class="pull-right text-muted" onclick="toggle_edit_note(<?= e($note['id']); ?>);return false;" style="margin-left: 8px; font-size: 16px;">
                                <i class="fa-regular fa-pen-to-square"></i>
                            </a>
                            <?php } ?>
                            <div class="media-heading">
                                <strong><?= get_staff_full_name($note['addedfrom']); ?></strong>
                                <small class="text-muted mleft5"><?= _dt($note['dateadded']); ?></small>
                                    <?php if (!empty($note['followup_type'])): ?>
                                    <span class="label label-info mleft10">
                                    <?= _l('Type:'); ?> <?= ucfirst($note['followup_type']); ?>
                                              </span>
                                              <?php endif; ?>
                            </div>
                            <div data-note-description="<?= e($note['id']); ?>" class="text-muted tw-leading-relaxed mtop10">
                                <?= process_text_content_for_display($note['description']); ?>
                                
                                <?php if (!empty($note['file_name'])): ?>
                                <div class="mtop10 note-attachment-wrapper">
                                    <?php
                                    $attachment_url = base_url('uploads/leads/notes/' . $note['id'] . '/' . $note['file_name']);
                                    $file_ext = strtolower(pathinfo($note['file_name'], PATHINFO_EXTENSION));
                                    
                                    if (in_array($file_ext, ['jpg', 'jpeg', 'png', 'gif'])): ?>
                                        <div class="note-image-preview">
                                            <a href="<?= $attachment_url; ?>" target="_blank" data-lightbox="lead-note-<?= $note['id']; ?>">
                                                <img src="<?= $attachment_url; ?>" alt="Image Attachment" class="img-responsive img-thumbnail" style="max-width:300px;max-height:200px;" />
                                            </a>
                                        </div>
                                    <?php elseif (in_array($file_ext, ['mp3', 'wav', 'ogg'])): ?>
                                        <div class="note-audio-preview">
                                            <audio controls class="audio-control">
                                                <source src="<?= $attachment_url; ?>" type="audio/<?= $file_ext; ?>">
                                                <?= _l('Your browser does not support the audio element.'); ?>
                                            </audio>
                                        </div>
                                    <?php else: ?>
                                        <div class="note-file-attachment">
                                            <a href="<?= $attachment_url; ?>" target="_blank" class="btn btn-link">
                                                <i class="fa fa-download"></i> <?= _l('Download Attachment'); ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <?php endif; ?>
                            </div>
                            
                            <div data-note-edit-textarea="<?= e($note['id']); ?>" class="hide mtop15">
                                <?= render_textarea('note', '', $note['description']); ?>
                                <div class="text-right">
                                    <button type="button" class="btn btn-default" onclick="toggle_edit_note(<?= e($note['id']); ?>);return false;">
                                        <?= _l('cancel'); ?>
                                    </button>
                                    <button type="button" class="btn btn-primary" onclick="edit_note(<?= e($note['id']); ?>);">
                                        <?= _l('update_note'); ?>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <?php if ($i >= 0 && $i != $len - 1) {
                            echo '<hr />';
                        }
                        ?>
                    </div>
                    <?php 
                        $i++;
                    } ?>
                    <?php // End of foreach loop for notes ?>
                </div>
                <?php hooks()->do_action('after_lead_tabs_content', $lead ?? null); ?>
            </div>
        </div>
    </div>
</div>
<?php } ?>

<script>
function delete_lead_note(el, note_id, lead_id) {
    if (!confirm('Are you sure you want to delete this note?')) return;
    $.post(admin_url + 'leads/delete_note/' + note_id + '/' + lead_id)
        .done(function(response) {
            var res = JSON.parse(response);
            if (res.success) {
                $(el).closest('.lead-note').fadeOut(300, function() { $(this).remove(); });
                alert_float('success', res.message || 'Note deleted successfully');
            } else {
                alert_float('danger', res.message || 'Failed to delete note');
            }
        })
        .fail(function() {
            alert_float('danger', 'Failed to delete note');
        });
}

<?php if (isset($lead)) { ?>
// Initialize AI Analysis when the tab is shown
$(document).ready(function() {
    // Initialize AI analysis functionality when the AI tab is clicked
    $('a[href="#ai_analysis"]').on('shown.bs.tab', function() {
        if (typeof window.initAIAnalysis === 'function') {
            window.initAIAnalysis(<?= $lead->id; ?>);
        }
        
        // Load statistics
        loadAIStatistics();
    });
    
    // Load AI analysis history when modal opens
    if (typeof window.loadAIAnalysisHistory === 'function') {
        window.loadAIAnalysisHistory(<?= $lead->id; ?>);
    }
    
    // Enhanced AI Analysis UI Handlers
    initEnhancedAIHandlers();
    
    // Load AI statistics when AI Analysis tab is shown
    $('a[href="#ai_analysis"]').on('shown.bs.tab', function() {
        loadAIStatistics();
        loadAnalysisHistory();
    });
    
    // If AI Analysis tab is already active on page load
    if ($('#ai_analysis').hasClass('active') || window.location.hash === '#ai_analysis') {
        setTimeout(function() {
            loadAIStatistics();
            loadAnalysisHistory();
        }, 500);
    }
});

function initEnhancedAIHandlers() {
    // Quick action buttons
    $(document).on('click', '.ai-quick-btn', function() {
        const analysisType = $(this).data('analysis-type');
        $('#ai_analysis_type').val(analysisType);
        $('#ai-analysis-panel').slideDown(300);
        updateAnalysisTypeTitle(analysisType);
        
        // Auto-select relevant focus options based on analysis type
        autoSelectFocusOptions(analysisType);
    });
    
    // Close panel button
    $(document).on('click', '#close-analysis-panel', function() {
        $('#ai-analysis-panel').slideUp(300);
    });
    
    // Analysis type change
    $(document).on('change', '#ai_analysis_type', function() {
        const analysisType = $(this).val();
        updateAnalysisTypeTitle(analysisType);
        autoSelectFocusOptions(analysisType);
    });
    
    // Enhanced start analysis button
    $(document).on('click', '#start-ai-analysis', function() {
        const $btn = $(this);
        const $loading = $btn.find('.ai-btn-loading');
        const $text = $btn.find('span');
        
        // Show loading state
        $text.hide();
        $loading.show();
        $btn.prop('disabled', true);
        
        // Get form data
        const analysisType = $('#ai_analysis_type').val();
        const analysisNotes = $('#ai_analysis_notes').val();
        
        // Get selected focus options
        const focusOptions = [];
        $('input[name="analysis_focus[]"]:checked').each(function() {
            focusOptions.push($(this).val());
        });
        
        // Prepare data for analysis
        const analysisData = {
            analysis_type: analysisType,
            analysis_notes: analysisNotes,
            focus_areas: focusOptions.join(',')
        };
        
        // Start actual AI analysis
        $.ajax({
            url: admin_url + 'leads/ai_analyze/' + <?= $lead->id; ?>,
            type: 'POST',
            data: analysisData,
            success: function(response) {
                // Reset button state
                $loading.hide();
                $text.show();
                $btn.prop('disabled', false);
                
                if (response.success) {
                    // Show success message
                    alert_float('success', response.message || 'AI Analysis completed successfully!');
                    
                    // Load latest analysis results
                    loadLatestAnalysisResults();
                    
                    // Update statistics
                    loadAIStatistics();
                    
                    // Hide analysis panel
                    $('#ai-analysis-panel').slideUp(300);
                    
                    // Load updated history
                    loadAnalysisHistory();
                } else {
                    alert_float('danger', response.message || 'Analysis failed. Please try again.');
                }
            },
            error: function(xhr, status, error) {
                // Reset button state
                $loading.hide();
                $text.show();
                $btn.prop('disabled', false);
                
                console.error('AI Analysis Error:', error);
                alert_float('danger', 'Analysis failed due to a technical error. Please try again.');
            }
        });
    });
    
    // History filter
    $(document).on('change', '#history-filter', function() {
        const filterType = $(this).val();
        filterAnalysisHistory(filterType);
    });
    
    // Export and share buttons
    $(document).on('click', '#export-results', function() {
        exportAnalysisResults();
    });
    
    $(document).on('click', '#share-results', function() {
        shareAnalysisResults();
    });
}

function updateAnalysisTypeTitle(analysisType) {
    const titles = {
        'document_analysis': 'Document Analysis Configuration',
        'lead_scoring': 'Lead Scoring & Qualification Setup',
        'conversation_analysis': 'Conversation Analysis Settings',
        'company_research': 'Company Research Configuration',
        'competitive_analysis': 'Competitive Analysis Setup',
        'opportunity_assessment': 'Opportunity Assessment Config',
        'risk_evaluation': 'Risk Evaluation Settings'
    };
    
    $('#analysis-type-title').text(titles[analysisType] || 'Advanced Analysis Configuration');
}

function autoSelectFocusOptions(analysisType) {
    // Clear all checkboxes first
    $('input[name="analysis_focus[]"]').prop('checked', false);
    
    // Auto-select relevant options based on analysis type
    const autoSelections = {
        'lead_scoring': ['financial_capacity', 'decision_making', 'timeline'],
        'company_research': ['financial_capacity', 'pain_points'],
        'conversation_analysis': ['pain_points', 'decision_making'],
        'opportunity_assessment': ['financial_capacity', 'timeline', 'pain_points'],
        'risk_evaluation': ['financial_capacity', 'decision_making']
    };
    
    if (autoSelections[analysisType]) {
        autoSelections[analysisType].forEach(option => {
            $(`input[name="analysis_focus[]"][value="${option}"]`).prop('checked', true);
        });
    }
}

function loadAIStatistics() {
    // Load total analyses count and average score
    $.ajax({
        url: admin_url + 'leads/get_ai_statistics/' + <?= $lead->id; ?>,
        type: 'GET',
        success: function(response) {
            if (response.success) {
                $('#total-analyses').text(response.data.total_analyses || 0);
                $('#confidence-score').text(response.data.avg_score ? response.data.avg_score + '%' : '--');
            }
        },
        error: function() {
            console.log('Failed to load AI statistics');
        }
    });
}

function loadLatestAnalysisResults() {
    // Load the latest AI analysis report for this lead
    $.ajax({
        url: admin_url + 'leads/get_ai_report/' + <?= $lead->id; ?>,
        type: 'GET',
        success: function(response) {
            if (response.success && response.data) {
                showAnalysisResults(response.data);
            }
        },
        error: function() {
            console.log('Failed to load latest analysis results');
        }
    });
}

function loadAnalysisHistory() {
    const $historyContent = $('#ai-history-content');
    const leadId = <?= $lead->id; ?>;
    
    // Show loading state
    $historyContent.html(`
        <div class="ai-history-loading">
            <div class="ai-loading-spinner">
                <i class="fa-solid fa-spinner fa-spin"></i>
            </div>
            <p>Loading AI reports history...</p>
        </div>
    `);
    
    $.ajax({
        url: admin_url + 'leads/get_ai_reports_history/' + leadId,
        type: 'GET',
        success: function(response) {
            if (response.success && response.data.reports.length > 0) {
                let historyHtml = '<div class="ai-history-list-professional">';
                
                response.data.reports.forEach(function(report, index) {
                    const isLatest = index === 0;
                    
                    historyHtml += `
                        <div class="ai-report-card ${isLatest ? 'latest-report' : ''}">
                            <div class="ai-report-header">
                                <div class="ai-report-meta-left">
                                    <div class="ai-report-type">
                                        <i class="fa-solid fa-brain"></i>
                                        ${report.analysis_type}
                                    </div>
                                    ${isLatest ? '<span class="latest-indicator">Latest</span>' : ''}
                                </div>
                                <div class="ai-report-meta-right">
                                    <div class="ai-report-date">
                                        <i class="fa-solid fa-calendar"></i>
                                        ${report.formatted_date}
                                    </div>
                                    <div class="ai-report-time-ago text-muted">
                                        ${report.time_ago}
                                    </div>
                                </div>
                            </div>
                            
                            <div class="ai-report-metrics">
                                <div class="ai-metric-item">
                                    <div class="ai-metric-label">Confidence Score</div>
                                    <div class="ai-metric-value">
                                        <div class="progress-wrapper">
                                            <div class="progress progress-sm">
                                                <div class="progress-bar progress-bar-${report.confidence_class}" 
                                                     style="width: ${report.confidence_score}%"></div>
                                            </div>
                                            <span class="progress-text">${report.confidence_score}%</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="ai-metric-item">
                                    <div class="ai-metric-label">Verdict</div>
                                    <div class="ai-metric-value">
                                        <span class="label label-${report.verdict_class}">${report.verdict}</span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="ai-report-summary">
                                <div class="ai-summary-content">
                                    ${report.summary}
                                </div>
                            </div>
                            
                            <div class="ai-report-actions">
                                <div class="ai-action-buttons">
                                    <button class="btn btn-default btn-sm view-in-ai-reports-btn" 
                                            data-report-id="${report.id}"
                                            title="Open in AI Reports page">
                                        <i class="fa-solid fa-external-link"></i> View Details
                                    </button>
                                    <button class="btn btn-info btn-sm compare-report-btn" 
                                            data-report-id="${report.id}"
                                            title="Compare with other reports">
                                        <i class="fa-solid fa-code-compare"></i> Compare
                                    </button>
                                </div>
                                <div class="ai-report-status">
                                    <span class="status-indicator status-${report.status}">
                                        <i class="fa-solid fa-circle"></i> ${report.status.charAt(0).toUpperCase() + report.status.slice(1)}
                                    </span>
                                </div>
                            </div>
                        </div>
                    `;
                });
                
                historyHtml += '</div>';
                
                // Add enhanced footer with statistics and actions
                historyHtml += `
                    <div class="ai-history-summary">
                        <div class="ai-summary-stats">
                            <div class="stat-item">
                                <div class="stat-number">${response.data.total_count}</div>
                                <div class="stat-label">Total Reports</div>
                            </div>
                            <div class="stat-divider"></div>
                            <div class="stat-item">
                                <div class="stat-number">${response.data.reports.length}</div>
                                <div class="stat-label">Showing</div>
                            </div>
                        </div>
                        <div class="ai-summary-actions">
                            <button class="btn btn-success btn-sm" onclick="window.open('${admin_url}ai_reports?lead_id=<?= $lead->id; ?>', '_blank')">
                                <i class="fa-solid fa-chart-line"></i> View All Reports
                            </button>
                            <button class="btn btn-default btn-sm" onclick="exportAIHistory(<?= $lead->id; ?>)">
                                <i class="fa-solid fa-download"></i> Export
                            </button>
                        </div>
                    </div>
                `;
                
                $historyContent.html(historyHtml);
                
                // Change layout from flex to block for content display
                $historyContent.css({
                    'display': 'block',
                    'align-items': 'initial',
                    'justify-content': 'initial'
                });
                
                // Bind enhanced click events
                bindEnhancedHistoryActions();
                
            } else {
                // Show placeholder for no analyses
                $historyContent.html(`
                    <div class="ai-history-placeholder">
                        <div class="ai-placeholder-icon">
                            <i class="fa-solid fa-history"></i>
                        </div>
                        <h5>No Previous Analyses</h5>
                        <p>Start your first AI analysis to see results here</p>
                        <button class="btn btn-primary btn-sm" onclick="$('#ai-analysis-panel').slideDown(300);">
                            <i class="fa-solid fa-magic"></i> Start Analysis
                        </button>
                    </div>
                `);
                
                // Reset to flex layout for placeholder
                $historyContent.css({
                    'display': 'flex',
                    'align-items': 'center',
                    'justify-content': 'center'
                });
            }
        },
        error: function(xhr, status, error) {
            console.error('AI History Load Error:', {
                status: xhr.status,
                statusText: xhr.statusText,
                responseText: xhr.responseText,
                error: error
            });
            
            let errorMessage = 'Unable to load AI analysis history. Please try again.';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                errorMessage = xhr.responseJSON.message;
            } else if (xhr.status === 404) {
                errorMessage = 'AI reports endpoint not found. Please check system configuration.';
            } else if (xhr.status === 500) {
                errorMessage = 'Server error occurred. Please check error logs.';
            }
            
            $historyContent.html(`
                <div class="ai-history-error">
                    <div class="ai-error-icon">
                        <i class="fa-solid fa-exclamation-triangle"></i>
                    </div>
                    <h5>Failed to Load History</h5>
                    <p>${errorMessage}</p>
                    <div class="ai-error-details">
                        <small class="text-muted">
                            Status: ${xhr.status} | Error: ${error}
                        </small>
                    </div>
                    <button class="btn btn-sm btn-outline-primary" onclick="loadAnalysisHistory()">
                        <i class="fa-solid fa-refresh"></i> Retry
                    </button>
                </div>
            `);
            
            // Reset to flex layout for error display
            $historyContent.css({
                'display': 'flex',
                'align-items': 'center',
                'justify-content': 'center'
            });
        }
    });
}

// Enhanced helper functions for AI history interactions
function bindEnhancedHistoryActions() {
    // View in AI Reports page (new tab)
    $('.view-in-ai-reports-btn').off('click').on('click', function() {
        const reportId = $(this).data('report-id');
        window.open(admin_url + 'ai_reports/view/' + reportId, '_blank');
    });
    
    // Compare reports
    $('.compare-report-btn').off('click').on('click', function() {
        const reportId = $(this).data('report-id');
        openCompareModal(reportId);
    });
}

function openCompareModal(reportId) {
    // For now, redirect to compare page with this report pre-selected
    const compareUrl = admin_url + 'ai_reports/compare?reports=' + reportId;
    window.open(compareUrl, '_blank');
}

function exportAIHistory(leadId) {
    // Export AI history as CSV or PDF
    window.open(admin_url + 'leads/export_ai_history/' + leadId, '_blank');
}

function showAnalysisResults(data = null) {
    // Show results section with animation
    $('#ai-analysis-results').slideDown(300);
    
    // If no data provided, show sample results
    if (!data) {
        const sampleResults = `
            <div class="ai-result-card">
                <div class="ai-result-header">
                    <h5><i class="fa-solid fa-chart-line"></i> Lead Score: 85%</h5>
                    <span class="ai-result-badge ai-badge-success">High Priority</span>
                </div>
                <div class="ai-result-body">
                    <p>This lead shows strong potential based on our analysis. Key indicators suggest high purchase intent and decision-making authority.</p>
                    <div class="ai-result-metrics">
                        <div class="ai-metric">
                            <span class="ai-metric-label">Financial Capacity</span>
                            <div class="ai-metric-bar">
                                <div class="ai-metric-fill" style="width: 90%"></div>
                            </div>
                            <span class="ai-metric-value">90%</span>
                        </div>
                        <div class="ai-metric">
                            <span class="ai-metric-label">Purchase Timeline</span>
                            <div class="ai-metric-bar">
                                <div class="ai-metric-fill" style="width: 75%"></div>
                            </div>
                            <span class="ai-metric-value">75%</span>
                        </div>
                    </div>
                </div>
            </div>
        `;
        $('#ai-results-content').html(sampleResults);
        return;
    }
    
    // Create results from real data
    const score = data.confidence_score || data.score || 0;
    const verdict = data.verdict || 'Unknown';
    const insights = data.key_insights || 'No insights available';
    const recommendations = data.recommended_actions || '';
    
    // Determine badge class based on score
    let badgeClass = 'ai-badge-danger';
    let priority = 'Low Priority';
    if (score >= 70) {
        badgeClass = 'ai-badge-success';
        priority = 'High Priority';
    } else if (score >= 40) {
        badgeClass = 'ai-badge-warning';
        priority = 'Medium Priority';
    }
    
    const resultsHtml = `
        <div class="ai-result-card">
            <div class="ai-result-header">
                <h5><i class="fa-solid fa-chart-line"></i> Lead Score: ${score}%</h5>
                <span class="ai-result-badge ${badgeClass}">${priority}</span>
            </div>
            <div class="ai-result-body">
                <div class="mb-3">
                    <h6><i class="fa-solid fa-lightbulb"></i> Key Insights</h6>
                    <p>${insights}</p>
                </div>
                
                ${recommendations ? `
                <div class="mb-3">
                    <h6><i class="fa-solid fa-tasks"></i> Recommended Actions</h6>
                    <p>${recommendations}</p>
                </div>
                ` : ''}
                
                <div class="ai-result-metrics">
                    <div class="ai-metric">
                        <span class="ai-metric-label">Lead Score</span>
                        <div class="ai-metric-bar">
                            <div class="ai-metric-fill" style="width: ${score}%"></div>
                        </div>
                        <span class="ai-metric-value">${score}%</span>
                    </div>
                    <div class="ai-metric">
                        <span class="ai-metric-label">Verdict</span>
                        <div class="ai-metric-bar">
                            <div class="ai-metric-fill" style="width: ${getVerdictWidth(verdict)}%"></div>
                        </div>
                        <span class="ai-metric-value">${verdict}</span>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    $('#ai-results-content').html(resultsHtml);
    
    // Scroll to results
    $('html, body').animate({
        scrollTop: $('#ai-analysis-results').offset().top - 100
    }, 500);
}

function getVerdictWidth(verdict) {
    const verdictMap = {
        'Hot': 90,
        'Warm': 60,
        'Cold': 30,
        'Unknown': 10
    };
    return verdictMap[verdict] || 50;
}

function filterAnalysisHistory(filterType) {
    // Implementation for filtering analysis history
    console.log('Filtering history by:', filterType);
}

function clearAIUploads() {
    // Clear uploaded files
    if (confirm('Are you sure you want to clear all uploaded files?')) {
        alert_float('success', 'Files cleared successfully');
    }
}

function exportAnalysisResults() {
    // Implementation for exporting results
    alert_float('info', 'Export functionality will be available soon');
}

function shareAnalysisResults() {
    // Implementation for sharing results
    alert_float('info', 'Share functionality will be available soon');
}

function exportAnalysisResults() {
    // Implementation for exporting results
    alert('Export functionality would be implemented here');
}

function shareAnalysisResults() {
    // Implementation for sharing results
    alert('Share functionality would be implemented here');
}

function clearAIUploads() {
    // Clear uploaded files
    if (confirm('Are you sure you want to clear all uploaded files?')) {
        alert_float('success', 'Files cleared successfully');
    }
}
<?php } ?>
</script>
