<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-success">
                    <div class="panel-heading">
                        <h3 class="panel-title">
                            <i class="fa fa-brain"></i> OpenAI Configuration
                        </h3>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-8">
                                <?php echo form_open(admin_url('ai_setup/setup_openai')); ?>
                                
                                <div class="form-group">
                                    <label for="openai_api_key">OpenAI API Key</label>
                                    <div class="input-group">
                                        <span class="input-group-addon">
                                            <i class="fa fa-key"></i>
                                        </span>
                                        <input type="password" 
                                               id="openai_api_key" 
                                               name="openai_api_key" 
                                               class="form-control" 
                                               value="<?php echo $current_key; ?>"
                                               placeholder="sk-...">
                                    </div>
                                    <p class="help-block">
                                        <i class="fa fa-info-circle"></i>
                                        Enter your OpenAI API key to enable AI-powered lead analysis.
                                        <br>
                                        <strong>Get your API key from:</strong> 
                                        <a href="https://platform.openai.com/api-keys" target="_blank">
                                            https://platform.openai.com/api-keys
                                            <i class="fa fa-external-link"></i>
                                        </a>
                                    </p>
                                </div>
                                
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fa fa-save"></i> Save OpenAI Configuration
                                    </button>
                                    
                                    <a href="<?= admin_url('ai_setup/fix_database'); ?>" class="btn btn-default">
                                        <i class="fa fa-arrow-left"></i> Back to Database Setup
                                    </a>
                                </div>
                                
                                <?php echo form_close(); ?>
                            </div>
                            
                            <div class="col-md-4">
                                <?php if (!empty($current_key)): ?>
                                    <div class="alert alert-success">
                                        <h4><i class="fa fa-check-circle"></i> Configuration Status</h4>
                                        <p>OpenAI API key is configured and ready!</p>
                                        <p><strong>Key:</strong> <?= substr($current_key, 0, 7) . '...' . substr($current_key, -4); ?></p>
                                    </div>
                                    
                                    <div class="panel panel-info">
                                        <div class="panel-heading">
                                            <h5 class="panel-title">Test AI Analysis</h5>
                                        </div>
                                        <div class="panel-body">
                                            <p>Your AI analysis is ready to use!</p>
                                            <a href="<?= admin_url('leads'); ?>" class="btn btn-success btn-block">
                                                <i class="fa fa-users"></i> Test with Leads
                                            </a>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="alert alert-warning">
                                        <h4><i class="fa fa-exclamation-triangle"></i> Setup Required</h4>
                                        <p>OpenAI API key is required for AI lead analysis functionality.</p>
                                    </div>
                                    
                                    <div class="panel panel-info">
                                        <div class="panel-heading">
                                            <h5 class="panel-title">How to Get API Key</h5>
                                        </div>
                                        <div class="panel-body">
                                            <ol>
                                                <li>Visit <a href="https://platform.openai.com" target="_blank">OpenAI Platform</a></li>
                                                <li>Sign up or log in</li>
                                                <li>Go to API Keys section</li>
                                                <li>Create a new API key</li>
                                                <li>Copy and paste it here</li>
                                            </ol>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h5 class="panel-title">AI Analysis Features</h5>
                                    </div>
                                    <div class="panel-body">
                                        <ul>
                                            <li><i class="fa fa-check text-success"></i> Lead scoring</li>
                                            <li><i class="fa fa-check text-success"></i> Document analysis</li>
                                            <li><i class="fa fa-check text-success"></i> Image analysis</li>
                                            <li><i class="fa fa-check text-success"></i> Recommendations</li>
                                            <li><i class="fa fa-check text-success"></i> Conversation insights</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php init_tail(); ?>
