<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-primary">
                    <div class="panel-heading">
                        <h3 class="panel-title">
                            <i class="fa fa-database"></i> AI Analysis Database Setup
                        </h3>
                    </div>
                    <div class="panel-body">
                        <?php 
                        $results = $this->session->flashdata('ai_setup_results');
                        if ($results): 
                        ?>
                            <?php foreach ($results as $result): ?>
                                <div class="alert alert-<?= $result[0]; ?>">
                                    <i class="fa fa-<?= $result[0] === 'success' ? 'check' : ($result[0] === 'danger' ? 'times' : 'info'); ?>-circle"></i>
                                    <?= $result[1]; ?>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        
                        <div class="row">
                            <div class="col-md-8">
                                <h4>Database Table Status</h4>
                                
                                <?php if (isset($table_status['tables']) && !empty($table_status['tables'])): ?>
                                    <?php foreach ($table_status['tables'] as $table => $info): ?>
                                        <div class="panel panel-default">
                                            <div class="panel-heading">
                                                <h5 class="panel-title">
                                                    <?php if ($info['exists']): ?>
                                                        <i class="fa fa-check-circle text-success"></i>
                                                    <?php else: ?>
                                                        <i class="fa fa-times-circle text-danger"></i>
                                                    <?php endif; ?>
                                                    <?= $info['name']; ?>
                                                    <small class="text-muted">(<?= $table; ?>)</small>
                                                </h5>
                                            </div>
                                            <div class="panel-body">
                                                <?php if ($info['exists']): ?>
                                                    <p class="text-success">✅ Table exists</p>
                                                    <?php if (!empty($info['columns'])): ?>
                                                        <p><strong>Columns:</strong></p>
                                                        <div class="row">
                                                        <?php foreach ($info['columns'] as $column): ?>
                                                            <div class="col-md-3">
                                                                <span class="label label-info"><?= $column; ?></span>
                                                            </div>
                                                        <?php endforeach; ?>
                                                    </div>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <p class="text-danger">❌ Table does not exist</p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                                <?php else: ?>
                                    <div class="alert alert-warning">
                                        <i class="fa fa-exclamation-triangle"></i> No table status information available.
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h5 class="panel-title">Actions</h5>
                                    </div>
                                    <div class="panel-body">
                                        <a href="<?= admin_url('ai_setup/fix_database?action=fix'); ?>" 
                                           class="btn btn-primary btn-block">
                                            <i class="fa fa-wrench"></i> Fix Database Structure
                                        </a>
                                        
                                        <hr>
                                        
                                        <a href="<?= admin_url('ai_setup/setup_openai'); ?>" 
                                           class="btn btn-success btn-block">
                                            <i class="fa fa-cog"></i> Configure OpenAI
                                        </a>
                                        
                                        <hr>
                                        
                                        <a href="<?= admin_url('leads'); ?>" 
                                           class="btn btn-default btn-block">
                                            <i class="fa fa-arrow-left"></i> Back to Leads
                                        </a>
                                    </div>
                                </div>
                                
                                <div class="panel panel-warning">
                                    <div class="panel-heading">
                                        <h5 class="panel-title">Required Tables</h5>
                                    </div>
                                    <div class="panel-body">
                                        <ul>
                                            <li><strong>leads_ai_reports:</strong> Stores AI analysis results</li>
                                            <li><strong>leads_ai_analysis_queue:</strong> Manages analysis queue</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php init_tail(); ?>
