<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Whatsapp_test extends AdminController
{
    public function __construct()
    {
        parent::__construct();
    }

    public function activate_test()
    {
        echo "<h1>WhatsApp API Module Activation Test</h1>";
        
        echo "<h2>Current Module Status:</h2>";
        
        // Check if options exist
        $options_to_check = [
            'whatsapp_api_enabled',
            'whatsapp_api_verification_id', 
            'whatsapp_api_product_token',
            'whatsapp_api_last_verification'
        ];

        foreach ($options_to_check as $option) {
            $value = get_option($option);
            echo "<p><strong>$option:</strong> " . ($value ? $value : 'NOT SET') . "</p>";
        }

        // Try to set options
        echo "<h2>Setting License Bypass Options:</h2>";

        $bypass_options = [
            'whatsapp_api_enabled' => '1',
            'whatsapp_api_verification_id' => base64_encode('dummy|verification|user|key'),
            'whatsapp_api_product_token' => 'dummy_token_bypassed',
            'whatsapp_api_last_verification' => time()
        ];

        foreach ($bypass_options as $name => $value) {
            try {
                update_option($name, $value);
                echo "<p>✅ Set $name = $value</p>";
            } catch (Exception $e) {
                echo "<p>❌ Failed to set $name: " . $e->getMessage() . "</p>";
            }
        }

        // Test module activation
        echo "<h2>Module Activation Test:</h2>";

        try {
            $modules = $this->app_modules->get();
            $whatsapp_api_module = null;
            
            foreach ($modules as $module) {
                if ($module['system_name'] === 'whatsapp_api') {
                    $whatsapp_api_module = $module;
                    break;
                }
            }
            
            if ($whatsapp_api_module) {
                echo "<p>✅ WhatsApp API module found</p>";
                echo "<p><strong>Version:</strong> " . $whatsapp_api_module['headers']['version'] . "</p>";
                echo "<p><strong>Status:</strong> " . ($whatsapp_api_module['activated'] ? 'ACTIVATED' : 'NOT ACTIVATED') . "</p>";
                
                if (!$whatsapp_api_module['activated']) {
                    echo "<p>🔄 Attempting to activate module...</p>";
                    
                    try {
                        $this->app_modules->activate('whatsapp_api');
                        echo "<p>✅ Module activation attempted</p>";
                        
                        // Check again
                        $modules = $this->app_modules->get();
                        foreach ($modules as $module) {
                            if ($module['system_name'] === 'whatsapp_api') {
                                echo "<p><strong>New Status:</strong> " . ($module['activated'] ? 'ACTIVATED' : 'NOT ACTIVATED') . "</p>";
                                break;
                            }
                        }
                        
                    } catch (Exception $e) {
                        echo "<p>❌ Module activation failed: " . $e->getMessage() . "</p>";
                    }
                }
            } else {
                echo "<p>❌ WhatsApp API module not found</p>";
            }
            
        } catch (Exception $e) {
            echo "<p>❌ Module test failed: " . $e->getMessage() . "</p>";
        }

        echo "<h2>Test Complete</h2>";
        echo "<p><a href='" . admin_url('modules') . "'>Go to Modules Page</a></p>";
    }
    
    public function force_activate()
    {
        echo "<h1>Force Activating WhatsApp API Module</h1>";
        
        // Set all required options directly in database
        $options = [
            'whatsapp_api_enabled' => '1',
            'whatsapp_api_verification_id' => base64_encode('dummy|verification|user|key'),
            'whatsapp_api_product_token' => 'dummy_token_bypassed',
            'whatsapp_api_last_verification' => time(),
            'whatsapp_cron_job_queue_enabled' => '0',
            'whatsapp_cron_has_run_from_cli' => '0'
        ];

        foreach ($options as $name => $value) {
            update_option($name, $value);
            echo "✅ Set $name = $value<br>";
        }

        // Clean up any error states
        delete_option('whatsapp_api_heartbeat');
        echo "✅ Cleaned up heartbeat errors<br>";

        echo "<h2>Activation Complete!</h2>";
        echo "<p><a href='" . admin_url('modules') . "'>Go to Modules Page</a></p>";
    }
}
?>
