<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Dark Glass Theme
Description: Modern dark theme with glassmorphism effects for Perfex CRM. Features include dark backgrounds, glass morphism UI elements, animated background orbs, customizable colors, and smooth transitions.
Version: 1.0.0
Requires at least: 2.3.*
Author: Dark Glass Theme
Author URI: https://github.com/yourusername/darkglass-theme
Module URI: https://github.com/yourusername/darkglass-theme
License: MIT
*/

/**
 * Register the module
 */
register_activation_hook('darkglass_theme', 'darkglass_theme_activation_hook');
register_deactivation_hook('darkglass_theme', 'darkglass_theme_deactivation_hook');

/**
 * The module activation function
 */
function darkglass_theme_activation_hook()
{
    $CI = &get_instance();
    
    // Create necessary database tables or settings if needed
    add_option('darkglass_theme_activated', 1);
    add_option('darkglass_theme_primary_color', '#06b6d4');
    add_option('darkglass_theme_secondary_color', '#14b8a6');
    add_option('darkglass_theme_blur_intensity', '20');
}

/**
 * The module deactivation function
 */
function darkglass_theme_deactivation_hook()
{
    // Clean up when module is deactivated
    delete_option('darkglass_theme_activated');
}

/**
 * Register module menu items in admin area
 */
hooks()->add_action('admin_init', 'darkglass_theme_init_menu_items');

function darkglass_theme_init_menu_items()
{
    $CI = &get_instance();
    
    if (has_permission('settings', '', 'view')) {
        $CI->app_menu->add_sidebar_menu_item('darkglass-theme-settings', [
            'name'     => 'Dark Glass Theme',
            'href'     => admin_url('darkglass_theme/settings'),
            'position' => 30,
            'icon'     => 'fa fa-paint-brush',
        ]);
    }
}

/**
 * Load theme assets
 */
hooks()->add_action('app_admin_head', 'darkglass_theme_head');
hooks()->add_action('app_admin_footer', 'darkglass_theme_footer');

function darkglass_theme_head()
{
    $CI = &get_instance();
    
    if (get_option('darkglass_theme_activated') == 1) {
        echo '<link href="' . module_dir_url('darkglass_theme', 'assets/css/darkglass-theme.css') . '" rel="stylesheet">';
        echo '<link href="' . module_dir_url('darkglass_theme', 'assets/css/glassmorphism.css') . '" rel="stylesheet">';
        
        // Add immediate inline styles to ensure theme loads
        echo '<style>
        /* Immediate Dark Glass Theme Application */
        body {
            background: linear-gradient(135deg, #0a0e27 0%, #1a1f3a 30%, #0f1729 60%, #1e2a3a 100%) !important;
            color: #ffffff !important;
        }
        #wrapper, .content {
            background: transparent !important;
            color: #ffffff !important;
        }
        .panel, .card, .box, .panel_s {
            background: rgba(255, 255, 255, 0.04) !important;
            border: 1px solid rgba(255, 255, 255, 0.08) !important;
            border-radius: 20px !important;
            color: #ffffff !important;
        }
        #side-menu, .side-menu {
            background: rgba(10, 14, 39, 0.95) !important;
            backdrop-filter: blur(25px);
        }
        /* Sidebar links */
        #side-menu li a, .nav-sidebar > li > a, .navbar-nav > li > a, .nav li a {
            color: rgba(255, 255, 255, 0.7) !important;
            background: transparent !important;
            border-radius: 12px !important;
            margin: 2px 10px !important;
            padding: 14px 15px !important;
        }
        #side-menu li a span, #side-menu li a i, .nav li a span, .nav li a i {
            color: rgba(255, 255, 255, 0.7) !important;
        }
        #side-menu li a:hover, .nav li a:hover {
            background: rgba(6, 182, 212, 0.15) !important;
            color: #06b6d4 !important;
        }
        #side-menu li a:hover span, #side-menu li a:hover i {
            color: #06b6d4 !important;
        }
        #side-menu li.active > a, .nav li.active > a {
            background: rgba(6, 182, 212, 0.25) !important;
            color: #06b6d4 !important;
        }
        #side-menu li.active > a span, #side-menu li.active > a i {
            color: #06b6d4 !important;
        }
        /* Adaptive text colors */
        h1, h2, h3, h4, h5, h6, p, span, div, td, th, .table {
            color: #ffffff !important;
        }
        .text-muted, .help-block, small {
            color: rgba(255, 255, 255, 0.7) !important;
        }
        a {
            color: #06b6d4 !important;
        }
        a:hover {
            color: #14b8a6 !important;
        }
        .form-control, input, textarea, select {
            background-color: rgba(255, 255, 255, 0.05) !important;
            border-color: rgba(255, 255, 255, 0.08) !important;
            color: #ffffff !important;
        }
        .form-control::placeholder, input::placeholder, textarea::placeholder {
            color: rgba(255, 255, 255, 0.4) !important;
        }
        /* Light backgrounds get dark text */
        .bg-white, .bg-light, .dropdown-menu {
            color: #2d3748 !important;
        }
        .bg-white .text-muted, .bg-light .text-muted {
            color: #4a5568 !important;
        }
        /* Modal fixes */
        .modal-content {
            background: rgba(10, 14, 39, 0.95) !important;
            color: #ffffff !important;
            border: 1px solid rgba(255, 255, 255, 0.08) !important;
            border-radius: 20px !important;
        }
        .modal-header, .modal-body, .modal-footer {
            color: #ffffff !important;
        }
        .modal-title {
            color: #ffffff !important;
        }
        /* Navigation tabs fixes */
        .nav-tabs {
            background: rgba(255, 255, 255, 0.03) !important;
            border-radius: 12px 12px 0 0 !important;
        }
        .nav-tabs .nav-link {
            color: rgba(255, 255, 255, 0.7) !important;
            background: transparent !important;
            border-radius: 8px 8px 0 0 !important;
        }
        .nav-tabs .nav-link.active {
            background: rgba(6, 182, 212, 0.15) !important;
            color: #06b6d4 !important;
            border-color: #06b6d4 !important;
        }
        .nav-pills .nav-link {
            background: rgba(255, 255, 255, 0.05) !important;
            color: rgba(255, 255, 255, 0.7) !important;
            border: 1px solid rgba(255, 255, 255, 0.08) !important;
        }
        .nav-pills .nav-link.active {
            background: #06b6d4 !important;
            color: #ffffff !important;
        }
        .tab-content {
            background: rgba(255, 255, 255, 0.02) !important;
            color: #ffffff !important;
        }
        /* Universal modal content fixes */
        .modal *, .modal div, .modal section, .modal article {
            background: transparent !important;
            color: #ffffff !important;
        }
        .modal .text-muted, .modal small, .modal .help-text {
            color: rgba(255, 255, 255, 0.7) !important;
        }
        .modal .bg-white, .modal .bg-light {
            background: rgba(255, 255, 255, 0.03) !important;
            color: #ffffff !important;
        }
        .modal .row, .modal .col-md-12, .modal .col-sm-12 {
            background: transparent !important;
            color: #ffffff !important;
        }
        /* Scroller elements */
        .scroller, .arrow-left, .arrow-right {
            background: rgba(255, 255, 255, 0.05) !important;
            border: 1px solid rgba(255, 255, 255, 0.08) !important;
            color: rgba(255, 255, 255, 0.7) !important;
        }
        .scroller.disabled, .arrow-left.disabled, .arrow-right.disabled {
            opacity: 0.3 !important;
            color: rgba(255, 255, 255, 0.3) !important;
        }
        .modal .panel, .modal .card, .modal .widget {
            background: rgba(255, 255, 255, 0.03) !important;
            border: 1px solid rgba(255, 255, 255, 0.08) !important;
            color: #ffffff !important;
        }
        /* Notes and Follow-up styling */
        .modal textarea, .modal .note-content, .modal .comment-field {
            background: rgba(10, 14, 39, 0.8) !important;
            border: 1px solid rgba(6, 182, 212, 0.3) !important;
            border-radius: 12px !important;
            color: #ffffff !important;
            padding: 15px !important;
        }
        .modal textarea::placeholder {
            color: rgba(255, 255, 255, 0.6) !important;
        }
        /* SUPER AGGRESSIVE TEXT FIELD STYLING */
        .modal input, .modal select, .modal .form-control, .modal [contenteditable] {
            background: rgba(10, 14, 39, 0.8) !important;
            border: 1px solid rgba(6, 182, 212, 0.3) !important;
            border-radius: 8px !important;
            color: #ffffff !important;
            padding: 12px 15px !important;
        }
        .modal div[style*="background"], .modal span[style*="background"], .modal .bg-white {
            background: rgba(10, 14, 39, 0.6) !important;
            color: #ffffff !important;
        }
        .modal div, .modal span, .modal p, .modal td, .modal th {
            color: #ffffff !important;
        }
        .modal .note-item, .modal .activity-item, .modal .follow-up-item {
            background: rgba(255, 255, 255, 0.05) !important;
            border: 1px solid rgba(255, 255, 255, 0.08) !important;
            border-radius: 12px !important;
            color: #ffffff !important;
            padding: 15px !important;
            margin-bottom: 15px !important;
        }
        .modal .note-header, .modal .activity-header {
            background: rgba(255, 255, 255, 0.03) !important;
            color: rgba(255, 255, 255, 0.7) !important;
            border-radius: 8px !important;
            padding: 8px 12px !important;
        }
        .modal .note-timestamp, .modal .activity-timestamp {
            color: rgba(255, 255, 255, 0.4) !important;
        }
        .modal input[type="date"], .modal input[type="datetime-local"] {
            background: rgba(255, 255, 255, 0.08) !important;
            border: 1px solid rgba(255, 255, 255, 0.08) !important;
            color: #ffffff !important;
        }
        .modal input[type="file"], .modal .file-upload {
            background: rgba(255, 255, 255, 0.05) !important;
            border: 2px dashed rgba(255, 255, 255, 0.08) !important;
            color: rgba(255, 255, 255, 0.7) !important;
        }
        .modal .btn-add-note, .modal .btn-add-followup {
            background: #06b6d4 !important;
            color: #ffffff !important;
            border-radius: 25px !important;
        }
        </style>';
    }
}

function darkglass_theme_footer()
{
    $CI = &get_instance();
    
    if (get_option('darkglass_theme_activated') == 1) {
        echo '<script src="' . module_dir_url('darkglass_theme', 'assets/js/darkglass-theme.js') . '"></script>';
        
        // Add animated background orbs
        echo '
        <div class="bg-orb bg-orb-1"></div>
        <div class="bg-orb bg-orb-2"></div>
        <div class="bg-orb bg-orb-3"></div>
        ';
    }
}

/**
 * Add custom body class
 */
hooks()->add_filter('body_class', 'darkglass_theme_body_class');

function darkglass_theme_body_class($classes)
{
    if (get_option('darkglass_theme_activated') == 1) {
        $classes .= ' darkglass-theme-active';
    }
    
    return $classes;
}
