# Dark Glass Theme for Perfex CRM

A modern dark theme with glassmorphism effects for Perfex CRM, featuring a sleek dark interface with transparent glass-like UI elements, animated backgrounds, and customizable colors.

## Features

- 🌙 **Dark Theme**: Professional dark color scheme with gradient backgrounds
- 🔮 **Glassmorphism Effects**: Modern glass-like UI elements with blur effects
- 🎨 **Customizable Colors**: Adjust primary, secondary, and accent colors
- ✨ **Animated Elements**: Floating background orbs and smooth transitions
- 💫 **Neon Glow Effects**: Eye-catching neon glows for important elements
- 🎯 **Interactive Hover Effects**: Dynamic mouse-follow effects on cards
- 📦 **Settings Management**: Import/export theme configurations
- 👁️ **Live Preview**: See changes in real-time before saving

## Installation

1. **Download the module**: Download the `darkglass_theme` folder
2. **Upload to Perfex**: Copy the folder to `modules/` directory in your Perfex CRM installation
3. **Activate**: Go to Setup → Modules and activate "Dark Glass Theme"
4. **Configure**: Navigate to the Dark Glass Theme settings to customize

## Module Structure

```
darkglass_theme/
├── assets/
│   ├── css/
│   │   ├── darkglass-theme.css      # Main theme styles
│   │   └── glassmorphism.css        # Glass effect styles
│   └── js/
│       └── darkglass-theme.js       # Interactive effects
├── controllers/
│   └── Darkglass_theme.php          # Settings controller
├── language/
│   └── english/
│       └── darkglass_theme_lang.php # Language strings
├── views/
│   └── settings.php                 # Settings page view
├── darkglass_theme.php              # Main module file
├── module.json                      # Module configuration
└── README.md                        # Documentation
```

## Configuration Options

### General Settings
- **Enable/Disable Theme**: Toggle the dark glass theme on/off
- **Animation Speed**: Choose from slow, normal, fast, or disabled
- **Background Orbs**: Enable/disable animated background elements
- **Floating Particles**: Add floating particle effects

### Color Customization
- **Primary Color**: Main theme color (default: #06b6d4)
- **Secondary Color**: Secondary theme color (default: #14b8a6)
- **Accent Color**: Used for warnings and highlights (default: #fb923c)

### Glass Effects
- **Blur Intensity**: Adjust backdrop blur from 0-40px
- **Glass Opacity**: Control transparency of glass elements
- **Border Opacity**: Adjust border visibility

## CSS Classes

The theme provides several utility classes for custom development:

### Glass Effects
```css
.glass-card          /* Basic glass card */
.frosted-glass       /* Heavy blur effect */
.glass-interactive   /* Interactive hover effects */
```

### Buttons
```css
.glass-btn           /* Glass style button */
.glass-neon          /* Neon glow effect */
.glass-neon-success  /* Green neon glow */
.glass-neon-warning  /* Orange neon glow */
.glass-neon-danger   /* Red neon glow */
```

### Form Elements
```css
.glass-input         /* Glass style input field */
.glass-select        /* Glass style select dropdown */
.glass-checkbox      /* Glass style checkbox */
.glass-radio         /* Glass style radio button */
```

### Animations
```css
.glass-fade-in       /* Fade in animation */
.glass-scale-in      /* Scale in animation */
.glass-slide-in      /* Slide in animation */
```

## Browser Compatibility

- Chrome 76+
- Firefox 72+
- Safari 12+
- Edge 79+

Note: The glassmorphism effects require browsers that support `backdrop-filter` CSS property.

## Customization

### Modifying Colors via CSS
You can override the theme colors by adding custom CSS:

```css
:root {
    --dg-primary: #06b6d4;
    --dg-secondary: #14b8a6;
    --dg-accent: #fb923c;
    --dg-dark-bg-1: #0a0e27;
    --dg-dark-bg-2: #1a1f3a;
    --dg-glass-bg: rgba(255, 255, 255, 0.04);
    --dg-glass-border: rgba(255, 255, 255, 0.08);
}
```

### Adding Custom Glass Elements
To apply glass effects to your custom elements:

```html
<div class="glass-card glass-fade-in">
    <h3>Your Content</h3>
    <p>This will have glass morphism effects</p>
</div>
```

### JavaScript API
The theme exposes some JavaScript functions:

```javascript
// Initialize theme on dynamic content
initDarkGlassTheme();

// Add entrance animations to new elements
addEntranceAnimations();

// Apply glass effects to elements
applyGlassToElements();
```

## Settings Import/Export

### Exporting Settings
1. Go to Dark Glass Theme settings
2. Click "Export Settings" button
3. Save the JSON file

### Importing Settings
1. Go to Dark Glass Theme settings
2. Click "Choose File" under Import Settings
3. Select your previously exported JSON file
4. Click "Import"

## Troubleshooting

### Theme Not Applying
- Ensure the module is activated in Setup → Modules
- Check that "Enable Dark Glass Theme" is checked in settings
- Clear browser cache and reload

### Blur Effects Not Working
- Check browser compatibility
- Some browsers need vendor prefixes for backdrop-filter
- Try adjusting blur intensity in settings

### Performance Issues
- Disable animations in settings
- Reduce blur intensity
- Disable background orbs and particles

## Support

For issues, questions, or feature requests, please create an issue on GitHub or contact support.

## License

MIT License - feel free to use and modify for your needs.

## Credits

- Glassmorphism effects inspired by modern UI design trends
- Built for Perfex CRM
- Uses CSS backdrop-filter for glass effects

## Changelog

### Version 1.0.0
- Initial release
- Dark theme implementation
- Glassmorphism effects
- Settings management
- Customizable colors
- Animated backgrounds
- Interactive effects
- Import/export functionality

---

Made with 🎨 for Perfex CRM