<?php
// Simple test to check if selectpicker is working in the module
defined('BASEPATH') or exit('No direct script access allowed');

// Include the dashboard view partially to test the dropdown
?>
<!DOCTYPE html>
<html>
<head>
    <title>Test Dropdown</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.14/css/bootstrap-select.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.14/js/bootstrap-select.min.js"></script>
</head>
<body>
    <div class="container" style="margin-top: 50px;">
        <h2>Test Staff Dropdown</h2>
        
        <div class="form-group">
            <label>Staff Filter Test:</label>
            <select id="test-staff-filter" class="form-control selectpicker" data-live-search="true" data-actions-box="true" multiple>
                <option value="1">John Doe</option>
                <option value="2">Jane Smith</option>
                <option value="3">Bob Johnson</option>
                <option value="4">Alice Wilson</option>
            </select>
        </div>
        
        <button id="test-btn" class="btn btn-primary">Test Selection</button>
        
        <div id="result" style="margin-top: 20px;"></div>
    </div>

    <script>
        $(document).ready(function() {
            console.log('Document ready');
            
            // Initialize selectpicker
            $('.selectpicker').selectpicker();
            console.log('Selectpicker initialized');
            
            // Test button click
            $('#test-btn').click(function() {
                var selected = $('#test-staff-filter').val();
                $('#result').html('<strong>Selected values:</strong> ' + JSON.stringify(selected));
                console.log('Selected:', selected);
            });
            
            // Test change event
            $('#test-staff-filter').on('changed.bs.select', function() {
                console.log('Selection changed');
            });
        });
    </script>
</body>
</html>
