<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="horizontal-scrollable-tabs panel-full-width-tabs">
    <div class="scroller arrow-left"><i class="fa fa-angle-left"></i></div>
    <div class="scroller arrow-right"><i class="fa fa-angle-right"></i></div>
    <div class="horizontal-tabs">
        <ul class="nav nav-tabs nav-tabs-horizontal" role="tablist">
            <li role="presentation" class="active">
                <a href="#misc" aria-controls="misc" role="tab" data-toggle="tab">
                    <i class="fa fa-cog"></i> <?php echo _l('settings_group_misc'); ?></a>
            </li>
            <li role="presentation">
                <a href="#settings_tables" aria-controls="settings_tables" role="tab" data-toggle="tab">
                    <i class="fa fa-table"></i> <?php echo _l('tables'); ?></a>
            </li>
            <li role="presentation">
                <a href="#inline_create" aria-controls="inline_create" role="tab" data-toggle="tab">
                    <i class="fa fa-plus"></i> <?php echo _l('inline_create'); ?>
                </a>
            </li>
        </ul>
    </div>

</div>
<div class="tab-content mtop15">
    <div role="tabpanel" class="tab-pane active" id="misc">
        <?php echo render_yes_no_option('view_contract_only_logged_in', 'settings_require_client_logged_in_to_view_contract'); ?>
        <hr />
        <?php echo render_input('settings[dropbox_app_key]', 'dropbox_app_key', get_option('dropbox_app_key')); ?>
        <hr />
        <?php echo render_input('settings[media_max_file_size_upload]', 'settings_media_max_file_size_upload', get_option('media_max_file_size_upload'), 'number'); ?>
        <hr />
        <i class="fa-regular fa-circle-question pull-left tw-mt-0.5 tw-mr-1" data-toggle="tooltip"
            data-title="<?php echo _l('settings_group_newsfeed'); ?>"></i>
        <?php echo render_input('settings[newsfeed_maximum_files_upload]', 'settings_newsfeed_max_file_upload_post', get_option('newsfeed_maximum_files_upload'), 'number'); ?>
        <hr />

        <?php echo render_input('settings[limit_top_search_bar_results_to]', 'settings_limit_top_search_bar_results', get_option('limit_top_search_bar_results_to'), 'number'); ?>
        <hr />
        <?php echo render_select('settings[default_staff_role]', $roles, ['roleid', 'name'], 'settings_general_default_staff_role', get_option('default_staff_role'), [], ['data-toggle' => 'tooltip', 'title' => 'settings_general_default_staff_role_tooltip']); ?>
        <hr />
        <?php echo render_input('settings[delete_activity_log_older_then]', 'delete_activity_log_older_then', get_option('delete_activity_log_older_then'), 'number'); ?>
        <hr />
        <?php echo render_yes_no_option('show_setup_menu_item_only_on_hover', 'show_setup_menu_item_only_on_hover'); ?>


        <hr />
        <?php echo render_yes_no_option('show_help_on_setup_menu', 'show_help_on_setup_menu'); ?>
        <hr />
        <?php render_yes_no_option('use_minified_files', 'use_minified_files'); ?>
        
        <hr />
        <h4 class="tw-mt-4 tw-mb-2">
            <i class="fa fa-bell tw-mr-2"></i>
            <?php echo _l('reminder_notification_settings', 'Reminder Notifications'); ?>
        </h4>
        
        <?php echo render_yes_no_option('reminder_notifications_enabled', 'reminder_notifications_enabled'); ?>
        
        <hr />
        
        <div class="form-group">
            <label for="reminder_notification_sound" class="control-label">
                <i class="fa fa-volume-up tw-mr-1"></i>
                <?php echo _l('reminder_notification_sound', 'Notification Sound'); ?>
            </label>
            <select name="settings[reminder_notification_sound]" id="reminder_notification_sound" class="form-control selectpicker" data-live-search="true">
                <option value="gentle" <?php if (get_option('reminder_notification_sound') == 'gentle') { echo 'selected'; } ?>>
                    <?php echo _l('reminder_sound_gentle', 'Gentle Chime'); ?>
                </option>
                <option value="standard" <?php if (get_option('reminder_notification_sound') == 'standard' || !get_option('reminder_notification_sound')) { echo 'selected'; } ?>>
                    <?php echo _l('reminder_sound_standard', 'Standard Beep'); ?>
                </option>
                <option value="urgent" <?php if (get_option('reminder_notification_sound') == 'urgent') { echo 'selected'; } ?>>
                    <?php echo _l('reminder_sound_urgent', 'Urgent Alert'); ?>
                </option>
                <option value="bell" <?php if (get_option('reminder_notification_sound') == 'bell') { echo 'selected'; } ?>>
                    <?php echo _l('reminder_sound_bell', 'Bell Ring'); ?>
                </option>
                <option value="ding" <?php if (get_option('reminder_notification_sound') == 'ding') { echo 'selected'; } ?>>
                    <?php echo _l('reminder_sound_ding', 'Ding Dong'); ?>
                </option>                <option value="none" <?php if (get_option('reminder_notification_sound') == 'none') { echo 'selected'; } ?>>
                    <?php echo _l('reminder_sound_none', 'No Sound'); ?>
                </option>
                <option value="custom" <?php if (get_option('reminder_notification_sound') == 'custom') { echo 'selected'; } ?>>
                    <?php echo _l('reminder_sound_custom', 'Custom Sound'); ?>
                </option>
            </select>
            <small class="help-block">
                <?php echo _l('reminder_notification_sound_help', 'Choose the sound played when reminder notifications appear. Users can still toggle sound on/off individually.'); ?>
            </small>
        </div>
          <div class="form-group" id="custom-sound-upload" style="<?php echo (get_option('reminder_notification_sound') == 'custom') ? '' : 'display: none;'; ?>">
            <label for="custom_reminder_sound" class="control-label">
                <i class="fa fa-upload tw-mr-1"></i>
                <?php echo _l('reminder_notification_sound_custom', 'Custom Sound File'); ?>
            </label>
            <div class="input-group">
                <input type="file" name="custom_reminder_sound" id="custom_reminder_sound" 
                       class="form-control" accept="audio/mp3,audio/wav,audio/ogg,audio/mp4,audio/aac" 
                       data-toggle="tooltip" title="<?php echo _l('custom_sound_upload_info', 'Upload MP3, WAV, or OGG audio files. Maximum size: 2MB'); ?>">
                <span class="input-group-btn">
                    <button type="button" class="btn btn-primary" id="upload-custom-sound" 
                            data-toggle="tooltip" title="<?php echo _l('upload_custom_sound', 'Upload Custom Sound'); ?>">
                        <i class="fa fa-upload"></i>
                    </button>
                    <?php if (get_option('custom_reminder_sound_file') && file_exists(FCPATH . 'uploads/custom_sounds/' . get_option('custom_reminder_sound_file'))): ?>
                        <button type="button" class="btn btn-danger" id="delete-custom-sound" 
                                data-toggle="tooltip" title="<?php echo _l('delete_custom_sound', 'Delete Custom Sound'); ?>">
                            <i class="fa fa-trash"></i>
                        </button>
                        <button type="button" class="btn btn-success" id="test-custom-sound"
                                data-toggle="tooltip" title="Test Custom Sound">
                            <i class="fa fa-play"></i>
                        </button>
                    <?php endif; ?>
                </span>
            </div>
            <?php if (get_option('custom_reminder_sound_file')): ?>
                <small class="help-block text-success">
                    <i class="fa fa-check"></i> 
                    Current custom sound: 
                    <strong><?php echo get_option('custom_reminder_sound_file'); ?></strong>
                </small>
            <?php else: ?>
                <small class="help-block">
                    <?php echo _l('custom_sound_upload_info', 'Upload MP3, WAV, or OGG audio files. Maximum size: 2MB. Recommended duration: 1-3 seconds.'); ?>
                </small>
            <?php endif; ?>
        </div>
        
        <div class="form-group">
            <label for="reminder_check_frequency" class="control-label">
                <i class="fa fa-clock-o tw-mr-1"></i>
                <?php echo _l('reminder_check_frequency', 'Check Frequency'); ?>
            </label>
            <select name="settings[reminder_check_frequency]" id="reminder_check_frequency" class="form-control selectpicker">
                <option value="30" <?php if (get_option('reminder_check_frequency') == '30') { echo 'selected'; } ?>>
                    <?php echo _l('reminder_frequency_30s', '30 seconds'); ?>
                </option>
                <option value="60" <?php if (get_option('reminder_check_frequency') == '60' || !get_option('reminder_check_frequency')) { echo 'selected'; } ?>>
                    <?php echo _l('reminder_frequency_60s', '1 minute'); ?>
                </option>
                <option value="120" <?php if (get_option('reminder_check_frequency') == '120') { echo 'selected'; } ?>>
                    <?php echo _l('reminder_frequency_2m', '2 minutes'); ?>
                </option>
                <option value="300" <?php if (get_option('reminder_check_frequency') == '300') { echo 'selected'; } ?>>
                    <?php echo _l('reminder_frequency_5m', '5 minutes'); ?>
                </option>
            </select>
            <small class="help-block">
                <?php echo _l('reminder_check_frequency_help', 'How often the system checks for due reminders. More frequent checks provide better responsiveness but use more resources.'); ?>
            </small>
        </div>
          <div class="form-group">
            <button type="button" class="btn btn-info btn-sm" id="test-reminder-sound">
                <i class="fa fa-play"></i>
                <?php echo _l('test_reminder_sound', 'Test Selected Sound'); ?>
            </button>
        </div>        <script>
        $(document).ready(function() {
            // Show/hide custom sound upload based on dropdown selection
            $('#reminder_notification_sound').on('change', function() {
                if ($(this).val() === 'custom') {
                    $('#custom-sound-upload').show();
                } else {
                    $('#custom-sound-upload').hide();
                }
            });

            // Test selected sound functionality
            $('#test-reminder-sound').on('click', function() {
                var soundType = $('#reminder_notification_sound').val();
                
                // Load sound script if not already loaded
                if (typeof playReminderSoundByType === 'undefined') {
                    var script = document.createElement('script');
                    script.src = '<?php echo base_url('assets/audio/reminder-sound.js'); ?>';
                    script.onload = function() {
                        playTestSound(soundType);
                    };
                    document.head.appendChild(script);
                } else {
                    playTestSound(soundType);
                }
            });

            // Test custom sound functionality
            $('#test-custom-sound').on('click', function() {
                var customSoundFile = '<?php echo get_option('custom_reminder_sound_file'); ?>';
                if (customSoundFile) {
                    var audio = new Audio('<?php echo base_url('uploads/custom_sounds/'); ?>' + customSoundFile);
                    audio.volume = 0.3;
                    audio.play().catch(function(error) {
                        alert('Error playing custom sound: ' + error.message);
                    });
                }
            });

            // Upload custom sound functionality
            $('#upload-custom-sound').on('click', function() {
                var fileInput = $('#custom_reminder_sound')[0];
                var file = fileInput.files[0];
                
                if (!file) {
                    alert('<?php echo _l('please_select_sound_file', 'Please select a sound file first'); ?>');
                    return;
                }                // Validate file type
                var allowedTypes = ['audio/mpeg', 'audio/wav', 'audio/ogg', 'audio/mp4', 'audio/aac'];
                var allowedExtensions = ['.mp3', '.wav', '.ogg', '.m4a', '.aac'];
                var fileExtension = file.name.toLowerCase().substring(file.name.lastIndexOf('.'));
                
                if (allowedTypes.indexOf(file.type) === -1 && allowedExtensions.indexOf(fileExtension) === -1) {
                    alert('<?php echo _l('invalid_sound_file_type', 'Please select a valid audio file (MP3, WAV, OGG, M4A, or AAC)'); ?>');
                    fileInput.value = '';
                    return;
                }
                
                // Additional validation for common audio issues
                if (file.size === 0) {
                    alert('The selected file appears to be empty. Please choose a valid audio file.');
                    fileInput.value = '';
                    return;
                }

                // Validate file size (2MB max)
                if (file.size > 2 * 1024 * 1024) {
                    alert('<?php echo _l('sound_file_too_large', 'File size must be less than 2MB'); ?>');
                    fileInput.value = '';
                    return;
                }

                // Show loading state
                var $btn = $(this);
                var originalText = $btn.html();
                $btn.html('<i class="fa fa-spinner fa-spin"></i> Uploading...').prop('disabled', true);

                // Upload file via AJAX
                var formData = new FormData();
                formData.append('custom_sound', file);
                formData.append('<?php echo $this->security->get_csrf_token_name(); ?>', '<?php echo $this->security->get_csrf_hash(); ?>');

                $.ajax({
                    url: '<?php echo admin_url('settings/upload_custom_reminder_sound'); ?>',
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        if (response.success) {
                            alert('<?php echo _l('custom_sound_uploaded_successfully', 'Custom sound uploaded successfully!'); ?>');
                            location.reload();
                        } else {
                            alert('Upload failed: ' + (response.message || 'Unknown error'));
                        }
                    },
                    error: function() {
                        alert('<?php echo _l('custom_sound_upload_failed', 'Failed to upload custom sound file'); ?>');
                    },
                    complete: function() {
                        $btn.html(originalText).prop('disabled', false);
                    }
                });
            });

            // Delete custom sound functionality
            $('#delete-custom-sound').on('click', function() {
                if (confirm('Are you sure you want to delete the custom sound file?')) {
                    var $btn = $(this);
                    var originalText = $btn.html();
                    $btn.html('<i class="fa fa-spinner fa-spin"></i>').prop('disabled', true);

                    $.post('<?php echo admin_url('settings/delete_custom_reminder_sound'); ?>', {
                        '<?php echo $this->security->get_csrf_token_name(); ?>': '<?php echo $this->security->get_csrf_hash(); ?>'
                    }).done(function(response) {
                        if (response.success) {
                            alert('<?php echo _l('custom_sound_deleted_successfully', 'Custom sound deleted successfully!'); ?>');
                            location.reload();
                        } else {
                            alert('Delete failed: ' + (response.message || 'Unknown error'));
                        }
                    }).fail(function() {
                        alert('<?php echo _l('custom_sound_delete_failed', 'Failed to delete custom sound file'); ?>');
                    }).always(function() {
                        $btn.html(originalText).prop('disabled', false);
                    });
                }
            });            function playTestSound(soundType) {
                if (typeof playReminderSoundByType === 'function') {
                    playReminderSoundByType(soundType);
                } else {
                    alert('Sound system not loaded');
                }
            }
        });
        </script>
        
        <?php hooks()->do_action('after_misc_settings'); ?>
    </div>

    <div role="tabpanel" class="tab-pane" id="settings_tables">
        <div class="form-group">
            <label for="save_last_order_for_tables" class="control-label clearfix">
                <i class="fa-regular fa-circle-question pointer" data-toggle="popover" data-html="true"
                    data-content="Currently supported tables: Customers, Leads, Tickets, Tasks, Projects, Payments, Subscriptions, Expenses, Proposals, Knowledge Base, Contracts <br /><br /> Note: Changing this option will delete all saved table orders!"
                    data-position="top"></i> <?php echo _l('save_last_order_for_tables'); ?>
            </label>
            <div class="radio radio-primary radio-inline">
                <input type="radio" id="y_opt_1_save_last_order_for_tables" name="settings[save_last_order_for_tables]"
                    value="1" <?php if (get_option('save_last_order_for_tables') == '1') {
    echo ' checked';
} ?>>
                <label for="y_opt_1_save_last_order_for_tables">
                    <?php echo _l('settings_yes'); ?>
                </label>
            </div>
            <div class="radio radio-primary radio-inline">
                <input type="radio" id="y_opt_2_save_last_order_for_tables" name="settings[save_last_order_for_tables]"
                    value="0" <?php if (get_option('save_last_order_for_tables') == '0') {
    echo ' checked';
} ?>>
                <label for="y_opt_2_save_last_order_for_tables">
                    <?php echo _l('settings_no'); ?>
                </label>
            </div>
        </div>
        <hr />

        <div class="form-group">
            <label><?php echo _l('show_table_export_button'); ?></label><br />
            <div class="radio radio-primary">
                <input type="radio" id="stbxb_all" name="settings[show_table_export_button]" value="to_all" <?php if (get_option('show_table_export_button') == 'to_all') {
    echo ' checked';
} ?>>
                <label for="stbxb_all"><?php echo _l('show_table_export_all'); ?></label>
            </div>

            <div class="radio radio-primary">
                <input type="radio" id="stbxb_admins" name="settings[show_table_export_button]" value="only_admins" <?php if (get_option('show_table_export_button') == 'only_admins') {
    echo ' checked';
} ?>>
                <label for="stbxb_admins"><?php echo _l('show_table_export_admins'); ?></label>

            </div>
            <div class="radio radio-primary">
                <input type="radio" id="stbxb_hide" name="settings[show_table_export_button]" value="hide" <?php if (get_option('show_table_export_button') == 'hide') {
    echo ' checked';
} ?>>
                <label for="stbxb_hide"><?php echo _l('show_table_export_hide'); ?></label>
            </div>
        </div>
        <hr />
        <?php echo render_input('settings[tables_pagination_limit]', 'settings_general_tables_limit', get_option('tables_pagination_limit'), 'number'); ?>
        <hr />
    </div>
    <div role="tabpanel" class="tab-pane" id="inline_create">
        <?php echo render_yes_no_option('staff_members_create_inline_lead_status', _l('inline_create_option', [
        '<b>' . _l('lead_status') . '</b>',
        '<b>' . _l('lead') . '</b>',
      ])); ?>
        <hr />
        <?php echo render_yes_no_option('staff_members_create_inline_lead_source', _l('inline_create_option', [
        '<b>' . _l('lead_source') . '</b>',
        '<b>' . _l('lead') . '</b>',
      ])); ?>
        <hr />
        <?php echo render_yes_no_option('staff_members_create_inline_customer_groups', _l('inline_create_option', [
        '<b>' . _l('customer_group') . '</b>',
        '<b>' . _l('client') . '</b>',
      ])); ?>
        <hr />
        <?php if (get_option('services') == 1) { ?>
        <?php echo render_yes_no_option('staff_members_create_inline_ticket_services', _l('inline_create_option', [
        '<b>' . _l('service') . '</b>',
        '<b>' . _l('ticket') . '</b>',
      ])); ?>
        <hr />
        <?php } ?>
        <?php echo render_yes_no_option('staff_members_save_tickets_predefined_replies', _l('inline_create_option_predefined_replies')); ?>
        <hr />
        <?php echo render_yes_no_option('staff_members_create_inline_contract_types', _l('inline_create_option', [
      '<b>' . _l('contract_type') . '</b>',
      '<b>' . _l('contract') . '</b>',
    ])); ?>
        <hr />
        <?php echo render_yes_no_option('staff_members_create_inline_expense_categories', _l('inline_create_option', [
      '<b>' . _l('expense_category') . '</b>',
      '<b>' . _l('expense') . '</b>',
    ])); ?>
    </div>
