<?php

defined('BASEPATH') or exit('No direct script access allowed');

$dimensions = $pdf->getPageDimensions();

// Header with company logo and info - Compact version
$html = '<div style="text-align: center; background-color: #3498db; color: white; padding: 8px; margin-bottom: 12px;">';

// Add company logo at the top - with error suppression for PNG warnings
$logo_html = '';
try {
    // Check if GD or Imagick extension is available for PNG handling
    if (extension_loaded('gd') || extension_loaded('imagick')) {
        // Suppress PNG warnings to prevent PDF generation issues
        $old_error_reporting = error_reporting(E_ALL & ~E_WARNING);
        $logo_html = pdf_logo_url();
        error_reporting($old_error_reporting);
    } else {
        // Skip logo if no image processing extensions available
        error_log('PDF Logo skipped: GD or Imagick extension required for PNG images');
    }
} catch (Exception $e) {
    // If logo fails, continue without it
    error_log('PDF Logo Error: ' . $e->getMessage());
}

if (!empty($logo_html)) {
    // Modify logo style for PDF header - smaller and more compact
    $logo_html = str_replace('<img width="', '<img style="margin-bottom: 5px;" width="', $logo_html);
    // Reduce logo size for compact header
    $logo_html = str_replace('width="120"', 'width="80"', $logo_html);
    $html .= $logo_html;
    $html .= '<br>';
}

$html .= '<h1 style="margin: 0; font-size: 18px; font-weight: bold;"> Staff Activity Report</h1>';
$html .= '<h3 style="margin: 2px 0; font-size: 12px;">' . get_option('companyname') . '</h3>';
$html .= '<p style="margin: 2px 0; font-size: 9px;">Generated on ' . date('F j, Y \a\t g:i A') . '</p>';
$html .= '</div>';

// Report Period - More compact
$dateFrom = isset($filters['from']) ? $filters['from'] : date('Y-m-01');
$dateTo = isset($filters['to']) ? $filters['to'] : date('Y-m-d');
$html .= '<div style="background-color: #ecf0f1; padding: 6px; margin-bottom: 10px; text-align: center;">';
$html .= '<p style="margin: 0; font-size: 11px; font-weight: bold; color: #2c3e50;"> Report Period: ' . date('M j, Y', strtotime($dateFrom)) . ' to ' . date('M j, Y', strtotime($dateTo)) . '</p>';
$html .= '</div>';

// Debug: Log filters to see what's being passed
error_log('PDF Template Debug: Filters received: ' . print_r($filters, true));

// Staff-specific heading if single staff is selected
// Initialize staff name variable for use throughout template
$selected_staff_name = '';
$is_single_staff = false;

if (isset($filters['staff']) && !empty($filters['staff'])) {
    // Convert to array if it's a single value
    $staff_array = is_array($filters['staff']) ? $filters['staff'] : [$filters['staff']];
    
    if (count($staff_array) == 1) {
        $is_single_staff = true;
    $CI = &get_instance();
        $staff_id = $staff_array[0];
    
    // Get staff information
    error_log('PDF Template Debug: Looking up staff ID: ' . $staff_id);
    $CI->db->select('firstname, lastname, email');
    $CI->db->from(db_prefix() . 'staff');
    $CI->db->where('staffid', $staff_id);
    $staff_query = $CI->db->get();
    
    error_log('PDF Template Debug: Staff query result count: ' . $staff_query->num_rows());
    
    if ($staff_query->num_rows() > 0) {
        $staff_info = $staff_query->row();
        $staff_name = trim($staff_info->firstname . ' ' . $staff_info->lastname);
        $staff_email = $staff_info->email;
        
        error_log('PDF Template Debug: Staff name found: ' . $staff_name);
        
        // Store staff name for use in template
        $selected_staff_name = $staff_name;
        
        // Staff-specific heading with name prominently displayed
        $html .= '<div style="background-color: #c0392b; color: white; padding: 12px; margin-bottom: 15px; text-align: center;">';
        $html .= '<div style="font-size: 11px; font-weight: bold; letter-spacing: 1px; margin-bottom: 5px;">STAFF REPORT</div>';
        $html .= '<div style="font-size: 18px; font-weight: bold;">' . e($staff_name) . '</div>';
        if (!empty($staff_email)) {
            $html .= '<div style="margin: 5px 0 0 0; font-size: 10px;">' . e($staff_email) . '</div>';
        }
        $html .= '</div>';
    } else {
        error_log('PDF Template Debug: Staff query returned no results for ID: ' . $staff_id);
    }
    }
} 

// Multiple staff selected - show team report heading
if (isset($filters['staff']) && is_array($filters['staff']) && count($filters['staff']) > 1) {
    // Multiple staff selected - show team report heading
    $staff_count = count($filters['staff']);
    $html .= '<div style="background-color: #e67e22; color: white; padding: 12px; margin-bottom: 15px; text-align: center;">';
    $html .= '<div style="font-size: 11px; font-weight: bold; letter-spacing: 1px; margin-bottom: 5px;">TEAM REPORT</div>';
    $html .= '<div style="font-size: 18px; font-weight: bold;">' . $staff_count . ' Staff Members</div>';
    $html .= '<div style="margin: 5px 0 0 0; font-size: 10px;">Combined activity report</div>';
    $html .= '</div>';
}

$pdf->writeHTML($html, true, false, false, false, '');

// KPI Summary Section
$html = '<h2 style="color: #2c3e50; border-bottom: 2px solid #3498db; padding-bottom: 5px; margin-bottom: 15px; font-size: 16px;"> Key Performance Indicators</h2>';

$html .= '<table style="width: 100%; border-collapse: collapse; margin-bottom: 15px; border: 1px solid #3498db;" cellpadding="10">';
$html .= '<thead>';
$html .= '<tr style="background-color: #3498db; color: white;">';
$html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">Today\'s Activities</th>';
$html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">This Week</th>';
$html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">This Month</th>';
$html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">Today\'s Logins</th>';
$html .= '</tr>';
$html .= '</thead>';
$html .= '<tbody>';
$html .= '<tr style="background-color: #ffffff;">';
$html .= '<td style="text-align: center; font-size: 14px; font-weight: bold; color: #27ae60; padding: 15px;">' . (int)$kpis['today'] . '</td>';
$html .= '<td style="text-align: center; font-size: 14px; font-weight: bold; color: #3498db; padding: 15px;">' . (int)$kpis['week'] . '</td>';
$html .= '<td style="text-align: center; font-size: 14px; font-weight: bold; color: #9b59b6; padding: 15px;">' . (int)$kpis['month'] . '</td>';
$html .= '<td style="text-align: center; font-size: 14px; font-weight: bold; color: #f39c12; padding: 15px;">' . (int)$kpis['logins_today'] . '</td>';
$html .= '</tr>';
$html .= '</tbody>';
$html .= '</table>';

$pdf->writeHTML($html, true, false, false, false, '');

// Top Active Staff Section
if (!empty($kpis['top_staff'])) {
    $html = '<h2 style="color: #2c3e50; border-bottom: 2px solid #f39c12; padding-bottom: 5px; margin-bottom: 15px; font-size: 16px;"> Top Active Staff</h2>';
    
    $html .= '<table style="width: 100%; border-collapse: collapse; margin-bottom: 15px; border: 1px solid #f39c12;" cellpadding="8">';
    $html .= '<thead>';
    $html .= '<tr style="background-color: #f39c12; color: white;">';
    $html .= '<th style="text-align: left; font-size: 12px; padding: 10px;">Staff Member</th>';
    $html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">Total Activities</th>';
    $html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">Activity Score</th>';
    $html .= '</tr>';
    $html .= '</thead>';
    $html .= '<tbody>';
    
    $rank = 1;
    foreach (array_slice($kpis['top_staff'], 0, 5) as $staff) { // Top 5 staff
        $score = min(100, ($staff['total'] / max(1, $kpis['month'])) * 100); // Calculate percentage score
        
        $html .= '<tr style="background-color: ' . ($rank % 2 == 0 ? '#f9f9f9' : '#ffffff') . ';">';
        $html .= '<td style="font-size: 11px; font-weight: bold; padding: 8px;">#' . $rank . ' ' . e($staff['staff_name']) . '</td>';
        $html .= '<td style="text-align: center; font-size: 11px; color: #3498db; font-weight: bold; padding: 8px;">' . (int)$staff['total'] . '</td>';
        $html .= '<td style="text-align: center; font-size: 11px; color: #27ae60; font-weight: bold; padding: 8px;">' . number_format($score, 1) . '%</td>';
        $html .= '</tr>';
        $rank++;
    }
    
    $html .= '</tbody>';
    $html .= '</table>';
    
    $pdf->writeHTML($html, true, false, false, false, '');
}

// Activity Summary by Type
if (!empty($activity_types['chart_data']['labels'])) {
    $html = '<h2 style="color: #2c3e50; border-bottom: 2px solid #9b59b6; padding-bottom: 5px; margin-bottom: 15px; font-size: 16px;"> Activity Distribution</h2>';
    
    $html .= '<table style="width: 100%; border-collapse: collapse; margin-bottom: 15px; border: 1px solid #9b59b6;" cellpadding="8">';
    $html .= '<thead>';
    $html .= '<tr style="background-color: #9b59b6; color: white;">';
    $html .= '<th style="text-align: left; font-size: 12px; padding: 10px;">Activity Type</th>';
    $html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">Count</th>';
    $html .= '<th style="text-align: center; font-size: 12px; padding: 10px;">Percentage</th>';
    $html .= '</tr>';
    $html .= '</thead>';
    $html .= '<tbody>';
    
    $total_activities = array_sum($activity_types['chart_data']['datasets'][0]['data']);
    
    for ($i = 0; $i < count($activity_types['chart_data']['labels']); $i++) {
        $count = $activity_types['chart_data']['datasets'][0]['data'][$i];
        $percentage = $total_activities > 0 ? ($count / $total_activities) * 100 : 0;
        
        $html .= '<tr style="background-color: ' . ($i % 2 == 0 ? '#f9f9f9' : '#ffffff') . ';">';
        $html .= '<td style="font-size: 11px; font-weight: bold; padding: 8px;">' . e($activity_types['chart_data']['labels'][$i]) . '</td>';
        $html .= '<td style="text-align: center; font-size: 11px; color: #9b59b6; font-weight: bold; padding: 8px;">' . (int)$count . '</td>';
        $html .= '<td style="text-align: center; font-size: 11px; color: #27ae60; font-weight: bold; padding: 8px;">' . number_format($percentage, 1) . '%</td>';
        $html .= '</tr>';
    }
    
    $html .= '</tbody>';
    $html .= '</table>';
    
    $pdf->writeHTML($html, true, false, false, false, '');
}

// Follow-up Types by Staff Section
if (!empty($followup_types['by_staff'])) {
    $html = '<h2 style="color: #2c3e50; border-bottom: 2px solid #1abc9c; padding-bottom: 5px; margin-bottom: 15px; font-size: 16px;"> Follow-up Types by Staff</h2>';
    
    // Normalize dataset to associative arrays keyed by follow-up type
    $normalizedFollowupData = [];
    foreach ($followup_types['by_staff'] as $staffName => $followupData) {
        $normalized = [];
        if (is_array($followupData)) {
            $needsConversion = !empty($followupData) && isset($followupData[0]) && is_array($followupData[0]) && array_key_exists('followup_type', $followupData[0]);
            if ($needsConversion) {
                foreach ($followupData as $item) {
                    $typeName = isset($item['followup_type']) ? $item['followup_type'] : 'General';
                    $count = isset($item['count']) ? (int)$item['count'] : 0;
                    if (!isset($normalized[$typeName])) {
                        $normalized[$typeName] = 0;
                    }
                    $normalized[$typeName] += $count;
                }
            } else {
                foreach ($followupData as $typeName => $count) {
                    $normalized[$typeName] = (int)$count;
                }
            }
        }
        $normalizedFollowupData[$staffName] = $normalized;
    }
    
    // Ensure we have all types available - get from normalized data
    $allTypes = [];
    foreach ($normalizedFollowupData as $followupData) {
        if (is_array($followupData)) {
            $allTypes = array_merge($allTypes, array_keys($followupData));
        }
    }
    $allTypes = array_unique($allTypes);
    
    // If no types found in data, use fallback
    if (empty($allTypes)) {
        $allTypes = ['Message', 'Phone Call', 'WhatsApp Call', 'WhatsApp Message', 'Reminder Created', 'Follow-up Added'];
    }
    
    $html .= '<table style="width: 100%; border-collapse: collapse; margin-bottom: 20px; border: 1px solid #1abc9c;" cellpadding="8" cellspacing="0">';
    
    // Header row
    $html .= '<thead>';
    $html .= '<tr style="background-color: #1abc9c; color: white;">';
    $html .= '<th style="text-align: left; font-size: 12px; font-weight: bold; padding: 10px; border: 1px solid #16a085;">Staff Member</th>';
    
    // Add column headers for each follow-up type
    foreach ($allTypes as $type) {
        $displayType = $type;
        $displayType = str_replace(['_', '-'], ' ', $displayType);
        $displayType = ucwords(strtolower($displayType));
        
        $html .= '<th style="text-align: center; font-size: 10px; font-weight: bold; padding: 8px 4px; border: 1px solid #16a085; max-width: 60px;">' . e($displayType) . '</th>';
    }
    $html .= '<th style="text-align: center; font-size: 10px; font-weight: bold; padding: 8px; border: 1px solid #16a085; background-color: #d4edda;">New Calls</th>';
    $html .= '<th style="text-align: center; font-size: 10px; font-weight: bold; padding: 8px; border: 1px solid #16a085; background-color: #d1ecf1;">Follow-up Calls</th>';
    $html .= '<th style="text-align: center; font-size: 12px; font-weight: bold; padding: 10px; border: 1px solid #16a085;">Call Connect</th>';
    $html .= '<th style="text-align: center; font-size: 12px; font-weight: bold; background-color: #16a085; padding: 10px; border: 1px solid #16a085;">TOTAL</th>';
    $html .= '</tr>';
    $html .= '</thead>';
    
    // Body rows
    $html .= '<tbody>';
    $row_count = 0;
    $columnTotals = array_fill(0, count($allTypes), 0);
    $grandTotal = 0;
    $totalNewCalls = 0;
    $totalFollowupCalls = 0;
    
    $pdfCallStats = isset($followup_types['call_connected']) && is_array($followup_types['call_connected'])
        ? $followup_types['call_connected']
        : [];
    
    $newCallsByStaff = isset($followup_types['new_calls_by_staff']) && is_array($followup_types['new_calls_by_staff'])
        ? $followup_types['new_calls_by_staff']
        : [];
    
    $followupCallsByStaff = isset($followup_types['followup_calls_by_staff']) && is_array($followup_types['followup_calls_by_staff'])
        ? $followup_types['followup_calls_by_staff']
        : [];
    
    foreach ($normalizedFollowupData as $staffName => $followupData) {
        $row_count++;
        $rowTotal = 0;
        
        // Calculate row total
        foreach ($allTypes as $type) {
            $rowTotal += isset($followupData[$type]) ? $followupData[$type] : 0;
        }
        
        $html .= '<tr style="background-color: ' . ($row_count % 2 == 0 ? '#f9f9f9' : '#ffffff') . ';">';
        $html .= '<td style="font-size: 11px; font-weight: bold; color: #2c3e50; padding: 8px; border: 1px solid #ddd;">' . e($staffName) . '</td>';
        
        // Add data for each follow-up type
        $colIndex = 0;
        foreach ($allTypes as $type) {
            $count = isset($followupData[$type]) ? $followupData[$type] : 0;
            $columnTotals[$colIndex] += $count;
            
            if ($count > 0) {
                $html .= '<td style="text-align: center; padding: 6px; border: 1px solid #ddd; background-color: #e8f5e8; color: #27ae60; font-weight: bold; font-size: 10px;">' . $count . '</td>';
            } else {
                $html .= '<td style="text-align: center; padding: 6px; border: 1px solid #ddd; color: #999; font-size: 10px;">0</td>';
            }
            $colIndex++;
        }
        
        // Add new calls column
        $newCalls = isset($newCallsByStaff[$staffName]) ? (int)$newCallsByStaff[$staffName] : 0;
        $totalNewCalls += $newCalls;
        $html .= '<td style="text-align: center; padding: 6px; border: 1px solid #ddd; background-color: #d4edda; color: #28a745; font-weight: bold; font-size: 10px;">' . $newCalls . '</td>';
        
        // Add followup calls column
        $followupCalls = isset($followupCallsByStaff[$staffName]) ? (int)$followupCallsByStaff[$staffName] : 0;
        $totalFollowupCalls += $followupCalls;
        $html .= '<td style="text-align: center; padding: 6px; border: 1px solid #ddd; background-color: #d1ecf1; color: #17a2b8; font-weight: bold; font-size: 10px;">' . $followupCalls . '</td>';
        
        // Add total column
        $staffCallStats = $pdfCallStats[$staffName] ?? null;
        $callConnectCell = '—';
        if ($staffCallStats && !empty($staffCallStats['logged'])) {
            $callConnectCell = (int)$staffCallStats['connected'] . '/' . (int)$staffCallStats['logged'] .
                ' (' . number_format((float)($staffCallStats['connect_rate'] ?? 0), 1) . '%)';
        }
        $html .= '<td style="text-align: center; padding: 6px; border: 1px solid #ddd; color: #2c3e50; font-size: 10px;">' . e($callConnectCell) . '</td>';
        $html .= '<td style="text-align: center; padding: 6px; border: 1px solid #ddd; background-color: #3498db; color: white; font-weight: bold; font-size: 11px;">' . $rowTotal . '</td>';
        $html .= '</tr>';
        
        $grandTotal += $rowTotal;
    }
    
    // Add totals row
    $html .= '<tr style="background-color: #34495e; color: white; font-weight: bold;">';
    $html .= '<td style="font-size: 11px; font-weight: bold; padding: 8px; border: 1px solid #2c3e50;">TOTALS</td>';
    
    foreach ($columnTotals as $total) {
        $html .= '<td style="text-align: center; padding: 6px; border: 1px solid #2c3e50; font-size: 10px;">' . $total . '</td>';
    }
    
    // Add new calls total column
    $html .= '<td style="text-align: center; padding: 8px; border: 1px solid #2c3e50; background-color: #d4edda; color: #28a745; font-weight: bold; font-size: 11px;">' . $totalNewCalls . '</td>';
    
    // Add followup calls total column
    $html .= '<td style="text-align: center; padding: 8px; border: 1px solid #2c3e50; background-color: #d1ecf1; color: #17a2b8; font-weight: bold; font-size: 11px;">' . $totalFollowupCalls . '</td>';
    
    $callSummary = '—';
    if (!empty($followup_types['call_connected_totals']['logged'])) {
        $totals = $followup_types['call_connected_totals'];
        $callSummary = (int)($totals['connected'] ?? 0) . '/' . (int)($totals['logged'] ?? 0) .
            ' (' . number_format((float)($totals['connect_rate'] ?? 0), 1) . '%)';
    }
    $html .= '<td style="text-align: center; padding: 6px; border: 1px solid #2c3e50; font-size: 10px;">' . e($callSummary) . '</td>';
    $html .= '<td style="text-align: center; padding: 6px; border: 1px solid #2c3e50; background-color: #e74c3c; font-size: 11px;">' . $grandTotal . '</td>';
    $html .= '</tr>';
    
    $html .= '</tbody>';
    $html .= '</table>';
    
    // Add summary statistics
    $html .= '<div style="background: linear-gradient(135deg, #ecf0f1 0%, #bdc3c7 100%); padding: 12px; border-left: 4px solid #1abc9c; margin-bottom: 20px; border-radius: 3px;">';
    $html .= '<h4 style="margin: 0 0 8px 0; color: #2c3e50; font-size: 13px; font-weight: bold;"> Follow-up Performance Summary</h4>';
    $html .= '<div style="font-size: 11px; color: #34495e; line-height: 1.4;">';
    $html .= '<span style="display: inline-block; margin-right: 20px;"><strong>Total Follow-ups:</strong> <span style="color: #1abc9c; font-weight: bold;">' . $grandTotal . '</span></span>';
    $html .= '<span style="display: inline-block; margin-right: 20px;"><strong>New Calls:</strong> <span style="color: #28a745; font-weight: bold;">' . $totalNewCalls . '</span></span>';
    $html .= '<span style="display: inline-block; margin-right: 20px;"><strong>Follow-up Calls:</strong> <span style="color: #17a2b8; font-weight: bold;">' . $totalFollowupCalls . '</span></span>';
    $html .= '<span style="display: inline-block; margin-right: 20px;"><strong>Active Staff:</strong> <span style="color: #3498db; font-weight: bold;">' . count($followup_types['by_staff']) . '</span></span>';
    $html .= '<span style="display: inline-block; margin-right: 20px;"><strong>Follow-up Types:</strong> <span style="color: #9b59b6; font-weight: bold;">' . count($followup_types['all_types']) . '</span></span>';
    
    // Call connect totals summary
    if (!empty($followup_types['call_connected_totals']['logged'])) {
        $ccTotals = $followup_types['call_connected_totals'];
        $html .= '<br><span style="display: inline-block; margin-top: 5px;"><strong>Call Connect:</strong> <span style="color: #2c3e50;">' .
            (int)($ccTotals['connected'] ?? 0) . ' connected out of ' . (int)($ccTotals['logged'] ?? 0) .
            ' logged (' . number_format((float)($ccTotals['connect_rate'] ?? 0), 1) . '%)</span></span>';
    }
    
    // Find most active staff member
    $mostActiveStaff = '';
    $mostActiveCount = 0;
    foreach ($followup_types['by_staff'] as $staffName => $followupData) {
        $staffTotal = array_sum($followupData);
        if ($staffTotal > $mostActiveCount) {
            $mostActiveCount = $staffTotal;
            $mostActiveStaff = $staffName;
        }
    }
    
    if ($mostActiveStaff) {
        $html .= '<br><span style="display: inline-block; margin-top: 5px;"><strong> Top Performer:</strong> <span style="color: #e67e22; font-weight: bold;">'  . e($mostActiveStaff) . '</span> <span style="color: #7f8c8d;">(' . $mostActiveCount . ' follow-ups)</span></span>';
    }
    
    $html .= '</div>';
    $html .= '</div>';
    
    $pdf->writeHTML($html, true, false, false, false, '');
}

// Start new page for detailed activity log
$pdf->AddPage();

// Detailed Activity Log
$html = '<h2 style="color: #2c3e50; border-bottom: 1px solid #bdc3c7; padding-bottom: 5px; font-size: 16px;"> Detailed Activity Log</h2>';
$html .= '<p style="color: #7f8c8d; font-size: 10px; margin-bottom: 10px;">Showing all activities for selected date range</p>';

// Debug: Log activity data for troubleshooting
if (isset($activity_log['data']) && !empty($activity_log['data'])) {
    error_log('PDF Activity Log: Found ' . count($activity_log['data']) . ' activities');
    if (count($activity_log['data']) > 0) {
        error_log('PDF Activity Log Sample: ' . json_encode($activity_log['data'][0]));
    }
} else {
    error_log('PDF Activity Log: No data found or empty array');
}

if (!empty($activity_log['data'])) {
    $html .= '<table style="width: 100%; border-collapse: collapse; font-size: 8px; table-layout: fixed; border: 1px solid #ddd;" cellpadding="4" cellspacing="0">';
    $html .= '<thead>';
    $html .= '<tr style="background-color: #34495e; color: white;">';
    $html .= '<th style="width: 14%; text-align: center; padding: 6px; vertical-align: middle; border: 1px solid #ddd;">Date & Time</th>';
    $html .= '<th style="width: 14%; text-align: center; padding: 6px; vertical-align: middle; border: 1px solid #ddd;">Staff</th>';
    $html .= '<th style="width: 13%; text-align: center; padding: 6px; vertical-align: middle; border: 1px solid #ddd;">Activity Type</th>';
    $html .= '<th style="width: 12%; text-align: center; padding: 6px; vertical-align: middle; border: 1px solid #ddd;">Call Connect</th>';
    $html .= '<th style="width: 23%; text-align: center; padding: 6px; vertical-align: middle; border: 1px solid #ddd;">Related Lead</th>';
    $html .= '<th style="width: 24%; text-align: center; padding: 6px; vertical-align: middle; border: 1px solid #ddd;">Description</th>';
    $html .= '</tr>';
    $html .= '</thead>';
    $html .= '<tbody>';
    
    $row_count = 0;
    foreach ($activity_log['data'] as $activity) { // Show all activities in date range
        $row_count++;
        $html .= '<tr style="background-color: ' . ($row_count % 2 == 0 ? '#f8f9fa' : '#ffffff') . ';">';
        
        // Date & Time
        $html .= '<td style="width: 14%; text-align: center; font-size: 8px; padding: 4px; vertical-align: top; border: 1px solid #ddd;">' . date('M j, Y<br/>g:i A', strtotime($activity['date'])) . '</td>';
        
        // Staff (use correct field name)
        $staff_name = isset($activity['staff']) ? $activity['staff'] : 'System';
        $html .= '<td style="width: 14%; text-align: center; font-size: 8px; padding: 4px; vertical-align: top; border: 1px solid #ddd;">' . e($staff_name) . '</td>';
        
        // Activity Type (use followup_type)
        $activity_type = isset($activity['followup_type']) ? $activity['followup_type'] : 'General';
        $html .= '<td style="width: 13%; text-align: center; font-size: 8px; padding: 4px; vertical-align: top; border: 1px solid #ddd;">' . e($activity_type) . '</td>';
        
        // Call connect status
        $call_status = !empty($activity['call_connected_status']) ? $activity['call_connected_status'] : '—';
        $html .= '<td style="width: 12%; text-align: center; font-size: 8px; padding: 4px; vertical-align: top; border: 1px solid #ddd;">' . e($call_status) . '</td>';
        
        // Related Lead (use lead information)
        $related_info = isset($activity['lead']) ? $activity['lead'] : 'N/A';
        $html .= '<td style="width: 23%; text-align: left; font-size: 8px; padding: 4px; vertical-align: top; word-wrap: break-word; border: 1px solid #ddd;">' . e($related_info) . '</td>';
        
        // Description (show complete description, not truncated)
        $description = isset($activity['description']) ? strip_tags($activity['description']) : '';
        // Clean up the description and ensure it's readable
        $description = trim($description);
        if (empty($description)) {
            $description = 'No description available';
        }
        // Don't truncate - show full description with proper word wrapping
        $html .= '<td style="width: 24%; text-align: left; font-size: 8px; padding: 4px; vertical-align: top; word-wrap: break-word; border: 1px solid #ddd;">' . e($description) . '</td>';
        $html .= '</tr>';
    }
    
    $html .= '</tbody>';
    $html .= '</table>';
} else {
    $html .= '<p style="text-align: center; color: #95a5a6; font-style: italic; padding: 20px;">No activity data found for the selected period.</p>';
}

$pdf->writeHTML($html, true, false, false, false, '');

// Footer section
$pdf->Ln(10);
$html = '<div style="border-top: 1px solid #bdc3c7; padding-top: 10px; text-align: center; color: #95a5a6; font-size: 10px;">';
$html .= '<p>This report was generated automatically by ' . get_option('companyname') . ' CRM System</p>';
$html .= '<p>Report generated on ' . date('F j, Y \a\t g:i A') . ' | Page {PAGENO} of {nb}</p>';
$html .= '</div>';

$pdf->writeHTML($html, true, false, false, false, '');

