<?php
// Test script to verify duplicate phone detection functionality
// No direct script access restriction for this test file

$basePath = 'c:/xampp/htdocs/crm.ibrayagroup.com/';
// Don't include framework files directly as they have access restrictions

echo "Duplicate Phone Number Detection Test\n";
echo "===================================\n";

// Connect to database
try {
    $db = mysqli_connect('localhost', 'admin', '', 'crm');
    if (!$db) {
        die('Database connection failed: ' . mysqli_connect_error());
    }
    echo "✅ Database connection successful\n";
} catch (Exception $e) {
    die('Database connection error: ' . $e->getMessage());
}

// Check if the Leads controller has the check_phone_exists function
$controllerPath = $basePath . 'application/controllers/admin/Leads.php';
$controllerContent = file_get_contents($controllerPath);

if (strpos($controllerContent, 'function check_phone_exists') !== false) {
    echo "✅ Found check_phone_exists function in Leads controller\n";
} else {
    echo "❌ check_phone_exists function missing from Leads controller\n";
}

// Check if the leads.js file has the checkDuplicatePhone function
$jsPath = $basePath . 'assets/js/leads.js';
$jsContent = file_get_contents($jsPath);

if (strpos($jsContent, 'function checkDuplicatePhone') !== false) {
    echo "✅ Found checkDuplicatePhone function in leads.js\n";
} else {
    echo "❌ checkDuplicatePhone function missing from leads.js\n";
}

// Check if the CSS file exists
$cssPath = $basePath . 'assets/css/phone_duplicate.css';
if (file_exists($cssPath)) {
    echo "✅ phone_duplicate.css file exists\n";
} else {
    echo "❌ phone_duplicate.css file missing\n";
}

// Check if profile.php includes the CSS
$profilePath = $basePath . 'application/views/admin/leads/profile.php';
$profileContent = file_get_contents($profilePath);

if (strpos($profileContent, 'phone_duplicate.css') !== false) {
    echo "✅ CSS link found in profile.php\n";
} else {
    echo "❌ CSS link missing in profile.php\n";
}

// Check if there are leads with phone numbers in the database
$result = mysqli_query($db, "SELECT COUNT(*) as count FROM tblleads WHERE phonenumber IS NOT NULL AND phonenumber != ''");
if ($result) {
    $row = mysqli_fetch_assoc($result);
    echo "✅ Found {$row['count']} leads with primary phone numbers\n";
} else {
    echo "❌ Error querying primary phone numbers\n";
}

$result = mysqli_query($db, "SELECT COUNT(*) as count FROM tblleads WHERE phone_numbers IS NOT NULL AND phone_numbers != ''");
if ($result) {
    $row = mysqli_fetch_assoc($result);
    echo "✅ Found {$row['count']} leads with additional phone numbers\n";
} else {
    echo "❌ Error querying additional phone numbers\n";
}

echo "\nTest completed. Ready to use duplicate phone detection feature.\n";
echo "This feature will now check for duplicate phone numbers across leads,\n";
echo "showing alerts when duplicates are detected while entering data.\n";
?>
