<?php
// Standalone test of the notes template
echo "<h1>Testing Notes Template Directly</h1>";

// Create test data
$notes = [
    [
        'id' => 1,
        'description' => 'Test WhatsApp message to check enhanced template',
        'addedfrom' => 1,
        'dateadded' => date('Y-m-d H:i:s')
    ],
    [
        'id' => 2,
        'description' => 'Test call follow-up to check phone detection',
        'addedfrom' => 1,
        'dateadded' => date('Y-m-d H:i:s')
    ]
];

// Mock functions that the template might need
if (!function_exists('staff_profile_image')) {
    function staff_profile_image($id, $classes = []) {
        return '<img src="#" class="' . implode(' ', $classes) . '" alt="Staff">';
    }
}

if (!function_exists('get_staff_full_name')) {
    function get_staff_full_name($id) {
        return 'Test Staff Member';
    }
}

if (!function_exists('_dt')) {
    function _dt($date) {
        return date('Y-m-d H:i A', strtotime($date));
    }
}

echo "<h2>Including Template:</h2>";

// Include the template
try {
    include('application/views/admin/leads/_notes_template.php');
    echo "<p style='color: green; font-weight: bold;'>✅ Template included successfully!</p>";
} catch (Exception $e) {
    echo "<p style='color: red; font-weight: bold;'>❌ Error including template: " . $e->getMessage() . "</p>";
}

echo "<h2>Template Test Complete</h2>";
?>
