<?php
// Simple test script to bypass module system
define('BASEPATH', TRUE); // This bypasses the "No direct script access" check

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Access-Control-Allow-Headers: Content-Type');

try {
    // Direct database connection (update these if different)
    $host = 'localhost';
    $username = 'autographcom_crm';
    $password = 'fM89m~jx+J;B';
    $database = 'autographcom_crm1'; // Update if your database name is different
    $prefix = 'tbl'; // Update if your table prefix is different
    
    $mysqli = new mysqli($host, $username, $password, $database);
    
    if ($mysqli->connect_error) {
        throw new Exception('Database connection failed: ' . $mysqli->connect_error);
    }
    
    // Get current date ranges
    $today = date('Y-m-d');
    $weekStart = date('Y-m-d', strtotime('monday this week'));
    $monthStart = date('Y-m-01');
    
    // Count activities
    $todayCount = $mysqli->query("SELECT COUNT(*) as cnt FROM {$prefix}lead_activity_log WHERE DATE(date) = '$today'")->fetch_assoc()['cnt'];
    $weekCount = $mysqli->query("SELECT COUNT(*) as cnt FROM {$prefix}lead_activity_log WHERE DATE(date) BETWEEN '$weekStart' AND '$today'")->fetch_assoc()['cnt'];
    $monthCount = $mysqli->query("SELECT COUNT(*) as cnt FROM {$prefix}lead_activity_log WHERE DATE(date) BETWEEN '$monthStart' AND '$today'")->fetch_assoc()['cnt'];
    
    // Get top staff
    $topStaffQuery = "SELECT s.staffid, CONCAT(s.firstname, ' ', s.lastname) as staff_name, COUNT(a.id) as total
                      FROM {$prefix}lead_activity_log a
                      LEFT JOIN {$prefix}staff s ON s.staffid = a.staffid
                      WHERE DATE(a.date) >= '$monthStart'
                      GROUP BY s.staffid
                      ORDER BY total DESC
                      LIMIT 5";
    
    $topStaffResult = $mysqli->query($topStaffQuery);
    $topStaff = [];
    while ($row = $topStaffResult->fetch_assoc()) {
        $topStaff[] = $row;
    }
    
    $response = [
        'today' => (int)$todayCount,
        'week' => (int)$weekCount,
        'month' => (int)$monthCount,
        'logins_today' => 0, // We'll skip this for now
        'top_staff' => $topStaff,
        'debug' => [
            'date_ranges' => [
                'today' => $today,
                'week_start' => $weekStart,
                'month_start' => $monthStart
            ],
            'table_prefix' => $prefix
        ]
    ];
    
    echo json_encode($response);
    
} catch (Exception $e) {
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage(),
        'trace' => $e->getTraceAsString()
    ]);
}
?>
