<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="panel_s">
            <div class="panel-body">
                <div class="row">
                    <div class="col-md-12">
                        <h4 class="no-margin">
                            <i class="fa fa-whatsapp text-success"></i>
                            <?php echo _l('whatsapp_reminder_management', 'WhatsApp Reminder Notifications'); ?>
                        </h4>
                    </div>
                </div>
                <div class="clearfix"></div>
                <hr class="hr-panel-heading" />
                
                <!-- Status Overview -->
                <div class="row">
                    <div class="col-md-6">
                        <div class="panel_s">
                            <div class="panel-body">
                                <h5><i class="fa fa-info-circle text-info"></i> <?php echo _l('system_status', 'System Status'); ?></h5>
                                <div id="system-status">
                                    <p><i class="fa fa-spinner fa-spin"></i> <?php echo _l('checking_system_status', 'Checking system status...'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="panel_s">
                            <div class="panel-body">
                                <h5><i class="fa fa-clock-o text-warning"></i> <?php echo _l('upcoming_reminders', 'Upcoming Reminders'); ?></h5>
                                <div id="upcoming-reminders">
                                    <p><i class="fa fa-spinner fa-spin"></i> <?php echo _l('loading_upcoming_reminders', 'Loading upcoming reminders...'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>                <!-- Action Buttons -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="btn-group margin-bottom-20" role="group">
                            <button type="button" class="btn btn-success" onclick="checkRemindersNow()">
                                <i class="fa fa-search"></i> <?php echo _l('check_due_reminders_now', 'Check Due Reminders Now'); ?>
                            </button>
                            <button type="button" class="btn btn-info" onclick="testReminderNotification()">
                                <i class="fa fa-paper-plane"></i> <?php echo _l('test_notification', 'Test Notification'); ?>
                            </button>
                            <button type="button" class="btn btn-primary" onclick="testCronHooks()">
                                <i class="fa fa-cogs"></i> Test Cron Hooks
                            </button>
                            <button type="button" class="btn btn-warning" onclick="refreshStatus()">
                                <i class="fa fa-refresh"></i> <?php echo _l('refresh_status', 'Refresh Status'); ?>
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Recent Activity Log -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel_s">
                            <div class="panel-body">
                                <h5><i class="fa fa-list text-primary"></i> <?php echo _l('recent_whatsapp_reminder_activity', 'Recent WhatsApp Reminder Activity'); ?></h5>
                                <div id="activity-log">
                                    <p><i class="fa fa-spinner fa-spin"></i> <?php echo _l('loading_activity_log', 'Loading activity log...'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>

<script>
$(document).ready(function() {
    refreshStatus();
    
    // Auto-refresh every 30 seconds
    setInterval(refreshStatus, 30000);
});

function refreshStatus() {
    checkSystemStatus();
    loadUpcomingReminders();
    loadActivityLog();
}

function checkSystemStatus() {
    $('#system-status').html('<p><i class="fa fa-spinner fa-spin"></i> <?php echo _l("checking_system_status", "Checking system status..."); ?></p>');
    
    $.ajax({
        url: admin_url + 'whatsapp_api/reminder_management/check_status',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            let html = '';
            
            if (response.module_active) {
                html += '<p><i class="fa fa-check text-success"></i> <?php echo _l("whatsapp_api_module", "WhatsApp API Module"); ?>: <strong><?php echo _l("active", "Active"); ?></strong></p>';
            } else {
                html += '<p><i class="fa fa-times text-danger"></i> <?php echo _l("whatsapp_api_module", "WhatsApp API Module"); ?>: <strong><?php echo _l("inactive", "Inactive"); ?></strong></p>';
            }
            
            if (response.api_configured) {
                html += '<p><i class="fa fa-check text-success"></i> <?php echo _l("api_configuration", "API Configuration"); ?>: <strong><?php echo _l("complete", "Complete"); ?></strong></p>';
            } else {
                html += '<p><i class="fa fa-times text-danger"></i> <?php echo _l("api_configuration", "API Configuration"); ?>: <strong><?php echo _l("incomplete", "Incomplete"); ?></strong></p>';
            }
            
            if (response.template_mapped) {
                html += '<p><i class="fa fa-check text-success"></i> <?php echo _l("staff_reminder_template", "Staff Reminder Template"); ?>: <strong><?php echo _l("configured", "Configured"); ?></strong></p>';
            } else {
                html += '<p><i class="fa fa-times text-danger"></i> <?php echo _l("staff_reminder_template", "Staff Reminder Template"); ?>: <strong><?php echo _l("not_configured", "Not Configured"); ?></strong></p>';
            }
            
            html += '<p><i class="fa fa-database text-info"></i> <?php echo _l("database_columns", "Database Columns"); ?>: <strong>' + (response.db_ready ? '<?php echo _l("ready", "Ready"); ?>' : '<?php echo _l("not_ready", "Not Ready"); ?>') + '</strong></p>';
            
            $('#system-status').html(html);
        },
        error: function() {
            $('#system-status').html('<p><i class="fa fa-exclamation-triangle text-danger"></i> <?php echo _l("error_checking_system_status", "Error checking system status"); ?></p>');
        }
    });
}

function loadUpcomingReminders() {
    $('#upcoming-reminders').html('<p><i class="fa fa-spinner fa-spin"></i> <?php echo _l("loading_upcoming_reminders", "Loading upcoming reminders..."); ?></p>');
    
    $.ajax({
        url: admin_url + 'whatsapp_api/reminder_management/upcoming_reminders',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            let html = '';
            
            if (response.reminders && response.reminders.length > 0) {
                html += '<div class="list-group">';
                response.reminders.forEach(function(reminder) {
                    html += '<div class="list-group-item">';
                    html += '<h6 class="list-group-item-heading">' + escapeHtml(reminder.description) + '</h6>';
                    html += '<p class="list-group-item-text">';
                    html += '<strong><?php echo _l("staff", "Staff"); ?>:</strong> ' + reminder.firstname + ' ' + reminder.lastname + '<br>';
                    html += '<strong><?php echo _l("due", "Due"); ?>:</strong> ' + reminder.formatted_date + '<br>';
                    html += '<strong><?php echo _l("phone", "Phone"); ?>:</strong> ' + (reminder.phonenumber || '<?php echo _l("not_provided", "Not provided"); ?>');
                    html += '</p>';
                    html += '</div>';
                });
                html += '</div>';
            } else {
                html = '<p><i class="fa fa-info-circle text-info"></i> <?php echo _l("no_upcoming_reminders_found", "No upcoming reminders found"); ?></p>';
            }
            
            $('#upcoming-reminders').html(html);
        },
        error: function() {
            $('#upcoming-reminders').html('<p><i class="fa fa-exclamation-triangle text-danger"></i> <?php echo _l("error_loading_reminders", "Error loading reminders"); ?></p>');
        }
    });
}

function loadActivityLog() {
    $('#activity-log').html('<p><i class="fa fa-spinner fa-spin"></i> <?php echo _l("loading_activity_log", "Loading activity log..."); ?></p>');
    
    $.ajax({
        url: admin_url + 'whatsapp_api/reminder_management/activity_log',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            let html = '';
            
            if (response.logs && response.logs.length > 0) {
                html += '<div class="table-responsive">';
                html += '<table class="table table-striped">';
                html += '<thead><tr><th><?php echo _l("date", "Date"); ?></th><th><?php echo _l("staff", "Staff"); ?></th><th><?php echo _l("reminder", "Reminder"); ?></th><th><?php echo _l("status", "Status"); ?></th></tr></thead>';
                html += '<tbody>';
                
                response.logs.forEach(function(log) {
                    html += '<tr>';
                    html += '<td>' + log.created_at + '</td>';
                    html += '<td>' + log.staff_name + '</td>';
                    html += '<td>' + escapeHtml(log.reminder_description.substring(0, 50)) + '...</td>';
                    html += '<td><span class="label label-' + (log.status == 'SUCCESS' ? 'success' : 'danger') + '">' + log.status + '</span></td>';
                    html += '</tr>';
                });
                
                html += '</tbody></table></div>';
            } else {
                html = '<p><i class="fa fa-info-circle text-info"></i> <?php echo _l("no_recent_activity_found", "No recent activity found"); ?></p>';
            }
            
            $('#activity-log').html(html);
        },
        error: function() {
            $('#activity-log').html('<p><i class="fa fa-exclamation-triangle text-danger"></i> <?php echo _l("error_loading_activity_log", "Error loading activity log"); ?></p>');
        }
    });
}

function checkRemindersNow() {
    alert_float('info', '<?php echo _l("checking_for_due_reminders", "Checking for due reminders..."); ?>');
    
    $.ajax({
        url: admin_url + 'whatsapp_api/reminder_management/check_now',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                alert_float('success', response.message);
                refreshStatus();
            } else {
                alert_float('danger', response.message || '<?php echo _l("error_checking_reminders", "Error checking reminders"); ?>');
            }
        },
        error: function() {
            alert_float('danger', '<?php echo _l("error_checking_reminders", "Error checking reminders"); ?>');
        }
    });
}

function testReminderNotification() {
    alert_float('info', '<?php echo _l("sending_test_notification", "Sending test notification..."); ?>');
    
    $.ajax({
        url: admin_url + 'whatsapp_api/reminder_management/test_notification',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                alert_float('success', response.message);
            } else {
                alert_float('danger', response.message || '<?php echo _l("error_sending_test_notification", "Error sending test notification"); ?>');
            }
        },
        error: function() {
            alert_float('danger', '<?php echo _l("error_sending_test_notification", "Error sending test notification"); ?>');
        }
    });
}

function testCronHooks() {
    alert_float('info', 'Testing cron hooks...');
    
    $.ajax({
        url: admin_url + 'whatsapp_api/reminder_management/trigger_cron_test',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                alert_float('success', response.message);
                refreshStatus();
            } else {
                alert_float('danger', response.message);
            }
        },
        error: function() {
            alert_float('danger', 'Error testing cron hooks');
        }
    });
}

function escapeHtml(text) {
    var map = {
        '&': '&amp;',
        '<': '&lt;',
        '>': '&gt;',
        '"': '&quot;',
        "'": '&#039;'
    };
    return text.replace(/[&<>"']/g, function(m) { return map[m]; });
}
</script>
