<?php

defined('BASEPATH') || exit('No direct script access allowed');

use WpOrg\Requests\Requests as Whatsapp_api_Request_Lib;

class Whatsapp_api_lib
{
    public $CI;
    public $to;
    public $staff_to;
    public $client_to;
    public $lead_to;
    public $messaging_template;
    public $merge_fields;
    public $tableData;
    public $attachmentData;
    public $category = null;
    public $blocked_message = false;
    public $send_data = [
        'messaging_product' => 'whatsapp',
        'recipient_type'    => 'individual',
        'type'              => 'template',
        'template'          => [],
        'text'          => '',
    ];

    public function __construct()
    {
        $this->CI = &get_instance();
        $this->CI->load->model('whatsapp_api/whatsapp_api_model');
        $this->initData();
    }

    public function initData()
    {
        $this->merge_fields = [];
    }

    public function send_mapped_template($category, $return=false, $request_from="MANUAL", ...$params)
    {
        $this->initData();

        $this->merge_fields = $this->CI->app_merge_fields->format_feature(
            'other_merge_fields'
        );

        $this->category = $category;
        \modules\whatsapp_api\core\Apiinit::the_da_vinci_code('whatsapp_api');
        $mapping_where = ['whatsapp_templates_mapping.category' => $category, 'active' => 1];
        if($request_from != "MANUAL"){
            $mapping_where[db_prefix() . 'whatsapp_templates_mapping.id'] = $request_from->whatsapp_mapped_template_id;
        }
        $all_templates         = $this->CI->whatsapp_api_model->get_mapping_data($mapping_where);
        $response              = ($this->{$category}(...$params));

        if (!$response['status']) {
            $log_data['response_code']    = '501';
            $log_data['response_data']    = json_encode(["message" => $response['message']]);
            $log_data['send_json']        = json_encode([]);
            $log_data['message_category'] = $category;
            $log_data['category_params']  = json_encode($params);
            $log_data['merge_field_data'] = json_encode([]);
            $this->CI->whatsapp_api_model->add_request_log($log_data);

            return;
        }

        foreach ($all_templates as $template) {
            if ($request_from != "MANUAL" && empty($template->whatsapp_after_number)) {
                continue;
            }

            if (!empty($template->whatsapp_after_number) && $request_from == "MANUAL") {
                $schedule_data['whatsapp_mapped_template_id'] = $template->id;
                $schedule_data['rel_id'] = $params[0];
                $schedule_data['rel_type'] = $template->category;
                $schedule_data['scheduled_at'] = date("Y-m-d H:i:s" ,strtotime("+ {$template->whatsapp_after_number} {$template->whatsapp_after_type}", time()));
                $this->CI->db->insert("scheduled_whatsapp_messages", $schedule_data);
                continue;
            }

            if($template->header_data_format == "IMAGE" || $template->header_data_format == "VIDEO"){
                $this->attachmentData = [
                    "file_name" => $template->attachment,
                    "url" => base_url('uploads/whatsapp_api/template_attachment/'.$template->id.'/'.$template->attachment),
                ];
            }

            $this->send_data['template']['name']       = $template->template_name;
            $this->send_data['template']['language']   = ['code' => $template->language];            switch ($template->send_to) {
                case 'contact':
                    $this->to = $this->client_to;
                    break;

                case 'lead':
                    $this->to = $this->lead_to;
                    break;

                case 'staff':
                    $this->to = $this->staff_to;
                    break;

                default:
                    // For lead_assigned category, always send to staff
                    if ($this->category == 'lead_assigned') {
                        $this->to = $this->staff_to;
                    } else {
                        $this->to = $this->staff_to;
                    }
                    break;
            }

            // change ticket url as per message send to
            if ($category == "ticket") {
                $this->merge_fields['{ticket_url}'] = admin_url('tickets/ticket/' . $params[array_key_first($params)]);
                if ($template->send_to == 'contact') {
                    $this->merge_fields['{ticket_url}'] = site_url('clients/ticket/' . $params[array_key_first($params)]);
                }
            }

            // Change Link as per send to
            if ($category == "tasks") {
                $this->CI->db->where('id', $params[array_key_first($params)]);
                $task = $this->CI->db->get(db_prefix() . 'tasks')->row();
                $this->merge_fields['{task_link}'] = admin_url('tasks/view/' . $params[array_key_first($params)]);
                if ($template->send_to == 'contact') {
                    $this->merge_fields['{task_link}'] = site_url('clients/project/' . $task->rel_id . '?group=project_tasks&taskid=' . $params[array_key_first($params)]);
                }
            }
            if ($category == "projects") {
                $this->merge_fields['{project_link}'] = admin_url('projects/view/' . $params[array_key_first($params)]);
                if ($template->send_to == 'contact') {
                    $this->merge_fields['{project_link}'] = site_url('clients/project/' . $params[array_key_first($params)]);
                }
            }
            if ($category == "secure_login") {
                $staff = get_staff($params[array_key_first($params)]);
                $this->merge_fields['{whatsapp_auth_code}'] = $staff->whatsapp_auth_code;
            }            $this->send_data['template']['components'] = [];
            
            // Use sequential array indices to ensure proper JSON array format
            $component_index = 0;
            if (!empty($template->header_params_count)) {
                $this->parseComponents('header', $template, $component_index);
                $component_index++;
            }
            if (!empty($template->body_params_count)) {
                $this->parseComponents('body', $template, $component_index);
                $component_index++;
            }            if (!empty($template->footer_params_count)) {
                $this->parseComponents('footer', $template, $component_index);
                $component_index++;
            }            // DEBUG: Force array structure to ensure it's not converted to object
            $this->send_data['template']['components'] = array_values($this->send_data['template']['components']);if ($category == "secure_login" && !empty(json_decode($template->buttons_data))) {
                $this->send_data['template']['components'][$component_index] = ['type' => "button", 'sub_type'=> "url", "index" => 0, 'parameters' => []];
                $this->send_data['template']['components'][$component_index]['parameters'][] = ['type' => 'text', 'text' => $staff->whatsapp_auth_code];
            }
            
            $data = $this->send();

            $response_code = $data['response_code'];

            if (($response_code >= 300 && $response_code <= 399) || ($response_code >= 400 && $response_code <= 499) || ($response_code >= 500 && $response_code <= 599)) {
                $data['cron_status'] = "FAILED";
            }

            if ($template->debug_mode) {
                $log_data                     = $data;
                $log_data['send_json']        = json_encode($this->send_data);
                $log_data['message_category'] = $category;
                $log_data['category_params']  = json_encode($params);
                $log_data['merge_field_data'] = json_encode($this->merge_fields);

                unset($log_data['cron_status']);
                unset($log_data['error_message']);

                $this->CI->whatsapp_api_model->add_request_log($log_data);
            }

            if ($request_from != "MANUAL") {
                $this->CI->db->update("scheduled_whatsapp_messages", [
                    'status' => $data['cron_status'],
                    'executed_at' => date("Y-m-d H:i:s"),
                    'error_message' => $data['error_message'] ?? NULL
                ], ['id' => $request_from->id]);
            }
            
            if ($return && $data['response_code'] == '200') {
                return true;
            }
        }
    }

    public function send_custom_message($receiverData, $postData, $imageUrl, $request_from='MANUAL')
    {
        $templateId = $postData['template_name'];
        $message = $postData['broadcast_message'];
        $debugMode = $postData['debug_mode'] ?? 0;
        $rel_type = $postData['rel_type'];

        $template = $this->CI->whatsapp_api_model->get_template_data($templateId);

        $this->send_data['template']['name']       = $template->template_name;
        $this->send_data['template']['language']   = ['code' => $template->language];
        $this->send_data['template']['components'] = [];

        $this->attachmentData = [
            "url" => $imageUrl
        ];

        $id = (!empty($rel_type)) ? ($rel_type == 'staff' ? 'staffid' : ($rel_type == 'client' ? 'userid' : 'id')) : 'id';

        $whatsapp_after_number = $postData['whatsapp_after_number'];
        $whatsapp_after_type = $postData['whatsapp_after_type'];

        foreach ($receiverData as $receiver) {
            if ($request_from != "MANUAL" && empty($whatsapp_after_number)) {
                continue;
            }

            switch ($rel_type) {
                case 'leads':
                    $relId = $receiver['id'];
                    break;

                case 'staff':
                    $relId = $receiver['staffid'];
                    break;

                case 'client':
                    $relId = $receiver['userid'];
                    break;
            }

            if (!empty($whatsapp_after_number) && $request_from == "MANUAL") {
                $schedule_data['whatsapp_mapped_template_id'] = $template->id;
                $schedule_data['rel_id'] = $relId;
                $schedule_data['rel_type'] = $rel_type;
                $schedule_data['scheduled_at'] = date("Y-m-d H:i:s" ,strtotime("+ {$whatsapp_after_number} {$whatsapp_after_type}", time()));
                $schedule_data['type'] = 'broadcast';
                $schedule_data['broadcast_message'] = $message;
                $schedule_data['debug_mode'] = $debugMode;
                $schedule_data['whatsapp_after_number'] = $whatsapp_after_number;
                $schedule_data['whatsapp_after_type'] = $whatsapp_after_type;
                $schedule_data['image_url'] = $imageUrl;
                $this->CI->db->insert("scheduled_whatsapp_messages", $schedule_data);
                continue;
            }

            $this->merge_fields = $this->CI->app_merge_fields->format_feature(
                $rel_type . '_merge_fields', $receiver[$id]
            );

            $modifyMergeFieldsArray = [];
            foreach ($this->merge_fields as $key => $value) {
                $modifiedKey = '@' . $key;
                $modifyMergeFieldsArray[$modifiedKey] = $value;
            }
            $template->body_params = str_replace(array_keys($modifyMergeFieldsArray), $modifyMergeFieldsArray, $message);

            $this->parseComponents('header', $template, 0);
            $this->parseComponents('body', $template, 1);
            $this->parseComponents('footer', $template, 2);

            $this->to = $receiver['phonenumber'];

            $data = $this->send();

            $response_code = $data['response_code'];
            if (($response_code >= 300 && $response_code <= 399) || ($response_code >= 400 && $response_code <= 499) || ($response_code >= 500 && $response_code <= 599)) {
                $data['cron_status'] = "FAILED";
                $error_message = json_decode($data['response_data'])->message;
            }

            if ($debugMode) {
                $log_data                     = $data;
                $log_data['send_json']        = json_encode($this->send_data);
                $log_data['message_category'] = "Broadcast Message";
                $log_data['category_params']  = json_encode(["templateId" => $templateId, "message" => $message, "imageUrl" => $imageUrl]);
                $log_data['merge_field_data'] = json_encode($receiver);

                unset($log_data['cron_status']);
                unset($log_data['error_message']);

                $this->CI->whatsapp_api_model->add_request_log($log_data);
            }

            if ($request_from != "MANUAL") {
                $this->CI->db->update("scheduled_whatsapp_messages", [
                    'status' => $data['cron_status'],
                    'executed_at' => date("Y-m-d H:i:s"),
                    'error_message' => $data['error_message'] ?? NULL
                ], ['id' => $request_from]);
            }
        }
    }    public function parseComponents($type, $template, $index)
    {
        $merge_fields = $this->merge_fields;
        if (!empty($template->{$type . '_params_count'})) {
            $this->send_data['template']['components'][$index] = ['type' => $type, 'parameters' => []];
            for ($i = 1; $i <= $template->{$type . '_params_count'}; $i++) {
                if (isJson($template->{$type . '_params'} ?? "[]")) {
                    $parsed_text = json_decode($template->{$type . '_params'} ?? "[]", true);
                    $parsed_text = array_map(static function ($body) use ($merge_fields) {
                        $body['value'] = preg_replace('/@{(.*?)}/', '{$1}', $body['value']);
                        foreach ($merge_fields as $key => $val) {
                            // Ensure $val is not null for PHP 8.2 compatibility
                            $replacement = $val ?? '';
                            $body['value'] =
                                false !== stripos($body['value'], $key)
                                ? str_replace($key, $replacement, $body['value'])
                                : str_replace($key, '', $body['value']);
                        }
                        return preg_replace('/\s+/', ' ', trim($body['value']));
                    }, $parsed_text);
                } else {
                    $parsed_text[1] = preg_replace('/\s+/', ' ', trim($template->{$type . '_params'}));
                }

                $this->send_data['template']['components'][$index]['parameters'][] = ['type' => 'text', 'text' => !empty($parsed_text[$i]) ? $parsed_text[$i] : ' '];
                \modules\whatsapp_api\core\Apiinit::the_da_vinci_code('whatsapp_api');
            }
        }
        if ($type == "header" && empty($template->{$type . '_params_count'}) && ($template->header_data_format == "DOCUMENT" || $template->header_data_format == "IMAGE" || $template->header_data_format == "VIDEO")) {
            $this->send_data['template']['components'][$index] = ['type' => $type];
            $this->send_data['template']['components'][$index]['parameters'] = [];
            if ($template->header_data_format == "DOCUMENT") {
                $this->send_data['template']['components'][$index]['parameters'][] = [
                    'type' => 'document',
                    'document' => [
                        "link" => $this->attachmentData['url'],
                        "filename" => $this->attachmentData['file_name']
                    ]
                ];
            }
            if ($template->header_data_format == "IMAGE") {
                $this->send_data['template']['components'][$index]['parameters'][] = [
                    'type' => 'image',
                    'image' => [
                        "link" => $this->attachmentData['url']
                    ]
                ];
            }
            if ($template->header_data_format == "VIDEO") {
                $this->send_data['template']['components'][$index]['parameters'][] = [
                    'type' => 'video',
                    'video' => [
                        "link" => $this->attachmentData['url']
                    ]
                ];
            }
        }
    }

    public function prepareData($staffID = null, $clientID = null, $merge_field_name = '', ...$merge_field_data)
    {
        if (!empty($staffID)) {
            $staff = get_staff($staffID);
            if (!empty($staff->phonenumber) && null !== $staff->phonenumber) {
                $this->staff_to = $staff->phonenumber;
            }
            $staff_fields       = $this->CI->app_merge_fields->format_feature('staff_merge_fields', $staffID);
            $this->merge_fields = array_merge($staff_fields, $this->merge_fields);
        }
        if (!empty($clientID)) {
            $primaryContact = get_primary_contact_user_id($clientID);
            $client         = $this->CI->clients_model->get_contact($primaryContact);
            $this->blocked_message = !(int)$client->{$this->category.'_message'};
            if($client->{$this->category.'_message'}){
                if (!empty($client->phonenumber) && null !== $client->phonenumber) {
                    $this->client_to = $client->phonenumber;
                }
                if (!empty($client->{$this->category.'_forward_phone'}) && null !== $client->{$this->category.'_forward_phone'}) {
                    $this->client_to = $client->{$this->category.'_forward_phone'};
                }
            }
            $client_fields      = $this->CI->app_merge_fields->format_feature('client_merge_fields', $clientID);
            $this->merge_fields = array_merge($client_fields, $this->merge_fields);
        }
        if($merge_field_name == "staff_reminder"){
            $category_fields = $this->CI->staff_merge_fields->reminder($merge_field_data[0]);
        } else {
            $category_fields    = $this->CI->app_merge_fields->format_feature($merge_field_name, ...$merge_field_data);
        }
        $this->merge_fields = array_merge($category_fields, $this->merge_fields);
    }

    public function send()
    {
        $this->send_data['to']       = $this->to;
        if (empty($this->to)) {
            if($this->blocked_message){
                return ['response_code' => 501, 'response_data' => json_encode(['message' => 'User unsubscribed for this message category'])];
            }
            return ['response_code' => 501, 'response_data' => json_encode(['message' => 'To Number not found'])];
        }
        \modules\whatsapp_api\core\Apiinit::the_da_vinci_code('whatsapp_api');
        $endpoint                    = 'https://graph.facebook.com/v14.0/' . get_option('phone_number_id') . '/messages';
        $data                        = [];
        $data['api_endpoint']        = $endpoint;
        $data['phone_number_id']     = get_option('phone_number_id');
        $data['access_token']        = get_option('whatsapp_access_token');
        $data['business_account_id'] = get_option('whatsapp_business_account_id');
        try {
            $request = Whatsapp_api_Request_Lib::post(
                $endpoint,
                ['Authorization' => 'Bearer ' . get_option('whatsapp_access_token')],
                $this->send_data,
            );
            $data['response_code'] = $request->status_code;
            $data['response_data'] = htmlentities($request->body);
            $data['cron_status'] = 'SUCCESS';
        } catch (Exception $e) {
            $data['response_code'] = 'EXCEPTION';
            $data['response_data'] = json_encode(["message" => $e->getMessage()]);
            $data['error_message'] = $e->getMessage();
            $data['cron_status'] = 'FAILED';
        }
        return $data;
    }    public function leads($leadsID)
    {
        $this->CI->load->model('leads_model');
        $tableData = $this->CI->leads_model->get($leadsID);
        if(empty($tableData)){
            return ['status' => false, 'message'=>"Lead not found!"];
        }
        
        // Manually set lead merge fields to ensure they work properly
        $this->merge_fields = [
            '{lead_name}' => $tableData->name,
            '{lead_email}' => $tableData->email,
            '{lead_position}' => $tableData->title,
            '{lead_website}' => $tableData->website,
            '{lead_description}' => $tableData->description,
            '{lead_phonenumber}' => $tableData->phonenumber,
            '{lead_company}' => $tableData->company,
            '{lead_country}' => get_country_short_name($tableData->country),
            '{lead_zip}' => $tableData->zip,
            '{lead_city}' => $tableData->city,
            '{lead_state}' => $tableData->state,
            '{lead_address}' => $tableData->address,
            '{lead_assigned}' => get_staff_full_name($tableData->assigned),
            '{lead_status}' => $tableData->status,
            '{lead_source}' => $tableData->source,
            '{lead_dateadded}' => date('F j, Y g:i A', strtotime($tableData->dateadded)),
            '{lead_link}' => admin_url('leads/index/' . $leadsID),
            '{lead_public_form_url}' => leads_public_url($leadsID)
        ];
        
        // Also prepare using the standard system as backup
        $this->prepareData($tableData->assigned, null, 'leads_merge_fields', $leadsID);
        
        // Set the phone number for WhatsApp
        $this->lead_to = $this->merge_fields['{lead_phonenumber}'];

        return ['status' => true];
    }    public function staff_reminder($reminderID)
    {
        $this->CI->load->model('misc_model');
        $this->CI->db->select('r.*, s.staffid, s.firstname, s.lastname, s.phonenumber, s.email');
        $this->CI->db->from(db_prefix() . 'reminders r');
        $this->CI->db->join(db_prefix() . 'staff s', 's.staffid = r.staff');
        $this->CI->db->where('r.id', $reminderID);
        $tableData = $this->CI->db->get()->row_array();
        
        if(empty($tableData)){
            return ['status' => false, 'message' => "Reminder not found!"];
        }
        
        if(empty($tableData['phonenumber'])){
            return ['status' => false, 'message' => "Staff member has no phone number configured!"];
        }
        
        // Prepare merge fields specific to staff reminders
        $this->merge_fields = [
            '{staff_firstname}' => $tableData['firstname'],
            '{staff_lastname}' => $tableData['lastname'], 
            '{reminder_description}' => $tableData['description'],
            '{reminder_date}' => date('F j, Y g:i A', strtotime($tableData['date'])),
            '{reminder_time_ago}' => time_ago($tableData['date']),
            '{staff_email}' => $tableData['email'],
            '{staff_id}' => $tableData['staffid']
        ];
        
        // If reminder is related to a lead, include lead merge fields
        if (!empty($tableData['rel_type']) && $tableData['rel_type'] == 'lead' && !empty($tableData['rel_id'])) {
            $this->CI->load->model('leads_model');
            $leadData = $this->CI->leads_model->get($tableData['rel_id']);
            
            if (!empty($leadData)) {
                // Add lead merge fields to staff reminder
                $lead_merge_fields = [
                    '{lead_name}' => $leadData->name,
                    '{lead_email}' => $leadData->email,
                    '{lead_position}' => $leadData->title,
                    '{lead_website}' => $leadData->website,
                    '{lead_description}' => $leadData->description,
                    '{lead_phonenumber}' => $leadData->phonenumber,
                    '{lead_company}' => $leadData->company,
                    '{lead_country}' => get_country_short_name($leadData->country),
                    '{lead_zip}' => $leadData->zip,
                    '{lead_city}' => $leadData->city,
                    '{lead_state}' => $leadData->state,
                    '{lead_address}' => $leadData->address,
                    '{lead_assigned}' => get_staff_full_name($leadData->assigned),
                    '{lead_status}' => $leadData->status,
                    '{lead_source}' => $leadData->source,
                    '{lead_dateadded}' => date('F j, Y g:i A', strtotime($leadData->dateadded)),
                    '{lead_link}' => admin_url('leads/index/' . $tableData['rel_id']),
                    '{lead_public_form_url}' => leads_public_url($tableData['rel_id'])
                ];
                
                // Merge lead fields with staff reminder fields
                $this->merge_fields = array_merge($this->merge_fields, $lead_merge_fields);
            }
        }
        
        $this->staff_to = $tableData['phonenumber'];
        $this->tableData = $tableData;

        return ['status' => true];
    }


    public function subscriptions($subscriptionID)
    {
        $this->CI->load->model('subscriptions_model');
        $subData = $this->CI->subscriptions_model->get_by_id($subscriptionID);
        if(empty($subData)){
            return ['status' => false, 'message'=>"Subscription Details not found!"];
        }
        $this->prepareData(null, $subData->clientid, 'subscriptions_merge_fields', $subscriptionID);
        
        return ['status' => true];
    }

    public function client($contactID)
    {
        $this->CI->load->model('clients_model');
        $contactData = $this->CI->clients_model->get_contact($contactID);
        $admins      = $this->CI->clients_model->get_admins($contactData->userid);
        $admins      = array_column($admins, 'staff_id');

        if(empty($contactData)){
            return ['status' => false, 'message'=>"Contact Details not found!"];
        }

        $firstValue = (!empty($admins)) ? $admins[array_key_first($admins)] : [];

        $this->prepareData($firstValue, $contactData->userid, 'client_merge_fields', $contactID, $contactData->userid);

        return ['status' => true];
    }

    public function invoice($invoiceID)
    {
        $this->CI->load->model('invoices_model');
        $tableData       = $this->CI->invoices_model->get($invoiceID);
        if(empty($tableData)){
            return ['status' => false, 'message'=>"Invoice Details not found!"];
        }
        $this->prepareData($tableData->sale_agent, $tableData->clientid, 'invoice_merge_fields', $invoiceID);
        $pdf = invoice_pdf($tableData);
        $pdf->Output(FCPATH . 'uploads/whatsapp_api/invoices/wa_invoice_' . $invoiceID . '.pdf', 'F');

        $this->attachmentData = [
            "file_name" => format_invoice_number($invoiceID) . ".pdf",
            "url" => base_url("uploads/whatsapp_api/invoices/wa_invoice_" . $invoiceID . ".pdf"),
        ];

        return ['status' => true];
    }

    public function tasks($taskID)
    {
        $this->CI->load->model('tasks_model');
        $tableData       = $this->CI->tasks_model->get($taskID);
        if(empty($tableData)){
            return ['status' => false, 'message'=>"Task Details not found!"];
        }
        if ('project' == $tableData->rel_type && !empty($tableData->project_data)) {
            $assignee = array_column($tableData->assignees, 'assigneeid');
            $this->prepareData($assignee[array_key_first($assignee)], $tableData->project_data->clientid, 'tasks_merge_fields', $taskID);

            return ['status' => true];
        }

        return ['status' => false, 'message' => 'Only project type is allowed in task'];
    }

    public function projects($projectID)
    {
        $this->CI->load->model('projects_model');
        $tableData       = $this->CI->projects_model->get($projectID);
        $members         = $this->CI->projects_model->get_project_members($projectID);
        $member_arr      = array_column($members, 'staff_id');
        if(empty($tableData)){
            return ['status' => false, 'message'=>"Project Details not found!"];
        }
        $this->prepareData($member_arr[array_key_first($member_arr)], $tableData->clientid, 'projects_merge_fields', $projectID);

        return ['status' => true];
    }

    public function proposals($proposalID)
    {
        $this->CI->load->model('proposals_model');
        $tableData       = $this->CI->proposals_model->get($proposalID);
        if(empty($tableData)){
            return ['status' => false, 'message'=>"Proposal Details not found!"];
        }
        if ('customer' == $tableData->rel_type) {
            $this->prepareData($tableData->assigned, $tableData->rel_id, 'proposals_merge_fields', $proposalID);
        }

        if ('lead' == $tableData->rel_type) {
            $this->CI->load->model('leads_model');
            $this->prepareData($tableData->assigned, null, 'proposals_merge_fields', $proposalID);

            // Merge fields prepare data for lead data 
            $lead       = $this->CI->leads_model->get($tableData->rel_id);
            if (!empty($lead->phonenumber) && null !== $lead->phonenumber) {
                $this->lead_to = $lead->phonenumber;
            }
            $lead_fields       = $this->CI->app_merge_fields->format_feature('leads_merge_fields', $tableData->rel_id);
            $this->merge_fields = array_merge($lead_fields, $this->merge_fields);
        }

        $pdf = proposal_pdf($tableData);
        $pdf->Output(FCPATH . '/uploads/whatsapp_api/proposals/wa_proposal_' . $proposalID . '.pdf', 'F');

        $this->attachmentData = [
            "file_name" => format_proposal_number($proposalID) . ".pdf",
            "url" => base_url("uploads/whatsapp_api/proposals/wa_proposal_" . $proposalID . ".pdf"),
        ];
        return ['status' => true];
    }

    public function payments($paymentsID)
    {
        $this->CI->load->model(['invoices_model', 'payments_model']);
        $invoiceid = $this->CI->db->select('invoiceid')->get_where(db_prefix() . 'invoicepaymentrecords', ['id' => $paymentsID])->row()->invoiceid;
        $payment = $this->CI->payments_model->get($paymentsID);
        if (empty($invoiceid)) {
            return ['status' => false, 'message'=>"Invoice not found!"];
        }
        if(empty($payment)){
            return ['status' => false, 'message'=>"Payment Details not found!"];
        }
        $tableData       = $this->CI->invoices_model->get($invoiceid);
        if(empty($tableData)){
            return ['status' => false, 'message'=>"Invoice Details not found!"];
        }
        $this->prepareData($tableData->sale_agent, $tableData->clientid, 'invoice_merge_fields', $invoiceid, $paymentsID);
        $payment->invoice_data = $tableData;
        $pdf = payment_pdf($payment);
        $pdf->Output(FCPATH.'/uploads/whatsapp_api/payments/wa_payment_' . $paymentsID . '.pdf', 'F');

        $this->attachmentData = [
            "file_name" => _l('payment_for_the') . format_invoice_number($invoiceid) . ".pdf",
            "url" => base_url("uploads/whatsapp_api/payments/wa_payment_" . $paymentsID . ".pdf"),
        ];
        return ['status' => true];
    }

    public function ticket($ticketID)
    {
        $this->CI->load->model('tickets_model');
        $tableData       = $this->CI->tickets_model->get($ticketID);
        if(empty($tableData)){
            return ['status' => false, 'message'=>"Ticket Details not found!"];
        }
        $this->prepareData($tableData->assigned, $tableData->userid, 'ticket_merge_fields', "new-ticket-opened-admin", $ticketID);

        return ['status' => true];
    }

    public function secure_login($staffID)
    {
        $this->prepareData($staffID, null, 'staff_merge_fields', $staffID);

        return ['status' => true];
    }

    public function send_reminder_text_message($reminderID)
    {
        // Get reminder data
        $reminder_data = $this->staff_reminder($reminderID);
        if (!$reminder_data['status']) {
            return $reminder_data;
        }
        
        // Prepare the text message
        $staff_name = $this->merge_fields['{staff_firstname}'];
        $reminder_desc = $this->merge_fields['{reminder_description}'];
        $reminder_date = $this->merge_fields['{reminder_date}'];
        
        $message_text = "Hello {$staff_name},\n\nYou have a reminder due:\n📅 {$reminder_desc}\n🕐 Scheduled for: {$reminder_date}\n\n-- CRM Reminder System";
        
        // Prepare the send data for text message
        $this->send_data = [
            'messaging_product' => 'whatsapp',
            'recipient_type' => 'individual',
            'type' => 'text',
            'text' => ['body' => $message_text],
            'to' => $this->staff_to
        ];
        
        // Send the message
        $response = $this->send();
        
        // Log if debug mode is enabled
        $CI = &get_instance();
        $CI->load->model('whatsapp_api/whatsapp_api_model');
        
        // Check if debug mode is enabled for staff_reminder category
        $CI->db->where('category', 'staff_reminder');
        $template_mapping = $CI->db->get('whatsapp_templates_mapping')->row();
        
        if ($template_mapping && $template_mapping->debug_mode) {
            $log_data = $response;
            $log_data['send_json'] = json_encode($this->send_data);
            $log_data['message_category'] = 'staff_reminder';
            $log_data['category_params'] = json_encode([$reminderID]);
            $log_data['merge_field_data'] = json_encode($this->merge_fields);
            
            unset($log_data['cron_status']);
            unset($log_data['error_message']);
            
            $CI->whatsapp_api_model->add_request_log($log_data);
        }
        
        return $response;
    }
    public function lead_assigned($leadsID)
    {
        $this->CI->load->model('leads_model');
        $leadData = $this->CI->leads_model->get($leadsID);
        if(empty($leadData)){
            return ['status' => false, 'message'=>"Lead not found!"];
        }
        
        if(empty($leadData->assigned) || $leadData->assigned == 0){
            return ['status' => false, 'message'=>"Lead has no assigned staff member!"];
        }
        
        // Get assigned staff member data
        $this->CI->db->select('staffid, firstname, lastname, phonenumber, email');
        $this->CI->db->from(db_prefix() . 'staff');
        $this->CI->db->where('staffid', $leadData->assigned);
        $staffData = $this->CI->db->get()->row();
        
        if(empty($staffData)){
            return ['status' => false, 'message'=>"Assigned staff member not found!"];
        }
        
        if(empty($staffData->phonenumber)){
            return ['status' => false, 'message'=>"Assigned staff member has no phone number configured!"];
        }
        
        // Prepare merge fields combining lead and staff data
        $this->merge_fields = [
            '{lead_name}' => $leadData->name,
            '{lead_email}' => $leadData->email,
            '{lead_position}' => $leadData->title,
            '{lead_website}' => $leadData->website,
            '{lead_description}' => $leadData->description,
            '{lead_phonenumber}' => $leadData->phonenumber,
            '{lead_company}' => $leadData->company,
            '{lead_country}' => get_country_short_name($leadData->country),
            '{lead_zip}' => $leadData->zip,
            '{lead_city}' => $leadData->city,
            '{lead_state}' => $leadData->state,
            '{lead_address}' => $leadData->address,
            '{lead_assigned}' => get_staff_full_name($leadData->assigned),
            '{lead_status}' => $leadData->status,
            '{lead_source}' => $leadData->source,
            '{lead_dateadded}' => date('F j, Y g:i A', strtotime($leadData->dateadded)),
            '{lead_link}' => admin_url('leads/index/' . $leadsID),
            '{lead_public_form_url}' => leads_public_url($leadsID),
            '{staff_firstname}' => $staffData->firstname,
            '{staff_lastname}' => $staffData->lastname,
            '{staff_fullname}' => $staffData->firstname . ' ' . $staffData->lastname,
            '{staff_email}' => $staffData->email,
            '{assignment_date}' => date('F j, Y g:i A'),
            '{company_name}' => get_option('companyname')
        ];
        
        // Set the phone number for WhatsApp (send to assigned staff member)
        $this->staff_to = $staffData->phonenumber;
        $this->tableData = $staffData;

        return ['status' => true];
    }
}
