# Staff Reminders & Follow-ups Tracking Feature

## Overview
This feature tracks and reports on due reminders and missed follow-ups by staff member, integrated into the Reporting Dashboard module. It provides visibility into staff accountability and follow-up discipline.

## Features Implemented

### 1. **Backend Data Collection**
**File**: `modules/reporting_dashboard/models/Reporting_dashboard_model.php`

**New Method**: `get_staff_reminders_followups(array $filters = [])`

**What it does**:
- Fetches **overdue reminders** (reminders past due date, not dismissed)
- Fetches **upcoming reminders** (reminders due within next 7 days)
- Aggregates data by staff member
- Tracks:
  - Overdue reminder count per staff
  - Upcoming reminder count per staff
  - Oldest overdue reminder (days)
  - Individual reminder details (description, due date, lead info)

**Returns**:
```php
[
    'staff_summary' => [
        [
            'staff_id' => 1,
            'staff_name' => 'John Doe',
            'overdue_count' => 5,
            'upcoming_count' => 3,
            'oldest_overdue_days' => 12,
            'overdue_reminders' => [...],
            'upcoming_reminders' => [...]
        ],
        // ... more staff
    ],
    'totals' => [
        'total_overdue' => 25,
        'total_upcoming' => 18,
        'staff_with_overdue' => 4,
        'staff_with_upcoming' => 6
    ],
    'all_overdue_reminders' => [...],
    'all_upcoming_reminders' => [...],
    'generated_at' => '2025-11-15 18:30:00'
]
```

### 2. **API Endpoint**
**File**: `modules/reporting_dashboard/controllers/Reporting_dashboard.php`

**New Method**: `get_staff_reminders_followups()`

**URL**: `admin/reporting_dashboard/get_staff_reminders_followups`

**Method**: POST

**Parameters**:
- `staff` (optional): Array of staff IDs to filter

**Response**:
```json
{
    "success": true,
    "data": {
        "staff_summary": [...],
        "totals": {...}
    }
}
```

### 3. **Integration with Staff Report**
**File**: `modules/reporting_dashboard/controllers/Reporting_dashboard.php`

**Modified Method**: `generate_staff_report()`

Now includes reminders/followups data in the staff report:
```php
$remindersData = $this->reporting_dashboard_model->get_staff_reminders_followups($filters);
$summary['reminders_followups'] = $remindersData;
```

### 4. **AI Analysis Enhancement**
**File**: `modules/reporting_dashboard/libraries/Staff_report_service.php`

**Modified Methods**:
- `build_ai_prompt()` - Now includes reminder accountability data in the AI analysis prompt
- `format_whatsapp_message()` - Displays reminder status in WhatsApp reports

**AI Prompt Addition**:
```
Reminders & Follow-ups Status:
- Overdue reminders: X; Upcoming reminders (7 days): Y; Staff with overdue: Z

Staff Breakdown:
1. John Doe — activities: 100, calls: 50, ... overdue reminders: 5, upcoming: 3
```

**WhatsApp Message Addition**:
```
• Reminders: ⚠️ 25 overdue, 📅 18 upcoming (7d)

Staff breakdown:
• John Doe — 100 activities (5.00/day) • 50 calls (50.0%)
    ↳ Types: Phone Call 60, Message 30, Email 10
    ↳ Reminders: ⚠️ 5 overdue, 📅 3 due soon
    ↳ Shows high productivity...
```

### 5. **Dashboard UI Panel**
**File**: `modules/reporting_dashboard/views/dashboard.php`

**New Panel**: "Staff Reminders & Follow-ups Status"

**Features**:
- **Summary Cards** (4 KPIs):
  - Total Overdue Reminders (red/warning)
  - Total Upcoming Reminders (blue/info)
  - Staff with Overdue (red)
  - Staff with Upcoming (green)

- **Detailed Table**:
  - Staff Member name
  - Overdue count (badge)
  - Upcoming count (badge)
  - Oldest overdue (days)
  - "View Details" button (for future expansion)

- **Auto-refresh**: Loads automatically on dashboard load
- **Manual refresh**: Button to reload data

### 6. **JavaScript Functions**
**File**: `modules/reporting_dashboard/views/dashboard.php`

**New Functions**:
- `loadStaffRemindersStatus()` - Fetches and renders reminders data
- `renderStaffRemindersStatus(data)` - Renders the UI with summary cards and table
- `viewStaffRemindersDetail(staffId, staffName)` - Placeholder for future detailed view modal

## Data Flow

```
1. User opens Reporting Dashboard
   ↓
2. JavaScript auto-loads reminders after 1.5s delay
   ↓
3. AJAX call to: /reporting_dashboard/get_staff_reminders_followups
   ↓
4. Controller checks authentication & permissions
   ↓
5. Model queries:
   - tblreminders (overdue & upcoming)
   - Joins with tblstaff and tblleads
   - Aggregates by staff
   ↓
6. Returns JSON data to frontend
   ↓
7. JavaScript renders:
   - 4 summary KPI cards
   - Detailed staff table with badges
```

## Database Tables Used

### `tblreminders`
- `id` - Reminder ID
- `description` - Reminder description
- `date` - Due date/time
- `isnotified` - Status (0 = active, 1 = completed/dismissed)
- `staff` - Staff ID (FK to tblstaff)
- `rel_id` - Related lead ID
- `rel_type` - Type ('lead', etc.)

### `tblstaff`
- `staffid` - Staff ID
- `firstname` - First name
- `lastname` - Last name

### `tblleads`
- `id` - Lead ID
- `name` - Lead name
- `company` - Company name
- `phonenumber` - Phone
- `email` - Email

## Example Output

### Dashboard UI
```
┌─────────────────────────────────────────────────────────┐
│ 🔔 Staff Reminders & Follow-ups Status     [Refresh]   │
├─────────────────────────────────────────────────────────┤
│  ┌─────────┐ ┌─────────┐ ┌─────────┐ ┌─────────┐      │
│  │   25    │ │   18    │ │    4    │ │    6    │      │
│  │ Overdue │ │Upcoming │ │Staff w/ │ │Staff w/ │      │
│  │Reminders│ │ (7 days)│ │Overdue  │ │Upcoming │      │
│  └─────────┘ └─────────┘ └─────────┘ └─────────┘      │
│                                                          │
│  Staff Member   │ Overdue │ Upcoming │ Oldest │ Actions│
│  ──────────────┼─────────┼──────────┼────────┼────────│
│  John Doe       │   [5]   │   [3]    │ 12 days│ [View] │
│  Jane Smith     │   [0]   │   [5]    │   —    │ [View] │
│  Bob Johnson    │   [3]   │   [2]    │  7 days│ [View] │
└─────────────────────────────────────────────────────────┘
```

### WhatsApp Report
```
📞 Staff Activity Performance
📅 Period: Sep 16, 2025 - Nov 15, 2025
━━━━━━━━━━━━━━━━━━━━
• Total activities: 1725
• Phone/WA calls: 1173 (68.0%)
• Avg activities/staff: 431.25
• Activity Mix: Phone Call 1173, Message 409, WhatsApp 50
• Reminders: ⚠️ 25 overdue, 📅 18 upcoming (7d)
━━━━━━━━━━━━━━━━━━━━
🧠 AI Overview
High activity volume with concerning overdue reminders...

• Memoona Hussain — 664 activities (10.71/day) • 587 calls (88.4%)
    ↳ Types: Phone Call 587, Message 69, Email 8
    ↳ Reminders: ⚠️ 5 overdue, 📅 3 due soon
    ↳ Shows high productivity and lead engagement...
```

## Benefits

1. **Accountability**: Clear visibility of who has overdue follow-ups
2. **Proactive Management**: Identifies upcoming reminders to prevent delays
3. **Performance Insight**: AI analysis considers reminder discipline in staff evaluation
4. **Action-Oriented**: Highlights oldest overdue items for priority action
5. **Integration**: Seamlessly integrated into existing staff reports and WhatsApp delivery

## Future Enhancements

1. **Detailed Modal**: Clicking "View Details" shows full list of reminders with:
   - Lead name, company, phone
   - Reminder description
   - Days overdue/until due
   - Quick action buttons (mark complete, snooze)

2. **Reminder Dismissal**: Allow managers to dismiss reminders from dashboard

3. **Trend Analysis**: Track reminder completion rates over time

4. **Alerts**: Send notifications when overdue count exceeds threshold

5. **Filter Options**: Filter by reminder type, lead status, or date range

## Testing

1. **Manual Test**:
   - Open Reporting Dashboard
   - Wait for reminders panel to load
   - Verify KPI cards show correct counts
   - Check staff table displays properly
   - Generate staff report via WhatsApp
   - Verify reminder data appears in message

2. **API Test**:
   ```bash
   curl -X POST http://localhost/crm/admin/reporting_dashboard/get_staff_reminders_followups \
     -H "Content-Type: application/json" \
     -d '{"staff": [1, 2, 3]}'
   ```

3. **Browser Console**:
   - Check for `[Reminders]` log messages
   - Verify no JavaScript errors
   - Inspect network tab for API call

## Configuration

No additional configuration required. Uses existing:
- Database connection
- Staff permissions system
- WhatsApp API settings (from Autograph Feedback Insights)
- OpenAI API settings (for AI analysis)

## Files Modified

1. `modules/reporting_dashboard/models/Reporting_dashboard_model.php` - Added `get_staff_reminders_followups()` method
2. `modules/reporting_dashboard/controllers/Reporting_dashboard.php` - Added endpoint and integrated with staff report
3. `modules/reporting_dashboard/libraries/Staff_report_service.php` - Enhanced AI prompt and WhatsApp message formatting
4. `modules/reporting_dashboard/views/dashboard.php` - Added UI panel and JavaScript functions

## Version
- **Created**: November 15, 2025
- **Module Version**: 2.0.0
- **Compatible with**: Perfex CRM 3.0+




