# Staff Reminders Detail Modal

## Overview
Added a detailed modal view that shows all overdue and upcoming reminders for a specific staff member when clicking the "View Details" button.

## Features

### 1. **Modal View**
- **Trigger**: Click "View Details" button in the Staff Reminders table
- **Display**: Large modal with comprehensive reminder information
- **Auto-fetch**: Automatically loads reminder details via API

### 2. **Summary Cards**
Shows quick stats at the top:
- **Overdue Reminders**: Total count (red/warning style)
- **Upcoming Reminders**: Total count in next 7 days (blue/info style)

### 3. **Overdue Reminders Table**
Displays all overdue reminders with:
- ⚠️ **Due Date**: When it was due (in red)
- 📊 **Days Overdue**: Badge showing how many days late
- 👤 **Lead Info**: Lead name and company
- 📝 **Description**: Reminder description
- 🔗 **Action**: "View Lead" button (opens in new tab)

### 4. **Upcoming Reminders Table**
Displays all upcoming reminders (next 7 days) with:
- 📅 **Due Date**: When it's due (in blue)
- ⏰ **Days Until Due**: Badge showing time remaining
- 👤 **Lead Info**: Lead name and company
- 📝 **Description**: Reminder description
- 🔗 **Action**: "View Lead" button (opens in new tab)

### 5. **Empty State**
If staff has no reminders:
- ✅ Shows success message: "All caught up! No pending reminders for [Staff Name]."

## UI Layout

```
┌────────────────────────────────────────────────┐
│ 🔔 Reminders: Memoona Hussain              [×] │
├────────────────────────────────────────────────┤
│ ┌─────────────┐  ┌─────────────┐              │
│ │     5       │  │     3       │              │
│ │  Overdue    │  │  Upcoming   │              │
│ └─────────────┘  └─────────────┘              │
│                                                │
│ ⚠️ Overdue Reminders                          │
│ ┌──────────────────────────────────────────┐ │
│ │Due Date│Days│Lead│Description│Action│    │ │
│ ├────────┼────┼────┼───────────┼──────┤    │ │
│ │Nov 3   │ 12 │ABC│Follow up  │View  │    │ │
│ │Nov 5   │ 10 │XYZ│Call back  │View  │    │ │
│ └──────────────────────────────────────────┘ │
│                                                │
│ 📅 Upcoming Reminders (Next 7 Days)           │
│ ┌──────────────────────────────────────────┐ │
│ │Due Date│Days│Lead│Description│Action│    │ │
│ ├────────┼────┼────┼───────────┼──────┤    │ │
│ │Nov 16  │  1 │DEF│Site visit │View  │    │ │
│ │Nov 20  │  5 │GHI│Demo       │View  │    │ │
│ └──────────────────────────────────────────┘ │
│                                                │
│                                [Close]         │
└────────────────────────────────────────────────┘
```

## Implementation

### JavaScript Functions

#### 1. `viewStaffRemindersDetail(staffId, staffName)`
**Purpose**: Opens the modal and fetches reminder details for a specific staff member

**Workflow**:
1. Sets modal title to "Reminders: [Staff Name]"
2. Shows loading spinner
3. Opens modal
4. Fetches reminders via API (filters by staff ID)
5. Renders the detailed view

**API Call**:
```javascript
POST /admin/reporting_dashboard/get_staff_reminders_followups
Body: { "staff": [staffId] }
```

#### 2. `renderDetailedReminders(staffData, staffName)`
**Purpose**: Renders the reminder details in the modal

**Features**:
- Creates summary cards
- Builds two separate tables (overdue vs upcoming)
- Handles empty states
- Formats dates/times nicely
- Adds "View Lead" links

#### 3. `formatDateTime(dateString)`
**Purpose**: Formats date strings to user-friendly format

**Output**: `11/15/2025 2:30 PM`

### Modal HTML Structure

**Modal ID**: `staffRemindersDetailModal`

**Key Elements**:
- `staff-reminders-modal-title`: Modal title (updated dynamically)
- `staff-reminders-modal-body`: Main content area

## Data Structure

### API Response (for single staff):
```json
{
  "success": true,
  "data": {
    "staff_summary": [{
      "staff_id": 8,
      "staff_name": "Memoona Hussain",
      "overdue_count": 5,
      "upcoming_count": 3,
      "oldest_overdue_days": 12,
      "overdue_reminders": [
        {
          "reminder_id": 123,
          "description": "Follow up on proposal",
          "due_date": "2025-11-03 10:00:00",
          "days_overdue": 12,
          "lead_name": "ABC Company",
          "lead_company": "ABC Corp",
          "lead_phone": "+1234567890",
          "lead_id": 456
        }
      ],
      "upcoming_reminders": [
        {
          "reminder_id": 124,
          "description": "Site visit scheduled",
          "due_date": "2025-11-16 14:00:00",
          "days_until_due": 1,
          "lead_name": "XYZ Industries",
          "lead_company": "XYZ Ltd",
          "lead_phone": "+9876543210",
          "lead_id": 789
        }
      ]
    }]
  }
}
```

## Usage

### For End Users:
1. Go to **Reporting Dashboard**
2. Scroll to **"Staff Reminders & Follow-ups Status"** panel
3. Look at the staff table
4. Click **"View Details"** button for any staff member
5. Modal opens showing all their reminders
6. Click **"View Lead"** to jump to the lead details
7. Click **"Close"** to exit modal

### For Developers:
```javascript
// Programmatically open the modal
viewStaffRemindersDetail(8, 'Memoona Hussain');

// The modal will:
// 1. Open immediately
// 2. Fetch data from API
// 3. Render results
```

## Styling

- **Overdue items**: Red text and badges
- **Upcoming items**: Blue text and badges
- **Success message**: Green alert box
- **Tables**: Bootstrap striped and bordered
- **Modal size**: Large (`modal-lg`)

## Benefits

1. **Quick Access**: No need to navigate to leads to see reminders
2. **Staff Accountability**: See exactly what's overdue and upcoming
3. **Contextual**: Shows lead info without leaving the dashboard
4. **Action-Oriented**: Direct link to lead details
5. **Visual Priority**: Color-coded by urgency

## Future Enhancements

Potential additions:
1. ✨ **Mark as Complete**: Button to mark reminders as done
2. 📧 **Send Reminder Email**: Notify staff about overdue items
3. 📊 **Export to Excel**: Download reminder list
4. 🔔 **Snooze Reminder**: Reschedule due date
5. 📝 **Add Note**: Quick note on reminder
6. 🔄 **Auto-refresh**: Real-time updates
7. 🎨 **Priority Levels**: Color code by importance

## Files Modified

1. ✅ `modules/reporting_dashboard/views/dashboard.php`
   - Added modal HTML structure
   - Implemented `viewStaffRemindersDetail()` function
   - Implemented `renderDetailedReminders()` function
   - Implemented `formatDateTime()` helper

## Testing

### Test Cases:

1. **Staff with overdue reminders**:
   - ✅ Click "View Details"
   - ✅ Modal opens
   - ✅ Shows overdue count in summary
   - ✅ Displays overdue table
   - ✅ Days overdue is accurate

2. **Staff with upcoming reminders**:
   - ✅ Shows upcoming count in summary
   - ✅ Displays upcoming table
   - ✅ Days until due is accurate

3. **Staff with no reminders**:
   - ✅ Shows success message
   - ✅ No tables displayed

4. **View Lead button**:
   - ✅ Opens lead in new tab
   - ✅ Correct lead ID in URL

5. **Date formatting**:
   - ✅ Shows readable date/time format
   - ✅ Handles different timezones correctly

### Browser Console Check:
```javascript
// Should see these logs when clicking "View Details":
[Reminders] Opening detail modal for staff: 8 Memoona Hussain
[Reminders] Response status: 200
[Reminders] Data received: {...}
```

## Version
- **Created**: November 15, 2025
- **Module Version**: 2.0.0
- **Status**: ✅ Ready for use

---

**Note**: This feature complements the staff reminders summary panel by providing drill-down details for each staff member.




