<?php

defined('BASEPATH') or exit('No direct script access allowed');

// Register menu items on admin initialization
hooks()->add_action('admin_init', function () {
    $CI = &get_instance();

    // Only show to logged in staff
    if (!is_staff_logged_in()) {
        return;
    }

    // Add main Autograph Insights menu item (independent, after Reports at position 60)
    $CI->app_menu->add_sidebar_menu_item('autograph_insights', [
        'collapse' => true,
        'name'     => 'Autograph Insights',
        'icon'     => 'fa fa-chart-bar',
        'position' => 61,
    ]);
    
    // Add Dashboard submenu item
    $CI->app_menu->add_sidebar_children_item('autograph_insights', [
        'slug'     => 'autograph_insights_dashboard',
        'name'     => 'Dashboard', 
        'href'     => admin_url('autograph_feedback_insights'),
        'position' => 1,
        'icon'     => 'fa fa-tachometer-alt',
    ]);
    
    // Add Automated Schedules submenu
    $CI->app_menu->add_sidebar_children_item('autograph_insights', [
        'slug'     => 'autograph_insights_schedules',
        'name'     => 'Automated Schedules', 
        'href'     => admin_url('autograph_feedback_insights/schedules'),
        'position' => 2,
        'icon'     => 'fa fa-clock-o',
    ]);
});
