# Autograph Feedback Insights Module

A Perfex CRM module that analyzes customer feedback from lead notes about Autograph Serviced Apartments using OpenAI API to generate sentiment and market narrative reports.

## Features

- **Automatic Note Collection**: Fetches all lead notes containing "Autograph" from the `tbllead_notes` table
- **Text Cleaning**: Removes HTML tags, normalizes whitespace, and groups notes by Lead ID
- **OpenAI Integration**: Uses GPT-4/5 to analyze sentiment and generate insights
- **Sentiment Analysis**: Provides sentiment scores (Positive/Neutral/Negative)
- **Market Insights**: Generates market narrative, highlights, concerns, and action suggestions
- **Automated Reports**: Optional cron job to re-analyze every 6 hours
- **Admin Dashboard**: Clean, responsive interface under Sales → Autograph Insights

## Installation

1. Upload the `AutographFeedbackInsights` folder to your Perfex CRM `modules/` directory
2. Go to Perfex CRM Admin → Setup → Modules
3. Find "Autograph Feedback Insights" and click "Activate"
4. Configure your OpenAI API key in the module settings

## Configuration

1. Navigate to **Sales → Autograph Insights**
2. Enter your OpenAI API key (starts with `sk-`)
3. Select your preferred OpenAI model (GPT-4, GPT-4 Turbo, or GPT-3.5 Turbo)
4. Optionally enable automatic analysis every 6 hours
5. Click "Save Settings"

## Usage

### Manual Analysis

1. Go to **Sales → Autograph Insights**
2. Click "Run Analysis Now"
3. Wait for the analysis to complete (this may take a few moments)
4. View the generated report with sentiment, highlights, concerns, and suggestions

### Automated Analysis (Cron Job)

To run automatic analysis every 6 hours:

1. Enable "Automatic Analysis" in module settings
2. Add the following to your crontab:

```bash
0 */6 * * * /usr/bin/php /path/to/crm/index.php autograph_feedback_insights cron run_analysis
```

Or access via URL:
```
https://yourdomain.com/admin/autograph_feedback_insights/cron/run_analysis
```

## Database Tables

The module creates two tables:

- `tblautograph_feedback_report` - Stores analysis reports
- `tblautograph_feedback_settings` - Stores module settings

## Report Structure

Each report includes:

- **Sentiment**: Overall sentiment (Positive/Neutral/Negative)
- **Sentiment Score**: Numerical score (0.0 to 1.0)
- **Summary**: Brief summary of overall feedback
- **Positive Highlights**: List of things customers liked
- **Negative Concerns**: List of customer objections/concerns
- **Market Narrative**: How customers perceive Autograph Serviced Apartments
- **Action Suggestions**: Recommendations to improve messaging and close rates

## Requirements

- Perfex CRM 3.0 or higher
- PHP 7.4 or higher
- cURL extension enabled
- Valid OpenAI API key
- Internet connection for API calls

## Permissions

The module uses the following permission:
- `autograph_feedback_insights` - View and edit access

By default, admins have full access. You can configure permissions via:
**Setup → Staff → Permissions**

## Troubleshooting

### No notes found
- Ensure you have lead notes in `tbllead_notes` that contain the word "autograph" (case-insensitive)
- Check that notes have non-empty `description` fields

### OpenAI API errors
- Verify your API key is correct and has sufficient credits
- Check your internet connection
- Ensure the selected model is available in your OpenAI account

### Analysis fails
- Check that you have notes related to Autograph Serviced Apartments
- Verify the OpenAI API response format hasn't changed
- Check PHP error logs for detailed error messages

## Support

For issues or questions, please contact your system administrator or refer to the Perfex CRM documentation.

## License

This module follows Perfex CRM's licensing terms.

