# Autograph Feedback Insights - Quick Start Guide

## 🎯 Installation (1 Minute)

### For cPanel:
1. Upload `autograph_feedback_insights` folder to `public_html/modules/`
2. Login to Perfex CRM Admin
3. Go to **Setup → Modules**
4. Click **Activate** on "Autograph Feedback Insights"
5. ✅ Done! All tables created automatically!

### For Local/XAMPP:
1. Copy `autograph_feedback_insights` folder to `htdocs/crm/modules/`
2. Login to Perfex CRM Admin
3. Go to **Setup → Modules**
4. Click **Activate** on "Autograph Feedback Insights"
5. ✅ Done! All tables created automatically!

## ⚙️ Configuration (2 Minutes)

1. Find **"Autograph Insights"** in sidebar menu
2. Click **Dashboard**
3. Enter **OpenAI API Key** (get from https://platform.openai.com/api-keys)
4. Select **GPT-4 Turbo** (recommended for large datasets)
5. Optionally add **WhatsApp Phone Number** (with country code: +971...)
6. Click **Save Settings**

## 🚀 First Analysis (1 Minute)

1. On Dashboard, click **Run Analysis Now**
2. Wait 10-30 seconds for AI analysis
3. View results:
   - Overall Sentiment (Positive/Neutral/Negative)
   - Key Positive Highlights
   - Key Concerns/Objections
   - Market Narrative
   - Action Suggestions

## 📊 View Reports

- Scroll down to **Previous Reports History**
- Click **View** to see full report
- Click **PDF** to download
- Click **WhatsApp** to send (if configured)

## ⏰ Setup Automation (5 Minutes)

1. Go to **Autograph Insights → Automated Schedules**
2. Click **New Schedule**
3. Configure:
   - **Name**: "Daily Dealer Report"
   - **Status Filter**: Select statuses (e.g., Dealer, Customer)
   - **Date Range**: Last 7 Days
   - **Frequency**: Daily
   - **Time**: 09:00
   - **WhatsApp Numbers**: (one per line)
     ```
     +971501234567
     +971509876543
     ```
4. Check **Enable this schedule**
5. Click **Save Schedule**

## 🔄 Enable Cron Job

**For cPanel:**
1. Go to **Cron Jobs** in cPanel
2. Add:
   ```
   0 * * * * /usr/bin/php /home/username/public_html/index.php autograph_feedback_insights cron execute_schedules
   ```

**For XAMPP (Windows Task Scheduler):**
1. Open Task Scheduler
2. Create Basic Task
3. Trigger: Hourly
4. Action: Start program
5. Program: `php.exe`
6. Arguments: `C:\xampp\htdocs\crm\index.php autograph_feedback_insights cron execute_schedules`

## 📱 WhatsApp Setup (Optional)

**Requirements:**
- WhatsApp Cloud API Business Integration module installed
- Business Account ID and Access Token configured

**In Module:**
- Enter WhatsApp phone number in settings
- Click WhatsApp button on any report to send

## ✨ What You Get

### Immediate Features:
✅ AI-powered sentiment analysis
✅ Customer feedback insights
✅ Market narrative generation
✅ Action suggestions
✅ PDF export
✅ Report history

### With Automation:
✅ Daily/Weekly/Monthly reports
✅ Status-based filtering
✅ Date range filtering
✅ Multi-recipient WhatsApp delivery
✅ Set and forget automation

## 🎓 Example Use Cases

**Use Case 1: Daily Dealer Insights**
- Filter: Dealer status leads
- Range: Last 7 days
- Schedule: Daily at 9 AM
- Send to: Sales team

**Use Case 2: Weekly Customer Feedback**
- Filter: Customer, Won status
- Range: Last 30 days
- Schedule: Every Monday 10 AM
- Send to: Management

**Use Case 3: Monthly Lost Lead Analysis**
- Filter: Lost, Junk status
- Range: Last month
- Schedule: 1st of month, 8 AM
- Send to: Strategy team

## 🔑 Key Points

- **Zero Manual SQL**: All tables auto-create on activation
- **No Code Changes**: Upload and activate
- **Self-Contained**: Everything included
- **Production Ready**: Error handling, logging
- **Scalable**: Handles 200+ notes per analysis
- **Flexible**: Multiple schedules, filters, recipients

## 📞 Getting Help

**Check:**
1. OpenAI API key is valid and has credits
2. WhatsApp API module is configured (if using WhatsApp)
3. Cron job is set up (if using automation)
4. PHP 7.4+ and cURL are enabled

**Common Issues:**
- **404 Error**: Deactivate and reactivate module
- **No Data**: Check lead status filter and date range
- **OpenAI Error**: Verify API key and model selection
- **WhatsApp Fails**: Check Phone Number ID in WhatsApp settings

## 🎉 You're Ready!

The module is fully automated and ready to deliver customer insights via AI-powered sentiment analysis!

**Total Setup Time: 5-10 minutes**
**Ongoing Maintenance: Zero (fully automated)**


