# Autograph Feedback Insights Module - Complete Feature Summary

## 🎯 Main Features

### 1. **Sentiment Analysis Dashboard**
- Analyzes customer feedback from lead notes
- Uses OpenAI GPT-4/Turbo for AI-powered insights
- Generates sentiment scores, highlights, concerns, and action suggestions
- Clean, responsive admin interface

### 2. **Advanced Filtering**
- **Status-Based Filtering**: Select specific lead statuses to analyze
- **Date Range Filtering**: Analyze notes from specific time periods
- **Smart Logic**: 
  - With status: Analyzes ALL notes from those leads
  - Without status: Analyzes only "Autograph" mentions from all leads

### 3. **Report History & Management**
- All reports saved permanently in database
- View up to 20 previous reports
- Track sentiment trends over time
- Compare different time periods

### 4. **PDF Export**
- Professional PDF reports with color-coding
- Includes all analysis sections
- Downloadable for offline sharing
- Format: `Autograph_Insights_Report_YYYY-MM-DD.pdf`

### 5. **WhatsApp Integration**
- Send reports directly to WhatsApp numbers
- Beautifully formatted with emojis
- Character limit handling (4096 chars)
- Supports WhatsApp Cloud API Business Integration

### 6. **Automated Scheduling System** ⭐ NEW
- Create unlimited automated report schedules
- Each schedule can have:
  - **Custom Status Filter**: Different lead statuses per schedule
  - **Date Range**: Last 7/30/90 days, This/Last month, or custom range
  - **Frequency**: Daily, Weekly, or Monthly
  - **Specific Time**: Choose exact time to send
  - **Multiple Recipients**: Send to multiple WhatsApp numbers
  - **Active/Inactive Toggle**: Enable/disable schedules

## 📁 Module Structure

```
modules/autograph_feedback_insights/
├── autograph_feedback_insights.php    # Main module file
├── install.php                        # Installation script
├── uninstall.php                      # Cleanup script
├── config/config.php                  # Module configuration
├── controllers/
│   ├── Autograph_feedback_insights.php  # Main controller
│   └── Cron.php                         # Cron job controller
├── models/
│   └── Autograph_feedback_insights_model.php  # Business logic
├── views/
│   ├── insights.php                   # Dashboard view
│   ├── schedules.php                  # Schedules management
│   └── view_report.php                # Individual report view
├── language/english/
│   └── autograph_feedback_insights_lang.php
└── Documentation/
    ├── README.md
    ├── INSTALLATION.md
    ├── AUTOMATED_SCHEDULES_GUIDE.md
    └── COMPLETE_SETUP.sql
```

## 🗄️ Database Tables

### 1. `tblautograph_feedback_report`
Stores all generated reports with sentiment analysis

### 2. `tblautograph_feedback_settings`
Stores module configuration (OpenAI key, filters, etc.)

### 3. `tblautograph_feedback_schedules` ⭐
Stores automated schedule configurations

## 🔧 Setup Instructions

### Step 1: Install Module
1. Upload to `modules/autograph_feedback_insights/`
2. Run SQL: `COMPLETE_SETUP.sql`
3. Activate in Setup → Modules

### Step 2: Configure OpenAI
1. Go to Autograph Insights → Dashboard
2. Enter OpenAI API key
3. Select model (GPT-4 Turbo recommended)
4. Save settings

### Step 3: Configure WhatsApp (Optional)
1. Ensure WhatsApp API module is configured
2. Enter WhatsApp phone number in module settings
3. Test by sending a manual report

### Step 4: Create Automated Schedules (Optional)
1. Go to Autograph Insights → Automated Schedules
2. Click "New Schedule"
3. Configure filters, time, and recipients
4. Save and enable

### Step 5: Setup Cron Job
Add to crontab:
```bash
0 * * * * /usr/bin/php /path/to/crm/index.php autograph_feedback_insights cron execute_schedules
```

## 📊 Usage Examples

### Example 1: Manual Analysis
1. Select lead status filter (optional)
2. Click "Run Analysis Now"
3. View results on dashboard
4. Export PDF or send to WhatsApp

### Example 2: Daily Dealer Report
- **Schedule**: Daily at 9 AM
- **Status**: Dealer, Interested Dealer
- **Date Range**: Last 7 Days
- **Recipients**: Sales team WhatsApp numbers
- **Result**: Automated daily insights about dealer leads

### Example 3: Monthly Customer Feedback
- **Schedule**: Monthly on 1st at 10 AM
- **Status**: Customer, Won
- **Date Range**: Last Month
- **Recipients**: Management WhatsApp numbers
- **Result**: Monthly customer sentiment trends

## 🎨 Menu Structure

```
Autograph Insights (Sidebar Menu)
├── Dashboard (Main analysis page)
└── Automated Schedules (Schedule management)
```

## 🔐 Permissions

- Uses `autograph_feedback_insights` permission
- Admins have full access by default
- Configure in Setup → Staff → Permissions

## 🚀 Key Capabilities

✅ OpenAI GPT-4 Turbo integration (128k tokens)
✅ Smart text truncation (handles 200+ notes)
✅ Multi-status filtering
✅ Date range filtering
✅ Unlimited report history
✅ PDF export with professional formatting
✅ WhatsApp integration with emoji formatting
✅ Multi-recipient scheduling
✅ Daily/Weekly/Monthly automation
✅ Responsive Bootstrap UI

## 📞 Support & Requirements

**Requirements:**
- Perfex CRM 3.0+
- PHP 7.4+
- cURL enabled
- OpenAI API key
- WhatsApp API module (for WhatsApp features)

**Support:**
- Comprehensive documentation included
- SQL setup scripts provided
- Error handling and logging
- User-friendly interface

## 🎉 Summary

A complete, production-ready Perfex CRM module that:
- Collects lead notes from database
- Analyzes customer sentiment using AI
- Generates actionable business insights
- Exports professional reports
- Sends automated WhatsApp notifications
- Tracks historical trends

Perfect for understanding customer perception of Autograph Serviced Apartments and improving sales messaging!




