# Autograph Feedback Insights - Installation Guide

## Quick Start

1. **Upload Module**: Ensure the `AutographFeedbackInsights` folder is in your Perfex CRM `modules/` directory

2. **Activate Module**:
   - Login to Perfex CRM Admin Panel
   - Navigate to **Setup → Modules**
   - Find "Autograph Feedback Insights"
   - Click **Activate**

3. **Configure Settings**:
   - Navigate to **Sales → Autograph Insights**
   - Enter your OpenAI API Key (starts with `sk-`)
   - Select your preferred model (GPT-4 recommended)
   - Optionally enable automatic analysis every 6 hours
   - Click **Save Settings**

4. **Run Analysis**:
   - Click **Run Analysis Now** button
   - Wait for analysis to complete
   - View the generated report

## Database Tables Created

The module creates two tables during installation:

1. **tblautograph_feedback_report**: Stores analysis reports
   - `id`: Primary key
   - `sentiment`: Overall sentiment (positive/neutral/negative)
   - `sentiment_score`: Numerical score (0.0 to 1.0)
   - `summary`: Brief summary
   - `positive_highlights`: JSON array of positive points
   - `negative_concerns`: JSON array of concerns
   - `market_narrative`: Market perception text
   - `action_suggestions`: JSON array of suggestions
   - `notes_analyzed`: Number of notes analyzed
   - `leads_analyzed`: Number of leads analyzed
   - `analysis_date`: When analysis was run
   - `created_at`, `updated_at`: Timestamps

2. **tblautograph_feedback_settings**: Stores module settings
   - `id`: Primary key
   - `setting_name`: Setting identifier
   - `setting_value`: Setting value
   - `updated_at`: Last update timestamp

## Cron Job Setup

To enable automatic analysis every 6 hours:

### Option 1: Via URL (Easiest)
Use a cron job service or scheduled task to call:
```
https://yourdomain.com/admin/autograph_feedback_insights/cron/run_analysis
```

### Option 2: Via Command Line
Add to your server's crontab:
```bash
0 */6 * * * /usr/bin/php /path/to/crm/index.php autograph_feedback_insights cron run_analysis
```

### Windows Task Scheduler
1. Open Task Scheduler
2. Create Basic Task
3. Set trigger: Every 6 hours
4. Action: Start a program
5. Program: `php.exe`
6. Arguments: `C:\xampp\htdocs\crm\index.php autograph_feedback_insights cron run_analysis`
7. Start in: `C:\xampp\htdocs\crm`

## Permissions

The module requires the permission `autograph_feedback_insights` to view/edit.

To configure permissions:
1. Go to **Setup → Staff → Permissions**
2. Select a role or staff member
3. Find "Autograph Feedback Insights"
4. Enable View and/or Edit permissions

**Note**: Admins have full access by default.

## Requirements

- Perfex CRM 3.0 or higher
- PHP 7.4 or higher
- cURL extension enabled
- Valid OpenAI API key with sufficient credits
- Internet connection for API calls

## Troubleshooting

### Module doesn't appear in menu
- Ensure module is activated in Setup → Modules
- Check that you have permissions: `autograph_feedback_insights` or are an admin
- Clear Perfex CRM cache

### No notes found
- Verify you have lead notes in `tbllead_notes` table
- Check that notes contain the word "autograph" (case-insensitive)
- Ensure notes have non-empty `description` fields

### OpenAI API errors
- Verify API key is correct and has credits
- Check internet connection
- Ensure selected model is available in your OpenAI account
- Check PHP error logs for detailed errors

### Analysis fails
- Check that you have notes related to Autograph Serviced Apartments
- Verify OpenAI API response format
- Check PHP error logs
- Ensure database tables were created correctly

## Uninstallation

To uninstall the module:
1. Go to **Setup → Modules**
2. Find "Autograph Feedback Insights"
3. Click **Deactivate**

**Note**: The uninstall script does NOT drop database tables by default to preserve data. If you want to remove all data, edit `uninstall.php` and uncomment the table drop statements.

## Support

For issues or questions:
1. Check PHP error logs
2. Check Perfex CRM logs
3. Verify OpenAI API key and credits
4. Contact your system administrator

