# Automated Report Schedules - Setup Guide

## Overview

The Automated Schedules feature allows you to create multiple report templates that run automatically and send results to WhatsApp numbers at scheduled times.

## Database Setup

**1. Create the schedules table:**

Run this SQL in phpMyAdmin:

```sql
CREATE TABLE IF NOT EXISTS `tblautograph_feedback_schedules` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `schedule_name` varchar(255) NOT NULL,
    `status_filter` text COMMENT 'JSON array of status IDs to filter',
    `date_range_type` enum('last_7_days','last_30_days','last_90_days','this_month','last_month','custom') DEFAULT 'last_7_days',
    `custom_start_date` date DEFAULT NULL,
    `custom_end_date` date DEFAULT NULL,
    `schedule_time` time NOT NULL COMMENT 'Time to send report (HH:MM:SS)',
    `schedule_frequency` enum('daily','weekly','monthly') DEFAULT 'daily',
    `schedule_day` int(2) DEFAULT NULL COMMENT 'Day of week (1-7) for weekly, day of month (1-31) for monthly',
    `whatsapp_numbers` text NOT NULL COMMENT 'JSON array of phone numbers',
    `active` tinyint(1) DEFAULT 1,
    `last_run` datetime DEFAULT NULL,
    `next_run` datetime DEFAULT NULL,
    `created_at` datetime NOT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `active` (`active`),
    KEY `next_run` (`next_run`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
```

**2. Add WhatsApp phone setting:**

```sql
INSERT INTO `tblautograph_feedback_settings` (`setting_name`, `setting_value`, `updated_at`) 
VALUES ('whatsapp_phone', '', NOW())
ON DUPLICATE KEY UPDATE `updated_at` = NOW();
```

## Features

### 1. **Multiple Schedule Templates**
Create unlimited automated report schedules with different configurations

### 2. **Status Filtering**
- Select specific lead statuses (e.g., "Dealer", "Customer", "Lost")
- Filter notes by leads with those statuses
- Each schedule can have its own status filter

### 3. **Date Range Options**
- **Last 7 Days** - Recent customer feedback
- **Last 30 Days** - Monthly overview
- **Last 90 Days** - Quarterly insights
- **This Month** - Current month data
- **Last Month** - Previous month report
- **Custom Range** - Pick specific start/end dates

### 4. **Flexible Scheduling**
- **Daily** - Run every day at specified time
- **Weekly** - Run on specific day of week (Monday-Sunday)
- **Monthly** - Run on specific day of month (1-31)

### 5. **Multiple Recipients**
- Add multiple WhatsApp numbers (one per line)
- Send the same report to all recipients
- Different schedules can have different recipients

## How to Create a Schedule

1. Go to **Autograph Insights → Automated Schedules**
2. Click **"New Schedule"** button
3. Fill in the form:
   - **Schedule Name**: e.g., "Weekly Dealer Status Report"
   - **Status Filter**: Select one or more lead statuses
   - **Date Range**: Choose how far back to analyze notes
   - **Frequency**: Daily/Weekly/Monthly
   - **Day**: (For weekly/monthly only)
   - **Time**: What time to send the report
   - **WhatsApp Numbers**: Add phone numbers (one per line with country code)
   - **Enable**: Check to activate the schedule
4. Click **"Save Schedule"**

## Example Schedules

### Example 1: Daily Dealer Status Report
- **Name**: Daily Dealer Status Report
- **Status Filter**: Dealer, Interested Dealer
- **Date Range**: Last 7 Days
- **Frequency**: Daily
- **Time**: 09:00 AM
- **Recipients**: +971501234567, +971509876543

### Example 2: Weekly Customer Feedback Summary
- **Name**: Weekly Customer Feedback
- **Status Filter**: Customer, Won
- **Date Range**: Last 30 Days
- **Frequency**: Weekly
- **Day**: Monday
- **Time**: 10:00 AM
- **Recipients**: +971501111111

### Example 3: Monthly Lost Leads Analysis
- **Name**: Monthly Lost Leads Analysis
- **Status Filter**: Lost, Junk
- **Date Range**: Last Month
- **Frequency**: Monthly
- **Day**: 1st (of each month)
- **Time**: 08:00 AM
- **Recipients**: +971502222222, +971503333333

## Cron Job Setup

To enable automated execution, add this to your server's crontab:

```bash
# Run every hour to check for due schedules
0 * * * * /usr/bin/php /path/to/crm/index.php autograph_feedback_insights cron execute_schedules
```

**Or via URL:**
```
https://yourdomain.com/admin/autograph_feedback_insights/cron/execute_schedules
```

**Windows Task Scheduler:**
- Frequency: Hourly
- Action: Start a program
- Program: `php.exe`
- Arguments: `C:\xampp\htdocs\crm\index.php autograph_feedback_insights cron execute_schedules`

## What Happens When Schedule Runs

1. ✅ System checks for schedules due to run
2. ✅ Fetches notes based on status filter and date range
3. ✅ Sends notes to OpenAI for sentiment analysis
4. ✅ Generates report and saves to database
5. ✅ Formats report for WhatsApp (with emojis and formatting)
6. ✅ Sends to all configured WhatsApp numbers
7. ✅ Updates "Last Run" and calculates "Next Run" time
8. ✅ Schedule automatically repeats based on frequency

## WhatsApp Message Format

Reports sent via WhatsApp include:
- 📊 Title and date
- 😊 Sentiment with emoji
- 📈 Sentiment score
- 📋 Summary
- ✅ Top 5 positive highlights
- ⚠️ Top 5 concerns
- 💡 Top 3 action suggestions

## Managing Schedules

### Edit Schedule
1. Go to Automated Schedules page
2. Click pencil icon on any schedule
3. Modify settings
4. Click "Save Schedule"

### Delete Schedule
1. Click trash icon on any schedule
2. Confirm deletion

### Activate/Deactivate
- Edit the schedule
- Check/uncheck "Enable this schedule"
- Save

## Troubleshooting

### Schedules not running
- Check cron job is configured
- Verify schedule is set to "Active"
- Check "Next Run" time is in the future
- Verify OpenAI API key is configured
- Check WhatsApp API module is configured

### WhatsApp messages not sending
- Verify WhatsApp API module is active
- Check Phone Number ID and Access Token in WhatsApp settings
- Verify phone numbers include country code (+971...)
- Check WhatsApp API has credits/permissions

### No data in report
- Check date range isn't too narrow
- Verify leads exist with selected statuses
- Check leads have notes in the date range
- Try wider date range or different statuses

## Best Practices

1. **Test First**: Create a daily schedule to yourself first to test
2. **Stagger Times**: Don't schedule all reports at the same time
3. **Date Ranges**: Use appropriate ranges (Last 7 days for daily, Last 30 for weekly)
4. **Recipients**: Add multiple stakeholders to keep everyone informed
5. **Status Grouping**: Create separate schedules for different lead types

## Requirements

- ✅ Autograph Feedback Insights module installed
- ✅ OpenAI API key configured
- ✅ WhatsApp API module installed and configured
- ✅ Cron job configured (hourly recommended)
- ✅ Schedules table created




