<?php
echo "<h1>Server Cache Status</h1>";

echo "<h2>OPcache Status:</h2>";
if (function_exists('opcache_get_status')) {
    $opcache_status = opcache_get_status();
    if ($opcache_status['opcache_enabled']) {
        echo "<p style='color: red; font-weight: bold;'>⚠️ OPcache is ENABLED - This could be caching PHP files!</p>";
        echo "<p>OPcache Settings:</p>";
        echo "<pre>" . print_r($opcache_status, true) . "</pre>";
        
        // Try to clear OPcache
        if (function_exists('opcache_reset')) {
            opcache_reset();
            echo "<p style='color: green; font-weight: bold;'>✅ OPcache has been reset!</p>";
        }
    } else {
        echo "<p style='color: green;'>✅ OPcache is disabled</p>";
    }
} else {
    echo "<p>OPcache functions not available</p>";
}

echo "<h2>File Info:</h2>";
$template_file = 'application/views/admin/leads/_notes_template.php';
if (file_exists($template_file)) {
    echo "<p>✅ Template file exists</p>";
    echo "<p>File modified: " . date('Y-m-d H:i:s', filemtime($template_file)) . "</p>";
    echo "<p>File size: " . filesize($template_file) . " bytes</p>";
    echo "<p>File permissions: " . substr(sprintf('%o', fileperms($template_file)), -4) . "</p>";
} else {
    echo "<p style='color: red;'>❌ Template file not found!</p>";
}

echo "<h2>Current Time:</h2>";
echo "<p>" . date('Y-m-d H:i:s') . "</p>";

phpinfo();
?>
