<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<!-- Include custom CSS fix -->
<link href="<?php echo base_url('assets/css/followup_types_fix.css'); ?>" rel="stylesheet" type="text/css" />
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="tw-mb-2 sm:tw-mb-4">
                    <a href="#" class="btn btn-primary" data-toggle="modal" data-target="#followup-type-modal">
                        <i class="fa fa-plus"></i> <?php echo _l('new_followup_type'); ?>
                    </a>
                </div>                
                <div class="panel_s">
                    <div class="panel-body">                        <!-- CSS FIX: Force styles for visibility -->
                        <style>
                            /* Super-strong CSS selectors to override any other styling */
                            .table-followup-types tr, 
                            .table-followup-types td, 
                            .table-followup-types th,
                            #followup-types-table tr,
                            #followup-types-table td,
                            #followup-types-table th,
                            body #wrapper .content .table-followup-types tr,
                            body #wrapper .content .table-followup-types td,
                            body #wrapper .content .table-followup-types th {
                                visibility: visible !important;
                                display: table-cell !important;
                                color: #333 !important;
                                background-color: #fff !important;
                                border: 1px solid #ddd !important;
                                text-shadow: none !important;
                            }
                            
                            .table-followup-types tr,
                            #followup-types-table tr,
                            table.dataTable tbody tr,
                            body #wrapper .content .table-followup-types tr {
                                display: table-row !important;
                                visibility: visible !important;
                                opacity: 1 !important;
                            }
                            
                            .table-followup-types thead th,
                            #followup-types-table thead th {
                                background-color: #f0f0f0 !important;
                                font-weight: bold !important;
                            }
                            
                            /* Fix for buttons */
                            .table-followup-types .btn {
                                margin: 2px !important;
                                float: none !important;
                                display: inline-block !important;
                            }
                            
                            /* Ensure proper table layout */
                            .table-followup-types {
                                max-width: 100% !important;
                                table-layout: fixed !important;
                                border-collapse: separate !important;
                                border-spacing: 0 !important;
                            }
                            
                            /* Add clear markings to see table boundaries */
                            .table-container {
                                border: 2px solid blue !important;
                                padding: 10px !important;
                                margin-bottom: 20px !important;
                            }
                        </style>
                        
                        <!-- Table container with visual boundaries -->
                        <div class="table-container">
                        
                        <div class="table-responsive">
                            <table class="table table-bordered table-followup-types" id="followup-types-table">
                                <thead>
                                    <tr>
                                        <th><?php echo _l('followup_type'); ?></th>
                                        <th><?php echo _l('options'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($followup_types) && !empty($followup_types)): ?>
                                        <?php foreach ($followup_types as $type): ?>
                                        <tr>
                                            <td><?php echo html_escape($type); ?></td>
                                            <td>
                                                <a href="javascript:void(0)" class="btn btn-default btn-icon" onclick="edit_type('<?php echo html_escape($type); ?>')" title="<?php echo _l('edit'); ?>">
                                                    <i class="fa fa-pencil-square-o"></i>
                                                </a>
                                                <a href="javascript:void(0)" class="btn btn-danger btn-icon" onclick="delete_type('<?php echo html_escape($type); ?>')" title="<?php echo _l('delete'); ?>">
                                                    <i class="fa fa-remove"></i>
                                                </a>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="2">No follow-up types found in database</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>                            </table>
                        </div>
                        </div> <!-- Close the table-container div -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="followup-type-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <span class="edit-title"><?php echo _l('edit_followup_type'); ?></span>
                    <span class="add-title"><?php echo _l('new_followup_type'); ?></span>
                </h4>
            </div>            
            <?php echo form_open(admin_url('leads/add_followup_type'), ['id' => 'followup-type-form']); ?>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="name"><?php echo _l('followup_type_add_edit_name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" required>
                        </div>
                        <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
$(function() {
    // Console logs for debugging
    console.log('Follow-up Types Management Page Loaded');
    console.log('Found Types:', <?php echo json_encode(isset($followup_types) ? $followup_types : []); ?>);
    
    // Display debug information on the page
    var debugInfo = $('<div class="alert alert-info" id="debug-info"></div>');
    debugInfo.html('<strong>Debug Info:</strong><br>' +
                  'Follow-up Types Count: ' + <?php echo json_encode(count(isset($followup_types) ? $followup_types : [])); ?> + '<br>' +
                  'Follow-up Types: ' + <?php echo json_encode(isset($followup_types) ? json_encode($followup_types) : 'none'); ?> + '<br>' +
                  '<button class="btn btn-xs btn-info" id="show-html">Show Table HTML</button>');
    $('.panel-body').prepend(debugInfo);
    
    // Button to show table HTML
    $('#show-html').on('click', function() {
        var tableHTML = $('#followup-types-table').prop('outerHTML');
        $('<div class="alert alert-info"><pre>' + tableHTML.replace(/</g, '&lt;').replace(/>/g, '&gt;') + '</pre></div>').insertAfter('#debug-info');
        $(this).prop('disabled', true);
    });
    
    // Apply visibility fixes
    $('table.table-followup-types tbody tr, table.table-followup-types tbody td').css({
        'visibility': 'visible',
        'display': 'table-cell',
        'color': '#333',
        'background-color': '#fff',
        'opacity': '1'
    });
    
    // Initialize without DataTables first to check raw content
    setTimeout(function() {
        try {
            // Now initialize DataTable with minimal settings
            var followupTypesTable = $('#followup-types-table').DataTable({
                "pageLength": 25,
                "ordering": true,
                "info": true,
                "searching": false,  // Disable search to keep it simple
                "language": {
                    "emptyTable": "<?php echo _l('no_followup_types_found'); ?>"
                },
                "initComplete": function() {
                    // Apply extra visibility fixes after DataTable init
                    $('#followup-types-table tbody tr').css('display', 'table-row');
                    $('#followup-types-table tbody td').css('display', 'table-cell');
                }
            });
            
            console.log('DataTable initialized successfully');
        } catch(e) {
            console.error('Error initializing DataTable:', e);
            $('#debug-info').append('<div class="text-danger">DataTable Error: ' + e.message + '</div>');
        }
    }, 500);

    // Handle form submission
    $('#followup-type-form').on('submit', function(e) {
        e.preventDefault();
        var form = $(this);
        var url = form.attr('action');
        
        $.ajax({
            type: "POST",
            url: url,
            data: form.serialize(),
            success: function(response) {
                $('#followup-type-modal').modal('hide');
                alert_float('success', '<?php echo _l('followup_type_added'); ?>');
                // Fully reload page
                location.reload();
            },
            error: function(xhr, status, error) {
                alert_float('danger', '<?php echo _l('error_adding_followup_type'); ?>');
            }
        });
    });
});

// Edit type function
function edit_type(name) {
    $('#followup-type-modal input[name="name"]').val(name);
    $('#followup-type-modal .add-title').addClass('hide');
    $('#followup-type-modal .edit-title').removeClass('hide');
    $('#followup-type-modal').modal('show');
}

// Delete type function
function delete_type(name) {
    if (confirm(app.lang.confirm_action_prompt)) {
        var data = {};
        data[csrfData.token_name] = csrfData.hash;
        
        $.ajax({
            url: admin_url + 'leads/delete_followup_type/' + encodeURIComponent(name),
            type: 'POST',
            data: data,
            success: function(response) {
                alert_float('success', '<?php echo _l('deleted', _l('followup_type')); ?>');
                // Fully reload page
                location.reload();
            },
            error: function(xhr, status, error) {
                alert_float('danger', '<?php echo _l('error_deleting_followup_type'); ?>');
            }
        });
    }
}

// When modal is hidden, reset it
$('#followup-type-modal').on('hidden.bs.modal', function(e) {
    $('#followup-type-modal input[name="name"]').val('');
    $('#followup-type-modal .add-title').removeClass('hide');
    $('#followup-type-modal .edit-title').addClass('hide');
});
</script>
