<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4 class="page-title"><?php echo $title; ?></h4>
                        
                        <!-- WhatsApp Module Status -->
                        <div class="alert <?php echo $whatsapp_enabled ? 'alert-success' : 'alert-danger'; ?>">
                            <strong>WhatsApp API Module:</strong> 
                            <?php echo $whatsapp_enabled ? '✅ Enabled' : '❌ Not Found'; ?>
                        </div>

                        <?php if ($whatsapp_enabled): ?>
                        
                        <!-- Quick Actions -->
                        <div class="row">
                            <div class="col-md-6">
                                <button type="button" class="btn btn-primary btn-block" onclick="testMergeFields()">
                                    🧪 Test Merge Fields Processing
                                </button>
                            </div>
                            <div class="col-md-6">
                                <button type="button" class="btn btn-warning btn-block" onclick="fixTemplates()">
                                    🔧 Auto-Fix Template Parameters
                                </button>
                            </div>
                        </div>
                        
                        <br>

                        <!-- Results Area -->
                        <div id="results" style="display: none;">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h3 class="panel-title">Test Results</h3>
                                </div>
                                <div class="panel-body" id="results-content">
                                    <!-- Results will be loaded here -->
                                </div>
                            </div>
                        </div>

                        <!-- Current System Status -->
                        <div class="row">
                            <div class="col-md-4">
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h3 class="panel-title">📋 Leads Status</h3>
                                    </div>
                                    <div class="panel-body">
                                        <?php if (!empty($leads)): ?>
                                            <p class="text-success">✅ Found <?php echo count($leads); ?> leads</p>
                                            <ul class="list-unstyled">
                                                <?php foreach (array_slice($leads, 0, 3) as $lead): ?>
                                                    <li>• <?php echo $lead['name']; ?> (ID: <?php echo $lead['id']; ?>)</li>
                                                <?php endforeach; ?>
                                            </ul>
                                        <?php else: ?>
                                            <p class="text-danger">❌ No leads found</p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h3 class="panel-title">👥 Staff Status</h3>
                                    </div>
                                    <div class="panel-body">
                                        <?php if (!empty($staff)): ?>
                                            <p class="text-success">✅ Found <?php echo count($staff); ?> staff members</p>
                                            <ul class="list-unstyled">
                                                <?php foreach (array_slice($staff, 0, 3) as $member): ?>
                                                    <li>• <?php echo $member['firstname'] . ' ' . $member['lastname']; ?></li>
                                                <?php endforeach; ?>
                                            </ul>
                                        <?php else: ?>
                                            <p class="text-danger">❌ No staff found</p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h3 class="panel-title">⏰ Lead Reminders</h3>
                                    </div>
                                    <div class="panel-body">
                                        <?php if (!empty($lead_reminders)): ?>
                                            <p class="text-success">✅ Found <?php echo count($lead_reminders); ?> lead reminders</p>
                                            <ul class="list-unstyled">
                                                <?php foreach (array_slice($lead_reminders, 0, 3) as $reminder): ?>
                                                    <li>• <?php echo $reminder->lead_name ?: 'Unknown Lead'; ?></li>
                                                <?php endforeach; ?>
                                            </ul>
                                        <?php else: ?>
                                            <p class="text-warning">⚠️ No lead-related reminders found</p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- WhatsApp Templates -->
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <h3 class="panel-title">📱 WhatsApp Templates</h3>
                            </div>
                            <div class="panel-body">
                                <?php if (!empty($templates)): ?>
                                    <div class="table-responsive">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Template Name</th>
                                                    <th>Type</th>
                                                    <th>Params Count</th>
                                                    <th>Parameters</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($templates as $template): ?>
                                                    <?php if ($template->rel_type == 'leads' || $template->rel_type == 'staff_reminder'): ?>
                                                    <tr>
                                                        <td><?php echo $template->template_name; ?></td>
                                                        <td><?php echo $template->rel_type; ?></td>
                                                        <td><?php echo $template->body_params_count ?: 0; ?></td>
                                                        <td>
                                                            <small><?php echo $template->body_params ?: 'None'; ?></small>
                                                        </td>
                                                        <td>
                                                            <?php
                                                            $has_lead_name = false;
                                                            if (!empty($template->body_params)) {
                                                                $params = json_decode($template->body_params, true);
                                                                if (json_last_error() === JSON_ERROR_NONE && is_array($params)) {
                                                                    foreach ($params as $param) {
                                                                        if (isset($param['value']) && strpos($param['value'], '{lead_name}') !== false) {
                                                                            $has_lead_name = true;
                                                                            break;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            echo $has_lead_name ? '<span class="text-success">✅ Has {lead_name}</span>' : '<span class="text-danger">❌ Missing {lead_name}</span>';
                                                            ?>
                                                        </td>
                                                    </tr>
                                                    <?php endif; ?>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php else: ?>
                                    <p class="text-danger">❌ No WhatsApp templates found</p>
                                    <div class="alert alert-info">
                                        <strong>Setup Required:</strong>
                                        <ol>
                                            <li>Go to Admin Panel > WhatsApp API > Template Mapping</li>
                                            <li>Create templates for 'leads' and 'staff_reminder'</li>
                                            <li>Include {lead_name} in the parameter values</li>
                                        </ol>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <?php endif; ?>

                        <!-- Help Section -->
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <h3 class="panel-title">💡 Quick Fix Guide</h3>
                            </div>
                            <div class="panel-body">
                                <h5>If {lead_name} is not being replaced:</h5>
                                <ol>
                                    <li><strong>Click "Auto-Fix Template Parameters"</strong> above to automatically correct template issues</li>
                                    <li><strong>Sync Templates:</strong> Go to WhatsApp API > Template Mapping > Click "Sync Templates"</li>
                                    <li><strong>Test:</strong> Create a staff reminder linked to a lead and send WhatsApp notification</li>
                                    <li><strong>Verify:</strong> Check that the reminder has rel_type='lead' and rel_id pointing to a valid lead</li>
                                </ol>
                                
                                <h5>Manual Template Setup:</h5>
                                <p>If auto-fix doesn't work, manually edit your templates:</p>
                                <ul>
                                    <li>Template Body Params should be JSON: <code>[{"type":"text","value":"{lead_name}"}]</code></li>
                                    <li>Body Params Count should match the number of parameters</li>
                                    <li>Make sure your WhatsApp template uses positional parameters: {{1}}, {{2}}, etc.</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function testMergeFields() {
    $('#results').show();
    $('#results-content').html('<div class="text-center"><i class="fa fa-spinner fa-spin"></i> Testing merge fields...</div>');
    
    $.get('<?php echo admin_url("lead_debug/test_merge_fields"); ?>', function(data) {
        let html = '<h4>🧪 Merge Fields Test Results</h4>';
        
        if (data.error) {
            html += '<div class="alert alert-danger">' + data.error + '</div>';
        } else {
            html += '<h5>Test Lead: ' + data.lead_data.name + ' (ID: ' + data.lead_data.id + ')</h5>';
            
            html += '<h6>Generated Merge Fields:</h6>';
            html += '<table class="table table-condensed">';
            html += '<tr><th>Field</th><th>Value</th></tr>';
            for (let field in data.merge_fields) {
                html += '<tr><td><code>' + field + '</code></td><td><strong>' + (data.merge_fields[field] || 'Empty') + '</strong></td></tr>';
            }
            html += '</table>';
            
            html += '<h6>Message Processing Test:</h6>';
            html += '<table class="table table-condensed">';
            html += '<tr><th>Original Message</th><th>Processed Message</th><th>Status</th></tr>';
            data.test_results.forEach(function(result) {
                let status = result.replaced ? '<span class="text-success">✅ Replaced</span>' : '<span class="text-danger">❌ No Change</span>';
                html += '<tr><td><code>' + result.original + '</code></td><td><strong>' + result.processed + '</strong></td><td>' + status + '</td></tr>';
            });
            html += '</table>';
        }
        
        $('#results-content').html(html);
    }).fail(function() {
        $('#results-content').html('<div class="alert alert-danger">Failed to run test. Please check the console for errors.</div>');
    });
}

function fixTemplates() {
    $('#results').show();
    $('#results-content').html('<div class="text-center"><i class="fa fa-spinner fa-spin"></i> Fixing templates...</div>');
    
    $.get('<?php echo admin_url("lead_debug/fix_templates"); ?>', function(data) {
        let html = '<h4>🔧 Template Fix Results</h4>';
        
        if (data.error) {
            html += '<div class="alert alert-danger">' + data.error + '</div>';
        } else {
            if (data.fixed_count > 0) {
                html += '<div class="alert alert-success"><strong>Success!</strong> Fixed ' + data.fixed_count + ' template(s).</div>';
            } else {
                html += '<div class="alert alert-info"><strong>No fixes needed.</strong> All templates are already configured correctly.</div>';
            }
            
            html += '<h6>Template Status:</h6>';
            html += '<table class="table table-condensed">';
            html += '<tr><th>Template</th><th>Status</th><th>Details</th></tr>';
            data.results.forEach(function(result) {
                let statusClass = result.status === 'fixed' ? 'success' : (result.status === 'ok' ? 'info' : 'danger');
                let statusIcon = result.status === 'fixed' ? '🔧' : (result.status === 'ok' ? '✅' : '❌');
                html += '<tr class="' + statusClass + '"><td>' + result.template_name + '</td><td>' + statusIcon + ' ' + result.status.toUpperCase() + '</td><td>' + (result.message || result.new_params || '') + '</td></tr>';
            });
            html += '</table>';
            
            if (data.fixed_count > 0) {
                html += '<div class="alert alert-warning"><strong>Next Step:</strong> Go to WhatsApp API > Template Mapping and click "Sync Templates" to update the WhatsApp API.</div>';
            }
        }
        
        $('#results-content').html(html);
    }).fail(function() {
        $('#results-content').html('<div class="alert alert-danger">Failed to fix templates. Please check the console for errors.</div>');
    });
}
</script>

<?php init_tail(); ?>
