<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Find_duplicates extends AdminController {
    public function __construct()
    {
        parent::__construct();
        // Load database if not autoloaded
        $this->load->database();
    }

    public function index()
    {
        // Only allow admin
        if (!is_admin()) {
            show_error('You must be admin to access this page.', 403);
        }

        // Fetch all leads
        $this->db->select('id, name, phonenumber, phone_numbers');
        $leads = $this->db->get(db_prefix() . 'leads')->result_array();

        // Helper: Normalize phone (last 10 digits, remove non-digits)
        function normalize_phone($phone) {
            $phone = preg_replace('/\D/', '', $phone);
            return strlen($phone) >= 10 ? substr($phone, -10) : $phone;
        }

        $phones = [];
        foreach ($leads as $row) {
            $lead_id = $row['id'];
            $lead_name = $row['name'];
            $primary = normalize_phone($row['phonenumber']);
            if ($primary) {
                $phones[$primary][] = [ 'id' => $lead_id, 'name' => $lead_name, 'number' => $row['phonenumber'] ];
            }
            // Additional phones
            if ($row['phone_numbers']) {
                $additional = json_decode($row['phone_numbers'], true);
                if (is_array($additional)) {
                    foreach ($additional as $add) {
                        $add_norm = normalize_phone($add);
                        if ($add_norm) {
                            $phones[$add_norm][] = [ 'id' => $lead_id, 'name' => $lead_name, 'number' => $add ];
                        }
                    }
                }
            }
        }

        // Find duplicates
        $duplicates = [];
        foreach ($phones as $norm => $list) {
            if (count($list) > 1) {
                $duplicates[$norm] = $list;
            }
        }

        // Prepare Excel data
        $excel_data = [ ['Normalized Number', 'Lead ID', 'Lead Name', 'Original Number'] ];
        foreach ($duplicates as $norm => $leads) {
            foreach ($leads as $lead) {
                $excel_data[] = [ $norm, $lead['id'], $lead['name'], $lead['number'] ];
            }
        }

        // Output Excel file
        $filename = 'duplicate_lead_numbers_' . date('Ymd_His') . '.xls';
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename=' . $filename);
        echo "<table border='1'>";
        foreach ($excel_data as $row) {
            echo '<tr>';
            foreach ($row as $cell) {
                echo '<td>' . htmlspecialchars($cell) . '</td>';
            }
            echo '</tr>';
        }
        echo '</table>';
        exit;
    }
}
