<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<!-- CSS fix for table visibility issues -->
<style>
    /* Strong selectors to override any theme CSS that might be hiding content */
    #followup-types-table,
    #followup-types-table thead,
    #followup-types-table tbody,
    #followup-types-table tr,
    #followup-types-table th,
    #followup-types-table td {
        visibility: visible !important;
        display: table !important;
        color: #333 !important;
        opacity: 1 !important;
    }
    
    #followup-types-table {
        display: table !important;
        width: 100% !important;
        border-collapse: separate !important;
        margin-bottom: 20px !important;
    }
    
    #followup-types-table thead,
    #followup-types-table tbody {
        display: table-row-group !important;
    }
    
    #followup-types-table tr {
        display: table-row !important;
    }
    
    #followup-types-table th,
    #followup-types-table td {
        display: table-cell !important;
        padding: 8px !important;
        border: 1px solid #ddd !important;
        background-color: #fff !important;
    }
    
    #followup-types-table thead th {
        background-color: #f0f0f0 !important;
        font-weight: bold !important;
    }
    
    .dataTables_wrapper .dataTables_info,
    .dataTables_wrapper .dataTables_paginate,
    .dataTables_wrapper .dataTables_length,
    .dataTables_wrapper .dataTables_filter {
        display: block !important;
        visibility: visible !important;
    }
</style>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="tw-mb-2 sm:tw-mb-4">
                    <a href="#" class="btn btn-primary" data-toggle="modal" data-target="#followup-type-modal">
                        <i class="fa fa-plus"></i> <?php echo _l('new_followup_type'); ?>
                    </a>
                </div>                <div class="panel_s">
                    <div class="panel-body">                        <div class="table-responsive">
                            <table class="table table-bordered table-followup-types" id="followup-types-table">
                                <thead>
                                    <tr>
                                        <th><?php echo _l('followup_type'); ?></th>
                                        <th><?php echo _l('options'); ?></th>
                                    </tr>
                                </thead>                                <tbody>
                                    <?php if(isset($followup_types) && !empty($followup_types)): ?>
                                        <?php foreach($followup_types as $type): ?>
                                        <tr>
                                            <td><?php echo html_escape($type); ?></td>
                                            <td>
                                                <a href="javascript:void(0)" class="btn btn-default btn-icon" onclick="edit_type('<?php echo html_escape($type); ?>')" title="<?php echo _l('edit'); ?>">
                                                    <i class="fa fa-pencil-square-o"></i>
                                                </a>
                                                <a href="javascript:void(0)" class="btn btn-danger btn-icon" onclick="delete_type('<?php echo html_escape($type); ?>')" title="<?php echo _l('delete'); ?>">
                                                    <i class="fa fa-remove"></i>
                                                </a>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="2">No follow-up types found</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="followup-type-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <span class="edit-title"><?php echo _l('edit_followup_type'); ?></span>
                    <span class="add-title"><?php echo _l('new_followup_type'); ?></span>
                </h4>
            </div>            <?php echo form_open(admin_url('leads/add_followup_type'), ['id' => 'followup-type-form']); ?>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="name"><?php echo _l('followup_type_add_edit_name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" required>
                        </div>
                        <input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
$(function() {
    // Apply robust fixes for table visibility
    function applyTableFixes() {
        // Force proper display of table and its elements
        $('#followup-types-table, #followup-types-table tr, #followup-types-table td, #followup-types-table th').css({
            'display': 'table',
            'visibility': 'visible',
            'opacity': '1',
            'color': '#333',
            'background-color': '#fff'
        });
        
        $('#followup-types-table').css('display', 'table');
        $('#followup-types-table tr').css('display', 'table-row');
        $('#followup-types-table td, #followup-types-table th').css('display', 'table-cell');
    }
    
    // Apply fixes immediately
    applyTableFixes();
    
    // Initialize the DataTable with minimal configuration
    try {
        var followupTypesTable = $('#followup-types-table').DataTable({
            "pageLength": 25,
            "ordering": true,
            "dom": 'Bfrtip',
            "language": {
                "emptyTable": "<?php echo _l('no_followup_types_found'); ?>"
            },
            "drawCallback": function() {
                // Reapply fixes after each table redraw
                applyTableFixes();
            },
            "initComplete": function() {
                // Ensure the table is visible after initialization
                applyTableFixes();
            }
        });
        
        // Force redraw after a delay to ensure styling is properly applied
        setTimeout(function() {
            applyTableFixes();
            followupTypesTable.draw();
        }, 500);
    } catch(e) {
        // Fallback if DataTable fails - ensure the HTML table is visible
        console.error('Error initializing DataTable:', e);
        applyTableFixes();
    }

    // Handle form submission with AJAX
    $('#followup-type-form').on('submit', function(e) {
        e.preventDefault();
        var form = $(this);
        var url = form.attr('action');
        
        $.ajax({
            type: "POST",
            url: url,
            data: form.serialize(),
            success: function(response) {
                $('#followup-type-modal').modal('hide');
                // Reload the page instead of just the table to refresh data
                setTimeout(function() {
                    location.reload();
                }, 1000);
                alert_float('success', '<?php echo _l('followup_type_added'); ?>');
            },
            error: function(xhr, status, error) {
                alert_float('danger', '<?php echo _l('error_adding_followup_type'); ?>');
            }
        });
    });
});

function edit_type(name) {
    $('#followup-type-modal input[name="name"]').val(name);
    $('#followup-type-modal .add-title').addClass('hide');
    $('#followup-type-modal .edit-title').removeClass('hide');
    $('#followup-type-modal').modal('show');
}

function delete_type(name) {
    if (confirm(app.lang.confirm_action_prompt)) {
        var data = {};
        data[csrfData.token_name] = csrfData.hash;
        
        $.ajax({
            url: admin_url + 'leads/delete_followup_type/' + encodeURIComponent(name),
            type: 'POST',
            data: data,
            success: function(response) {
                // Instead of reloading just the DataTable, reload the entire page
                alert_float('success', '<?php echo _l('deleted', _l('followup_type')); ?>');
                setTimeout(function() {
                    location.reload();
                }, 1000);
            },
            error: function(xhr, status, error) {
                alert_float('danger', '<?php echo _l('error_deleting_followup_type'); ?>');
            }
        });
    }
}

// When modal is hidden, reset it
$('#followup-type-modal').on('hidden.bs.modal', function(e) {
    $('#followup-type-modal input[name="name"]').val('');
    $('#followup-type-modal .add-title').removeClass('hide');
    $('#followup-type-modal .edit-title').addClass('hide');
});
</script>
