<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Custom logging function to log events and messages
 *
 * @param string $message - The message to log
 * @param string $type - The type of log (info, debug, error, warning)
 * @param array $context - Additional context data to log
 * @return bool
 */
if (!function_exists('app_log')) {
    function app_log($message, $type = 'info', $context = [])
    {
        $CI = &get_instance();
        $logPath = APPPATH . 'logs/event_log-' . date('Y-m-d') . '.php';
        
        // Make sure the log directory exists and is writable
        if (!is_dir(APPPATH . 'logs')) {
            mkdir(APPPATH . 'logs', 0755, true);
        }
        
        // Create log file if it doesn't exist with PHP header to prevent direct access
        if (!file_exists($logPath)) {
            file_put_contents($logPath, "<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>\n");
        }
        
        $timestamp = date('Y-m-d H:i:s');
        $ip = $CI->input->ip_address();
        $user_id = isset($CI->session) && $CI->session->has_userdata('staff_user_id') 
            ? $CI->session->userdata('staff_user_id') 
            : 'Guest';
        
        // Format context data
        $contextString = '';
        if (!empty($context)) {
            $contextString = json_encode($context);
        }
        
        // Assemble log entry
        $logEntry = "[{$timestamp}] [{$type}] [User:{$user_id}] [IP:{$ip}] {$message}" . 
                   (!empty($contextString) ? " Context: {$contextString}" : "") . PHP_EOL;
        
        // Write to log file
        file_put_contents($logPath, $logEntry, FILE_APPEND);
        
        return true;
    }
}

/**
 * Log database queries for debugging
 * 
 * @param string $query - The SQL query to log
 * @return bool
 */
if (!function_exists('log_db_query')) {
    function log_db_query($query) 
    {
        app_log("DB Query: " . $query, 'debug');
        return true;
    }
}
