<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Facebook Leads Integration Module - Installation Script
 * This script runs when the module is activated
 */

$CI = &get_instance();

// Create logs table
if (!$CI->db->table_exists(db_prefix() . 'facebook_leads_logs')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . 'facebook_leads_logs` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `facebook_lead_id` varchar(255) NOT NULL,
        `form_id` varchar(255) NOT NULL,
        `lead_id` int(11) DEFAULT NULL COMMENT "Perfex Lead ID",
        `data` text NOT NULL COMMENT "JSON data from Facebook",
        `status` enum("success","failed","duplicate") DEFAULT "success",
        `error_message` text,
        `created_at` datetime NOT NULL,
        PRIMARY KEY (`id`),
        UNIQUE KEY `facebook_lead_id` (`facebook_lead_id`),
        KEY `form_id` (`form_id`),
        KEY `lead_id` (`lead_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=' . $CI->db->char_set . ';');
}

// Create settings table
if (!$CI->db->table_exists(db_prefix() . 'facebook_leads_settings')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . 'facebook_leads_settings` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `setting_name` varchar(100) NOT NULL,
        `setting_value` text,
        `updated_at` datetime DEFAULT NULL,
        PRIMARY KEY (`id`),
        UNIQUE KEY `setting_name` (`setting_name`)
    ) ENGINE=InnoDB DEFAULT CHARSET=' . $CI->db->char_set . ';');
    
    // Insert default settings
    $default_settings = [
        ['setting_name' => 'app_id', 'setting_value' => '', 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'app_secret', 'setting_value' => '', 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'page_access_token', 'setting_value' => '', 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'page_id', 'setting_value' => '', 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'form_ids', 'setting_value' => '', 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'default_assigned_staff', 'setting_value' => '', 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'lead_status', 'setting_value' => '1', 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'lead_source', 'setting_value' => '', 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'cron_interval', 'setting_value' => '15', 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'webhook_verify_token', 'setting_value' => generate_random_string(32), 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'last_fetch_time', 'setting_value' => '', 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'enabled', 'setting_value' => '0', 'updated_at' => date('Y-m-d H:i:s')],
    ];
    
    $CI->db->insert_batch(db_prefix() . 'facebook_leads_settings', $default_settings);
}

// Create "Facebook" lead source if it doesn't exist
$CI->db->where('name', 'Facebook');
$existing_source = $CI->db->get(db_prefix() . 'leads_sources')->row();

if (!$existing_source) {
    $CI->db->insert(db_prefix() . 'leads_sources', [
        'name' => 'Facebook'
    ]);
    
    $source_id = $CI->db->insert_id();
    
    // Update default source in settings
    $CI->db->where('setting_name', 'lead_source');
    $CI->db->update(db_prefix() . 'facebook_leads_settings', [
        'setting_value' => $source_id
    ]);
}

// Create logs directory if it doesn't exist
if (!file_exists(FCPATH . 'modules/facebook_leads_integration/logs')) {
    mkdir(FCPATH . 'modules/facebook_leads_integration/logs', 0755, true);
}

// Create .htaccess to protect logs directory
$htaccess_content = "Order Deny,Allow\nDeny from all";
file_put_contents(FCPATH . 'modules/facebook_leads_integration/logs/.htaccess', $htaccess_content);

// Generate random string helper
function generate_random_string($length = 32)
{
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

