<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Facebook Leads Integration - Configuration
 */

// Facebook Graph API Version
define('FACEBOOK_GRAPH_API_VERSION', 'v20.0');

// Facebook Graph API Base URL
define('FACEBOOK_GRAPH_API_URL', 'https://graph.facebook.com/' . FACEBOOK_GRAPH_API_VERSION);

// Default cron interval in minutes
define('FACEBOOK_LEADS_DEFAULT_CRON_INTERVAL', 15);

// Maximum number of leads to fetch per request
define('FACEBOOK_LEADS_FETCH_LIMIT', 100);

// Log retention days (logs older than this will be deleted)
define('FACEBOOK_LEADS_LOG_RETENTION_DAYS', 30);

// Enable/disable detailed API logging (set to false in production)
define('FACEBOOK_LEADS_DEBUG_MODE', false);

// Timeout for API requests (in seconds)
define('FACEBOOK_LEADS_API_TIMEOUT', 30);

// Required Facebook permissions
$facebook_required_permissions = [
    'leads_retrieval',
    'pages_read_engagement',
    'pages_manage_ads',
    'pages_show_list'
];

// Field mapping configuration
// Maps Facebook form field names to Perfex CRM lead fields
$facebook_field_mapping = [
    // Name fields
    'name' => ['full_name', 'name', 'full name', 'fullname'],
    'first_name' => ['first_name', 'first name', 'firstname', 'fname'],
    'last_name' => ['last_name', 'last name', 'lastname', 'lname'],
    
    // Contact fields
    'email' => ['email', 'e-mail', 'e_mail', 'email_address'],
    'phone' => ['phone', 'phone_number', 'phone number', 'mobile', 'mobile_number', 'tel', 'telephone'],
    
    // Address fields
    'address' => ['address', 'street_address', 'street address'],
    'city' => ['city', 'town'],
    'state' => ['state', 'province', 'region'],
    'zip' => ['zip', 'postal_code', 'postal code', 'postcode'],
    'country' => ['country'],
    
    // Company fields
    'company' => ['company', 'company_name', 'company name', 'organization', 'business'],
    'website' => ['website', 'web', 'url'],
    
    // Other fields
    'title' => ['job_title', 'job title', 'title', 'position'],
    'message' => ['message', 'comments', 'notes', 'description', 'inquiry']
];

// Default lead status (will be overridden by settings)
define('FACEBOOK_LEADS_DEFAULT_STATUS', 1);

// Enable webhook signature validation (recommended for production)
define('FACEBOOK_LEADS_VALIDATE_WEBHOOK_SIGNATURE', true);

