# Frequently Asked Questions (FAQ)

## General Questions

### What does this module do?

The Facebook Leads Integration module automatically fetches leads from Facebook Lead Forms and imports them into Perfex CRM. It works with scheduled cron jobs or real-time webhooks.

### Do I need a Facebook Business account?

No, but you need a Facebook Developer account (free) and access to a Facebook Page with Lead Forms.

### Is this module free?

Yes, the module itself is free. However, you may incur costs from Facebook Ads if you're running lead generation campaigns.

### Which Perfex CRM versions are supported?

Perfex CRM version 3.0 and higher. The module uses standard CodeIgniter patterns compatible with Perfex.

---

## Installation & Setup

### Where do I get the Facebook credentials?

1. **App ID & Secret**: Facebook Developers → Your App → Settings → Basic
2. **Page Access Token**: Facebook Developers → Tools → Graph API Explorer
3. **Page ID**: Your Facebook Page → About → Page ID
4. **Form ID**: Facebook Page → Publishing Tools → Forms Library (in URL)

### How do I get a Page Access Token?

1. Go to [Graph API Explorer](https://developers.facebook.com/tools/explorer/)
2. Select your app from dropdown
3. Click "Generate Access Token"
4. Grant permissions: `leads_retrieval`, `pages_read_engagement`
5. Copy the token

### What permissions does my token need?

Required Facebook permissions:
- `leads_retrieval` (required)
- `pages_read_engagement` (required)
- `pages_manage_ads` (recommended)
- `pages_show_list` (recommended)

### My token expires after 1 hour. How do I get a long-lived token?

Use Facebook's token debugger to exchange it:
1. Go to [Access Token Debugger](https://developers.facebook.com/tools/debug/accesstoken/)
2. Paste your token
3. Click "Extend Access Token"
4. Copy the new long-lived token (valid for 60 days)

Alternatively, generate a Page Access Token which never expires (as long as you maintain page access).

---

## Configuration

### Can I import leads from multiple forms?

Yes! Enter multiple Form IDs separated by commas:
```
123456789,987654321,555555555
```

### Can I import from multiple Facebook Pages?

Currently, the module supports one Facebook Page at a time. For multiple pages, you would need multiple installations or custom modifications.

### How often are leads fetched?

By default, every 15 minutes via cron job. You can change this in module settings (minimum 1 minute, maximum 1440 minutes/24 hours).

### What happens to duplicate leads?

The module checks for duplicates in two ways:
1. **Facebook Lead ID**: If the same Facebook lead was already imported
2. **Email Address**: If a lead with the same email exists in Perfex

Duplicates are logged but not imported again.

### Can I customize field mapping?

The module automatically maps common fields:
- Full Name, First Name, Last Name → Lead Name
- Email → Lead Email
- Phone → Lead Phone
- All other fields → Lead Description

Custom mapping can be modified in `helpers/facebook_helper.php` (requires PHP knowledge).

---

## Operation

### How do I know if leads are being imported?

Check these places:
1. **Perfex Leads Section**: Look for new leads with "Facebook" source
2. **Module Dashboard Widget**: Shows import statistics
3. **Module Logs Tab**: Detailed import history
4. **Log Files**: `modules/facebook_leads_integration/logs/`

### Can I manually fetch leads?

Yes! Go to module settings and click **"Fetch Leads Now"** button. This is useful for testing or importing existing leads.

### What if the cron job fails?

The module logs all errors. Check:
1. `modules/facebook_leads_integration/logs/error_*.log`
2. Test manually: `php cron/fetch_facebook_leads.php`
3. Check PHP error logs
4. Verify cron job is scheduled correctly

### How do I test the cron job without waiting?

Run it manually from command line:
```bash
php /path/to/perfex/modules/facebook_leads_integration/cron/fetch_facebook_leads.php
```

---

## Webhooks

### What's the difference between cron and webhooks?

- **Cron**: Polls Facebook every X minutes. Delay = cron interval.
- **Webhooks**: Facebook pushes leads instantly. Real-time delivery.

We recommend using **both**: webhooks for real-time + cron as backup.

### Do I need webhooks?

No, webhooks are optional. Cron jobs work fine, just with a small delay (15 minutes by default).

### Why is my webhook verification failing?

Common causes:
- **No HTTPS**: Webhooks require SSL certificate
- **URL not accessible**: Must be publicly accessible
- **Wrong verify token**: Must match exactly (case-sensitive)
- **Firewall blocking**: Check server firewall rules
- **Wrong URL format**: Should be `https://yourdomain.com/index.php/facebook_leads_integration/webhook`

### How do I test webhooks?

1. Submit a test lead on your Facebook form
2. Check module logs immediately
3. Lead should appear in CRM within seconds
4. Check Facebook App Dashboard → Webhooks for delivery status

---

## Troubleshooting

### "Connection failed" error when testing

**Causes & Solutions:**
- Wrong App ID/Secret → Double-check credentials
- Token expired → Generate new token
- Token missing permissions → Add `leads_retrieval` permission
- Wrong Page ID → Verify Page ID is correct
- API rate limit → Wait and try again

### No leads are being imported

**Checklist:**
1. ✅ Integration is enabled (toggle is ON)
2. ✅ Form IDs are correct (no spaces)
3. ✅ Cron job is running
4. ✅ Forms have submitted leads
5. ✅ Check error logs for details

### Leads imported but missing fields

The module maps common field names. If your form uses custom names:
- Fields go into the "Description" field
- Check logs to see raw data
- Modify field mapping in `helpers/facebook_helper.php`

### Cron job says "Too soon to fetch"

This is normal. The module respects the configured interval. To force immediate fetch:
- Click "Fetch Leads Now" in settings, OR
- Wait for the interval to pass, OR
- Reduce the cron interval in settings

### Getting rate limit errors from Facebook

Facebook limits API requests. Solutions:
- Increase cron interval (e.g., 30 minutes)
- Use webhooks instead of frequent polling
- Wait for rate limit to reset (usually 1 hour)

### Some leads are marked as "failed" in logs

Click "View Data" button in logs to see the error. Common issues:
- Missing required fields (name or email)
- Invalid email format
- Database constraint violations
- Permission issues

---

## Data & Privacy

### Where is lead data stored?

- **Perfex Leads**: Standard Perfex leads table
- **Module Logs**: `facebook_leads_settings` and `facebook_leads_logs` tables
- **Log Files**: `modules/facebook_leads_integration/logs/` directory

### Is the module GDPR compliant?

The module itself doesn't add GDPR obligations, but you must:
- Get proper consent on Facebook forms
- Include privacy policy link
- Allow users to request data deletion
- Follow Facebook's lead generation policies
- Comply with your local privacy laws

### How long are logs kept?

Log files older than 30 days are automatically deleted. Database logs are kept indefinitely (you can manually delete them).

### Can I export lead data?

Yes, use Perfex CRM's standard export features:
- Leads → Export
- Or query the database directly

### What happens if I uninstall the module?

By default, data is **kept** for safety. To delete all data:
1. Edit `uninstall.php`
2. Uncomment the deletion code
3. Uninstall module

---

## Advanced

### Can I modify the module?

Yes! The module is open-source. Common modifications:
- Custom field mapping
- Additional validation rules
- Custom notifications
- Integration with other services

**Tip**: Keep a backup before modifying.

### How do I add custom field mapping?

Edit `helpers/facebook_helper.php` → `parse_facebook_lead_data()` function.

### Can I trigger custom actions when a lead is imported?

Yes, use Perfex CRM's hooks. In your custom module:
```php
hooks()->add_action('after_lead_added', 'my_custom_function');
```

### How do I debug API issues?

1. Enable debug mode in `config/config.php`
2. Check `logs/info_*.log` for API requests/responses
3. Use Facebook's [Graph API Explorer](https://developers.facebook.com/tools/explorer/) to test manually

### Can I import historical leads?

Yes! The first time you fetch, all existing leads from the forms will be imported (up to the API limit of 500 per form).

### What's the maximum number of leads that can be imported?

No hard limit. The module processes in batches of 100. For large volumes:
- Use webhooks for real-time processing
- Increase PHP memory limit if needed
- Monitor server resources

---

## Performance

### Will this slow down my CRM?

No. Cron jobs run in the background. Webhooks are processed asynchronously. The module is optimized for performance.

### How many leads can it handle?

Tested with thousands of leads. No practical limit. Database is indexed for fast queries.

### Does it affect Facebook API limits?

Yes, like any API usage. Tips to stay within limits:
- Don't poll too frequently (15 minutes is reasonable)
- Use webhooks instead of constant polling
- Monitor API usage in Facebook App Dashboard

---

## Support & Maintenance

### Where can I get help?

1. **Documentation**: README.md, INSTALLATION.md
2. **Logs**: Check error logs first
3. **Facebook Docs**: [Facebook Lead Ads](https://developers.facebook.com/docs/marketing-api/guides/lead-ads)
4. **Perfex Community**: Perfex CRM forums

### How do I update the module?

1. Backup your installation
2. Replace module files
3. Deactivate and reactivate module (if needed)
4. Check changelog for breaking changes

### Can I contribute to development?

Yes! Fork the repository, make improvements, submit pull requests.

---

## Billing & Costs

### Is there a monthly fee?

No, the module is free. However:
- Facebook Ads cost money (if running campaigns)
- You need a Facebook Developer account (free)
- You need hosting for Perfex CRM

### Does Facebook charge for API access?

No, the Graph API is free for lead retrieval. You only pay for ad campaigns.

---

## Compatibility

### Does it work with Facebook Business Suite?

Yes, as long as you have lead forms on your Facebook Page.

### What about Instagram lead forms?

Instagram lead forms are connected to Facebook. If your Instagram business account is linked to your Facebook Page, leads should be accessible through the same API.

### Can I use it with Facebook Ads Manager?

Yes! The module fetches leads from forms, regardless of how they were generated (organic or paid ads).

---

Still have questions? Check the full documentation or open an issue on GitHub!

