<?php
define('BASEPATH', true);
require_once '../../application/config/database.php';
require_once '../../application/config/config.php';

// Simple database connection for testing
$host = $db['default']['hostname'];
$user = $db['default']['username'];
$pass = $db['default']['password'];
$dbname = $db['default']['database'];
$prefix = $db['default']['dbprefix'];

$pdo = new PDO("mysql:host=$host;dbname=$dbname", $user, $pass);

echo "<h1>Reporting Dashboard Test</h1>";
echo "<style>body{font-family:Arial;margin:20px;} table{border-collapse:collapse;width:100%;} th,td{border:1px solid #ddd;padding:8px;text-align:left;} th{background:#f2f2f2;}</style>";

// Test 1: Check tables exist
echo "<h2>1. Table Structure Check</h2>";
$tables = [
    'lead_activity_log' => $prefix . 'lead_activity_log',
    'activitylog' => $prefix . 'activitylog',
    'leads' => $prefix . 'leads',
    'staff' => $prefix . 'staff'
];

foreach ($tables as $name => $table) {
    try {
        $stmt = $pdo->query("SHOW TABLES LIKE '$table'");
        if ($stmt->rowCount() > 0) {
            echo "<p style='color:green;'>✓ Table $table exists</p>";
            
            // Get row count
            $count = $pdo->query("SELECT COUNT(*) FROM $table")->fetchColumn();
            echo "<p>- Row count: $count</p>";
            
            // Show structure for lead_activity_log
            if ($name == 'lead_activity_log') {
                echo "<h3>Structure of $table:</h3>";
                $struct = $pdo->query("DESCRIBE $table")->fetchAll();
                echo "<table><tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th></tr>";
                foreach ($struct as $col) {
                    echo "<tr><td>{$col['Field']}</td><td>{$col['Type']}</td><td>{$col['Null']}</td><td>{$col['Key']}</td></tr>";
                }
                echo "</table>";
                
                // Sample data
                if ($count > 0) {
                    echo "<h3>Sample Data (Latest 3 entries):</h3>";
                    $sample = $pdo->query("SELECT * FROM $table ORDER BY date DESC LIMIT 3")->fetchAll();
                    if (!empty($sample)) {
                        echo "<table>";
                        echo "<tr>";
                        foreach (array_keys($sample[0]) as $col) {
                            if (!is_numeric($col)) echo "<th>$col</th>";
                        }
                        echo "</tr>";
                        foreach ($sample as $row) {
                            echo "<tr>";
                            foreach ($row as $key => $val) {
                                if (!is_numeric($key)) echo "<td>" . htmlspecialchars($val ?? '') . "</td>";
                            }
                            echo "</tr>";
                        }
                        echo "</table>";
                    }
                }
            }
        } else {
            echo "<p style='color:red;'>✗ Table $table not found</p>";
        }
    } catch (Exception $e) {
        echo "<p style='color:red;'>Error checking $table: " . $e->getMessage() . "</p>";
    }
    echo "<hr>";
}

// Test 2: Check if there's lead activity data
echo "<h2>2. Lead Activity Test Query</h2>";
try {
    $leadTable = $prefix . 'lead_activity_log';
    $staffTable = $prefix . 'staff';
    
    $sql = "SELECT a.*, s.firstname, s.lastname 
            FROM $leadTable a 
            LEFT JOIN $staffTable s ON s.staffid = a.staffid 
            WHERE a.date >= DATE_SUB(NOW(), INTERVAL 30 DAY)
            ORDER BY a.date DESC 
            LIMIT 10";
    
    $results = $pdo->query($sql)->fetchAll();
    
    echo "<p>Found " . count($results) . " lead activities in last 30 days</p>";
    
    if (!empty($results)) {
        echo "<table>";
        echo "<tr><th>Date</th><th>Staff</th><th>Lead ID</th><th>Description</th></tr>";
        foreach ($results as $row) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($row['date']) . "</td>";
            echo "<td>" . htmlspecialchars(($row['firstname'] ?? '') . ' ' . ($row['lastname'] ?? '')) . "</td>";
            echo "<td>" . htmlspecialchars($row['leadid'] ?? '') . "</td>";
            echo "<td>" . htmlspecialchars(substr($row['description'] ?? '', 0, 100)) . "...</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p style='color:red;'>No lead activity found in last 30 days!</p>";
    }
} catch (Exception $e) {
    echo "<p style='color:red;'>Error: " . $e->getMessage() . "</p>";
}

// Test 3: Create sample data if none exists
echo "<h2>3. Create Sample Data (if needed)</h2>";
try {
    $leadTable = $prefix . 'lead_activity_log';
    $leadsTable = $prefix . 'leads';
    
    // Check if we have any leads
    $leadCount = $pdo->query("SELECT COUNT(*) FROM $leadsTable")->fetchColumn();
    echo "<p>Total leads in system: $leadCount</p>";
    
    if ($leadCount > 0) {
        // Get a sample lead
        $sampleLead = $pdo->query("SELECT id FROM $leadsTable LIMIT 1")->fetch();
        $leadId = $sampleLead['id'];
        
        // Check if this lead has activity
        $activityCount = $pdo->query("SELECT COUNT(*) FROM $leadTable WHERE leadid = $leadId")->fetchColumn();
        echo "<p>Activities for lead $leadId: $activityCount</p>";
        
        if ($activityCount == 0) {
            // Create sample activity
            $stmt = $pdo->prepare("INSERT INTO $leadTable (date, description, leadid, staffid, full_name) VALUES (NOW(), 'Test activity - Lead viewed', ?, 1, 'Test User')");
            $stmt->execute([$leadId]);
            echo "<p style='color:green;'>✓ Created sample activity for lead $leadId</p>";
        }
    } else {
        echo "<p style='color:orange;'>No leads found - create a lead first to test the dashboard</p>";
    }
} catch (Exception $e) {
    echo "<p style='color:red;'>Error creating sample data: " . $e->getMessage() . "</p>";
}

// Test 4: Test the actual model query
echo "<h2>4. Model Query Test</h2>";
try {
    $leadTable = $prefix . 'lead_activity_log';
    $staffTable = $prefix . 'staff';
    
    // This mimics the model query
    $from = date('Y-m-01'); // First of this month
    $to = date('Y-m-d'); // Today
    
    $sql = "SELECT COUNT(*) as cnt FROM $leadTable a WHERE a.date >= ? AND a.date <= ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$from, $to]);
    $count = $stmt->fetch()['cnt'];
    
    echo "<p>Activities from $from to $to: $count</p>";
    
    // Staff activity chart data
    $sql = "SELECT s.staffid, CONCAT(s.firstname, ' ', s.lastname) as staff_name, COUNT(a.id) as total
            FROM $leadTable a
            LEFT JOIN $staffTable s ON s.staffid = a.staffid
            WHERE a.date >= ? AND a.date <= ?
            GROUP BY s.staffid
            ORDER BY total DESC
            LIMIT 5";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$from, $to]);
    $staffData = $stmt->fetchAll();
    
    echo "<h3>Staff Activity Chart Data:</h3>";
    echo "<table><tr><th>Staff ID</th><th>Staff Name</th><th>Total Activities</th></tr>";
    foreach ($staffData as $row) {
        echo "<tr><td>{$row['staffid']}</td><td>{$row['staff_name']}</td><td>{$row['total']}</td></tr>";
    }
    echo "</table>";
    
} catch (Exception $e) {
    echo "<p style='color:red;'>Error in model test: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h2>Next Steps:</h2>";
echo "<ol>";
echo "<li>If tables exist but no data: Create some leads and perform actions (add notes, change status, etc.)</li>";
echo "<li>If sample data was created: Try the dashboard again</li>";
echo "<li>Check the browser console for JavaScript errors</li>";
echo "<li>Verify the module routes are working: <a href='../../admin/reporting_dashboard/debug'>Debug URL</a></li>";
echo "</ol>";

echo "<h3>Quick Dashboard Links:</h3>";
echo "<ul>";
echo "<li><a href='../../admin/reporting_dashboard'>Main Dashboard</a></li>";
echo "<li><a href='../../admin/reporting_dashboard/debug'>Debug Endpoint</a></li>";
echo "</ul>";
?>

