<?php
defined('BASEPATH') or exit('No direct script access allowed');

// Simple test controller to check permissions
class Test_permissions extends AdminController
{
    public function index()
    {
        if (!is_admin()) {
            show_error('Access denied - Admin only');
        }
        
        echo "<h2>Permissions Test</h2>";
        
        $current_staff_id = get_staff_user_id();
        echo "<p>Current Staff ID: $current_staff_id</p>";
        echo "<p>Is Admin: " . (is_admin() ? 'Yes' : 'No') . "</p>";
        
        // Direct database query to check permissions
        $CI = &get_instance();
        $CI->db->select('*');
        $CI->db->from(db_prefix() . 'reporting_dashboard_permissions');
        $CI->db->where('staff_id', $current_staff_id);
        $query = $CI->db->get();
        
        if ($query->num_rows() > 0) {
            $permission = $query->row();
            echo "<h3>Permission Found:</h3>";
            echo "<pre>" . print_r($permission, true) . "</pre>";
        } else {
            echo "<h3>No Permission Set (Default: view_own_only)</h3>";
        }
        
        // Test staff list
        $CI->db->select('staffid, firstname, lastname, email, admin, active');
        $CI->db->from(db_prefix() . 'staff');
        $CI->db->where('active', 1);
        $staff_query = $CI->db->get();
        
        echo "<h3>All Active Staff:</h3>";
        echo "<table border='1'>";
        echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Admin</th></tr>";
        foreach ($staff_query->result_array() as $staff) {
            echo "<tr>";
            echo "<td>" . $staff['staffid'] . "</td>";
            echo "<td>" . $staff['firstname'] . ' ' . $staff['lastname'] . "</td>";
            echo "<td>" . $staff['email'] . "</td>";
            echo "<td>" . ($staff['admin'] == 1 ? 'Yes' : 'No') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // Test what should be shown based on permissions
        echo "<h3>What Current User Should See:</h3>";
        $permission_type = 'view_own_only'; // default
        $allowed_staff_ids = [$current_staff_id]; // default
        
        if ($query->num_rows() > 0) {
            $permission = $query->row();
            $permission_type = $permission->permission_type;
            
            if ($permission_type === 'view_specific_staff') {
                $allowed_staff_ids = json_decode($permission->allowed_staff_ids, true) ?: [];
                if (!in_array($current_staff_id, $allowed_staff_ids)) {
                    $allowed_staff_ids[] = $current_staff_id;
                }
            } elseif ($permission_type === 'view_all_staff') {
                $allowed_staff_ids = []; // empty means all
            }
        }
        
        if (is_admin($current_staff_id)) {
            $permission_type = 'view_all_staff';
            $allowed_staff_ids = [];
        }
        
        echo "<p>Permission Type: $permission_type</p>";
        echo "<p>Allowed Staff IDs: " . (empty($allowed_staff_ids) ? 'ALL' : implode(', ', $allowed_staff_ids)) . "</p>";
        
        if (empty($allowed_staff_ids)) {
            echo "<p>Should show ALL staff</p>";
        } else {
            echo "<p>Should show only specific staff:</p>";
            echo "<table border='1'>";
            echo "<tr><th>ID</th><th>Name</th><th>Email</th></tr>";
            foreach ($staff_query->result_array() as $staff) {
                if (in_array($staff['staffid'], $allowed_staff_ids)) {
                    echo "<tr style='background-color: #d4edda;'>";
                    echo "<td>" . $staff['staffid'] . "</td>";
                    echo "<td>" . $staff['firstname'] . ' ' . $staff['lastname'] . "</td>";
                    echo "<td>" . $staff['email'] . "</td>";
                    echo "</tr>";
                }
            }
            echo "</table>";
        }
    }
}
?>
