<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Create_test_user extends AdminController
{
    public function index()
    {
        if (!is_admin()) {
            show_error('Access denied - Admin only');
        }
        
        echo "<h3>Create Test Non-Admin User</h3>";
        echo "<p>This will create a test user for permission testing</p>";
        
        if ($this->input->post('create_user')) {
            // Create test user
            $data = [
                'firstname' => 'Test',
                'lastname' => 'User',
                'email' => 'test.user@example.com',
                'password' => password_hash('testpass123', PASSWORD_DEFAULT),
                'admin' => 0, // NOT an admin
                'active' => 1,
                'datecreated' => date('Y-m-d H:i:s')
            ];
            
            $this->db->insert(db_prefix() . 'staff', $data);
            $new_staff_id = $this->db->insert_id();
            
            if ($new_staff_id) {
                echo "<div style='color: green;'>";
                echo "<h4>Test User Created Successfully!</h4>";
                echo "<ul>";
                echo "<li><strong>Staff ID:</strong> $new_staff_id</li>";
                echo "<li><strong>Email:</strong> test.user@example.com</li>";
                echo "<li><strong>Password:</strong> testpass123</li>";
                echo "<li><strong>Admin:</strong> No</li>";
                echo "</ul>";
                echo "</div>";
                
                // Now set a specific permission for this user
                echo "<h4>Setting Permission for Test User</h4>";
                echo "<form method='post'>";
                echo "<input type='hidden' name='set_permission' value='1'>";
                echo "<input type='hidden' name='staff_id' value='$new_staff_id'>";
                echo "<p>Permission Type:</p>";
                echo "<label><input type='radio' name='permission_type' value='view_own_only' checked> View Own Only (Default)</label><br>";
                echo "<label><input type='radio' name='permission_type' value='view_specific_staff'> View Specific Staff</label><br>";
                echo "<label><input type='radio' name='permission_type' value='view_all_staff'> View All Staff</label><br>";
                echo "<br><button type='submit'>Set Permission</button>";
                echo "</form>";
            } else {
                echo "<p style='color: red;'>Failed to create test user</p>";
            }
        } elseif ($this->input->post('set_permission')) {
            $staff_id = $this->input->post('staff_id');
            $permission_type = $this->input->post('permission_type');
            
            $permission_data = [
                'staff_id' => $staff_id,
                'permission_type' => $permission_type,
                'allowed_staff_ids' => ($permission_type === 'view_specific_staff') ? json_encode([get_staff_user_id()]) : null,
                'granted_by' => get_staff_user_id(),
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ];
            
            $this->db->insert(db_prefix() . 'reporting_dashboard_permissions', $permission_data);
            
            echo "<div style='color: green;'>";
            echo "<h4>Permission Set Successfully!</h4>";
            echo "<p>Test user (ID: $staff_id) now has '$permission_type' permission</p>";
            echo "<p><strong>Now you can:</strong></p>";
            echo "<ol>";
            echo "<li>Logout from current admin account</li>";
            echo "<li>Login as test.user@example.com / testpass123</li>";
            echo "<li>Access the reporting dashboard to test permissions</li>";
            echo "</ol>";
            echo "</div>";
        } else {
            echo "<form method='post'>";
            echo "<input type='hidden' name='create_user' value='1'>";
            echo "<p>Click to create a test non-admin user:</p>";
            echo "<button type='submit'>Create Test User</button>";
            echo "</form>";
        }
        
        // Show existing test users
        $this->db->select('staffid, firstname, lastname, email, admin, active');
        $this->db->from(db_prefix() . 'staff');
        $this->db->where('email', 'test.user@example.com');
        $existing = $this->db->get();
        
        if ($existing->num_rows() > 0) {
            echo "<h4>Existing Test User:</h4>";
            $user = $existing->row();
            echo "<ul>";
            echo "<li><strong>Staff ID:</strong> " . $user->staffid . "</li>";
            echo "<li><strong>Name:</strong> " . $user->firstname . ' ' . $user->lastname . "</li>";
            echo "<li><strong>Email:</strong> " . $user->email . "</li>";
            echo "<li><strong>Admin:</strong> " . ($user->admin ? 'Yes' : 'No') . "</li>";
            echo "<li><strong>Active:</strong> " . ($user->active ? 'Yes' : 'No') . "</li>";
            echo "</ul>";
            
            // Check permission
            $this->db->select('*');
            $this->db->from(db_prefix() . 'reporting_dashboard_permissions');
            $this->db->where('staff_id', $user->staffid);
            $perm_query = $this->db->get();
            
            if ($perm_query->num_rows() > 0) {
                $perm = $perm_query->row();
                echo "<p><strong>Current Permission:</strong> " . $perm->permission_type . "</p>";
            } else {
                echo "<p><strong>Current Permission:</strong> view_own_only (default)</p>";
            }
        }
    }
}
?>
