<?php

defined('BASEPATH') || exit('No direct script access allowed');

class Migration_Version_130 extends App_module_migration
{
    public function up()
    {
        $CI = &get_instance();

        _maybe_create_upload_path(get_upload_path_by_type('template_attachment'));

        if ($CI->db->table_exists(db_prefix() . 'whatsapp_templates_mapping')) {
            if (!$CI->db->field_exists('attachment', db_prefix() . 'whatsapp_templates_mapping')) {
                $CI->db->query('ALTER TABLE `' . db_prefix() . 'whatsapp_templates_mapping` ADD `attachment` VARCHAR(100) NULL DEFAULT NULL;');
            }
        }

        if ($CI->db->table_exists(db_prefix() . 'reminders')) {
            if (!$CI->db->field_exists('whatsapp_notified', db_prefix() . 'reminders')) {
                $CI->db->query('ALTER TABLE `' . db_prefix() . 'reminders` ADD `whatsapp_notified` INT NOT NULL DEFAULT 0;');
            }
        }

        if (table_exists('contacts')) {
            $CI = &get_instance();
            if (!$CI->db->field_exists('subscriptions_message', db_prefix() . 'contacts')) {
                $CI->db->query("ALTER TABLE `" . db_prefix() . "contacts` ADD `subscriptions_message` tinyint(1) NOT NULL DEFAULT '1'");
            }

            if (!$CI->db->field_exists('subscriptions_forward_phone', db_prefix() . 'contacts')) {
                $CI->db->query("ALTER TABLE `" . db_prefix() . "contacts` ADD `subscriptions_forward_phone` varchar(100) NULL DEFAULT NULL");
            }
        }


        $core_files_list = [
            APPPATH . 'models/Subscriptions_model.php'      => module_dir_path('whatsapp_api', '/resources/application/models/Subscriptions_model.php'),
        ];

        // Copy each file in $core_files_list to its actual path if it doesn't already exist
        foreach ($core_files_list as $actual_path => $resource_path) {
            if (!file_exists($actual_path . ".backup")) {
                copy($actual_path, $actual_path . ".backup");
            }
            copy($resource_path, $actual_path);
            
        }
    }
}
