<?php
// Quick verification script for reporting dashboard filters
defined('BASEPATH') or exit('No direct script access allowed');

echo "<h2>Reporting Dashboard Filter Debug</h2>";

// Check if the main dashboard file exists and can be read
$dashboardFile = __DIR__ . '/views/dashboard.php';
if (file_exists($dashboardFile)) {
    echo "<p><strong>✓ Dashboard file exists:</strong> " . $dashboardFile . "</p>";
    
    $content = file_get_contents($dashboardFile);
    
    // Check for key components
    $checks = [
        'datepicker class' => strpos($content, 'class="form-control datepicker"') !== false,
        'selectpicker class' => strpos($content, 'class="form-control selectpicker"') !== false,
        'appDatepicker function' => strpos($content, 'appDatepicker') !== false,
        'init_selectpicker function' => strpos($content, 'init_selectpicker') !== false,
        'jQuery document ready' => strpos($content, '$(document).ready') !== false,
        'Bootstrap Select initialization' => strpos($content, 'selectpicker(') !== false,
        'Date initialization' => strpos($content, 'setInitialDates') !== false,
    ];
    
    echo "<h3>Component Check:</h3><ul>";
    foreach ($checks as $name => $found) {
        $status = $found ? '✓' : '✗';
        $color = $found ? 'green' : 'red';
        echo "<li style='color: $color;'>$status $name</li>";
    }
    echo "</ul>";
    
    // Check for potential issues
    $issues = [];
    if (substr_count($content, '$(document).ready') > 1) {
        $issues[] = "Multiple $(document).ready blocks found";
    }
    if (strpos($content, 'init_selectpicker()') === false && strpos($content, 'selectpicker(') === false) {
        $issues[] = "No selectpicker initialization found";
    }
    if (strpos($content, 'appDatepicker') === false && strpos($content, 'datepicker(') === false) {
        $issues[] = "No datepicker initialization found";
    }
    
    if (!empty($issues)) {
        echo "<h3 style='color: red;'>Potential Issues:</h3><ul>";
        foreach ($issues as $issue) {
            echo "<li style='color: red;'>⚠ $issue</li>";
        }
        echo "</ul>";
    } else {
        echo "<h3 style='color: green;'>✓ No obvious issues detected</h3>";
    }
    
} else {
    echo "<p style='color: red;'><strong>✗ Dashboard file not found:</strong> " . $dashboardFile . "</p>";
}

// Check for assets
$assetsFile = __DIR__ . '/includes/assets.php';
if (file_exists($assetsFile)) {
    echo "<p><strong>✓ Assets file exists:</strong> " . $assetsFile . "</p>";
    $assetsContent = file_get_contents($assetsFile);
    
    if (strpos($assetsContent, 'bootstrap-select') !== false) {
        echo "<p style='color: green;'>✓ Bootstrap Select assets referenced</p>";
    } else {
        echo "<p style='color: orange;'>⚠ No Bootstrap Select assets found in assets.php</p>";
    }
} else {
    echo "<p style='color: red;'><strong>✗ Assets file not found:</strong> " . $assetsFile . "</p>";
}

echo "<h3>Quick Fix Recommendations:</h3>";
echo "<ol>";
echo "<li>Ensure both datepicker and selectpicker are properly initialized</li>";
echo "<li>Check browser console for JavaScript errors</li>";
echo "<li>Verify Perfex CRM's standard assets are loading</li>";
echo "<li>Use the 'Refresh Filters' button if elements don't load</li>";
echo "</ol>";

echo "<p><a href='dropdown_test.php'>→ Test dropdowns and date pickers</a></p>";
?>
