<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Quick_debug extends AdminController
{
    public function index()
    {
        $current_staff_id = get_staff_user_id();
        
        echo "<h3>Quick Permission Debug for Staff ID: $current_staff_id</h3>";
        
        // Check if admin
        echo "<p><strong>Is Admin:</strong> " . (is_admin($current_staff_id) ? 'YES' : 'NO') . "</p>";
        
        // Check database permission
        $this->db->select('*');
        $this->db->from(db_prefix() . 'reporting_dashboard_permissions');
        $this->db->where('staff_id', $current_staff_id);
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            $permission = $query->row();
            echo "<h4>Database Permission Found:</h4>";
            echo "<ul>";
            echo "<li><strong>Permission Type:</strong> " . $permission->permission_type . "</li>";
            echo "<li><strong>Allowed Staff IDs:</strong> " . ($permission->allowed_staff_ids ?: 'NULL') . "</li>";
            echo "<li><strong>Created At:</strong> " . ($permission->created_at ?: 'NULL') . "</li>";
            echo "<li><strong>Updated At:</strong> " . ($permission->updated_at ?: 'NULL') . "</li>";
            echo "</ul>";
        } else {
            echo "<p><strong>No Database Permission Found</strong> (defaults to view_own_only)</p>";
        }
        
        // Show what the logic should return
        $permission_type = 'view_own_only'; // default
        $allowed_staff_ids = [$current_staff_id]; // default
        
        if ($query->num_rows() > 0) {
            $permission = $query->row();
            $permission_type = $permission->permission_type;
            
            if ($permission_type === 'view_specific_staff') {
                $allowed_staff_ids = json_decode($permission->allowed_staff_ids, true) ?: [];
                if (!in_array($current_staff_id, $allowed_staff_ids)) {
                    $allowed_staff_ids[] = $current_staff_id;
                }
            } elseif ($permission_type === 'view_all_staff') {
                $allowed_staff_ids = []; // empty means all
            }
        }
        
        // Admin override
        if (is_admin($current_staff_id)) {
            $permission_type = 'view_all_staff';
            $allowed_staff_ids = [];
            echo "<p style='color: red;'><strong>ADMIN OVERRIDE:</strong> Admin users always get view_all_staff permission</p>";
        }
        
        echo "<h4>Final Logic Result:</h4>";
        echo "<ul>";
        echo "<li><strong>Permission Type:</strong> $permission_type</li>";
        echo "<li><strong>Allowed Staff IDs:</strong> " . (empty($allowed_staff_ids) ? 'ALL (empty array)' : implode(', ', $allowed_staff_ids)) . "</li>";
        echo "<li><strong>Can View All Staff:</strong> " . ($permission_type === 'view_all_staff' ? 'YES' : 'NO') . "</li>";
        echo "</ul>";
        
        // Show all staff
        $this->db->select('staffid, firstname, lastname, email, admin, active');
        $this->db->from(db_prefix() . 'staff');
        $this->db->where('active', 1);
        $all_staff_query = $this->db->get();
        
        echo "<h4>All Active Staff (Total: " . $all_staff_query->num_rows() . "):</h4>";
        echo "<table border='1'>";
        echo "<tr><th>Staff ID</th><th>Name</th><th>Email</th><th>Admin</th><th>Should Show?</th></tr>";
        foreach ($all_staff_query->result_array() as $staff) {
            $should_show = (empty($allowed_staff_ids) || in_array($staff['staffid'], $allowed_staff_ids));
            $bg_color = $should_show ? '#d4edda' : '#f8d7da';
            echo "<tr style='background-color: $bg_color;'>";
            echo "<td>" . $staff['staffid'] . "</td>";
            echo "<td>" . $staff['firstname'] . ' ' . $staff['lastname'] . "</td>";
            echo "<td>" . $staff['email'] . "</td>";
            echo "<td>" . ($staff['admin'] == 1 ? 'Yes' : 'No') . "</td>";
            echo "<td>" . ($should_show ? 'YES' : 'NO') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        echo "<p><strong>Green rows</strong> = Should be shown to current user<br>";
        echo "<strong>Red rows</strong> = Should NOT be shown to current user</p>";
    }
}
?>
