<?php

namespace modules\api\core;

require_once __DIR__.'/../third_party/node.php';
require_once __DIR__.'/../vendor/autoload.php';

use Firebase\JWT\JWT as api_JWT;
use Firebase\JWT\Key as api_Key;
use WpOrg\Requests\Requests as api_Requests;

class Apiinit
{
    public static function the_da_vinci_code($module_name)
    {
        // Complete bypass of all activation checks
        return true;
    }
    
    public static function ease_of_mind($module_name)
    {
        // Bypass ease of mind check
        return true;
        
        if (!function_exists($module_name . '_actLib') || !function_exists($module_name . '_sidecheck') || !function_exists($module_name . '_deregister')) {
            get_instance()->app_modules->deactivate($module_name);
        }
    }
    
    public static function activate($module)
    {
        // Bypass activation screen - module is automatically activated
        return true;
        
        if (!option_exists($module['system_name'] . '_verification_id') && empty(get_option($module['system_name'] . '_verification_id'))) {
            $CI                   = &get_instance();
            $data['submit_url']   = admin_url($module['system_name']) . '/env_ver/activate';
            $data['original_url'] = admin_url('modules/activate/' . $module['system_name']);
            $data['module_name']  = $module['system_name'];
            $data['title']        = 'Module activation';
            echo $CI->load->view($module['system_name'] . '/activate', $data, true);
            exit;
        }
    }
    
    public static function getUserIP()
    {
        $ipaddress = '';
        if (isset($_SERVER['HTTP_CLIENT_IP'])) {
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } elseif (isset($_SERVER['HTTP_X_FORWARDED'])) {
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        } elseif (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        } elseif (isset($_SERVER['HTTP_FORWARDED'])) {
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        } elseif (isset($_SERVER['REMOTE_ADDR'])) {
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        } else {
            $ipaddress = 'UNKNOWN';
        }

        return $ipaddress;
    }
    
	public static function pre_validate($module_name, $code = '')
	{
		get_instance()->load->library('api_aeiou');
		$module = get_instance()->app_modules->get($module_name);
		if (empty($code)) {
			return ['status' => false, 'message' => 'Purchase key is required'];
		}
		$all_activated = get_instance()->app_modules->get_activated();
		foreach ($all_activated as $active_module => $value) {
			$verification_id =  get_option($active_module.'_verification_id');
			if (!empty($verification_id)) {
				$verification_id = base64_decode($verification_id);
				$id_data         = explode('|', $verification_id);
				if ($id_data[3] == $code) {
					return ['status' => false, 'message' => 'This does not seem like a purchase code of this product.'];
				}
			}
		}

		$envato_res = get_instance()->api_aeiou->getPurchaseData($code);

		if (empty($envato_res) || !\is_object($envato_res) || isset($envato_res->error) || !isset($envato_res->sold_at)) {
			return ['status' => false, 'message' => 'Error - Please contact support team.'];
		}
		if (basename($module['headers']['uri']) != $envato_res->item->id) {
			return ['status' => false, 'message' => 'Invalid license key used.'];
		}
		
		// Retrieve and store the supported_until value if it exists
		if (isset($envato_res->supported_until)) {
			// Store the supported_until value in the database
			update_option($module_name.'_supported_until', $envato_res->supported_until);
		}

		get_instance()->load->library('user_agent');
		$data['user_agent']       = get_instance()->agent->browser().' '.get_instance()->agent->version();
		$data['activated_domain'] = base_url();
		$data['requested_at']     = date('Y-m-d H:i:s');
		$data['ip']               = self::getUserIP();
		$data['os']               = get_instance()->agent->platform();
		$data['purchase_code']    = $code;
		$data['envato_res']       = $envato_res;
		$data                     = json_encode($data);

		try {
			$response = api_Requests::post(REG_PROD_POINT, ['Accept' => 'application/json'], $data);

			if ($response->status_code >= 500 || 404 == $response->status_code) {
				update_option($module_name.'_verification_id', '');
				update_option($module_name.'_last_verification', time());
				update_option($module_name.'_heartbeat', base64_encode(json_encode(['status' => $response->status_code, 'id' => $code, 'end_point' => REG_PROD_POINT])));

				return ['status' => true];
			}
			$response = json_decode($response->body);
			if (200 != $response->status) {
				return ['status' => false, 'message' => $response->message];
			}
			$return = $response->data ?? [];
			if (!empty($return)) {
				update_option($module_name.'_verification_id', base64_encode($return->verification_id));
				update_option($module_name.'_last_verification', time());
				update_option($module_name.'_product_token', $return->token);
				delete_option($module_name.'_heartbeat');

				return ['status' => true];
			}
		} catch (Exception $e) {
			update_option($module_name.'_verification_id', '');
			update_option($module_name.'_last_verification', time());
			update_option($module_name.'_heartbeat', base64_encode(json_encode(['status' => $request->status_code, 'id' => $code, 'end_point' => REG_PROD_POINT])));

			return ['status' => true];
		}

		return ['status' => false, 'message' => 'Something went wrong'];
	}
}
