<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="clearfix"></div>
                        
                        <!-- Header -->
                        <div class="row">
                            <div class="col-md-12">
                                <h4 class="customer-profile-group-heading">
                                    <i class="fa fa-key"></i> OpenAI Settings
                                    <small class="text-muted">Configure your OpenAI API integration</small>
                                </h4>
                                <hr />
                            </div>
                        </div>

                        <?php echo form_open(admin_url('openai_settings'), ['id' => 'openai-settings-form']); ?>
                        
                        <div class="row">
                            <div class="col-md-8">
                                <!-- API Key Section -->
                                <div class="form-group">
                                    <label for="openai_api_key" class="control-label">
                                        <i class="fa fa-key"></i> OpenAI API Key
                                        <span class="text-danger">*</span>
                                    </label>
                                    <div class="input-group">
                                        <input type="password" 
                                               class="form-control" 
                                               name="openai_api_key" 
                                               id="openai_api_key"
                                               value="<?php echo !empty($current_api_key) ? $current_api_key : ''; ?>"
                                               placeholder="sk-..." />
                                        <span class="input-group-btn">
                                            <button type="button" 
                                                    class="btn btn-default" 
                                                    id="toggle-api-key"
                                                    title="Show/Hide API Key">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                            <button type="button" 
                                                    class="btn btn-info" 
                                                    id="test-api-key"
                                                    title="Test API Key">
                                                <i class="fa fa-check"></i> Test
                                            </button>
                                        </span>
                                    </div>
                                    <p class="text-muted">
                                        Get your API key from <a href="https://platform.openai.com/api-keys" target="_blank">OpenAI Platform</a>
                                    </p>
                                </div>

                                <!-- Model Selection -->
                                <div class="form-group">
                                    <label for="openai_model" class="control-label">
                                        <i class="fa fa-cog"></i> OpenAI Model
                                    </label>
                                    <select name="openai_model" id="openai_model" class="form-control">
                                        <option value="gpt-4o-mini" <?php echo $openai_model == 'gpt-4o-mini' ? 'selected' : ''; ?>>
                                            GPT-4o Mini (Recommended - Fast & Cost-effective)
                                        </option>
                                        <option value="gpt-4o" <?php echo $openai_model == 'gpt-4o' ? 'selected' : ''; ?>>
                                            GPT-4o (Latest Model - Higher Cost)
                                        </option>
                                        <option value="gpt-4-turbo" <?php echo $openai_model == 'gpt-4-turbo' ? 'selected' : ''; ?>>
                                            GPT-4 Turbo (Previous Generation)
                                        </option>
                                        <option value="gpt-3.5-turbo" <?php echo $openai_model == 'gpt-3.5-turbo' ? 'selected' : ''; ?>>
                                            GPT-3.5 Turbo (Budget Option)
                                        </option>
                                    </select>
                                    <p class="text-muted">Choose the OpenAI model for lead analysis</p>
                                </div>

                                <!-- Max Tokens -->
                                <div class="form-group">
                                    <label for="openai_max_tokens" class="control-label">
                                        <i class="fa fa-sliders"></i> Max Tokens
                                    </label>
                                    <input type="number" 
                                           class="form-control" 
                                           name="openai_max_tokens" 
                                           id="openai_max_tokens"
                                           value="<?php echo $openai_max_tokens; ?>"
                                           min="100" 
                                           max="4000"
                                           step="100" />
                                    <p class="text-muted">Maximum number of tokens for AI responses (100-4000)</p>
                                </div>

                                <!-- Submit Buttons -->
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fa fa-save"></i> Save Settings
                                    </button>
                                    <button type="button" class="btn btn-default" id="clear-settings">
                                        <i class="fa fa-trash"></i> Clear Settings
                                    </button>
                                    <a href="<?php echo admin_url('ai_setup'); ?>" class="btn btn-info">
                                        <i class="fa fa-arrow-left"></i> Back to AI Setup
                                    </a>
                                </div>
                            </div>

                            <!-- Info Panel -->
                            <div class="col-md-4">
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h3 class="panel-title"><i class="fa fa-info-circle"></i> Information</h3>
                                    </div>
                                    <div class="panel-body">
                                        <h5><i class="fa fa-key"></i> API Key</h5>
                                        <p class="small">Your OpenAI API key is encrypted and stored securely. It's only used for AI analysis requests.</p>
                                        
                                        <h5><i class="fa fa-money"></i> Cost Information</h5>
                                        <p class="small">
                                            <strong>GPT-4o Mini:</strong> ~$0.15 per 1M tokens<br>
                                            <strong>GPT-4o:</strong> ~$2.50 per 1M tokens<br>
                                            <strong>GPT-4 Turbo:</strong> ~$10 per 1M tokens
                                        </p>
                                        
                                        <h5><i class="fa fa-shield"></i> Security</h5>
                                        <p class="small">Your API key is stored encrypted and never logged. Only admins can access these settings.</p>
                                        
                                        <h5><i class="fa fa-question-circle"></i> Support</h5>
                                        <p class="small">
                                            Need help? Check the 
                                            <a href="https://platform.openai.com/docs" target="_blank">OpenAI Documentation</a>
                                        </p>
                                    </div>
                                </div>

                                <!-- Current Status -->
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h3 class="panel-title"><i class="fa fa-status"></i> Current Status</h3>
                                    </div>
                                    <div class="panel-body">
                                        <div id="api-status">
                                            <?php if (!empty($current_api_key)): ?>
                                                <p class="text-success">
                                                    <i class="fa fa-check-circle"></i> API Key Configured
                                                </p>
                                                <p class="small">
                                                    Key: <?php echo substr($current_api_key, 0, 7) . '...' . substr($current_api_key, -4); ?>
                                                </p>
                                            <?php else: ?>
                                                <p class="text-warning">
                                                    <i class="fa fa-exclamation-triangle"></i> No API Key Set
                                                </p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php init_tail(); ?>

<script>
// OpenAI Settings JavaScript - Loaded after jQuery
$(document).ready(function() {
    // Toggle API key visibility
    $('#toggle-api-key').click(function() {
        var input = $('#openai_api_key');
        var icon = $(this).find('i');
        
        if (input.attr('type') === 'password') {
            input.attr('type', 'text');
            icon.removeClass('fa-eye').addClass('fa-eye-slash');
        } else {
            input.attr('type', 'password');
            icon.removeClass('fa-eye-slash').addClass('fa-eye');
        }
    });

    // Test API key
    $('#test-api-key').click(function() {
        var button = $(this);
        var apiKey = $('#openai_api_key').val();
        
        if (!apiKey || apiKey.length < 10) {
            alert_float('warning', 'Please enter a valid API key first');
            return;
        }

        button.prop('disabled', true);
        button.html('<i class="fa fa-spinner fa-spin"></i> Testing...');

        // Prepare data with CSRF token
        var formData = new FormData();
        formData.append('api_key', apiKey);
        
        // Get CSRF token from the form
        var csrfInput = $('input[name*="csrf"]');
        if (csrfInput.length > 0) {
            formData.append(csrfInput.attr('name'), csrfInput.val());
        }

        $.ajax({
            url: admin_url + 'openai_settings/test_api_key',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json'
        })
        .done(function(response) {
            if (response && response.success) {
                alert_float('success', response.message || 'API key is valid');
            } else {
                alert_float('danger', response.message || 'API key test failed');
            }
        })
        .fail(function(xhr, status, error) {
            var errorMsg = 'Failed to test API key';
            try {
                var response = JSON.parse(xhr.responseText);
                if (response.message) {
                    errorMsg = response.message;
                }
            } catch (e) {
                if (xhr.responseText) {
                    errorMsg = 'Server error: ' + xhr.responseText.substring(0, 100);
                }
            }
            
            alert_float('danger', errorMsg);
        })
        .always(function() {
            button.prop('disabled', false);
            button.html('<i class="fa fa-check"></i> Test');
        });
    });

    // Clear settings
    $('#clear-settings').click(function() {
        if (confirm('Are you sure you want to clear all OpenAI settings?')) {
            var formData = new FormData();
            
            // Get CSRF token from the form
            var csrfInput = $('input[name*="csrf"]');
            if (csrfInput.length > 0) {
                formData.append(csrfInput.attr('name'), csrfInput.val());
            }
            
            $.ajax({
                url: admin_url + 'openai_settings/clear_settings',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'json'
            })
            .done(function(response) {
                if (response && response.success) {
                    alert_float('success', response.message || 'Settings cleared successfully');
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                } else {
                    alert_float('danger', response.message || 'Failed to clear settings');
                }
            })
            .fail(function(xhr, status, error) {
                alert_float('danger', 'Failed to clear settings: ' + error);
            });
        }
    });
});
</script>
