<?php defined('BASEPATH') or exit('No direct script access allowed');
$data = '<div class="row">';
foreach($attachments as $attachment) {
    $attachment_url = site_url('download/file/lead_attachment/'.$attachment['id']);
    if(!empty($attachment['external'])){
        $attachment_url = $attachment['external_link'];
    }
    
    $data .= '<div class="display-block lead-attachment-wrapper">';
    $data .= '<div class="col-md-10">';
    
    // Add better preview for images
    $is_image = strpos($attachment['filetype'], 'image/') !== false;
    if($is_image) {
        $data .= '<div class="lead-attachment-preview">';
        $data .= '<a href="'.e($attachment_url).'" target="_blank" class="lead-attachment-image-link">';
        $data .= '<img src="'.e($attachment_url).'" class="img-responsive img-thumbnail" style="max-height: 100px; margin-bottom: 10px;" alt="'.e($attachment['file_name']).'">';
        $data .= '</a>';
        $data .= '</div>';
    }
    
    $data .= '<div class="pull-left"><i class="'.e(get_mime_class($attachment['filetype'])).'"></i></div>';
    $data .= '<a href="'.e($attachment_url).'" target="_blank" class="bold">'.e($attachment['file_name']).'</a>';
    $data .= '<p class="text-muted">'.e($attachment["filetype"]).'</p>';    // Enhanced description display with better formatting and error handling
    $hasDescription = false;
    $description = '';
    
    // Try to get description from multiple sources
    if (isset($attachment['description']) && !empty($attachment['description'])) {
        $hasDescription = true;
        $description = $attachment['description'];
    }
    
    // Add debug info
    error_log("Attachment display - ID: " . $attachment['id'] . ", Has description: " . ($hasDescription ? "YES" : "NO"));
    if ($hasDescription) {
        error_log("Description content: " . $description);
    }
    
    // Always output description section
    $data .= '<div class="attachment-description">';
    if ($hasDescription) {
        $data .= '<p class="text-info"><strong>'._l('lead_attachment_description').':</strong> '.e($description).'</p>';
    } else {
        $data .= '<p class="text-muted"><em>No description available</em></p>';
        
        // Attempt to fetch description directly from database as fallback
        $CI =& get_instance();
        $CI->db->select('description');
        $CI->db->where('id', $attachment['id']);
        $result = $CI->db->get('tblfiles')->row();
        
        if ($result && !empty($result->description)) {
            $data .= '<p class="text-success"><strong>Found description in database:</strong> '.e($result->description).'</p>';
        }
    }
    $data .= '</div>';
    
    $data .= '</div>';
    $data .= '<div class="col-md-2 text-right">';
    if($attachment['staffid'] == get_staff_user_id() || is_admin()){
        $data .= '<a href="#" class="text-danger" onclick="delete_lead_attachment(this,'.$attachment['id'].', '.$attachment['rel_id'].'); return false;"><i class="fa fa fa-times"></i></a>';
    }
    $data .= '</div>';
    $data .= '<div class="clearfix"></div><hr/>';
    $data .= '</div>';
}
$data .= '</div>';
echo $data;
