<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h4 class="no-margin">
                                    <i class="fa fa-list-alt"></i> <?php echo $title; ?>
                                </h4>
                            </div>
                            <div class="col-md-4 text-right">
                                <a href="<?php echo admin_url('ai_setup/create_test_log'); ?>" class="btn btn-info btn-sm">
                                    <i class="fa fa-plus"></i> Create Test Log
                                </a>
                                <?php echo form_open(admin_url('ai_setup/api_logs'), ['style' => 'display:inline-block; margin-left: 5px;']); ?>
                                <button type="submit" name="clear_logs" value="1" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to clear all API logs?')">
                                    <i class="fa fa-trash"></i> Clear Logs
                                </button>
                                <?php echo form_close(); ?>
                            </div>
                        </div>
                        <hr class="hr-panel-heading">
                        
                        <div class="row">
                            <div class="col-md-12">
                                <p>Monitor AI API calls, responses, and performance. Total logs: <strong><?php echo $total_logs; ?></strong></p>
                            </div>
                        </div>
                        
                        <?php if (empty($logs)): ?>
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> No API logs found. Logs will appear here when AI analysis is performed.
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Date/Time</th>
                                            <th>Lead ID</th>
                                            <th>Endpoint</th>
                                            <th>Status</th>
                                            <th>Response Time</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($logs as $log): ?>
                                            <tr>
                                                <td>
                                                    <small><?php echo _dt($log->created_at); ?></small>
                                                </td>
                                                <td>
                                                    <?php if ($log->lead_id): ?>
                                                        <a href="<?php echo admin_url('leads/index/' . $log->lead_id); ?>" target="_blank">
                                                            #<?php echo $log->lead_id; ?>
                                                        </a>
                                                    <?php else: ?>
                                                        <span class="text-muted">-</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <code><?php echo e($log->endpoint); ?></code>
                                                </td>
                                                <td>
                                                    <?php if ($log->success): ?>
                                                        <span class="label label-success">
                                                            <i class="fa fa-check"></i> Success (<?php echo $log->status_code; ?>)
                                                        </span>
                                                    <?php else: ?>
                                                        <span class="label label-danger">
                                                            <i class="fa fa-times"></i> Failed (<?php echo $log->status_code ?: 'N/A'; ?>)
                                                        </span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if ($log->response_time): ?>
                                                        <span class="<?php echo $log->response_time > 5 ? 'text-warning' : 'text-success'; ?>">
                                                            <?php echo number_format($log->response_time, 2); ?>s
                                                        </span>
                                                    <?php else: ?>
                                                        <span class="text-muted">-</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <button type="button" class="btn btn-xs btn-info" onclick="viewLogDetails(<?php echo $log->id; ?>)">
                                                        <i class="fa fa-eye"></i> View
                                                    </button>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            
                            <?php echo $pagination; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Log Details Modal -->
<div class="modal fade" id="logDetailsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">API Log Details</h4>
            </div>
            <div class="modal-body">
                <div id="logDetailsContent">
                    <i class="fa fa-spinner fa-spin"></i> Loading...
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
function viewLogDetails(logId) {
    $('#logDetailsModal').modal('show');
    $('#logDetailsContent').html('<i class="fa fa-spinner fa-spin"></i> Loading...');
    
    $.ajax({
        url: admin_url + 'ai_setup/get_log_details/' + logId,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            console.log('Log details response:', response);
            
            if (response && response.success) {
                var log = response.data;
                var html = '<div class="row">';
                
                // Basic info
                html += '<div class="col-md-6">';
                html += '<h5>Basic Information</h5>';
                html += '<table class="table table-bordered table-sm">';
                html += '<tr><td><strong>ID:</strong></td><td>' + (log.id || 'N/A') + '</td></tr>';
                html += '<tr><td><strong>Date:</strong></td><td>' + (log.created_at || 'N/A') + '</td></tr>';
                html += '<tr><td><strong>Lead ID:</strong></td><td>' + (log.lead_id || 'N/A') + '</td></tr>';
                html += '<tr><td><strong>Endpoint:</strong></td><td><code>' + (log.endpoint || 'N/A') + '</code></td></tr>';
                html += '<tr><td><strong>Method:</strong></td><td>' + (log.method || 'N/A') + '</td></tr>';
                html += '<tr><td><strong>Status:</strong></td><td>' + (log.success ? '<span class="text-success">Success</span>' : '<span class="text-danger">Failed</span>') + '</td></tr>';
                html += '<tr><td><strong>Status Code:</strong></td><td>' + (log.status_code || 'N/A') + '</td></tr>';
                html += '<tr><td><strong>Response Time:</strong></td><td>' + (log.response_time ? log.response_time + 's' : 'N/A') + '</td></tr>';
                html += '</table>';
                html += '</div>';
                
                // Error message
                html += '<div class="col-md-6">';
                if (log.error_message) {
                    html += '<h5>Error Message</h5>';
                    html += '<div class="alert alert-danger"><small>' + log.error_message + '</small></div>';
                }
                html += '</div>';
                html += '</div>';
                
                // Request data
                if (log.request_data) {
                    html += '<div class="row mtop15">';
                    html += '<div class="col-md-12">';
                    html += '<h5>Request Data</h5>';
                    html += '<pre style="max-height: 200px; overflow-y: auto; white-space: pre-wrap;">' + log.request_data + '</pre>';
                    html += '</div>';
                    html += '</div>';
                }
                
                // Response data
                if (log.response_data) {
                    html += '<div class="row mtop15">';
                    html += '<div class="col-md-12">';
                    html += '<h5>Response Data</h5>';
                    html += '<pre style="max-height: 200px; overflow-y: auto; white-space: pre-wrap;">' + log.response_data + '</pre>';
                    html += '</div>';
                    html += '</div>';
                }
                
                $('#logDetailsContent').html(html);
            } else {
                $('#logDetailsContent').html('<div class="alert alert-danger">Error loading log details: ' + (response ? response.message : 'Unknown error') + '</div>');
            }
        },
        error: function(xhr, status, error) {
            console.error('AJAX error:', xhr.responseText);
            var errorMsg = 'Error loading log details';
            if (xhr.responseText) {
                try {
                    var errorResponse = JSON.parse(xhr.responseText);
                    errorMsg += ': ' + (errorResponse.message || xhr.responseText);
                } catch (e) {
                    errorMsg += ': ' + xhr.responseText;
                }
            }
            $('#logDetailsContent').html('<div class="alert alert-danger">' + errorMsg + '</div>');
        }
    });
}
</script>

<?php init_tail(); ?>
