<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h4 class="no-margin">
                                    <i class="fa fa-balance-scale"></i> <?php echo $title; ?>
                                </h4>
                            </div>
                            <div class="col-md-4 text-right">
                                <a href="<?php echo admin_url('ai_reports'); ?>" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> Back to Reports
                                </a>
                                <button onclick="window.print()" class="btn btn-info">
                                    <i class="fa fa-print"></i> Print
                                </button>
                            </div>
                        </div>
                        <hr class="hr-panel-heading">
                        
                        <!-- Comparison Summary -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="alert alert-info">
                                    <h4><i class="fa fa-info-circle"></i> Comparison Summary</h4>
                                    <p>Comparing <?php echo count($reports); ?> AI analysis reports side by side.</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Reports Comparison Table -->
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th width="20%">Attribute</th>
                                        <?php foreach ($reports as $index => $report): ?>
                                            <th width="<?php echo round(80 / count($reports)); ?>%">
                                                Report #<?php echo $report->id; ?>
                                            </th>
                                        <?php endforeach; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Lead Information -->
                                    <tr>
                                        <td><strong>Lead Name</strong></td>
                                        <?php foreach ($reports as $report): ?>
                                            <td>
                                                <a href="<?php echo admin_url('leads/index/' . $report->lead_id); ?>">
                                                    <?php echo $report->lead_name ?: 'Unknown'; ?>
                                                </a>
                                            </td>
                                        <?php endforeach; ?>
                                    </tr>
                                    <tr>
                                        <td><strong>Lead ID</strong></td>
                                        <?php foreach ($reports as $report): ?>
                                            <td>#<?php echo $report->lead_id; ?></td>
                                        <?php endforeach; ?>
                                    </tr>
                                    <tr>
                                        <td><strong>Company</strong></td>
                                        <?php foreach ($reports as $report): ?>
                                            <td><?php echo $report->lead_company ?: 'N/A'; ?></td>
                                        <?php endforeach; ?>
                                    </tr>
                                    
                                    <!-- Analysis Results -->
                                    <tr class="info">
                                        <td><strong>Confidence Score</strong></td>
                                        <?php foreach ($reports as $report): ?>
                                            <td>
                                                <?php 
                                                $score = $report->confidence_score ?: 0;
                                                $score_class = $score >= 80 ? 'success' : ($score >= 60 ? 'warning' : 'danger');
                                                ?>
                                                <div class="progress" style="margin-bottom: 5px;">
                                                    <div class="progress-bar progress-bar-<?php echo $score_class; ?>" 
                                                         style="width: <?php echo $score; ?>%"><?php echo $score; ?>%</div>
                                                </div>
                                            </td>
                                        <?php endforeach; ?>
                                    </tr>
                                    <tr class="info">
                                        <td><strong>Verdict</strong></td>
                                        <?php foreach ($reports as $report): ?>
                                            <td>
                                                <?php 
                                                $verdict = $report->purchase_likelihood ?: 'Unknown';
                                                $badge_class = '';
                                                switch (strtolower($verdict)) {
                                                    case 'hot': $badge_class = 'danger'; break;
                                                    case 'warm': $badge_class = 'warning'; break;
                                                    case 'cold': $badge_class = 'info'; break;
                                                    case 'qualified': $badge_class = 'success'; break;
                                                    default: $badge_class = 'default';
                                                }
                                                ?>
                                                <span class="label label-<?php echo $badge_class; ?>"><?php echo $verdict; ?></span>
                                            </td>
                                        <?php endforeach; ?>
                                    </tr>
                                    <tr>
                                        <td><strong>Analysis Type</strong></td>
                                        <?php foreach ($reports as $report): ?>
                                            <td><?php echo ucfirst(str_replace('_', ' ', $report->analysis_type)); ?></td>
                                        <?php endforeach; ?>
                                    </tr>
                                    
                                    <!-- Enhanced Data if available -->
                                    <?php 
                                    $has_enhanced_data = false;
                                    foreach ($reports as $report) {
                                        if (!empty($report->ai_response_data)) {
                                            $has_enhanced_data = true;
                                            break;
                                        }
                                    }
                                    ?>
                                    
                                    <?php if ($has_enhanced_data): ?>
                                    <tr class="warning">
                                        <td><strong>Urgency Level</strong></td>
                                        <?php foreach ($reports as $report): ?>
                                            <td>
                                                <?php if (isset($report->ai_response_data['urgency_level'])): ?>
                                                    <?php 
                                                    $urgency = $report->ai_response_data['urgency_level'];
                                                    $urgency_class = strtolower($urgency) == 'high' ? 'danger' : (strtolower($urgency) == 'medium' ? 'warning' : 'info');
                                                    ?>
                                                    <span class="label label-<?php echo $urgency_class; ?>"><?php echo $urgency; ?></span>
                                                <?php else: ?>
                                                    <span class="text-muted">N/A</span>
                                                <?php endif; ?>
                                            </td>
                                        <?php endforeach; ?>
                                    </tr>
                                    <?php endif; ?>
                                    
                                    <!-- Key Insights -->
                                    <tr>
                                        <td><strong>Key Insights</strong></td>
                                        <?php foreach ($reports as $report): ?>
                                            <td>
                                                <div style="max-height: 150px; overflow-y: auto;">
                                                    <?php echo nl2br(htmlspecialchars(substr($report->key_insights ?: 'No insights available', 0, 300))); ?>
                                                    <?php if (strlen($report->key_insights ?: '') > 300): ?>
                                                        <br><small class="text-muted">... (truncated)</small>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        <?php endforeach; ?>
                                    </tr>
                                    
                                    <!-- Recommendations -->
                                    <tr>
                                        <td><strong>Recommendations</strong></td>
                                        <?php foreach ($reports as $report): ?>
                                            <td>
                                                <div style="max-height: 150px; overflow-y: auto;">
                                                    <?php echo nl2br(htmlspecialchars(substr($report->recommendations ?: 'No recommendations available', 0, 300))); ?>
                                                    <?php if (strlen($report->recommendations ?: '') > 300): ?>
                                                        <br><small class="text-muted">... (truncated)</small>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        <?php endforeach; ?>
                                    </tr>
                                    
                                    <!-- Report Details -->
                                    <tr class="active">
                                        <td><strong>Created By</strong></td>
                                        <?php foreach ($reports as $report): ?>
                                            <td><?php echo $report->created_by_name ?: 'Unknown'; ?></td>
                                        <?php endforeach; ?>
                                    </tr>
                                    <tr class="active">
                                        <td><strong>Created Date</strong></td>
                                        <?php foreach ($reports as $report): ?>
                                            <td><?php echo _dt($report->created_at); ?></td>
                                        <?php endforeach; ?>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Individual Report Actions -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">Individual Report Actions</h4>
                                    </div>
                                    <div class="panel-body">
                                        <div class="row">
                                            <?php foreach ($reports as $report): ?>
                                                <div class="col-md-<?php echo count($reports) <= 2 ? '6' : (count($reports) <= 3 ? '4' : '3'); ?>">
                                                    <div class="text-center">
                                                        <h5>Report #<?php echo $report->id; ?></h5>
                                                        <div class="btn-group-vertical">
                                                            <a href="<?php echo admin_url('ai_reports/view/' . $report->id); ?>" 
                                                               class="btn btn-primary btn-sm">
                                                                <i class="fa fa-eye"></i> View Full Report
                                                            </a>
                                                            <a href="<?php echo admin_url('leads/index/' . $report->lead_id); ?>" 
                                                               class="btn btn-info btn-sm">
                                                                <i class="fa fa-user"></i> View Lead
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>

<style>
@media print {
    .btn, .panel-heading .btn, .content-header, #wrapper .sidebar {
        display: none !important;
    }
    
    .content {
        margin-left: 0 !important;
    }
    
    .table {
        font-size: 12px;
    }
}

.progress {
    height: 20px;
    margin-bottom: 5px;
}

.table td {
    vertical-align: top;
}

.table td div {
    word-wrap: break-word;
}

.btn-group-vertical .btn {
    margin-bottom: 5px;
}
</style>
