<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Database Query Logger Hook Class
 */
class LogQueries
{
    /**
     * Log database queries
     */
    public function log_queries()
    {
        $CI = &get_instance();
        
        if (!isset($CI->db) || !$CI->db->save_queries) {
            return;
        }

        $times = $CI->db->query_times;
        $dbs = [];
        $output = '';
        $queries = $CI->db->queries;

        if (count($queries) == 0) {
            return;
        }

        foreach ($queries as $key => $query) {
            $output .= 'SQL: ' . $query . "\n";
            
            if (!empty($times[$key])) {
                $output .= 'Time: ' . $times[$key] . "\n";
            }
            
            $output .= "\n";
        }        // Write query log to file
        if (function_exists('app_log')) {
            app_log('DB QUERIES: ' . count($queries), 'debug', ['query_count' => count($queries)]);
            
            // If slow queries are detected (more than 1 second), log them separately
            foreach ($times as $key => $time) {
                if ($time > 1) {
                    app_log('SLOW QUERY: ' . $queries[$key], 'warning', ['execution_time' => $time]);
                }
            }
        } else {
            // Fallback if app_log helper is not loaded yet
            $log_path = APPPATH . 'logs/db_query_log-' . date('Y-m-d') . '.php';
            $header = '';
            if (!file_exists($log_path)) {
                $header = "<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>\n";
            }
            $log_content = $header . date('Y-m-d H:i:s') . " - Query count: " . count($queries) . "\n";
            file_put_contents($log_path, $log_content, FILE_APPEND);
        }
    }
}
