<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4>Simple Reporting Dashboard - Permission Test</h4>
                        <hr>
                        
                        <div class="alert alert-info">
                            <h5>Debug Information:</h5>
                            <ul>
                                <li><strong>Current Staff ID:</strong> <?= $debug_info['current_staff_id']; ?></li>
                                <li><strong>Permission Type:</strong> <?= $debug_info['permission_type']; ?></li>
                                <li><strong>Can View All Staff:</strong> <?= $can_view_all_staff ? 'Yes' : 'No'; ?></li>
                                <li><strong>Allowed Staff IDs:</strong> <?= empty($debug_info['allowed_staff_ids']) ? 'ALL' : implode(', ', $debug_info['allowed_staff_ids']); ?></li>
                                <li><strong>Staff Count Shown:</strong> <?= $debug_info['staff_count']; ?></li>
                            </ul>
                        </div>
                        
                        <h5>Staff List (Based on Permissions):</h5>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Staff ID</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Admin</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($staff_list)): ?>
                                        <?php foreach ($staff_list as $staff): ?>
                                            <tr>
                                                <td><?= $staff['staffid']; ?></td>
                                                <td><?= $staff['firstname'] . ' ' . $staff['lastname']; ?></td>
                                                <td><?= $staff['email']; ?></td>
                                                <td><?= $staff['admin'] == 1 ? 'Yes' : 'No'; ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="4" class="text-center">No staff members found</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <h5>Filter Controls Test:</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <label>Staff Filter:</label>
                                <select id="staff-filter" multiple class="form-control">
                                    <?php if (!empty($staff_list)): ?>
                                        <?php foreach ($staff_list as $staff): ?>
                                            <option value="<?= $staff['staffid']; ?>">
                                                <?= $staff['firstname'] . ' ' . $staff['lastname']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                                <small class="text-muted">
                                    This dropdown should only show <?= $can_view_all_staff ? 'ALL staff members' : 'staff members you have permission to view'; ?>
                                </small>
                            </div>
                        </div>
                        
                        <div class="row" style="margin-top: 20px;">
                            <div class="col-md-12">
                                <a href="<?= admin_url('reporting_dashboard'); ?>" class="btn btn-primary">
                                    <i class="fa fa-arrow-left"></i> Back to Full Dashboard
                                </a>
                                <a href="<?= admin_url('reporting_dashboard/permissions_management'); ?>" class="btn btn-info">
                                    <i class="fa fa-cog"></i> Manage Permissions
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
console.log('Simple Dashboard Debug Info:', <?= json_encode($debug_info); ?>);
console.log('Staff List:', <?= json_encode($staff_list); ?>);
console.log('Can View All Staff:', <?= json_encode($can_view_all_staff); ?>);
</script>

<?php init_tail(); ?>
