# Cron Setup Helper Feature

## Overview
Added an interactive cron setup helper in the "Manage Schedules" modal that provides ready-to-copy cron commands with automatic URL and path detection.

## Feature Location
**Reporting Dashboard → Manage Schedules → Cron Setup Helper Panel**

## What Was Added

### 1. Collapsible Cron Helper Panel
- Located at the top of the schedules modal
- Toggle visibility with "Help" button
- Shows server-specific cron commands

### 2. Pre-configured Cron Commands

#### Linux/Unix (crontab)
Three command options with one-click copy:

**Option 1: curl (Recommended)**
```bash
*/5 * * * * curl -s http://yourdomain.com/admin/misc/cron >/dev/null 2>&1
```

**Option 2: PHP CLI**
```bash
*/5 * * * * php /path/to/crm/index.php misc/cron_job >/dev/null 2>&1
```

**Option 3: wget**
```bash
*/5 * * * * wget -q -O- http://yourdomain.com/admin/misc/cron >/dev/null 2>&1
```

#### Windows (Task Scheduler)
Step-by-step instructions with:
- Program path: Auto-detected PHP binary path
- Arguments: Auto-detected CRM path + `index.php misc/cron_job`

#### cPanel / Plesk
Simplified command for hosting control panels:
```bash
php /path/to/crm/index.php misc/cron_job
```

### 3. One-Click Copy Functionality
- Click "Copy" button next to any command
- Command is copied to clipboard
- Button shows "✓ Copied!" confirmation for 2 seconds
- Works with modern clipboard API and fallback for older browsers

### 4. Auto-Detected Values
The commands automatically include:
- ✅ **Cron URL**: Detected from `admin_url('misc/cron')`
- ✅ **Base Path**: Detected from `FCPATH`
- ✅ **PHP Binary**: Detected from `PHP_BINDIR`
- ✅ **Domain**: Uses current server configuration

### 5. Information Footer
Shows at bottom of panel:
- Current cron URL
- Current base path
- For reference when setting up manually

## Usage

### For Users:

1. **Open Schedules:**
   - Go to Reporting Dashboard
   - Click "Manage Schedules" button

2. **View Cron Setup:**
   - Click the "? Help" button in the cron panel header
   - Panel expands showing all setup options

3. **Copy Command:**
   - Choose your server type (Linux/Windows/cPanel)
   - Click "Copy" button next to the appropriate command
   - Paste into your server's cron configuration

4. **Verify Setup:**
   - After configuring cron, go to **Setup → Settings → Cron Job**
   - Check "Last Run" timestamp updates every 5 minutes

### For Server Administrators:

#### Linux/Unix Server:
```bash
# Edit crontab
crontab -e

# Add one of the provided commands
*/5 * * * * curl -s http://yourdomain.com/admin/misc/cron >/dev/null 2>&1

# Save and exit
```

#### Windows Server:
1. Open Task Scheduler
2. Create Basic Task
3. Set trigger: Daily, repeat every 5 minutes
4. Set action: Start a program
5. Use paths from the helper panel

#### cPanel/Plesk:
1. Log into control panel
2. Find "Cron Jobs" section
3. Add new cron job
4. Set interval: `*/5 * * * *`
5. Paste command from helper

## Technical Implementation

### Backend (PHP)

**File:** `modules/reporting_dashboard/views/dashboard.php`

**Auto-Detection:**
```php
<?php echo admin_url('misc/cron'); ?>      // http://domain.com/admin/misc/cron
<?php echo FCPATH; ?>                      // /var/www/html/crm/
<?php echo PHP_BINDIR; ?>                  // /usr/bin
```

These values are automatically injected into the commands, so users always get the correct paths for their specific installation.

### Frontend (JavaScript)

**Functions Added:**

#### 1. `toggleCronHelp()`
Toggles visibility of the cron help panel.

#### 2. `copyCronCommand(type)`
Copies the selected cron command to clipboard with visual feedback.

**Features:**
- Uses modern `navigator.clipboard` API
- Falls back to `document.execCommand('copy')` for older browsers
- Shows success confirmation ("✓ Copied!")
- Changes button color green for 2 seconds

#### 3. `fallbackCopy(input)`
Fallback method for browsers without clipboard API support.

## Benefits

### 1. **No Manual Configuration**
- Commands are pre-configured with correct URLs and paths
- No need to look up domain or file paths
- Reduces setup errors

### 2. **Multiple Options**
- Different commands for different server environments
- Users can choose what works best for their setup

### 3. **Easy Copy**
- One-click copying
- No need to manually select text
- Visual confirmation

### 4. **Clear Instructions**
- Step-by-step for each platform
- Verification steps included
- Warning about automatic execution

### 5. **Always Accurate**
- URLs update automatically if domain changes
- Paths update if CRM is moved
- No outdated documentation

## UI/UX Features

### Visual Design:
- **Panel Style**: Info panel (blue) to indicate it's informational
- **Collapsible**: Hidden by default to avoid clutter
- **Clear Sections**: Organized by operating system
- **Copy Buttons**: Prominent blue buttons with icons
- **Success Feedback**: Green checkmark when copied

### Accessibility:
- Readonly input fields for easy selection
- High contrast text
- Clear labels and headings
- Keyboard accessible

### Responsive:
- Works on desktop and mobile
- Input fields stretch to available width
- Buttons maintain size on small screens

## Troubleshooting

### Issue: Copy button doesn't work
**Solution:**
- Browser might not support clipboard API
- Try using HTTPS instead of HTTP
- Manually select and copy the text

### Issue: Cron not executing
**Solution:**
1. Check if cron is actually configured on server
2. Verify "Setup → Settings → Cron Job" shows recent execution
3. Check server cron logs: `/var/log/cron` (Linux)
4. Ensure PHP CLI is available and executable

### Issue: Wrong path in command
**Solution:**
- Commands auto-detect paths from server
- If moved installation, paths update automatically
- If still wrong, check PHP configuration

## Security Considerations

### 1. **Public Access:**
- Cron URL (`/admin/misc/cron`) is publicly accessible by design
- Perfex CRM validates requests internally
- No sensitive data exposed in commands

### 2. **Command Injection:**
- All paths are server-generated
- No user input in commands
- Safe to copy and use directly

### 3. **HTTPS Recommended:**
- Use HTTPS for curl/wget commands
- Ensures encrypted communication
- Some clipboard APIs require HTTPS

## Future Enhancements

Potential improvements:
1. **Auto-detection of cron status** - Check if cron is working
2. **Test button** - Trigger cron manually to test
3. **Cron history** - Show recent cron executions
4. **Email notifications** - Alert if cron fails
5. **Multiple intervals** - Options for 1, 5, 15, 30 minutes
6. **Cron job templates** - Saved configurations

## Related Documentation

- **SCHEDULE_LOGGING_FEATURE.md** - How execution logs work
- **VIEWING_SCHEDULE_LOGS_GUIDE.md** - User guide for viewing logs
- **SCHEDULE_NOT_EXECUTING_TROUBLESHOOTING.md** - Troubleshooting guide

## Support

### Common Questions:

**Q: How often should cron run?**
A: Every 5 minutes is recommended. More frequent isn't necessary; less frequent delays schedule execution.

**Q: Can I use a different interval?**
A: Yes, change `*/5` to `*/1` (every minute), `*/15` (every 15 min), etc.

**Q: Do I need all three commands?**
A: No, choose ONE that works for your server (curl is usually best).

**Q: What if I don't have server access?**
A: Ask your hosting provider to set up the cron job using the provided command.

**Q: Can schedules work without cron?**
A: No, for automatic execution you MUST have cron configured. You can still generate reports manually via the dashboard.

---

**Version:** 1.0.0  
**Date:** November 15, 2025  
**Status:** ✅ Complete and Working

